/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_error.h
Function: Header 
Comment: 
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_ERROR
#define DRD64_HEADER_ERROR

#include"drd64_types.h"
#include"drd64_defines.h"

#define	DRD64_ERROR_SET_CODE(c,p,m,n)	(((DWord)(c))|((DWord)(p))|(((DWord)(m))<<8)|((DWord)(n)))
#define	DRD64_ERROR_SET_LOCATION(m,a,s,f)	(((DWord)(m))|((DWord)(a))|(((DWord)(s))<<8)|((DWord)(f)))

/*DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD

 [Error] : Error Code
   31 | xxxx xxxx | xxxx xxxx | xxxx xxxx | xxxx xxxx | 0
      | AAAA RRRR | PPPP PPPP | 1111 1111 | 2222 2222 |
     AAAA => Error Type Code
     RRRR => Reserved. 
     PPPP => Error Pattern     
     1111 => Error Code Level-1 ( defined by Each-Module )
     2222 => Error Code Level-2 ( defined by Each-Module )

DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD

 [Location] : Error Location Code
   31 | xxxx xxxx | xxxx xxxx | xxxx xxxx | xxxx xxxx | 0
      | 1111 1orA | AAAA SSSS | SSSS SSSS | FFFF FFFF |
     1111 => Module Level-1 Code
     AAAA => Archtechture Code or Module Sub-Code 
     SSSS => Source File ID ( defined by Each-Module )     
     FFFF => Function ID ( defined by Each-Module )

DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD*/

#define	DRD64_ERROR_CODE_CLEAR			0x00000000
#define	DRD64_ERROR_LOCATION_CLEAR		0x00000000

/* [Error] Type Code ================== __*_______ */
#define	DRD64_ERROR_TYPE_FATAL			0x80000000
#define	DRD64_ERROR_TYPE_ERROR			0x40000000
#define	DRD64_ERROR_TYPE_WARNING		0x20000000
#define	DRD64_ERROR_TYPE_INFO			0x10000000
#define	DRD64_ERROR_TYPE_NONE			0x00000000

/* [Error] Pattern Code =============== ____**____ */
#define	DRD64_ERROR_PTN_NOERROR			0x00000000
#define	DRD64_ERROR_PTN_PACKET			0x00010000
#define	DRD64_ERROR_PTN_COMMAND			0x00020000
#define	DRD64_ERROR_PTN_LOG				0x00030000
#define	DRD64_ERROR_PTN_SYSCALL			0x00040000
#define	DRD64_ERROR_PTN_TIMEOUT			0x00050000
#define	DRD64_ERROR_PTN_NOEXIST			0x00060000
#define	DRD64_ERROR_PTN_NOMEMORY		0x00070000
#define	DRD64_ERROR_PTN_SOCKET			0x00080000
#define	DRD64_ERROR_PTN_INETADDR		0x00090000
#define	DRD64_ERROR_PTN_FUNCTION		0x00ff0000


/* [Location] Module Level-1 Code ===== __*+______ */
#define	DRD64_ERROR_MODULE_MARSHALD		0x01000000
#define	DRD64_ERROR_MODULE_DEBUGD		0x02000000
#define	DRD64_ERROR_MODULE_SERVER		0x03000000
#define	DRD64_ERROR_MODULE_LIBGOBLIN	0x11000000
#define	DRD64_ERROR_MODULE_LIBDRD64		0x12000000
#define	DRD64_ERROR_MODULE_LIBARCH		0x20000000
#define	DRD64_ERROR_MODULE_LIBASM		0x30000000
#define	DRD64_ERROR_MODULE_UI			0x71000000

/* [Location] Archtechture Code ======= ___**_____ */
#define	DRD64_ERROR_ARCH_NODEPEND		0x00000000
#define	DRD64_ERROR_ARCH_INTEL64		0x01100000
#define	DRD64_ERROR_ARCH_INTEL32		0x01200000
#define	DRD64_ERROR_ARCH_INTEL16		0x01300000
#define	DRD64_ERROR_ARCH_POWERPC64		0x02100000
#define	DRD64_ERROR_ARCH_POWERPC32		0x03200000
#define	DRD64_ERROR_ARCH_ARM32			0x04100000
#define	DRD64_ERROR_ARCH_SPARC			0x05100000
#define	DRD64_ERROR_ARCH_MIPS			0x06100000


typedef struct	{
	DWord	dw_error;
	DWord	dw_location;
	int		i_system_errno;
	Value	v_value;
	char	str_string[DRD64_MAX_PATH+1];
} Drd64_ErrorInfo;


#endif	/* DRD64_HEADER_XXX */

/* EOF of drd64_.h ----------------------------------- */
