/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.h
Function: Header 
Comment: 
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_PACKET
#define DRD64_HEADER_PACKET

#include<netinet/in.h>
#include"drd64_types.h"
#include"drd64_defines.h"

#define	DRD64_PACKET_HEADER		0x8664

#define	DRD64_COMMAND_CONNECT			0x0010
#define	DRD64_COMMAND_CONNECT_COUNT		0x0012
#define	DRD64_COMMAND_DISCONNECT		0x0020
#define	DRD64_COMMAND_ATTACH_REQUEST	0x0031
#define	DRD64_COMMAND_ATTACH_LINK		0x0032
#define	DRD64_COMMAND_ATTACH_REPORT		0x0033
#define	DRD64_COMMAND_DEBUG_REQUEST		0x0041
#define	DRD64_COMMAND_DEBUG_CONFIRM		0x0042
#define	DRD64_COMMAND_DETACH			0x0050
#define	DRD64_COMMAND_EXIT				0x0060
#define	DRD64_COMMAND_DEBUGD_BOOTINFO	0x8070

#define	DRD64_COMMTYPE_ERR		0x00
#define	DRD64_COMMTYPE_LOCAL	0x01
#define	DRD64_COMMTYPE_INET		0x02

//#define	DRD64_PACKETTYPE_REQUEST	0x0001
//#define	DRD64_PACKETTYPE_TRANSPORT	0x0002
//#define	DRD64_PACKETTYPE_ANSWER		0x0003
//#define	DRD64_PACKETTYPE_INFO		0x0004
#define	DRD64_PACKETTYPE_MASK_TYPE			0x00ff
#define	DRD64_PACKETTYPE_DEBUG				0x0001
#define	DRD64_PACKETTYPE_CONTROL			0x0002
#define	DRD64_PACKETTYPE_LINK				0x0003
#define	DRD64_PACKETTYPE_REPORT				0x0004

#define	DRD64_PACKETTYPE_OPTION_INDICATE	0x0010

#define	DRD64_PACKETTYPE_FLAG_REQUEST		0x0000	/* Bit 0x0100 is OFF */
#define	DRD64_PACKETTYPE_FLAG_ANSWER		0x0100	/* Bit 0x0100 is ON */
#define	DRD64_PACKETTYPE_FLAG_TRANSPORT		0x0200
#define	DRD64_PACKETTYPE_FLAG_RELAY			0x0400

#define	DRD64_CONNECTID_NONE	-1

#define	DRD64_IsPacketTypeFlag(m,n)	((Word)((Word)(n)&(Word)((m)->w_packettype))==(n))
#define	DRD64_IsPacketType_Answer(n)	((Word)((Word)DRD64_PACKETTYPE_FLAG_ANSWER&(Word)((n)->w_packettype))==DRD64_PACKETTYPE_FLAG_ANSWER)
#define	DRD64_IsPacketBaseType(m,n)		((Word)((Word)DRD64_PACKETTYPE_MASK_TYPE&((m)->w_packettype))==(n))

typedef struct	{
	/* Headers */
	Word	w_header;	/* 0x8664*/

	/* Comm. */
	INT		i_cid_dest;
	INT		i_cid_src;
	INT		i_cid_client;
	//Byte	b_commtype;

	/* Command */
	DWord	dw_command;
	Word	w_packettype;
	INT		i_datalen;
	INT		i_rid_resume;	/* resume_recvstatus_id */

	/* Answer */
	//INT		i_result;
	//INT		i_error;
	DWord	dw_errcode;
	DWord	dw_errlocation;

} __attribute((packed)) Drd64_PacketHeader;

#define	DRD64_MAX_PACKET_LENGTH	65536 
#define	DRD64_MAX_PACKET_DATA	(DRD64_MAX_PACKET_LENGTH-sizeof(Drd64_PacketHeader)) 

#define	DRD64_PacketSize(n)	(sizeof(Drd64_PacketHeader)+((n)->i_datalen))
#define	DRD64_PacketData(n)	((n)+sizeof(Drd64_PacketHeader))


/* CMD: Connect Data ===================================*/

typedef struct	{
	/* Request Data */
	INT					i_client_pid;
	struct	in_addr		t_client_addr_inet;
	INT					i_client_cinfo_id;

	/* Answer Data */
	INT					i_connect_id;
	INT					i_marshald_pid;

} __attribute((packed)) Drd64_PacketData_Connect;


/* CMD: ConnectCount Data ==============================*/

typedef struct	{
	/* Request Data */
	INT					i_refcount_diff;
	INT					i_refcount_client;

	/* Answer Data */
	INT					i_refcount_server;

} __attribute((packed)) Drd64_PacketData_ConnectCount;


/* CMD: Attach Request ===================================*/

typedef struct	{
	/* Request Data */
	INT					i_prog_pid;
	struct	in_addr		t_prog_addr;

	/* Answer Data */
	INT					i_cid_debugd;
	INT					i_cid_marshald;
	INT					i_debugd_pid;
	char				str_debugd_sockname[DRD64_MAX_PATH+1];

} __attribute((packed)) Drd64_PacketData_AttachRequest;


/* CMD: Attach Link ===================================*/

typedef struct	{
	/* Request Data */
	char				str_debugd_sockname[DRD64_MAX_PATH+1];

	/* Answer Data */

} __attribute((packed)) Drd64_PacketData_AttachLink;



/* CMD: Attach Report ===================================*/

typedef struct	{
	/* Request Data */
	char				str_debugd_sockname[DRD64_MAX_PATH+1];

	/* Answer Data */

} __attribute((packed)) Drd64_PacketData_AttachReport;


/* CMD: Detach =========================================*/

typedef struct	{
	/* Request Data */
	//INT					i_cid;

	/* Answer Data */

} __attribute((packed)) Drd64_PacketData_Detach;


#endif	/* DRD64_HEADER_XXX */

/* EOF of drd64_.h ----------------------------------- */
