/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBBROWNIE_ERROR
#include"drd64_libbrownie.h"

static	Drd64_ErrorInfo	*gp_errorinfo_pool;
static	Drd64_ErrorInfo	**gpp_errorinfo_history;
static	int				gi_max_errorinfo;


LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_Error_SetErrorInfo(
		DWord	dw_errcode,
		DWord	dw_errlocation,
		int		i_syserrno )
{
	int		i_cnt;
	Drd64_ErrorInfo		*p_errinfo;

	p_errinfo	= *(gpp_errorinfo_history + gi_max_errorinfo);
	for( i_cnt = gi_max_errorinfo - 1; i_cnt > 0; i_cnt-- )		{
		*(gpp_errorinfo_history + i_cnt)
			= *(gpp_errorinfo_history + (i_cnt - 1));
	}

	p_errinfo->dw_error			= dw_errcode;
	p_errinfo->dw_location		= dw_errlocation;
	p_errinfo->i_system_errno	= i_syserrno;

	*(gpp_errorinfo_history + 0)	= p_errinfo;
	
	return 0x00;
}


LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_Error_InitErrorSystem(
		int i_max_errorinfo )
{
	int					i_cnt;
	Drd64_ErrorInfo		*p_errinfo;
	Drd64_ErrorInfo		*p_errnow;
	Drd64_ErrorInfo		**pp_errhistory;

	gp_errorinfo_pool		= NULL;
	gpp_errorinfo_history	= NULL;
	gi_max_errorinfo		= 0;

	if( 1 > i_max_errorinfo )	{ return 0x03; }

	p_errinfo = (Drd64_ErrorInfo *)malloc(
					sizeof( Drd64_ErrorInfo ) * i_max_errorinfo );
	if( NULL == p_errinfo )		{ return 0x01; }

	memset( p_errinfo, 0x00, sizeof( Drd64_ErrorInfo ) * i_max_errorinfo );

	
	pp_errhistory = (Drd64_ErrorInfo **)malloc(
						sizeof( Drd64_ErrorInfo * ) * i_max_errorinfo );
	if( NULL == pp_errhistory )		{ return 0x02; }

	for( i_cnt = 0; i_cnt < i_max_errorinfo; i_cnt++ )
		{ *(pp_errhistory + i_cnt )	= (p_errinfo + i_cnt); }

	gp_errorinfo_pool		= p_errinfo;
	gpp_errorinfo_history	= pp_errhistory;
	gi_max_errorinfo		= i_max_errorinfo;
	
	return 0x00;
}


LIBBROWNIE_FUNC
void
	Drd64_LibBrownie_Error_TermErrorSystem(
		void )
{
	if( NULL != gp_errorinfo_pool )	{
		free( gp_errorinfo_pool );
		gp_errorinfo_pool		= NULL;
	}
		
	if( NULL != gpp_errorinfo_history )	{
		free( gpp_errorinfo_history );
		gpp_errorinfo_history	= NULL;
	}

	return;
}


LIBBROWNIE_FUNC
Drd64_ErrorInfo *
	Drd64_LibBrownie_Error_GetErrorInfo(
		int i_history_id )
{
	Drd64_ErrorInfo		*p_errinfo;

	if((gi_max_errorinfo <= i_history_id ) || ( 0 > i_history_id ))
		{ return NULL; }

	p_errinfo	= *(gpp_errorinfo_history + i_history_id);

	return p_errinfo;
}


/* EOF of drd64_.c ----------------------------------- */
