/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_libbrownie.h"

/* Drd64_Server_INetAddr_CmpInAddr */
LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_INetAddr_CmpInAddr(
		struct	in_addr	*p_dest, 
		struct	in_addr	*p_src )
{
	/* XXX */
	return (( p_dest->s_addr == p_src->s_addr ) ? 0x00 : 0x01 );
}


/* Drd64_Server_INetAddr_CopyInAddr */
LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_INetAddr_CopyInAddr(
		struct	in_addr	*p_dest,
		struct	in_addr	*p_src )
{
	/* XXX : only FreeBSD */
	memcpy( p_dest, p_src, sizeof( struct in_addr ) );

	return 0x00;
}


/* Drd64_LibDrd64_INet_SetInAddr */
LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_INetAddr_SetInAddr_fromFQDN(
		struct	in_addr *p_addr,
		char	*pstr_hostname )
{
	struct	hostent		*p_hent;

	if( NULL == p_addr )	{ return 0xff; }

	p_hent	= gethostbyname( pstr_hostname );
	if( NULL == p_hent )	{
		return 0x02;
	}

	if( NULL == p_hent->h_addr_list )	{ 
		return 0x03;
	}
        
	/* XXX : only FreeBSD */
	memcpy( p_addr, *(p_hent->h_addr_list), p_hent->h_length );

	return 0x00;
}


/* Drd64_Server_INetAddr_SetInAddr_LocalHost */
LIBBROWNIE_FUNC
int
	Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
		struct	in_addr	*p_addr )
{
	char	str_hostname[ 256 ];
	struct	hostent		*p_hent;

	if( NULL == p_addr )	{ return 0xff; }

	if( 0 != gethostname( str_hostname, sizeof( str_hostname ) ))
		{ return 0x01; }

	p_hent	= gethostbyname( str_hostname );
	if( NULL == p_hent )	{ return 0x02; }

	if( NULL == p_hent->h_addr_list )	{ return 0x03; }
 
	/* XXX : only FreeBSD */
	memcpy( p_addr, *(p_hent->h_addr_list), p_hent->h_length );

	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
