/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_libbrownie.h"


/* Drd64_Server_Socket_InitSocket_Local( */
int
	Drd64_LibBrownie_Socket_InitSocketServer_Local(
		const char *pstr_addr )
{
	int						i_socket_local;
	int						i_err;
	struct	sockaddr_un		t_sun;

	i_socket_local	= socket( PF_LOCAL, SOCK_STREAM, 0 );
	if( -1 == i_socket_local )
		{ return -1; }

	unlink( pstr_addr );

	memset( &t_sun, 0x00, sizeof( struct sockaddr_un ) );

	t_sun.sun_family	= AF_UNIX;
	strcpy( t_sun.sun_path, pstr_addr );

	i_err = bind( i_socket_local,
					(struct sockaddr *)&t_sun,
					SUN_LEN( &t_sun ) );
	if( i_err == -1 )	{ return -3; }

	i_err = listen( i_socket_local, SOMAXCONN );
	if( i_err == -1 )	{ return -4; }
	
	return i_socket_local;
}


/* Drd64_Server_Socket_InitSocket_INet */
int
	Drd64_LibBrownie_Socket_InitSocketServer_INet(
		const char *pstr_addr, 
		u_short us_port )
{
	int						i_socket_inet;
	int						i_err;
	int						i_flag;
	struct	sockaddr_in		t_sin;

	i_socket_inet	= socket( PF_INET, SOCK_STREAM, 0 );
	if( -1 == i_socket_inet )
		{ return -1; }

	memset( &t_sin, 0x00, sizeof( struct sockaddr_in ) );

	t_sin.sin_family	= AF_INET;
	t_sin.sin_port		= htons( us_port );
	if( !strcmp( pstr_addr, "INADDR_ANY" ) )	{
		t_sin.sin_addr.s_addr	= htonl( INADDR_ANY );
	}
	else	{
		t_sin.sin_addr.s_addr	= inet_addr( pstr_addr );
		if( INADDR_NONE == t_sin.sin_addr.s_addr )	{ return -2; }
	}

	i_flag	= 1;
	i_err	= setsockopt(i_socket_inet, IPPROTO_TCP, TCP_NODELAY,
										(char *)&i_flag, sizeof(int));
	if( 0 > i_err )		{ return -3;} 

	i_err = bind( i_socket_inet,
					(struct sockaddr *)&t_sin,
					sizeof( struct sockaddr_in ) );
	if( i_err == -1 )	{ return -4; }

	i_err = listen( i_socket_inet, SOMAXCONN );
	if( i_err == -1 )	{ return -5; }
	
	return i_socket_inet;
}


/* Drd64_Server_Socket_InitSocket_Local_Client */
int
	Drd64_LibBrownie_Socket_InitSocketClient_Local(
		const char *pstr_socket )
{
	int						i_err;
	int						i_socket_local;
	struct	sockaddr_un		t_sun;

	i_socket_local	= socket( PF_LOCAL, SOCK_STREAM, 0x00 );
	if( -1 == i_socket_local )	{ return -1; }

	t_sun.sun_family	= AF_UNIX;
	strncpy( t_sun.sun_path, pstr_socket, DRD64_SUNPATH_LEN - 1 );

	i_err	= connect( i_socket_local,
						(struct sockaddr *)&t_sun, SUN_LEN( &t_sun ) );
	if( -1 == i_err )	{ return -2; }

	return i_socket_local;
}


/* Drd64_Server_Socket_InitSocketClient_INet */
int
	Drd64_LibBrownie_Socket_InitSocketClient_INet(
		struct	in_addr		*p_addr, 
		u_short us_port )
{
	int		i_err;
	int						i_socket_inet;
	struct	sockaddr_in		t_sin;
	int		i_flag;


	i_socket_inet	= socket( PF_INET, SOCK_STREAM, 0x00 );
	if( -1 == i_socket_inet )	{ return -1; }

	memset( &t_sin, 0x00, sizeof( struct sockaddr_in ) );

	t_sin.sin_family	= AF_INET;
	Drd64_LibBrownie_INetAddr_CopyInAddr( &t_sin.sin_addr, p_addr );
	t_sin.sin_port		= htons( us_port );
	
	i_flag	= 1;
	i_err	= setsockopt(i_socket_inet, IPPROTO_TCP, TCP_NODELAY,
										(char *)&i_flag, sizeof(int));
	if( 0 > i_err )		{ return -2;} 

	i_err	= connect( i_socket_inet,
					(struct sockaddr *)&t_sin,
					sizeof( struct sockaddr_in ) );
	if( -1 == i_err )	{ return -3; }

	return i_socket_inet;
}


/* EOF of drd64_.c ----------------------------------- */
