/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_libdrd64.h"


int
	Drd64_LibDrd64_Cmd_Attach_Report(
		Drd64_LibDrd64_ConnectInfo	*p_cinfo )
{
	int		i_err;
	int		i_socket;
	int		i_socket_marshald;
	Drd64_PacketHeader				*p_phead;
	Drd64_PacketData_AttachReport	*p_areport;

	assert( NULL != p_cinfo );

	/* Phase 1 : Set Packet Data --- */
	p_phead	= (Drd64_PacketHeader *)gp_buffer;
	p_areport
		= (Drd64_PacketData_AttachReport *)DRD64_PacketData( gp_buffer );

	/*strncpy( p_alink->str_debugd_sockname,
				p_cinfo->str_debugd_addr_local,
				DRD64_MAX_PATH );*/

	Drd64_LibDrd64_Packet_SetPacketHeader(
							p_phead,
							p_cinfo->i_marshald_cid,
							DRD64_PACKETTYPE_CONTROL,
							DRD64_COMMAND_ATTACH_REPORT,
							sizeof( Drd64_PacketData_AttachReport ) );

	/* Phase 2 : Send & Recv. Attach-Link Cmd */
	i_err	= Drd64_LibDrd64_Packet_SendPacket(
						p_cinfo->i_marshald_socket, gp_buffer,
						sizeof( Drd64_PacketData_AttachReport ),
						sizeof( Drd64_PacketData_AttachReport ),
						0x00 );
	if( 0 > i_err )		{ return -2; }

	return 0x00;
}


int
	Drd64_LibDrd64_Cmd_Attach_Link(
		Drd64_LibDrd64_ConnectInfo	*p_cinfo )
{
	int		i_err;
	int		i_socket;
	Drd64_PacketHeader				*p_phead;
	Drd64_PacketData_AttachLink		*p_alink;

	assert( NULL != p_cinfo );

	
	/* Phase 1 : Create Socket for Debugd */
	if( DRD64_LIBDRD64_CINFO_COMMTYPE_LOCAL == p_cinfo->b_commtype )	{
		i_socket = Drd64_LibBrownie_Socket_InitSocketClient_Local(
									p_cinfo->str_debugd_addr_local );
	}
	else	{
		i_socket = Drd64_LibBrownie_Socket_InitSocketClient_INet(
									&(p_cinfo->t_debugd_addr_inet),
									DRD64_SOCKET_NETWORK_PORT );
	}

	if( 0 > i_socket )		{ return -1; }

	/* Phase 2 : Set Packet Data --- */
	p_phead	= (Drd64_PacketHeader *)gp_buffer;
	p_alink
		= (Drd64_PacketData_AttachLink *)DRD64_PacketData( gp_buffer );
	strncpy( p_alink->str_debugd_sockname,
				p_cinfo->str_debugd_addr_local,
				DRD64_MAX_PATH );

	Drd64_LibDrd64_Packet_SetPacketHeader(
							p_phead,
							p_cinfo->i_debugd_cid,
							DRD64_PACKETTYPE_DEBUG,
							DRD64_COMMAND_ATTACH_LINK,
							sizeof( Drd64_PacketData_AttachLink ) );

	/* Phase 3 : Send & Recv. Attach-Link Cmd */
	i_err	= Drd64_LibDrd64_Packet_SendPacket(
						i_socket, gp_buffer,
						sizeof( Drd64_PacketData_AttachLink ),
						sizeof( Drd64_PacketData_AttachLink ),
						0x00 );
	if( 0 > i_err )		{ return -2; }

	p_cinfo->i_debugd_socket	= i_socket;

	return 0x00;
}



int
	Drd64_LibDrd64_Cmd_Attach_Request(
		Drd64_LibDrd64_ConnectInfo	*p_cinfo,
		int		i_prog_pid,
		char	*pstr_hostname )
{
	int		i_err;
	int		i_socket_marshald;
	Byte	b_commtype;
	Drd64_PacketHeader			*p_phead;
	Drd64_PacketData_AttachRequest		*p_attach;

	/* Phase 1 : Set Packet Data --- */
	p_phead	= (Drd64_PacketHeader *)gp_buffer;

	Drd64_LibDrd64_Packet_SetPacketHeader(
							p_phead,
							drd64_libdrd64_minfo.i_marshald_connectid,
							DRD64_PACKETTYPE_CONTROL, 
							DRD64_COMMAND_ATTACH_REQUEST,
							sizeof( Drd64_PacketData_AttachRequest ) );

	p_attach
		= (Drd64_PacketData_AttachRequest *)DRD64_PacketData( gp_buffer );

	if( !strcmp( pstr_hostname, "localhost" ) )		{
		i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
						&(p_attach->t_prog_addr) );
		b_commtype	= DRD64_LIBDRD64_CINFO_COMMTYPE_LOCAL;
	}
	else	{
		i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_fromFQDN(
						&(p_attach->t_prog_addr), pstr_hostname );
		b_commtype	= DRD64_LIBDRD64_CINFO_COMMTYPE_INET;
	}
	if( 0x00 != i_err )		{ return 0x01; }

	p_attach->i_prog_pid		= i_prog_pid;
	p_attach->i_cid_debugd		= DRD64_CONNECTID_NONE;
	p_attach->i_cid_marshald	= DRD64_CONNECTID_NONE;

	/* Phase 2 : Send Attach-Request Packet --- */
	i_err	= Drd64_LibDrd64_Packet_SendPacket(
					drd64_libdrd64_minfo.i_marshald_socket,
					gp_buffer,
					sizeof( Drd64_PacketData_AttachRequest ),
					sizeof( Drd64_PacketData_AttachRequest ),
					0x01 );
	if( 0 > i_err )		{
		return 0x01;
	}

	/* Phase 3 : Set ConnectInfo from Result ---*/
	p_cinfo->b_commtype		= b_commtype;
	p_cinfo->i_prog_pid		= i_prog_pid;
	
	p_cinfo->i_debugd_pid	= p_attach->i_debugd_pid;
	p_cinfo->i_debugd_cid	= p_attach->i_cid_debugd;
	strncpy( p_cinfo->str_debugd_addr_local,
				p_attach->str_debugd_sockname,
				DRD64_MAX_PATH );
    Drd64_LibBrownie_INetAddr_CopyInAddr(
        		&(p_cinfo->t_debugd_addr_inet),
        		&(p_attach->t_prog_addr) );
	
	p_cinfo->i_marshald_pid	= drd64_libdrd64_minfo.i_marshald_pid;	
	p_cinfo->i_marshald_cid	= p_attach->i_cid_marshald;
	p_cinfo->i_marshald_socket	= drd64_libdrd64_minfo.i_marshald_socket;

	return 0x00;
}


LIBDRD64_FUNC
int
	Drd64_LibDrd64_Cmd_Attach(
		int		i_prog_pid,
		char	*pstr_hostname )
{
	int		i_err;
	Drd64_LibDrd64_ConnectInfo *p_cinfo;

	/* Alloc Connect Info */
	p_cinfo	= Drd64_LibDrd64_CInfo_AllocConnectInfo();
	if( NULL == p_cinfo )	{
		return -1;
	}

	/* Phase 1: Attach Request */
	i_err = Drd64_LibDrd64_Cmd_Attach_Request(
					p_cinfo, i_prog_pid, pstr_hostname );
	if( 0x00 != i_err )	{ return -2; }

	/* Phase 2: Attach Link */
	i_err = Drd64_LibDrd64_Cmd_Attach_Link( p_cinfo );
	if( 0x00 != i_err )	{ return -3; }

	/* Phase 3: Attach Report */
	i_err = Drd64_LibDrd64_Cmd_Attach_Report( p_cinfo );
	if( 0x00 != i_err )	{ return -4; }

	return p_cinfo->i_id;
}


/* EOF of drd64_.c ----------------------------------- */
