/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_libdrd64.h"


typedef struct  {
	struct	cmsghdr		t_hdr;
	struct	cmsgcred	t_cred;
} Drd64_Server_SendCMsg;

Drd64_Server_SendCMsg	gt_sendmsg_cmsg;
struct	msghdr			gt_sendmsg_msghdr;
struct	iovec			gt_sendmsg_iovec;


void
	Drd64_LibDrd64_Socket_InitSendBuffer(
		void )
{
	struct				cmsghdr		*p_cmsghdr;

	memset( &gt_sendmsg_cmsg, 0x00,
				sizeof( struct cmsghdr ) + sizeof( struct cmsgcred ) );
	memset( &gt_sendmsg_msghdr, 0x00, sizeof( struct msghdr ) );

	p_cmsghdr   = (struct cmsghdr *)&gt_sendmsg_cmsg;
	p_cmsghdr->cmsg_len   = sizeof( struct cmsghdr )
								+ sizeof( struct cmsgcred );
	p_cmsghdr->cmsg_level = SOL_SOCKET;
	p_cmsghdr->cmsg_type  = SCM_CREDS;

	gt_sendmsg_msghdr.msg_name		= NULL;
	gt_sendmsg_msghdr.msg_namelen   = 0;
	gt_sendmsg_msghdr.msg_iov		= &gt_sendmsg_iovec;
	gt_sendmsg_msghdr.msg_iovlen	= 1;
	gt_sendmsg_msghdr.msg_control	= (caddr_t)&gt_sendmsg_cmsg;
	gt_sendmsg_msghdr.msg_controllen
			= sizeof( struct cmsghdr ) + sizeof( struct cmsgcred );

	return;
}


int
	Drd64_LibDrd64_Socket_Send_Cert(
		int		i_socket, 
		void	*pv_data,
		int		i_wsize )
{
	gt_sendmsg_iovec.iov_base    = pv_data;
   	gt_sendmsg_iovec.iov_len     = i_wsize;

	return sendmsg( i_socket, &gt_sendmsg_msghdr, 0x00 );
}


int
    Drd64_LibDrd64_Socket_ReadSocket(
        int     i_socket,
        Byte    *pb_data,
        int     i_size,
		int		i_wait )
{
    int     i_bytes;
    int     i_reads;
    int     i_err;
    int     i_ret;
    Byte    *pb_now;
    fd_set  t_fds_socket;
    fd_set  t_fds_temp;
    struct  timeval t_wait;

    i_err   = 0;
    i_ret   = 0;

    FD_ZERO( &t_fds_socket );
    FD_SET( i_socket, &t_fds_socket );

    t_wait.tv_usec  = 0;
    t_wait.tv_sec   = i_wait;
    pb_now  = pb_data;
   
    i_bytes = i_size;
    memcpy( &t_fds_temp, &t_fds_socket, sizeof( fd_set ) );

    do  {
        i_err   = select( i_socket+1, &t_fds_temp, NULL, NULL, &t_wait );
        if( -1 == i_err )   {
            i_ret   = -1;
            break;
        } else if ( 0 == i_err )    {
            i_ret   = -2;
            break;
        }

        if( FD_ISSET( i_socket, &t_fds_temp ) )     {
            i_reads = read( i_socket, pb_now, i_bytes );

            if( -1 == i_reads )     {
                i_ret   = -3;
                break;
            }

            pb_now  += i_reads;
            i_bytes -= i_reads;
        }
    	memcpy( &t_fds_temp, &t_fds_socket, sizeof( fd_set ) );
    } while( i_bytes > 0 );

    if( 0 == i_ret )        {
        i_ret   = i_size - i_bytes;
    }

    return i_ret;
}


/* EOF of drd64_.c ----------------------------------- */
