/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define DRD64_SRC_LIBGOBLIN_API_READBIN
#include"drd64_libgoblin.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_FUNC
int
	LibGoblin_ReadBinary_File(
		char	*pstr_filepath )
{
	int		i_bid;
	int		i_err;
	int		i_fd;
	struct	stat	t_sb;
	Byte	*p_head;
	LibGoblin_BinaryInfo	*p_bin;


	/* Open Test LM */
	i_fd	= open( pstr_filepath, O_RDONLY );
	if( -1 == i_fd )	{
		i_bid	= -1;
		goto goto_LibGoblin_AnalyzeBinaryFile_err;
	}

	/* Get FileSize */
	i_err	= fstat( i_fd, &t_sb );
	if( -1 == i_err )		{
		i_bid	= -2;
		close( i_fd );
		goto goto_LibGoblin_AnalyzeBinaryFile_err;
	}

	p_head  = mmap( NULL, t_sb.st_size, PROT_READ, MAP_SHARED, i_fd, 0 );
	if( MAP_FAILED == p_head )		{
		i_bid	= -3;
		close( i_fd );
		goto goto_LibGoblin_AnalyzeBinaryFile_err;
	}

	/* Alloc BinaryInfo Struct */
	p_bin	= LibDrd64_BinInfo_AllocBinInfo();
	if( NULL == p_bin )		{
		i_bid	= -4;
		close( i_fd );
		goto goto_LibGoblin_AnalyzeBinaryFile_err;
	}
	i_bid	= p_bin->i_id;

	p_bin->p_binary	= p_head;
	p_bin->dw_size	= (DWord)t_sb.st_size;
	p_bin->i_fd	= i_fd;
	strncpy( p_bin->str_filepath, pstr_filepath, DRD64_MAX_PATH );

	LibGoblin_AnalyzeBinary( p_bin );
        

goto_LibGoblin_AnalyzeBinaryFile_err:

	return i_bid;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_FUNC
int
	LibGoblin_ReadBinary_Memory(
		Byte	*p_data,
		DWord	dw_size )
{
	int		i_bid;
	int		i_result;
	LibGoblin_BinaryInfo	*p_bin;

	/* Alloc BinaryInfo Struct */
	p_bin	= LibDrd64_BinInfo_AllocBinInfo();
	if( NULL == p_bin )		{ return -1; }
	i_bid	= p_bin->i_id;

	p_bin->p_binary	= p_data;
	p_bin->dw_size	= dw_size;

	i_result = LibGoblin_AnalyzeBinary( p_bin );

	return i_bid;
}


/* EOF of drd64_.c ----------------------------------- */
