/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_BINFO
#include"drd64_libgoblin.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_BINFO_EXTERN
LibGoblin_BinaryInfo *
	LibDrd64_BinInfo_AllocBinInfo(
		void)
{
	int		i_cnt;
	int		i_id_now;
	LibGoblin_BinaryInfo *p_binfo_base;
	LibGoblin_BinaryInfo *p_binfo_now;
	
	p_binfo_now	= NULL;
	i_id_now	= -1;
	
	if( gi_now_binary_info == gi_max_binary_info )	{
		for( i_cnt = 0; i_cnt < gi_max_binary_info; i_cnt++ )	{
			if( -1 == (gp_binary_info + i_cnt)->i_id )	{
				p_binfo_now	= gp_binary_info + i_cnt;
				i_id_now	= i_cnt;
				break;
			}
		}

		if( NULL == p_binfo_now )	{
			p_binfo_base	= realloc( gp_binary_info,
					sizeof( LibGoblin_BinaryInfo ) *
						(gi_max_binary_info + LIBGOBLIN_BINFO_UNITS) );
			if( NULL == p_binfo_base )		{ return NULL; }
		
			gp_binary_info	= p_binfo_base;
			gi_max_binary_info	+= LIBGOBLIN_BINFO_UNITS; 

			p_binfo_now	= gp_binary_info + gi_now_binary_info;
			i_id_now	= gi_now_binary_info++;
		}
	}
	else	{
		p_binfo_now	= gp_binary_info + gi_now_binary_info;
		i_id_now	= gi_now_binary_info++;
	}

	memset( p_binfo_now, 0x00, sizeof( LibGoblin_BinaryInfo ) );

	p_binfo_now->i_id	= i_id_now;
	p_binfo_now->i_fd	= -1;

	return p_binfo_now;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_BINFO_EXTERN
int
	LibGoblin_FreeBinaryInfo(
		LibGoblin_BinaryInfo *p_binfo )
{

	if( NULL == p_binfo )	{ return 0x01; }

	if( NULL != p_binfo->p_format )		{
		free( p_binfo->p_format );
		p_binfo->p_format	= NULL;
	}

	if( -1 != p_binfo->i_fd )	{
		munmap( p_binfo->p_binary, p_binfo->dw_size );
		p_binfo->i_fd	= 0;
	}

	memset( p_binfo, 0x00, sizeof( LibGoblin_BinaryInfo ) );

	p_binfo->i_id	= -1;
	
	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_BINFO_EXTERN
int
	LibGoblin_InitBinaryInfo(
		void)
{
	gp_binary_info	= malloc( sizeof( LibGoblin_BinaryInfo )
								* LIBGOBLIN_BINFO_UNITS );
	if( NULL == gp_binary_info )	
		{ return -1; }

	gi_max_binary_info	= LIBGOBLIN_BINFO_UNITS;
	gi_now_binary_info	= 0;

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_BINFO_EXTERN
int
	LibGoblin_TermBinaryInfo(
		void )
{
	LibGoblin_BinaryInfo	*p_bin;

	if( gi_now_binary_info > 0 )	{
		for( ; gi_now_binary_info >= 0; gi_now_binary_info-- )	{
			p_bin = LibGoblin_BInfo_GetBinaryInfo( gi_now_binary_info );
			LibGoblin_FreeBinaryInfo( p_bin );
		}
	}

	
	free( gp_binary_info );
	
	gp_binary_info		= NULL;
	gi_max_binary_info	= 0;
	gi_now_binary_info	= 0;

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_BINFO_EXTERN
LibGoblin_BinaryInfo *
	LibGoblin_BInfo_GetBinaryInfo(
		int	i_bid )
{
	if(( gi_now_binary_info <= i_bid ) && ( 0 > i_bid ))
		{ return NULL; }
	
	return (gp_binary_info + i_bid);
}


/* EOF of drd64_.c ----------------------------------- */
