/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.h
Function: Header 
Comment: 
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_LIBGOBLIN_BINFO
#define DRD64_HEADER_LIBGOBLIN_BINFO

#include"drd64_libgoblin.h"

#ifdef DRD64_SRC_LIBGOBLIN_BINFO
	#define LIBGOBLIN_BINFO_EXTERN
#else
	#define LIBGOBLIN_BINFO_EXTERN	extern
#endif

#define LIBGOBLIN_BINFO_UNITS      8

#define	LIBGOBLIN_BINFO_TYPE_NONE		0x00
#define	LIBGOBLIN_BINFO_TYPE_ELF		0x01
#define	LIBGOBLIN_BINFO_TYPE_ELF64		0x64
#define	LIBGOBLIN_BINFO_TYPE_ELF32		0x32

#define	IsBinfoType_Elf64(n) \
	((LIBGOBLIN_BINFO_TYPE_ELF64==((n)->b_type)) ? 0x01 : 0x00)
#define	IsBinfoType_Elf32(n) \
	((LIBGOBLIN_BINFO_TYPE_ELF32==((n)->b_type)) ? 0x01 : 0x00)

#define	LIBGOBLIN_BINFO_ENDIAN_NONE		0x00
#define	LIBGOBLIN_BINFO_ENDIAN_LITTLE	0x01
#define	LIBGOBLIN_BINFO_ENDIAN_BIG		0x02

#define	LIBGOBLIN_BINFO_SECTION_TEXT	0x00
#define	LIBGOBLIN_BINFO_SECTION_DATA	0x01
#define	LIBGOBLIN_BINFO_SECTION_BSS		0x02


typedef struct	{
	/* BinaryInfo Struct ID */
	int			i_id;

	/* Binary-File Info. */
	int			i_fd;
	char		str_filepath[DRD64_MAX_PATH];

	/* Binary-File Memory Image Access Info. */
	DWord		dw_size;
	Byte		*p_binary;

	/* BinaryInfo Common Info. */
	Byte		b_type;
	Byte		b_endian;
	Byte		b_bits;

	/* Binary-Format Depending Info. (ELF)*/
	void		*p_format;
	/* Debug-Format Depending Info. (DWarf) */
	void		*p_debug;
	
	/* Section Table */
	int			i_num_sectbl;
	LibGoblin_SectionTable	*p_sectbl;

}	LibGoblin_BinaryInfo;




LIBGOBLIN_BINFO_EXTERN	LibGoblin_BinaryInfo		*gp_binary_info;
LIBGOBLIN_BINFO_EXTERN	int							gi_max_binary_info;
LIBGOBLIN_BINFO_EXTERN	int							gi_now_binary_info;


LIBGOBLIN_BINFO_EXTERN
	LibGoblin_BinaryInfo *
		LibDrd64_BinInfo_AllocBinInfo(
			void );

LIBGOBLIN_BINFO_EXTERN
	int
		LibGoblin_FreeBinaryInfo(
			LibGoblin_BinaryInfo *p_binfo );

LIBGOBLIN_BINFO_EXTERN
	int
		LibGoblin_InitBinaryInfo(
			void );

LIBGOBLIN_BINFO_EXTERN
	int
		LibGoblin_TermBinaryInfo(
			void );

LIBGOBLIN_BINFO_EXTERN
	LibGoblin_BinaryInfo *
		LibGoblin_BInfo_GetBinaryInfo(
			int i_bid );



#endif	/* DRD64_HEADER_LIBGOBLIN_BINFO */

/* EOF of drd64_.h ----------------------------------- */
