/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_DWARF
#include"drd64_libgoblin.h"

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_EXTERN
int
	LibGoblin_IsDwarf(
		LibGoblin_BinaryInfo	*p_bin )
{
	Byte	*pb_data_abbrev;
	QWord	qw_size_abbrev;

	assert( NULL != p_bin );

	/* Get .debug_abbrev section Info */
	pb_data_abbrev	= LibGoblin_Elf_GetSection(
						&qw_size_abbrev, p_bin,
						LIBGOBLIN_ELF_SEC_ID_DEBUG_ABBREV );
	if( NULL == pb_data_abbrev )	{ return 0x00; }

	return 0x01;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_EXTERN
int
	LibGoblin_FreeDwarfInfo(
		LibGoblin_BinaryInfo	*p_bin )
{
	LibGoblin_Dwarf_AbbrevInfo		*p_abbrev;
	LibGoblin_Dwarf_SourceFile		*p_src;
	LibGoblin_Debug_Dwarf			*p_dwarf;
	
	assert( NULL != p_bin );

	if( NULL == p_bin->p_debug )	{ return 0x00; }
	p_dwarf	= (LibGoblin_Debug_Dwarf *)p_bin->p_debug;

	p_src	= p_dwarf->p_src;
	p_abbrev	= p_src->p_abbrev_info;
	free( p_abbrev );
	free( p_src );
	p_dwarf->p_src	= NULL;

	free( p_bin->p_debug );
	p_bin->p_debug	= NULL;


	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_EXTERN
int
	LibGoblin_AnalyzeDwarf(
		LibGoblin_BinaryInfo	*p_bin )
{
	int		i_srcfilenum;
	int		i_abbrevs;
	int		i_err;
	LibGoblin_Debug_Dwarf	*p_dwarf;
	LibGoblin_Dwarf_SourceFile	*p_src;

	assert( NULL != p_bin );
	assert( NULL != p_bin->p_format );

	/* Alloc Debug-Info(Dwarf) Struct Memory */
	p_dwarf	= (LibGoblin_Debug_Dwarf *)malloc( sizeof(LibGoblin_Debug_Dwarf) );
	if( NULL == p_dwarf )	{ return 0x01; }
	memset( p_dwarf, 0x00, sizeof(LibGoblin_Debug_Dwarf) );
	p_bin->p_debug	= (void *)p_dwarf;

	/* Get Source File Nums & Abbrev. Sturcture Nums */
	i_err	= LibGoblin_DwarfAbbrev_GetItems(
					&i_srcfilenum, &i_abbrevs, p_bin );
	if(( 0x00 != i_err ) || ( 0 == i_srcfilenum ))	{ return 0x02; }

	/* Alloc SourceFile Debug-Info Struct. Memory */
	p_src	= (LibGoblin_Dwarf_SourceFile *)malloc(
						sizeof( LibGoblin_Dwarf_SourceFile) * i_srcfilenum );
	if( NULL == p_src )		{ return 0x03; }
	memset( p_src, 0x00, sizeof(LibGoblin_Dwarf_SourceFile) * i_srcfilenum );
	p_dwarf->p_src			= p_src;
	p_dwarf->i_srcfilenum	= i_srcfilenum;
	
	/* Read .debug_abbrev section */
	LibGoblin_DwarfAbbrev_Read( p_bin, i_abbrevs );

	/* Read .debug_abbrev section */
	LibGoblin_DwarfInfo_Analyze( p_bin );

	/* Read .debug_line section */
	LibGoblin_DwarfLine_Analyze( p_bin );
	
	puts("OK");
	

	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
