/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_DWARF_ABBREV
#include"drd64_libgoblin.h"

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_ABBREV_EXTERN
Byte *
	LibGoblin_DwarfAbbrev_ReadEntry(
		LibGoblin_Dwarf_AbbrevEntry	*p_entry,
		Byte	*pb_src,
		QWord	*pqw_remain )
{
	int		i_items;
	DWord	dw_attribute;
	DWord	dw_format;
	QWord	qw_temp;

	assert( NULL != p_entry );
	assert( NULL != pb_src );

	i_items	= 0;

	memset( p_entry, 0x00, sizeof( LibGoblin_Dwarf_AbbrevEntry ) );

	/* Read Abbrev Number */
	pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_src, pqw_remain );

	p_entry->dw_id	= (DWord)qw_temp;
	if( 0x00000000 == p_entry->dw_id )	{
		return pb_src;
	}

	/* Read TAG */
	pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_src, pqw_remain );
	p_entry->dw_tag	= (DWord)qw_temp;

	/* Read IsChildren */
	pb_src	= LibGoblin_DwarfCommon_Read_Byte(
					&(p_entry->b_children), pb_src, pqw_remain );
	if( NULL == pb_src )	{ return NULL; }

/*
	printf("%04x : TAG=%04x (Children=%x) %ld\n",
				p_entry->dw_id, p_entry->dw_tag, p_entry->b_children, *pqw_remain);
*/

	do	{
		/* Read Attribute */
		pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_src, pqw_remain );
		dw_attribute	= (DWord)qw_temp;
		p_entry->dw_attribute[i_items]	= dw_attribute;
	
		/* Read Format */
		pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_src, pqw_remain );
		dw_format		= (DWord)qw_temp;
		p_entry->dw_format[i_items]	= dw_format;

/*
		printf("    Attiribute=%02x Format=%02x\n",
					dw_attribute, dw_format);
*/

		i_items++;

	}while((0x00 != dw_attribute) && (0x00 != dw_format)
					&& (*pqw_remain > 0) );

	p_entry->i_items	= i_items;

	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_ABBREV_EXTERN
int
	LibGoblin_DwarfAbbrev_GetItems(
		int		*pi_filenum,
		int		*pi_abbrevs,
		LibGoblin_BinaryInfo	*p_bin )
{
	Byte	*pb_data;
	Byte	b_children;
	QWord	qw_temp;
	QWord	qw_size_abbrev;
	DWord	dw_abbrev_num;
	DWord	dw_tag;
	DWord	dw_attribute;
	DWord	dw_format;
	LibGoblin_Debug_Dwarf		*p_dwarf;

	assert( NULL != p_bin );

	p_dwarf	= (LibGoblin_Debug_Dwarf *)p_bin->p_debug;
	assert( NULL != p_dwarf );

	/* Get .debug_abbrev section Info */
	pb_data	= LibGoblin_Elf_GetSection(
					&qw_size_abbrev, p_bin,
					LIBGOBLIN_ELF_SEC_ID_DEBUG_ABBREV );
	if( NULL == pb_data )	{ return 0x01; }

	*pi_filenum	= 0;
	*pi_abbrevs	= 0;

	do	{
		(*pi_abbrevs)++;

		/* Read Abbrev Number */
		pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_data, &qw_size_abbrev );
		dw_abbrev_num	= (DWord)qw_temp;

		/* Read TAG */
		pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_data, &qw_size_abbrev );
		dw_tag	= (DWord)qw_temp;
		if( DW_TAG_compile_unit == dw_tag )		{
			(*pi_filenum)++;
		}

		/* Read IsChildren */
		b_children	= *pb_data++;
		qw_size_abbrev--;

		do	{
			/* Read Attribute */
			pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_data, &qw_size_abbrev );
			dw_attribute	= (DWord)qw_temp;
	
			/* Read Format */
			pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_data, &qw_size_abbrev );
			dw_format	= (DWord)qw_temp;

		}while((0x00 != dw_attribute) && (0x00 != dw_format)
					&& (qw_size_abbrev > 0) );

		/* Skip Byte for Next Compile-Unit Abbrev. */
		if( 0x00 == *pb_data )	{
			pb_data++;
			qw_size_abbrev--;
		}

	}while((qw_size_abbrev > 0) && (dw_tag != 0x00));
	
	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_ABBREV_EXTERN
int
	LibGoblin_DwarfAbbrev_Read(
		LibGoblin_BinaryInfo	*p_bin,
		int						i_abbrevs )
{
	Byte	*pb_data;
	Byte	b_children;
	QWord	qw_temp;
	QWord	qw_size_abbrev;
	QWord	qw_remain;
	DWord	dw_abbrev_num;
	DWord	dw_tag;
	DWord	dw_attribute;
	DWord	dw_format;
	LibGoblin_Dwarf_AbbrevInfo	*p_abbrev;
	LibGoblin_Dwarf_SourceFile	*p_src;
	LibGoblin_Dwarf_SourceFile	*p_nowsrc;
	LibGoblin_Debug_Dwarf		*p_dwarf;

	assert( NULL != p_bin );

	p_dwarf	= (LibGoblin_Debug_Dwarf *)p_bin->p_debug;
	assert( NULL != p_dwarf );

	p_src	= p_dwarf->p_src;
	assert( NULL != p_src );

	/* Get .debug_abbrev section Info */
	pb_data	= LibGoblin_Elf_GetSection(
					&qw_size_abbrev, p_bin,
					LIBGOBLIN_ELF_SEC_ID_DEBUG_ABBREV );
	if( NULL == pb_data )	{ return 0x01; }

	/* Alloc Abbrev Info. for debug_dwarf_info struct */
	p_abbrev	= (LibGoblin_Dwarf_AbbrevInfo *)malloc(
					sizeof(LibGoblin_Dwarf_AbbrevInfo) * i_abbrevs );
	if( NULL == p_abbrev )	{ return 0x02; }
	memset( p_abbrev, 0x00,
				sizeof(LibGoblin_Dwarf_AbbrevInfo) * i_abbrevs );


	do	{
		/* Set Abbrev Data to AbbrevInfo Struct - Phase 1*/
		p_abbrev->pb_pos	= pb_data;
		qw_remain			= qw_size_abbrev;

		/* Read Abbrev Number */
		pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_data, &qw_remain );
		dw_abbrev_num	= (DWord)qw_temp;

		/* Read TAG */
		pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_temp, pb_data, &qw_remain );
		dw_tag	= (DWord)qw_temp;

		/* Read IsChildren */
		b_children	= *pb_data++;
		qw_remain--;

		/* Set Abbrev Data to AbbrevInfo Struct */
		p_abbrev->dw_tag	= dw_tag;
		p_abbrev->dw_id		= dw_abbrev_num;

		if( DW_TAG_compile_unit == dw_tag )		{
			p_nowsrc	= p_src++;
			p_nowsrc->p_abbrev_info	= p_abbrev;
		}

		/*printf("%04x : TAG=%04x (Children=%x) %ld\n",
					dw_abbrev_num, dw_tag, b_children, qw_size_abbrev);*/

		do	{
			/* Read Attribute */
			pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_data, &qw_remain );
			dw_attribute	= (DWord)qw_temp;
	
			/* Read Format */
			pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_temp, pb_data, &qw_remain );
			dw_format	= (DWord)qw_temp;

			/*printf("    Attiribute=%02x Format=%02x\n",
						dw_attribute, dw_format);*/

		}while((0x00 != dw_attribute) && (0x00 != dw_format)
					&& (qw_remain > 0) );

		p_abbrev->w_size	= (Word)(qw_size_abbrev - qw_remain);
		p_abbrev++;

		/* Skip Byte for Next Compile-Unit Abbrev. */
		if( 0x00 == *pb_data )	{
			pb_data++;
			qw_remain--;
		}

	}while((qw_remain > 0) && (dw_tag != 0x00));
	
	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
