/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_DWARF_COMMON
#include"drd64_libgoblin.h"

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Read_Byte(
		Byte	*pb_value,
		Byte	*pb_src,
		QWord	*pqw_size )
{
	if( 1 > *pqw_size )		{ return NULL; }

	*pb_value	= *(pb_src);
	pb_src		+= 1;
	*pqw_size	-= 1;
	
	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Read_Word(
		Word	*pw_value,
		Byte	*pb_src,
		QWord	*pqw_size )
{
	if( 2 > *pqw_size )		{ return NULL; }

	*pw_value	= *((Word *)pb_src);
	pb_src		+= 2;
	*pqw_size	-= 2;
	
	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Read_DWord(
		DWord	*pdw_value,
		Byte	*pb_src,
		QWord	*pqw_size )
{
	if( 4 > *pqw_size )		{ return NULL; }

	*pdw_value	= *((DWord *)pb_src);
	pb_src		+= 4;
	*pqw_size	-= 4;
	
	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Read_QWord(
		QWord	*pqw_value,
		Byte	*pb_src,
		QWord	*pqw_size )
{
	if( 8 > *pqw_size )		{ return NULL; }

	*pqw_value	= *((QWord *)pb_src);
	pb_src		+= 8;
	*pqw_size	-= 8;
	
	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Read_CUHeader(
		LibGoblin_DwarfCommon_CUHeader	*p_cuhead,
		Byte	*pb_data,
		QWord	qw_size_info )
{
	int		i_bitflag;
	int		i_readbytes;
	DWord	dw_dword;
	QWord	qw_qword;

	assert( NULL != p_cuhead );
	assert( NULL != pb_data );

	i_readbytes	= 0;
	i_bitflag	= 32;

	/*   Read unit_length (4Byte + 8Byte(64bit)) */
	pb_data	= LibGoblin_DwarfCommon_Read_DWord(
				&dw_dword, pb_data, &qw_size_info );
	if( NULL == pb_data )	{ return NULL; }

	if( ((DWord)0xffffffff) == dw_dword )	{
		pb_data	= LibGoblin_DwarfCommon_Read_QWord(
					&qw_qword, pb_data, &qw_size_info );
		if( NULL == pb_data )	{ return NULL; }

		p_cuhead->qw_unitsize	= (QWord)qw_qword;
		i_bitflag				= 64;
		p_cuhead->b_bits		= 64;
	}
	else	{
		p_cuhead->qw_unitsize	= (QWord)dw_dword;
		p_cuhead->b_bits		= 32;
	}

	/*   Read version (2Byte) */
	pb_data	= LibGoblin_DwarfCommon_Read_Word(
				&(p_cuhead->w_version), pb_data, &qw_size_info );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	= 2;

	/*   Read abbrev_offset (4Byte(32bit), 8Byte(64bit)) */
	if( 64 == i_bitflag )	{
		pb_data	= LibGoblin_DwarfCommon_Read_QWord(
					&qw_qword, pb_data, &qw_size_info );
		if( NULL == pb_data )	{ return NULL; }
		i_readbytes	+= 8;

		p_cuhead->qw_abbrev_offset	= qw_qword;
	}
	else	{
		pb_data	= LibGoblin_DwarfCommon_Read_DWord(
					&dw_dword, pb_data, &qw_size_info );
		if( NULL == pb_data )	{ return NULL; }
		i_readbytes	+= 4;

		p_cuhead->qw_abbrev_offset	= (QWord)dw_dword;
	}

	/*   Read address_size (1Byte) */
	pb_data	= LibGoblin_DwarfCommon_Read_Byte(
				&(p_cuhead->b_pointersize), pb_data, &qw_size_info);
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;

	p_cuhead->qw_unitsize	-= i_readbytes;
	
	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Decode_ULEB128(
		QWord	*qw_result,
		Byte	*pb_data,
		QWord	*pqw_remain )
{
	Byte	b_value;
	int		i_shift;

	*qw_result	= 0x00;
	i_shift		= 0;
	b_value		= 0x80;
	while( (0x00 != (b_value & 0x80)) && (0 < *pqw_remain) )	{
		b_value		= *pb_data++;
		*qw_result	= *qw_result | ((QWord)(b_value & 0x7f) << i_shift);
		(*pqw_remain)--;
		i_shift		+= 7;	
	}

	return	pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_COMMON_EXTERN
Byte *
	LibGoblin_DwarfCommon_Decode_LEB128(
		Int64	*ii_result, 
		Byte	*pb_data,
		QWord	*pqw_remain )
{
	Byte	b_value;
	int		i_shift;

	*ii_result	= 0x00;
	i_shift		= 0;
	b_value		= 0x80;
	while( (0x00 != (b_value & 0x80)) && (0 < *pqw_remain) )	{
		b_value		= *pb_data++;
		*ii_result	= *ii_result | ((Int64)(b_value & 0x7f) << i_shift);
		(*pqw_remain)--;
		i_shift		+= 7;	
	}

	if((i_shift < 64) && ( 0x00 != (b_value & 0x40)))	{
		*ii_result	|= -1 * (0x01 << i_shift);
	}

	return	pb_data;
}


/* EOF of drd64_.c ----------------------------------- */
