/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_DWARF_ABBREV
#include"drd64_libgoblin.h"

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
		LibGoblin_Dwarf_DIEValue	*p_dievalue,
		Byte	*pb_src, 
		QWord	*pqw_remain,
		Byte	*pb_type,
		int		i_sizebytes,
		Byte	*pb_custart )
{
	Byte	*pb_link;
	Byte	b_size;
	Word	w_size;
	DWord	dw_size;
	QWord	qw_size;

	assert( NULL != pb_src );
	assert( NULL != p_dievalue );

	if( 1 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_Byte(
						&b_size, pb_src, pqw_remain );
		qw_size	= (QWord)b_size;
	}
	else if( 2 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_Word(
						&w_size, pb_src, pqw_remain );
		qw_size	= (QWord)w_size;
	}
	else if( 4 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_DWord(
						&dw_size, pb_src, pqw_remain );
		qw_size	= (QWord)dw_size;
	}
	else if( 8 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_QWord(
						&qw_size, pb_src, pqw_remain );
	}
	else	{
		pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
       			        &qw_size, pb_src, pqw_remain );
	}
	if( NULL == pb_src )	{ return NULL; }

	pb_link	= pb_custart + qw_size;
	p_dievalue->pb_link	= pb_link;
	*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_LINK;
	
	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadFormat_Block(
		LibGoblin_Dwarf_DIEValue	*p_dievalue,
		Byte	*pb_src, 
		QWord	*pqw_remain,
		Byte	*pb_type,
		int		i_sizebytes )
{
	Byte	b_size;
	Word	w_size;
	DWord	dw_size;
	QWord	qw_size;
	assert( NULL != pb_src );
	assert( NULL != p_dievalue );

	if( 1 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_Byte(
						&b_size, pb_src, pqw_remain );
		qw_size	= (QWord)b_size;
	}
	else if( 2 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_Word(
						&w_size, pb_src, pqw_remain );
		qw_size	= (QWord)w_size;
	}
	else if( 4 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_DWord(
						&dw_size, pb_src, pqw_remain );
		qw_size	= (QWord)dw_size;
	}
	else if( 8 == i_sizebytes )	{
		pb_src	= LibGoblin_DwarfCommon_Read_QWord(
						&qw_size, pb_src, pqw_remain );
	}
	else	{
		pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
       			        &qw_size, pb_src, pqw_remain );
	}

	if( NULL == pb_src )	{ return NULL; }

	
	if( *pqw_remain >= qw_size )	{
		p_dievalue->t_value.qw_size	= qw_size;
		p_dievalue->t_value.pb_data	= pb_src;
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_BLOCK;
		pb_src		+= qw_size;
		*pqw_remain	-= qw_size;
	}

	return pb_src;
}

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadFormat_Strp(
		LibGoblin_Dwarf_DIEValue	*p_dievalue,
		Byte	*pb_src, 
		QWord	*pqw_remain,
		Byte	*pb_type,
		Byte	b_bits )
{
	assert( NULL != pb_src );
	assert( NULL != p_dievalue );

	if( 64 == b_bits )	{
		pb_src	= LibGoblin_DwarfCommon_Read_QWord(
					&(p_dievalue->qw_value), pb_src, pqw_remain );
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_QWORD;
	}
	else if( 32 == b_bits )	{
		pb_src	= LibGoblin_DwarfCommon_Read_DWord(
					&(p_dievalue->dw_value), pb_src, pqw_remain );
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_DWORD;
	}

	return pb_src;
}
/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadFormat_String(
		LibGoblin_Dwarf_DIEValue	*p_dievalue,
		Byte	*pb_src, 
		QWord	*pqw_remain,
		Byte	*pb_type )
{
	Byte	*pb_now;

	assert( NULL != pb_src );
	assert( NULL != p_dievalue );

	pb_now	= pb_src;

	while( (0 < *pqw_remain) && ('\0' != *pb_now) )	{
		pb_now++;
		(*pqw_remain)--;
	}

	if( 0 < *pqw_remain )	{
		p_dievalue->str_value	= (char *)pb_src;
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_STRING;

		pb_now++;
		(*pqw_remain)--;
	}

	return pb_now;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadFormat_Address(
		LibGoblin_Dwarf_DIEValue	*p_dievalue,
		Byte	*pb_src, 
		QWord	*pqw_remain,
		Byte	*pb_type,
		int		i_pointersize )
{
	assert( NULL != pb_src );
	assert( NULL != p_dievalue );

	if( 8 == i_pointersize )	{
		pb_src	= LibGoblin_DwarfCommon_Read_QWord(
					&(p_dievalue->qw_value), pb_src, pqw_remain );
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_QWORD;
	}
	else if( 4 == i_pointersize )	{
		pb_src	= LibGoblin_DwarfCommon_Read_DWord(
					&(p_dievalue->dw_value), pb_src, pqw_remain );
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_DWORD;
	}
	else if( 2 == i_pointersize )	{
		pb_src	= LibGoblin_DwarfCommon_Read_Word(
					&(p_dievalue->w_value), pb_src, pqw_remain );
		*pb_type	= LIBGOBLIN_DWARF_INFO_TYPE_WORD;
	}

	if( NULL == pb_src )
		{ *pb_type = LIBGOBLIN_DWARF_INFO_TYPE_NONE; }

	return pb_src;
}



/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadDIE(
		LibGoblin_Dwarf_DIE *p_die,
		Byte	*pb_src, 
		QWord	*pqw_remains,
		LibGoblin_Dwarf_SourceFile	*pt_srcfile,
		LibGoblin_DwarfCommon_CUHeader	*p_cuheader )
{
	int		i_cnt;
	Byte	*pb_abb;
	Byte	b_type;
	DWord	dw_abbrev;
	DWord	dw_attribute;
	DWord	dw_format;
	QWord	qw_size;
	QWord	qw_temp;
	LibGoblin_Dwarf_AbbrevInfo	*p_abbrev;
	LibGoblin_Dwarf_AbbrevEntry	t_abbentry;

	//printf(" pnt: %p  ", pb_src);
	/* Read Reference Abbrev-ID */
	pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
                &qw_temp, pb_src, pqw_remains );
	dw_abbrev	= (DWord)qw_temp;

	//printf(" abbrev: %ld\n", dw_abbrev);

	if( 0x00000000 == dw_abbrev )	{ return pb_src; }

	/* Set Reference Abbrev */
	p_abbrev	= (pt_srcfile->p_abbrev_info) + (dw_abbrev - 1 );
	if( NULL == p_abbrev )	{ return NULL; }

	pb_abb	= p_abbrev->pb_pos;
	assert( NULL != pb_abb );

	qw_size	= (QWord)p_abbrev->w_size;
	pb_abb	= LibGoblin_DwarfAbbrev_ReadEntry( &t_abbentry, pb_abb, &qw_size);
	if( NULL == pb_abb )	{ return NULL; }

	p_die->dw_tag		= t_abbentry.dw_tag;
	p_die->dw_abbrev	= t_abbentry.dw_id;
	p_die->i_items		= t_abbentry.i_items;

	for( i_cnt = 0; i_cnt < p_die->i_items; i_cnt++ )	{
		dw_attribute	= t_abbentry.dw_attribute[ i_cnt ];
		dw_format		= t_abbentry.dw_format[ i_cnt ];

		p_die->dw_attribute[ i_cnt ]	= dw_attribute;
		p_die->dw_format[ i_cnt ]		= dw_format;
		
		switch( dw_format )	{
			case DW_FORM_addr:		/* 0x01: address */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Address(
							&(p_die->t_value[i_cnt]), pb_src, pqw_remains,
							&b_type, (int)(p_cuheader->b_pointersize) ); 
				break;
			case DW_FORM_block2:	/* 0x03: block */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Block(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 2);
				break;
			case DW_FORM_block4:	/* 0x04: block */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Block(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 4);
				break;
			case DW_FORM_data2:		/* 0x05: const. */
				pb_src	= LibGoblin_DwarfCommon_Read_Word(
							&(p_die->t_value[i_cnt].w_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_WORD;
				break;
			case DW_FORM_data4:		/* 0x06: const. line/loc/mac/rng-ptr */
				pb_src	= LibGoblin_DwarfCommon_Read_DWord(
							&(p_die->t_value[i_cnt].dw_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_DWORD;
				break;
			case DW_FORM_data8:		/* 0x07: const. line/loc/mac/rng-ptr */
				pb_src	= LibGoblin_DwarfCommon_Read_QWord(
							&(p_die->t_value[i_cnt].qw_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_QWORD;
				break;
			case DW_FORM_string:	/* 0x08: string */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_String(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type);
				break;
			case DW_FORM_block:		/* 0x09: block */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Block(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, -1);
				break;
			case DW_FORM_block1:	/* 0x0a: block */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Block(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 1);
				break;
			case DW_FORM_data1:		/* 0x0b: const. */
				pb_src	= LibGoblin_DwarfCommon_Read_Byte(
							&(p_die->t_value[i_cnt].b_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_BYTE;
				break;
			case DW_FORM_flag:		/* 0x0c: flag */
				pb_src	= LibGoblin_DwarfCommon_Read_Byte(
							&(p_die->t_value[i_cnt].b_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_BYTE;
				break;
			case DW_FORM_sdata:		/* 0x0d: sdata */
				pb_src	= LibGoblin_DwarfCommon_Decode_LEB128(
							&(p_die->t_value[i_cnt].ii_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_INT64;
				break;
			case DW_FORM_strp:		/* 0x0e: string */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Strp(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type,
							p_cuheader->b_bits );
				// XXX  reference for .debug_str
				break;
			case DW_FORM_udata:		/* 0x0f: const. */
				pb_src	= LibGoblin_DwarfCommon_Decode_ULEB128(
							&(p_die->t_value[i_cnt].qw_value),
							pb_src, pqw_remains );
				b_type	= LIBGOBLIN_DWARF_INFO_TYPE_QWORD;
				break;
			case DW_FORM_ref_addr:	/* 0x10: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Address(
							&(p_die->t_value[i_cnt]),pb_src, pqw_remains,
							&b_type, (int)(p_cuheader->b_pointersize) ); 
				break;
			case DW_FORM_ref1:		/* 0x11: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 1,
							pt_srcfile->t_infosec.pb_pos );
				break;
			case DW_FORM_ref2:		/* 0x12: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 2,
							pt_srcfile->t_infosec.pb_pos );
				break;
			case DW_FORM_ref4:		/* 0x13: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 4,
							pt_srcfile->t_infosec.pb_pos );
				break;
			case DW_FORM_ref8:		/* 0x14: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, 8,
							pt_srcfile->t_infosec.pb_pos );
				break;
			case DW_FORM_ref_udata:	/* 0x15: ref. */
				pb_src	= LibGoblin_DwarfInfo_ReadFormat_Ref_inCU(
							&(p_die->t_value[i_cnt]),
							pb_src, pqw_remains, &b_type, -1,
							pt_srcfile->t_infosec.pb_pos );
				break;
			case DW_FORM_indirect:	/* 0x16: ref. */
				puts("a");
				break;
			default:
				break;
		}
	}
	

	return pb_src;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfInfo_ReadCompileUnit(
		LibGoblin_Dwarf_SourceFile	*p_src,
		Byte	*pb_data,
		QWord	*pqw_size_info )
{
	QWord		qw_unitsize;
	LibGoblin_DwarfCommon_CUHeader	t_cuheader;
	LibGoblin_Dwarf_DIE t_die;

	assert( NULL != p_src );
	assert( NULL != pb_data );

	if( 0 == *pqw_size_info )		{ return NULL; }
	
	/* Read Compile Unit Header */
	pb_data	= LibGoblin_DwarfCommon_Read_CUHeader(
						&t_cuheader, pb_data, *pqw_size_info);
	if( NULL == pb_data )	{ return NULL; }

	qw_unitsize		= t_cuheader.qw_unitsize;

/*	printf( "size: %ld, ver:%d, abbrev off.:%ld, addr.size: %d\n",
			t_cuheader.qw_unitsize,
			t_cuheader.w_version,
			t_cuheader.qw_abbrev_offset,
			t_cuheader.b_pointersize); */

	do	{
		/* Read Debug Information Entry (DIE */
		pb_data	= LibGoblin_DwarfInfo_ReadDIE(
					&t_die, pb_data, &qw_unitsize, p_src, &t_cuheader );

		/* Dispatch for generate Rapid-Access Table by DIE-tag */

	}while( 0 != qw_unitsize ); 

	puts( "OKOK");
	*pqw_size_info	-= t_cuheader.qw_unitsize;

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_INFO_EXTERN
int
	LibGoblin_DwarfInfo_Analyze(
		LibGoblin_BinaryInfo	*p_bin )
{
	int		i_srcfiles;
	Byte	*pb_data;
	QWord	qw_size_info;
	LibGoblin_Dwarf_SourceFile	*p_src;
	LibGoblin_Debug_Dwarf		*p_dwarf;

	assert( NULL != p_bin );

	p_dwarf	= (LibGoblin_Debug_Dwarf *)p_bin->p_debug;
	assert( NULL != p_dwarf );

	i_srcfiles	= p_dwarf->i_srcfilenum;

	p_src	= p_dwarf->p_src;
	assert( NULL != p_src );

	/* Get .debug_abbrev section Info */
	pb_data	= LibGoblin_Elf_GetSection(
					&qw_size_info, p_bin,
					LIBGOBLIN_ELF_SEC_ID_DEBUG_INFO );
	if( NULL == pb_data )	{ return 0x01; }

	do	{
		p_src->t_infosec.pb_pos	= pb_data;

		/* Analyze .debug_info compile unit */
		pb_data	= LibGoblin_DwarfInfo_ReadCompileUnit(
						p_src, pb_data, &qw_size_info );
		if( NULL == pb_data)	{ return 0x02; }

		p_src++;
		i_srcfiles--;

	}while((qw_size_info > 0) && (i_srcfiles > 0));
	
	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
