/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_DWARF_ABBREV
#include"drd64_libgoblin.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_Read_LineHeader_FileNameData(
		LibGoblin_Dwarf_LineSection *pt_line,
		Byte	*pb_data,
		QWord	*pqw_remain,
		int		i_files )
{
	QWord	qw_qword;
	Byte	b_byte;

	/* Read FileName */
	b_byte	= *pb_data;
	pt_line->t_filename[ i_files ].pstr_srcfilename
									= (char *)(pb_data - 1);
	while( ( 0 < *pqw_remain) && ('\0' != b_byte) )	{
		(*pqw_remain)--;
		b_byte	= *pb_data++;
	}

	/* Read Directory Index */
	pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_qword, pb_data, pqw_remain );
	if( NULL == pb_data )	{ return NULL; }
	pt_line->t_filename[ i_files ].dw_dirindex	= (DWord)qw_qword;

	/* Read File-Date */
	pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_qword, pb_data, pqw_remain );
	if( NULL == pb_data )	{ return NULL; }
	pt_line->t_filename[ i_files ].qw_date	= qw_qword;

	/* Read File-Size */
	pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
					&qw_qword, pb_data, pqw_remain );
	if( NULL == pb_data )	{ return NULL; }
	pt_line->t_filename[ i_files ].qw_filesize	= qw_qword;

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_Read_LineHeader_FileNames(
		LibGoblin_Dwarf_LineSection *pt_line,
		Byte	*pb_data,
		QWord	*pqw_remain )
{
	int		i_files;
	//QWord	qw_qword;
	Byte	b_byte;

	i_files	= 0;

	if( 1 > (*pqw_remain)-- )	{ return NULL; }
	b_byte	= *pb_data++;

	while( '\0' != b_byte)	{
		pb_data	= LibGoblin_DwarfLine_Read_LineHeader_FileNameData(
						pt_line, pb_data, pqw_remain, i_files );

		/* Read FileName */
/*		pt_line->t_filename[ i_files ].pstr_srcfilename
									= (char *)(pb_data - 1);
		while( ( 0 < *pqw_remain) && ('\0' != b_byte) )	{
			(*pqw_remain)--;
			b_byte	= *pb_data++;
		}
*/
		/* Read Directory Index */
		/*pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_qword, pb_data, pqw_remain );
		if( NULL == pb_data )	{ return NULL; }
		pt_line->t_filename[ i_files ].dw_dirindex	= (DWord)qw_qword;
*/
		/* Read File-Date */
		/*pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_qword, pb_data, pqw_remain );
		if( NULL == pb_data )	{ return NULL; }
		pt_line->t_filename[ i_files ].qw_date	= qw_qword;
*/
		/* Read File-Size */
		/*pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_qword, pb_data, pqw_remain );
		if( NULL == pb_data )	{ return NULL; }
		pt_line->t_filename[ i_files ].qw_filesize	= qw_qword;
*/
		if( 1 > (*pqw_remain)-- )	{ return NULL; }
		b_byte	= *pb_data++;
	
		i_files++;
	}

	pt_line->i_num_filename	= i_files;

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_Read_LineHeader_IncludePath(
		LibGoblin_Dwarf_LineSection *pt_line,
		Byte	*pb_data,
		QWord	*qw_remain )
{
	int		i_cnt;
	Byte	b_byte;

	i_cnt	= 0;

	if( 1 > (*qw_remain)-- )	{ return NULL; }
	pt_line->pstr_includepath	= (char *)pb_data;
	b_byte	= *pb_data++;

	while( '\0' != b_byte )	{ 
		if( 1 > (*qw_remain)-- )	{ return NULL; }
		b_byte	= *pb_data++;

		if( '\0' == b_byte )	{
			if( 1 > (*qw_remain)-- )	{ return NULL; }
			b_byte	= *pb_data++;
			i_cnt++;
		}
	}
	pt_line->i_num_includepath	= i_cnt;

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_Read_LineHeader(
		LibGoblin_Dwarf_LineSection *pt_line,
		Byte	*pb_data,
		QWord	*pqw_size_linesec )
{
	int		i_bitflag;
	int		i_readbytes;
	int		i_cnt;
	Byte	b_byte;
	DWord	dw_dword;
	QWord	qw_qword;
	QWord	qw_remain;

	assert( NULL != pt_line );
	assert( NULL != pb_data );


	i_readbytes	= 0;
	i_bitflag	= 32;
	pt_line->b_bits	= 32;
	qw_remain	= *pqw_size_linesec;

	puts("now");
	/* Read unit_length (4Byte(32bit) or 8Byte(64bit)) */
	pb_data	= LibGoblin_DwarfCommon_Read_DWord(
						&dw_dword, pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }

    if( ((DWord)0xffffffff) == dw_dword )   {
		pb_data	= LibGoblin_DwarfCommon_Read_QWord(
					&qw_qword, pb_data, &qw_remain );
		if( NULL == pb_data )	{ return NULL; }
		
		i_bitflag	= 64;
		pt_line->b_bits	= 64;
		qw_remain	= qw_qword;
	}
	else	{
		qw_remain	= (QWord)dw_dword;
	}
	
	/* Read version (2Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Word(
					&(pt_line->w_version), pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 2;

	/* Read Header Length (4Byte(32bit), 8Byte(64bit)) */
    if( 64 == i_bitflag )	{
		pb_data = LibGoblin_DwarfCommon_Read_QWord(
					&qw_qword, pb_data, &qw_remain );
		if( NULL == pb_data )	{ return NULL; }
		i_readbytes += 8;

		pt_line->qw_headerlength	= qw_qword;
    }
    else    {
		pb_data = LibGoblin_DwarfCommon_Read_DWord(
					&dw_dword, pb_data, &qw_remain );
		if( NULL == pb_data )	{ return NULL; }
		i_readbytes += 4;

		pt_line->qw_headerlength	= (QWord)dw_dword;
    }

	/* Read minimum Instruction Length (1Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&(pt_line->b_minimum_inst_length), pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;

	/* Read default isStatement (1Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&(pt_line->b_default_is_stmt), pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;

	/* Read LineBase (1Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&b_byte, pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;
	pt_line->i_line_base	= (INT)((char)b_byte);

	/* Read LineRange (1Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&b_byte, pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;
	pt_line->i_line_range	= (INT)((DWord)b_byte);

	/* Read Opcode Base (1Byte) */
	pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&(pt_line->b_opcode_base), pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	i_readbytes	+= 1;

	/* Read Operand length of the Standard Opecode */
	for( i_cnt = 1; i_cnt < (pt_line->b_opcode_base); i_cnt++)	{
		pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
						&qw_qword, pb_data, &qw_remain );
		pt_line->dw_stdoperand_length[i_cnt]	= (int)((DWord)qw_qword);
	}

	/* Read Include File-Path  */
	pb_data	= LibGoblin_DwarfLine_Read_LineHeader_IncludePath(
					pt_line, pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }

	/* Read FileNames */
	pb_data	= LibGoblin_DwarfLine_Read_LineHeader_FileNames(
					pt_line, pb_data, &qw_remain );
	if( NULL == pb_data )	{ return NULL; }
	

	printf("  version: %d \n", pt_line->w_version );
	printf("  header length: %ld\n", pt_line->qw_headerlength );
	printf("  min. Inst. length: %d\n", pt_line->b_minimum_inst_length );
	printf("  default isStmt: %x\n", pt_line->b_default_is_stmt );
	printf("  line_base: %d\n", pt_line->i_line_base );
	printf("  line_range: %d\n", pt_line->i_line_range );
	printf("  opcode_base: %d\n", pt_line->b_opcode_base );
	for( i_cnt = 0; i_cnt < pt_line->b_opcode_base; i_cnt++ )	{
		printf("    Std.Operand(%x) : %d \n", i_cnt, 
			pt_line->dw_stdoperand_length[i_cnt] );
	}
	printf("  include path nums: %d\n", pt_line->i_num_includepath );
	printf("  include file nums: %d\n", pt_line->i_num_filename );
	for( i_cnt = 0; i_cnt < pt_line->i_num_filename; i_cnt++ )	{
		printf("    SrcFile[%d] filename: %s  Dir.Index: %d  Date: %ld  Size: %ld \n", 
						i_cnt, 
						pt_line->t_filename[i_cnt].pstr_srcfilename,
						pt_line->t_filename[i_cnt].dw_dirindex,
						pt_line->t_filename[i_cnt].qw_date,
						pt_line->t_filename[i_cnt].qw_date );
	}

	//*pqw_size_linesec	= qw_remain;

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
QWord
	LibGoblin_DwarfLine_CalcAddress(
		Byte	b_opcode,
		LibGoblin_Dwarf_LineSection		*pt_line )
{
	QWord	qw_value;

	assert( NULL != pt_line );

	qw_value	= ((INT)(b_opcode - pt_line->b_opcode_base)
						/ pt_line->i_line_range)
					* (INT)pt_line->b_minimum_inst_length;

	return qw_value;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Int64
	LibGoblin_DwarfLine_CalcLine(
		Byte	b_opcode,
		LibGoblin_Dwarf_LineSection		*pt_line )
{
	Int64	ii_value;

	assert( NULL != pt_line );

	ii_value	= (Int64)(((INT)(b_opcode - pt_line->b_opcode_base)
							% pt_line->i_line_range) + pt_line->i_line_base);

	return ii_value;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int	
	LibGoblin_DwarfLine_DebugPrint_Register(
		LibGoblin_Dwarf_Line_Register	*pt_reg )
{
	if( NULL == pt_reg )	{
		puts(" Error: DebugRegister is NULL ");
		return 0xff;
	}

	printf("  [Line] File:%3d, PC:%08lx, Line:%5ld, Col:%2ld, ISA:%2ld, Option: %s%s%s%s\n",
			pt_reg->dw_file, pt_reg->qw_address, pt_reg->qw_line,
    		pt_reg->qw_column,pt_reg->qw_isa,
			((pt_reg->b_is_stmt != 0x00 ) ? "Stmt : " : "" ),
			((pt_reg->b_basic_block != 0x00 ) ? "BasicBlk : " : "" ),
			((pt_reg->b_prologue_end != 0x00 ) ? "PrologueEnd : " : "" ),
			((pt_reg->b_epilogue_begin != 0x00 ) ? "EpilogueBegin" : "" ));

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int	
	LibGoblin_DwarfLine_InitRegister(
		LibGoblin_Dwarf_Line_Register	*pt_reg, 
		LibGoblin_Dwarf_LineSection 	*pt_line )
{
	assert( NULL != pt_reg );
	assert( NULL != pt_line );

	pt_reg->qw_address			= 0x0000000000000000;
    pt_reg->qw_line				= 1;
    pt_reg->dw_file				= 1;
	pt_reg->b_is_stmt
			= (pt_line->b_default_is_stmt == 0x00 ? 0x00 : 0x01 );
    pt_reg->b_basic_block		= 0x00;
    pt_reg->b_prologue_end		= 0x00;
    pt_reg->b_epilogue_begin	= 0x00;
    pt_reg->qw_column			= 0;
    pt_reg->qw_isa				= 0;

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_Read_LineData(
		LibGoblin_Dwarf_LineSection *pt_line,
		Byte	*pb_data,
		QWord	*pqw_remain )
{
	Byte	*pb_temp;
	Byte	b_opcode;
	QWord	qw_qword;
	Int64	ii_value;
	Word	w_value;
	LibGoblin_Dwarf_Line_Register	t_reg;
	
	assert( NULL != pt_line );
	assert( NULL != pb_data );

	LibGoblin_DwarfLine_InitRegister( &t_reg, pt_line );

	do	{
		/* Read Opecode */
		pb_data = LibGoblin_DwarfCommon_Read_Byte(
					&b_opcode, pb_data, pqw_remain );
		if( NULL == pb_data )	{ return NULL; }

		/* Read & Proc. by Opcode */
		if( 0x00 == b_opcode )		{
			/* Extended Opcode */
			pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
							&qw_qword, pb_data, pqw_remain );
			pb_temp	= pb_data + qw_qword;

			/* XXX: unsupport user-more_than_2byte_opcode */
			pb_data = LibGoblin_DwarfCommon_Read_Byte(
						&b_opcode, pb_data, pqw_remain );
			if( NULL == pb_data )	{ return NULL; }

			/* dispatch for Extendee Opcode */
			if( DW_LNE_end_sequence == b_opcode )	{
				/* No Operand */
				puts("  DW_LNE_end_sequence <NoOperand>");
				break;
			}
			else if( DW_LNE_set_address == b_opcode )	{
				/* Operand: 4Byte(32bit) or 8Byte(64bit) */
					pb_data = LibGoblin_DwarfCommon_Read_QWord(
									&qw_qword, pb_data, pqw_remain );
					t_reg.qw_address	= qw_qword;
				/*if( 64 == pt_line->b_bits )	{
					pb_data = LibGoblin_DwarfCommon_Read_QWord(
									&qw_qword, pb_data, pqw_remain );
					t_reg.qw_address	= qw_qword;
				}
				else 	{
					pb_data = LibGoblin_DwarfCommon_Read_DWord(
									&dw_value, pb_data, pqw_remain );
					t_reg.qw_address	= (QWord)dw_value;
				}*/
				printf("  DW_LNE_set_address %08lx\n", t_reg.qw_address );
			}
			else if( DW_LNE_define_file == b_opcode )	{
				/* Operand: Filename Data Struct(Line Header) */
				pb_data	= LibGoblin_DwarfLine_Read_LineHeader_FileNameData(
								pt_line, pb_data, pqw_remain,
								pt_line->i_num_filename );
				pt_line->i_num_filename++;
				printf("  DW_LNE_define_file \n");
			}
			else	{
				pb_data	= pb_temp;
			}
		
		}
		else if( pt_line->b_opcode_base > b_opcode )	{
			/* Standard Opcode */
			switch( b_opcode )	{
				case DW_LNS_copy:				/* 0x01 */
					/* No Operand */
					t_reg.b_basic_block		= 0x00;
					t_reg.b_prologue_end	= 0x00;
					t_reg.b_epilogue_begin	= 0x00;
					puts("  DW_LNS_copy <NoOperand>");
					break;

				case DW_LNS_advance_pc:			/* 0x02 */
					/* Operand: uLEB128 */
					pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
									&qw_qword, pb_data, pqw_remain );
					t_reg.qw_address
						+= pt_line->b_minimum_inst_length * qw_qword;
					printf("  DW_LNS_advance_pc %08lx\n", qw_qword);
					
					break;

				case DW_LNS_advance_line:		/* 0x03 */
					/* Operand: sLEB128 */
					pb_data	= LibGoblin_DwarfCommon_Decode_LEB128(
									&ii_value, pb_data, pqw_remain );
					t_reg.qw_line
						= (QWord)((Int64)(t_reg.qw_line) + ii_value);
					printf("  DW_LNS_advance_line %8ld\n", ii_value);
					break;

				case DW_LNS_set_file:			/* 0x04 */
					/* Operand: uLEB128 */
					pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
									&qw_qword, pb_data, pqw_remain );
					t_reg.dw_file	= (DWord)qw_qword;
					printf("  DW_LNS_set_file %ld\n", qw_qword);
					break;

				case DW_LNS_set_column:			/* 0x05 */
					/* Operand: uLEB128 */
					pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
									&qw_qword, pb_data, pqw_remain );
					t_reg.qw_column	= qw_qword;
					printf("  DW_LNS_set_column %ld\n", qw_qword);
					break;

				case DW_LNS_negate_stmt:		/* 0x06 */
					/* No Operand */
					t_reg.b_is_stmt
						= ((t_reg.b_is_stmt == 0x00) ? 0x01 : 0x00 );
					puts("  DW_LNS_negate_stmt");
					break;

				case DW_LNS_set_basic_block:	/* 0x07 */
					/* No Operand */
					t_reg.b_basic_block	= 0x01;
					puts("  DW_LNS_set_basic_block");
					break;

				case DW_LNS_const_add_pc:		/* 0x08 */
					qw_qword
						= LibGoblin_DwarfLine_CalcAddress( 0xff, pt_line);
					t_reg.qw_address	+= qw_qword;
					printf("  DW_LNS_const_add_pc %08lx\n", qw_qword);
					break;

				case DW_LNS_fixed_advance_pc:	/* 0x09 */
					/* Operand: uhalf(short) */
					pb_data = LibGoblin_DwarfCommon_Read_Word(
								&w_value, pb_data, pqw_remain );
					t_reg.qw_address += (QWord)w_value;
					printf("  DW_LNS_fixed_advance_pc %08lx\n", (QWord)w_value);
					break;

				case DW_LNS_set_prologue_end:	/* 0x0a */
					t_reg.b_prologue_end	= 0x01;
					puts("  DW_LNS_set_prologue_end");
					break;

				case DW_LNS_set_epilogue_begin:	/* 0x0b */
					t_reg.b_epilogue_begin	= 0x01;
					puts("  DW_LNS_set_epilogue_begin");
					break;

				case DW_LNS_set_isa:			/* 0x0c */
					/* Operand: uLEB128 */
					pb_data	= LibGoblin_DwarfCommon_Decode_ULEB128(
									&qw_qword, pb_data, pqw_remain );
					t_reg.qw_isa	+= qw_qword;
					printf("  DW_LNS_set_isa %08lx\n", qw_qword);
					break;

				default:
					break;
			}
		}
		else 	{
			/* Special Opcode */
			qw_qword = LibGoblin_DwarfLine_CalcAddress( b_opcode, pt_line);
			ii_value = LibGoblin_DwarfLine_CalcLine( b_opcode, pt_line);

			t_reg.qw_address	+= (qw_qword * pt_line->b_minimum_inst_length);
			t_reg.qw_line		= (QWord)((Int64)t_reg.qw_line + ii_value);

			t_reg.b_basic_block		= 0x00;
			t_reg.b_prologue_end	= 0x00;
			t_reg.b_epilogue_begin	= 0x00;

		}

		LibGoblin_DwarfLine_DebugPrint_Register( &t_reg );

	}while( 0 != *pqw_remain );

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Byte *
	LibGoblin_DwarfLine_ReadCompileUnit(
		LibGoblin_Dwarf_SourceFile *p_src,
		Byte	*pb_data,
		QWord	*pqw_remain )
{
	LibGoblin_Dwarf_LineSection	*pt_line;

	assert( NULL != p_src );
	assert( NULL != pb_data );

	pt_line	= &(p_src->t_linesec);

	/* Read & SetInfo LineHeader (in CU) */
	pt_line->pb_header	= pb_data;
	pb_data	= LibGoblin_DwarfLine_Read_LineHeader(
				pt_line, pb_data, pqw_remain );
	if( NULL == pb_data )	{
		return NULL;
	}

	/* Read & Check LineData */
	pb_data	= LibGoblin_DwarfLine_Read_LineData(
						pt_line, pb_data, pqw_remain );

	
	return pb_data;
}



/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_DWARF_LINE_EXTERN
int
	LibGoblin_DwarfLine_Analyze(
		LibGoblin_BinaryInfo	*p_bin )
{
	int		i_srcfiles;
	Byte	*pb_data;
	QWord	qw_size;
	LibGoblin_Dwarf_SourceFile	*p_src;
	LibGoblin_Debug_Dwarf		*p_dwarf;

	assert( NULL != p_bin );

	p_dwarf	= (LibGoblin_Debug_Dwarf *)p_bin->p_debug;
	assert( NULL != p_dwarf );

	i_srcfiles	= p_dwarf->i_srcfilenum;

	p_src	= p_dwarf->p_src;
	assert( NULL != p_src );

	/* Get .debug_abbrev section Info */
	pb_data	= LibGoblin_Elf_GetSection(
					&qw_size, p_bin,
					LIBGOBLIN_ELF_SEC_ID_DEBUG_LINE );
	if( NULL == pb_data )	{ return 0x01; }

	do	{
		p_src->t_linesec.pb_header	= pb_data;

		/* Analyze .debug_info compile unit */
		pb_data	= LibGoblin_DwarfLine_ReadCompileUnit(
						p_src, pb_data, &qw_size );
		if( NULL == pb_data)	{ return 0x02; }

		p_src++;
		i_srcfiles--;

	}while((qw_size > 0) && (i_srcfiles > 0));
	
	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
