/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_ELF
#include"drd64_libgoblin.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_ELF_EXTERN 
int
	LibGoblin_IsElf(
		Byte	*p_data )
{
	//Elf_Ehdr	*p_elfhdr;

	assert( NULL != p_data );
	//p_elfhdr	= (Elf_Ehdr *)p_data;
	if( ( ELFMAG0 == *(p_data + EI_MAG0) )
			&& ( ELFMAG1 == *(p_data + EI_MAG1) )
			&& ( ELFMAG2 == *(p_data + EI_MAG2) )
			&& ( ELFMAG3 == *(p_data + EI_MAG3) ) )
		{ return 0x01; }
	return 0x00;

	//return IS_ELF( *p_elfhdr );
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_ELF_EXTERN
Byte *
	LibGoblin_Elf_GetSection(
		QWord	*qw_secsize,
		LibGoblin_BinaryInfo	*p_bin,
		Byte	b_secid )
{
	Byte					*pb_data;
	LibGoblin_Format_Elf64	*p_elf64;
	LibGoblin_Format_Elf32	*p_elf32;
	Elf64_Shdr				*p_elfshr64;
	Elf32_Shdr				*p_elfshr32;

	assert( NULL != p_bin );

	pb_data		= NULL;
	*qw_secsize	= 0;

	if( LIBGOBLIN_ELF_SEC_ID_DEFAULT_MAX <= b_secid )	{ return NULL; }

	if( IsBinfoType_Elf64(p_bin) )	{
		p_elf64		= (LibGoblin_Format_Elf64 *)p_bin->p_format;
		p_elfshr64	= p_elf64->p_section[b_secid];
		pb_data		= (Byte *)(p_bin->p_binary + p_elfshr64->sh_offset);
		*qw_secsize	= (QWord)p_elfshr64->sh_size;
	}
	else if( IsBinfoType_Elf32(p_bin) ) {
		p_elf32		= (LibGoblin_Format_Elf32 *)p_bin->p_format;
		p_elfshr32	= p_elf32->p_section[b_secid];
		pb_data		= (Byte *)(p_bin->p_binary + p_elfshr32->sh_offset);
		*qw_secsize	= (QWord)p_elfshr32->sh_size;
	}

	return pb_data;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_ELF_EXTERN
int
	LibGoblin_AnalyzeElf(
		LibGoblin_BinaryInfo	*p_bin )
{
	//int		i_err;
	Byte	*pb_data;

	assert( NULL != p_bin );
	pb_data	= p_bin->p_binary;
	assert( NULL != pb_data );

	/* Analyze ELF Ident Header from Bits ---*/
	if( ELFCLASS64 == *(pb_data + EI_CLASS) )
		{ p_bin->b_type	= LIBGOBLIN_BINFO_TYPE_ELF64; }
	else if( ELFCLASS32 == *(pb_data + EI_CLASS) )
		{ p_bin->b_type	= LIBGOBLIN_BINFO_TYPE_ELF32; }
	
	/* Analyze ELF Ident Header from Endian ---*/
	if( ELFDATA2LSB == *(pb_data + EI_DATA) )
		{ p_bin->b_endian	= LIBGOBLIN_BINFO_ENDIAN_LITTLE; }
	else if( ELFDATA2MSB == *(pb_data + EI_DATA) )
		{ p_bin->b_endian	= LIBGOBLIN_BINFO_ENDIAN_BIG; }


	/* Alloc BinaryInfo Format Struct Area from bits ---*/
	if( LIBGOBLIN_BINFO_TYPE_ELF64 == p_bin->b_type )		{
		p_bin->p_format	= LibGoblin_Elf64_AllocFormat();
	}
	else if( LIBGOBLIN_BINFO_TYPE_ELF32 == p_bin->b_type )	{
		p_bin->p_format	= LibGoblin_Elf32_AllocFormat();
	}
	if( NULL == p_bin->p_format )	{
		return 0x01;
	} 
	
	/* Analyze ELF Header */
	if( LIBGOBLIN_BINFO_TYPE_ELF64 == p_bin->b_type )		{
		LibGoblin_Elf64_Analyze( p_bin );
	}
	else if( LIBGOBLIN_BINFO_TYPE_ELF32 == p_bin->b_type )	{
	}


	/* Analyze Dwarf-Debug Info. */
	if( 0x00 != LibGoblin_IsDwarf( p_bin ) )	{
		LibGoblin_AnalyzeDwarf( p_bin );
	}
	


	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
