/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_LIBGOBLIN_ELF64
#include"drd64_libgoblin.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_ELF64_EXTERN
void *
	LibGoblin_Elf64_AllocFormat(
		void )
{
	LibGoblin_Format_Elf64	*p_elf;

	p_elf	= (LibGoblin_Format_Elf64 *)
		malloc( sizeof(LibGoblin_Format_Elf64) );
	if( NULL != p_elf )		{
		memset( p_elf, 0x00, sizeof(LibGoblin_Format_Elf64) );
	}
	
	return (void *)p_elf;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	LibGoblin_Elf64_SetSectionHeader(
		LibGoblin_Format_Elf64	*p_elf,
		Byte	*pb_data )
{
	int			i_cnt;
	int			i_secnum;
	int			i_index;
	int			i_user_section;
	char		*pstr_secname;
	Elf64_Ehdr	*p_elfhdr;
	Elf64_Shdr	*p_sechdr;
	Elf64_Shdr	*p_secstrhdr;

	assert( NULL != p_elf );
	assert( NULL != pb_data );

	p_elfhdr	= p_elf->p_elfhdr;

	i_user_section	= LIBGOBLIN_ELF_SEC_ID_DEFAULT_MAX;

	/* Get Section Header of the "Section-Name Section" */
	p_secstrhdr	= (Elf64_Shdr *)(pb_data + p_elfhdr->e_shoff
					+ (p_elfhdr->e_shentsize * p_elfhdr->e_shstrndx));

	i_secnum	= p_elfhdr->e_shnum;
	for( i_cnt = 0; i_cnt < i_secnum; i_cnt++ )	{
		p_sechdr	= (Elf64_Shdr *)(pb_data + (p_elfhdr->e_shoff)
							+ (p_elfhdr->e_shentsize * i_cnt));

		pstr_secname	= (char *)pb_data
									+ p_secstrhdr->sh_offset
									+ p_sechdr->sh_name;

		for( i_index = 0;
				i_index < LIBGOBLIN_ELF_SEC_ID_DEFAULT_MAX;
				i_index++ )	{

			if( !strncmp( pstr_secname,
					gstr_elf_section_name[i_index], 20 ))	{
				p_elf->p_section[i_index]	= p_sechdr;
				break;
			}
		}

		if( LIBGOBLIN_ELF_SEC_ID_DEFAULT_MAX == i_index )	{
			p_elf->p_section[i_user_section]	= p_sechdr;
			i_user_section++;
		}

	}
	
	
	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBGOBLIN_ELF64_EXTERN
int
	LibGoblin_Elf64_Analyze(
		LibGoblin_BinaryInfo	*p_bin )
{
	//int		i_err;
	Byte	*pb_data;
	LibGoblin_Format_Elf64	*p_elf;
	//Elf64_Ehdr	*p_elfhdr;

	assert( NULL != p_bin );

	assert( NULL != p_bin->p_binary );
	pb_data	= p_bin->p_binary;

	assert( NULL != p_bin->p_format );
	p_elf	= (LibGoblin_Format_Elf64 *)p_bin->p_format;

	/* Set ELF64 Header */
	p_elf->p_elfhdr	= (Elf64_Ehdr *)pb_data;
	
	/* Read & Analyze Section Header */
	LibGoblin_Elf64_SetSectionHeader( p_elf, pb_data );
	
	test( p_bin );

	return 0x00;
}


int test( LibGoblin_BinaryInfo  *p_bin )
{

	//int		i_err;
	Byte	*p_data;
	LibGoblin_Format_Elf64	*p_elf;
	Elf64_Ehdr	*p_elfhdr;
	Elf64_Shdr	*p_sechdr;
	Elf64_Shdr	*p_secstrhdr;
	FILE		*fp;
	int		i_cnt;
	int		i_secnum;
	char	fname[256];
	Byte		*p_start;
	DWord		dw_size;

	assert( NULL != p_bin );

	assert( NULL != p_bin->p_binary );
	p_data	= p_bin->p_binary;

	assert( NULL != p_bin->p_format );
	p_elf	= (LibGoblin_Format_Elf64 *)p_bin->p_format;
	p_elfhdr	= p_elf->p_elfhdr;

	p_secstrhdr	= (Elf64_Shdr *)(p_bin->p_binary + p_elfhdr->e_shoff + (p_elfhdr->e_shentsize * p_elfhdr->e_shstrndx));

	i_secnum	= p_elfhdr->e_shnum;
	printf( "%d\n", i_secnum );
	for( i_cnt = 0; i_cnt < i_secnum; i_cnt++ )	{
		p_sechdr	= p_bin->p_binary + (p_elfhdr->e_shoff) + (p_elfhdr->e_shentsize * i_cnt);
		snprintf(fname, 256, "bin%s", ((char *)p_bin->p_binary + p_secstrhdr->sh_offset + p_sechdr->sh_name));
		printf( "%d: %s\n", i_cnt, fname );
		p_start	= (Byte *)p_bin->p_binary + (p_sechdr->sh_offset);
		dw_size	= p_sechdr->sh_size;
		fp = fopen( fname, "wb");
		fwrite( p_start, dw_size, 1, fp);
		fclose( fp);
	}
	
	
	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
