/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
    
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_asm.c
Function: Intel64 Line Assembler Main Module
Comment:  none
----------------------------------------------------------------------*/

#include"drd64_intel64.h"
#include"drd64_intel64_dbtype.h"
#include"drd64_intel64_db.h"
#include"drd64_intel64_asm.h"
#include"drd64_intel64_disasm.h"
#include"drd64_intel64_asm_system.h"
#define DRD64_SRC_LIBINTEL64ASM_FUNC
#include"../include/libintel64asm.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64_CarveStringBlock(
		Drd64_Intel64_AssemblePacket *p_assemble,
		char	*p_src)
{
	char	*p_now;
	char	*p_temp;
	char	*p_end;

	p_now	= p_src;
	do	{
		if(( '\r' == *p_now ) || ( '\n' == *p_now ))	
			{ *p_now	= '\0'; }
	}while( '\0' != *(p_now++ + 1) );
		
	
	p_now	= p_src;

	/* Carve Instruction String --- */
	do	{
		if(( '\t' != *p_now ) && ( ' ' != *p_now))	{ break; }
	}while( '\0' != *(p_now++ + 1) );
	p_temp	= p_now;

	do	{
		if(( '\t' == *p_now ) || ( ' ' == *p_now))	{ break; }
		*p_now	= tolower( *p_now );
	}while( '\0' != *(p_now++ + 1) );
	
	strncpy( p_assemble->str_instruction, p_temp, (p_now - p_temp));

	/* Carve Destination String --- */
	do	{
		if(( '\t' != *p_now ) && ( ' ' != *p_now))	{ break; }
	}while( '\0' != *(p_now++ + 1) );

	if( '\0' != *p_now )	{
		p_temp	= p_now;
		do	{
			if( ',' == *p_now )	{ break; }
			*p_now	= tolower( *p_now );
		}while( '\0' != *(p_now++ + 1) );

		if( p_temp == p_now )	{ return 0xff; }

		p_end	= p_now;
		do	{
			if(( '\t' != *(p_end - 1)) && ( ' ' != *(p_end - 1)))	{ break; }
		}while( p_temp <= --p_end );
		strncpy( p_assemble->str_destination, p_temp, (p_end - p_temp));
		if( ',' == *p_now )		{ p_now++; }
	}

	/* Carve Source String --- */
	do	{
		if(( '\t' != *p_now ) && ( ' ' != *p_now))	{ break; }
	}while( '\0' != *(p_now++ + 1) );

	if( '\0' != *p_now )	{
		p_temp	= p_now;
		do	{
			if( ',' == *p_now )	{ break; }
			*p_now	= tolower( *p_now );
		}while( '\0' != *(p_now++ + 1) );

		if( p_temp == p_now )	{ return 0xff; }

		p_end	= p_now;
		do	{
			if(( '\t' != *(p_end - 1)) && ( ' ' != *(p_end - 1)))	{ break; }
		}while( p_temp <= --p_end );
		strncpy( p_assemble->str_source, p_temp, (p_end - p_temp));
		if( ',' == *p_now )		{ p_now++; }
	}

	/* Carve Option String --- */
	do	{
		if(( '\t' != *p_now ) && ( ' ' != *p_now))	{ break; }
	}while( '\0' != *(p_now++ + 1) );

	if( '\0' != *p_now )	{
		p_temp	= p_now;
		do	{
			*p_now	= tolower( *p_now );
		}while( '\0' != *(p_now++ + 1) );

		p_end	= p_now;
		do	{
			if(( '\t' != *(p_end - 1)) && ( ' ' != *(p_end - 1)))	{ break; }
		}while( p_temp <= --p_end );
		strncpy( p_assemble->str_option, p_temp, (p_now - p_temp));
	}

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
Drd64_Intel64_OperandNode	*
	Drd64_Intel64_ConstructOperand_RPNChain(
		char	*pstr_operand)
{
	char	*pstr_now;
	char	str_buffer[MAX_OPERAND];
	char	*pstr_bufpos;
	/* i_mode : 0=> Ignore  1=> Calc Mode.  2=>Data Stock. */
	int		i_mode;
	int		i_datas;

	Drd64_Intel64_OperandNode	*p_stack;
	Drd64_Intel64_OperandNode	*p_chain;
	Drd64_Intel64_OperandNode	*p_cnow;

	Drd64_Intel64_OperandNode	*p_data;
	Drd64_Intel64_OperandNode	*p_operator;
	Drd64_Intel64_OperandNode	*p_temp;
	
	pstr_now	= pstr_operand - 1;
	i_mode		= 0x00;
	i_datas		= 0;

	p_chain		= NULL;
	p_cnow		= NULL;
	p_stack		= NULL;
	p_data		= NULL;
	p_operator	= NULL;
	p_temp		= NULL;
	pstr_bufpos	= str_buffer;
	memset( str_buffer, 0x00, MAX_OPERAND );

	while( '\0' != *(++pstr_now) )	{
		/* Pattern 1 - Ignore Chr. --- */
		if(( ' ' == *pstr_now ) || ( '\t' == *pstr_now ))
			{ continue; }
		/* Pattern 2 - Calc. Chr. --- */
		else if(( '[' == *pstr_now ) || ( ']' == *pstr_now ) ||
				( '+' == *pstr_now ) || ( '*' == *pstr_now ) ||
				( '-' == *pstr_now ) || ( ':' == *pstr_now ))	{

			/* if Data Stock Mode => Proc. Data Ending ---*/
			if( 0x02 == i_mode )	{
				p_data	= Drd64_Intel64_AllocOperandNode();
				if( NULL == p_data )	{ return NULL;	}
				strncpy( p_data->str_data, str_buffer, MAX_OPERAND );
				pstr_bufpos	= str_buffer;
				memset( str_buffer, 0x00, MAX_OPERAND );

				/* Chain Data ---*/
				if( NULL == p_chain )	{
					p_chain	= p_data;
					p_cnow	= p_chain;
				}
				p_cnow->p_next		= p_data;
				p_data->p_before	= p_cnow;
				p_cnow				= (void *)p_data;
			}

			i_mode	= 0x01;
			p_operator	= Drd64_Intel64_AllocOperandNode();
			if( NULL == p_operator )	{ return NULL;	}
			p_operator->str_data[0]	= *pstr_now;	

			/* Check Stack in Primery Operator ---*/
			if( NULL != p_stack )	{
				p_temp	= p_stack;
				do	{
					if((( '+' == p_operator->str_data[0] ) ||
							( '-' == p_operator->str_data[0] ) ||
							( '*' == p_operator->str_data[0] )) &&
							( ':' == p_temp->str_data[0]))	{
						p_cnow->p_next		= p_temp;
						p_temp->p_before	= p_cnow;
						p_cnow				= p_temp;
						p_stack				= p_temp->p_next;
					}
					else if((( '+' == p_operator->str_data[0] ) ||
							( '-' == p_operator->str_data[0] )) &&
							( '*' == p_temp->str_data[0]))	{
						p_cnow->p_next		= p_temp;
						p_temp->p_before	= p_cnow;
						p_cnow				= p_temp;
						p_stack				= p_temp->p_next;
					}
					else if(( '+' == p_operator->str_data[0] ) &&
							( '-' == p_temp->str_data[0]))	{
						p_cnow->p_next		= p_temp;
						p_temp->p_before	= p_cnow;
						p_cnow				= p_temp;
						p_stack				= p_temp->p_next;
					}
					else if((( '[' == p_operator->str_data[0] ) ||
							 ( ']' == p_operator->str_data[0] )) &&
							(( '+' == p_temp->str_data[0]) ||
							 ( '-' == p_temp->str_data[0]) ||
							 ( '*' == p_temp->str_data[0]) ||
							 ( ':' == p_temp->str_data[0])))	{
						p_cnow->p_next		= p_temp;
						p_temp->p_before	= p_cnow;
						p_cnow				= p_temp;
						p_stack				= p_temp->p_next;
					}
					else
						{ break; }
					p_temp	= p_temp->p_next;
				}while( NULL != p_temp ); 
			}

			/* Push Stack Operator --- */
			if( NULL != p_stack )	{ p_stack->p_before	= p_operator; }
			p_operator->p_next	= p_stack;
			p_stack				= (void *)p_operator;
		}
		/* Pattern 3 - Data Chr. --- */
		else	{
			*pstr_bufpos++	= *pstr_now;
			i_mode			= 0x02;
		}	
	}

	if( 0x02 == i_mode )	{
		p_data	= Drd64_Intel64_AllocOperandNode();
		if( NULL == p_data )	{ return NULL;	}
		strncpy( p_data->str_data, str_buffer, MAX_OPERAND );
		pstr_bufpos	= str_buffer;
		memset( str_buffer, 0x00, MAX_OPERAND );

		/* Chain Data ---*/
		if( NULL == p_chain )	{
			p_chain	= p_data;
			p_cnow	= p_chain;
		}
		else	{
			p_cnow->p_next		= p_data;
		}
		p_data->p_before	= p_cnow;
		p_cnow				= (void *)p_data;
	}

	/* Flash Stack Operaters --- */
	if( NULL != p_stack )	{
		p_temp	= p_stack;
		do	{
			p_cnow->p_next		= p_temp;
			p_temp->p_before	= p_cnow;
			p_cnow				= p_temp;
			p_stack				= p_temp->p_next;
			p_temp	= p_temp->p_next;
		}while( NULL != p_temp ); 
	}

	Drd64_Intel64_Debug_Asm_PrintOperandChain( p_chain );

	return p_chain;
}


Drd64_Intel64_OperandNode *
	Drd64_Intel64_CarveOperandSizePrefix(
		Drd64_Intel64_OperandNode *p_chain)
{
	Drd64_Intel64_OperandNode	*p_ret;

	p_ret	= p_chain;
	if( !strncmp( p_chain->str_data, "byte", MAX_OPERAND ))
		{ p_chain->i_operandsize	= 1; }
	else if( !strncmp( p_chain->str_data, "word", MAX_OPERAND ))
		{ p_chain->i_operandsize	= 2; }
	else if( !strncmp( p_chain->str_data, "dword", MAX_OPERAND ))
		{ p_chain->i_operandsize	= 4; }
	else if( !strncmp( p_chain->str_data, "qword", MAX_OPERAND ))
		{ p_chain->i_operandsize	= 8; }
	else if( !strncmp( p_chain->str_data, "dqword", MAX_OPERAND ))
		{ p_chain->i_operandsize	= 16; }

	p_chain->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE;

	if( 0 < p_chain->i_operandsize )	{
		p_ret	= p_chain->p_next;
	}	

	return p_ret;
}


int
	Drd64_Intel64_CheckMemoryOperandFormat(
		Drd64_Intel64_OperandNode *p_chain)
{
	Drd64_Intel64_OperandNode	*p_now;
	Drd64_Intel64_OperandNode	*p_temp[2];
	int		i_ret;

	i_ret	= 0x00;

	p_now	=	p_chain;
	do	{
		p_temp[0]	= p_now->p_next;

		if( NULL != p_temp[0] )	{
			if( ']' == p_temp[0]->str_data[0] )	{
				p_temp[1]	= p_temp[0]->p_next;
				if( NULL == p_temp[1] )
					{ return -1; }
				if( '[' != p_temp[1]->str_data[0] ) 
					{ return -2; }
				if( NULL != p_temp[1]->p_next )
					{ return -3; }	
	
				i_ret	= 1;
				p_now->p_next	= NULL;	
			}
		}

		p_now	= p_now->p_next;
	}while( NULL != p_now );

	if( 0 < i_ret )		{
		p_now	= p_chain;
		do	{
			p_now->b_flag_addr	= 0x01;
			p_now	= p_now->p_next;
		}while( NULL != p_now );
	}

	return i_ret;
}



Drd64_Intel64_OperandNode	*
	Drd64_Intel64_ConstructOperandTree(
		Drd64_Intel64_OperandNode *p_chain)
{
	Drd64_Intel64_OperandNode	*p_root;
	Drd64_Intel64_OperandNode	*p_temp;
	Drd64_Intel64_OperandNode	*p_value[3];
	char	*pstr_temp;
	
	p_temp	= p_chain;
	do{
		if(( '+' == p_temp->str_data[0] ) ||
				( '*' == p_temp->str_data[0] ) ||
				( ':' == p_temp->str_data[0] ) ||
				( '-' == p_temp->str_data[0] ))	{	
			p_value[1]	= p_temp->p_before;
			assert( NULL != p_value[1] );
			p_value[0]	= p_value[1]->p_before;
			assert( NULL != p_value[0] );

			p_value[0]->p_parent	= p_temp;
			p_value[1]->p_parent	= p_temp;
			p_temp->p_left			= p_value[0];
			p_temp->p_right			= p_value[1];

			p_temp->p_before		= p_value[0]->p_before;
			p_value[2]				= p_value[0]->p_before;
			if( NULL != p_value[2] )
				{ p_value[2]->p_next	= p_temp; }
			
			p_value[0]->p_before	= NULL;
			p_value[0]->p_next		= NULL;
			p_value[1]->p_before	= NULL;
			p_value[1]->p_next		= NULL;
			
			/* Proc Minus */
			if( '-' == p_temp->str_data[0] )	{
				if( '*' == p_value[1]->str_data[0] )	{
					p_root	= NULL;
					break;
				}

				pstr_temp	= p_value[1]->str_data + MAX_OPERAND;
				do	{
					*pstr_temp	= *(pstr_temp - 1);
				}while( p_value[1]->str_data != --pstr_temp );
				*pstr_temp	= '-';
				p_temp->str_data[0]	= '+';
			}

		}

		if( NULL == p_temp->p_next )	{ p_root	= p_temp; }
		p_temp	= p_temp->p_next;
	}while( NULL != p_temp );

	return p_root;
}



int
	Drd64_Intel64_ConvAsciiToValue(
		QWord	*pqw_value,
		int		*i_size,
		char *pstr_value )
{
	char	*pstr_src;
	int		i_flag_minus;
	int		i_base;
	int		i_flag_zero;
	int		i_len;
	int		i_pos;
	int		i_num;
	int		i_err;
	QWord	qw_temp;

	i_flag_minus	= 0x00;
	i_flag_zero		= 0x00;
	i_err			= 0x00;
	i_base			= 10;
	i_pos			= 0;
	qw_temp			= 0;
	pstr_src		= pstr_value;

	/* Check 1 : Check String Length */
	i_len	= strlen( pstr_value );
	if( 0 == i_len )	{ return 0x01; }

	/* Check 2 : Check Hexical Value? */
	if( 'h' == *(pstr_value + i_len - 1) )		{
		i_base			= 16;
		i_len--;
	}

	/* Check 3 : Check Minus Value? */
	if( '-' == *(pstr_value + 0) )	{
		i_flag_minus	= 0x01;
		pstr_src++;
		i_len--;
	}

	do	{
		if( isdigit( *pstr_src ) )	{
			if(( '0' == *pstr_src ) && ( 0x00 == i_flag_zero ))		{
				i_pos++;
				continue;
			}
			else	{
				i_flag_zero	= 0x01;
				/* XXX : Ascii Code Only! */
				qw_temp		= (qw_temp * i_base) + (*pstr_src - 0x30);		
				i_pos++;
			}
		}
		else if( 16 == i_base ) 	{
			if( 'a' == *pstr_src )			{ i_num	= 10; }
			else if( 'b' == *pstr_src )		{ i_num	= 11; }
			else if( 'c' == *pstr_src )		{ i_num	= 12; }
			else if( 'd' == *pstr_src )		{ i_num	= 13; }
			else if( 'e' == *pstr_src )		{ i_num	= 14; }
			else if( 'f' == *pstr_src )		{ i_num	= 15; }
			else	{ 
				i_err	= 0x02;
				break;
			}

			qw_temp		= (qw_temp * i_base) + i_num;		
			i_flag_zero	= 0x01;
			i_pos++;

		}
		else	{
			i_err	= 0x03;
			break;
		}
	}while(( '\0' != *pstr_src++ ) && ( --i_len > 0 ));

	if( 0x00 != i_err )
		{ goto goto_Drd64_Intel64_ConvAsciiToValue_err;	}

	if(  2 >= i_pos )		{ *i_size	= 1; }
	else if(  4 >= i_pos )	{ *i_size	= 2; }
	else if(  8 >= i_pos )	{ *i_size	= 4; }
	else if( 16 >= i_pos )	{ *i_size	= 8; }
	else if( 16 <  i_pos )	{ i_err	= 0x03; }
	
	if( 0x00 != i_err )
		{ goto goto_Drd64_Intel64_ConvAsciiToValue_err;	}

	if( 0x01 == i_flag_minus )	{
		if(( *i_size == 1 ) && ( 0x7f < qw_temp ))
			{ i_err	= 0x04;	}
		else if(( *i_size == 2 ) && ( 0x7fff < qw_temp ))
			{ i_err	= 0x04;	}
		else if(( *i_size == 4 ) && ( 0x7fffffff < qw_temp ))
			{ i_err	= 0x04;	}
		else if(( *i_size == 8 ) && ( 0x7fffffffffffffff < qw_temp ))
			{ i_err	= 0x04;	}

		if( 0x00 == i_err ) 	{
			qw_temp	= (~qw_temp) + 1;
		}
	}

	if( 0x00 != i_err )
		{ goto goto_Drd64_Intel64_ConvAsciiToValue_err;	}

	*pqw_value	= qw_temp;
goto_Drd64_Intel64_ConvAsciiToValue_err:
	return i_err;
}


int
	Drd64_Intel64_SetOperandNodeInfo(
		Drd64_Intel64_OperandNode *p_now)
{
	int	i_err;

	i_err	= 0x00;
	
	if( 0x00 < i_err )	 { return i_err; }

	if( NULL != p_now->p_left )		{
		i_err	= Drd64_Intel64_SetOperandNodeInfo( p_now->p_left );
		if( 0x00 < i_err )	 { return i_err; }
	}
	 
	if( NULL != p_now->p_right )	{
		i_err = Drd64_Intel64_SetOperandNodeInfo( p_now->p_right );
		if( 0x00 < i_err )	 { return i_err; }
	}

	/* Set Info. My Node ---*/
	if(( '*' != p_now->str_data[0] ) && 
			( ':' != p_now->str_data[0] ) &&
			( '+' != p_now->str_data[0] ))		{

		/* Check 1 : String Is Register ? --- */
		p_now->w_typeid
			=	Drd64_Intel64db_GetRegisterCode( p_now->str_data );
		if( OPTYPE_REG_INVAILD != p_now->w_typeid )	{
			if( isBitFlag(p_now->w_typeid, OPTYPE_BASE_REG_64BIT))
				{ p_now->i_operandsize	= 8; }
			else if( isBitFlag(p_now->w_typeid, OPTYPE_BASE_REG_32BIT))
				{ p_now->i_operandsize	= 4; }
			else if( isBitFlag(p_now->w_typeid, OPTYPE_BASE_REG_16BIT))
				{ p_now->i_operandsize	= 2; }
			else if( isBitFlag(p_now->w_typeid, OPTYPE_BASE_REG_8BIT))
				{ p_now->i_operandsize	= 1; }
			else if( isBitFlag(p_now->w_typeid, OPTYPE_BASE_REG_8BIT))
				{ p_now->i_operandsize	= 1; }
			else if( isRegType(p_now->w_typeid, OPTYPE_BASE_REG_MMX))
				{ p_now->i_operandsize	= 8; }
			else if( isRegType(p_now->w_typeid, OPTYPE_BASE_REG_SSE))
				{ p_now->i_operandsize	= 16; }
			else if( isRegType(p_now->w_typeid, OPTYPE_BASE_REG_CONTROL))
				{ p_now->i_operandsize	= 8; }
			else if( isRegType(p_now->w_typeid, OPTYPE_BASE_REG_DEBUG))
				{ p_now->i_operandsize	= 8; }
			else if( isRegType(p_now->w_typeid, OPTYPE_BASE_REG_SEGMENT))
				{ p_now->i_operandsize	= 2; }
			else
				{ p_now->i_operandsize	= -1; }
		}
		/* Check 2 : String Is Value ? --- */
		else	{
			i_err	= Drd64_Intel64_ConvAsciiToValue(
						&(p_now->v_val.val.val64),
						&(p_now->v_val.i_bytes),
						p_now->str_data );
			if( 0x00 == i_err )		{
				p_now->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_IMM;
				p_now->i_operandsize	= p_now->v_val.i_bytes;
			}
		}
	}
	else	{
		p_now->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR;
	}

	return i_err;
}


Drd64_Intel64_OperandNode *
	Drd64_Intel64_CarveSegmentPrefix_Sub(
		Drd64_Intel64_OperandNode *p_now)
{
	Drd64_Intel64_OperandNode *p_ret;

	p_ret	= NULL;

	if( NULL == p_now )		{ return NULL; }

	p_ret	= Drd64_Intel64_CarveSegmentPrefix_Sub( p_now->p_left );
	if( NULL != p_ret )		{ return p_ret; }
	
	p_ret	= Drd64_Intel64_CarveSegmentPrefix_Sub( p_now->p_right );
	if( NULL != p_ret )		{ return p_ret; }


	if( ':' == p_now->str_data[0] )	{
		assert( NULL != p_now->p_left );
		assert( NULL != p_now->p_right );

		if( isRegType( 
				((Drd64_Intel64_OperandNode *)(p_now->p_left))->w_typeid,
				OPTYPE_BASE_REG_SEGMENT))	{

			p_ret	= p_now->p_left;

			memcpy( p_now, p_now->p_right, sizeof(Drd64_Intel64_OperandNode));
		}
		else	{
			p_ret	= p_now;
		}
	}

	return p_ret;
}


int
	Drd64_Intel64_CarveSegmentPrefix(
		Drd64_Intel64_AssemblePacket *p_assemble,
		Drd64_Intel64_OperandNode *p_now)
{
	Drd64_Intel64_OperandNode *p_ret;

	p_ret	= Drd64_Intel64_CarveSegmentPrefix_Sub( p_now );

	if( NULL != p_ret )	{
		if( ':' == p_ret->str_data[0] )
			{ return 0x01; }
		else
			{ p_assemble->p_segment	= p_ret; }
	}

	return 0x00;
}

int
	Drd64_Intel64_CheckOperandNode_Operator(
		Drd64_Intel64_OperandNode *p_now,
		int *pi_plus,
		int	*pi_accum,
		int	*pi_imm)
{
	int	i_err;

	if( NULL == p_now)
		{ return 0x00;	}

	i_err	= Drd64_Intel64_CheckOperandNode_Operator(
				p_now->p_left, pi_plus, pi_accum, pi_imm );
	if( 0x00 != i_err )		{ return i_err;	}

	i_err	= Drd64_Intel64_CheckOperandNode_Operator(
				p_now->p_right, pi_plus, pi_accum, pi_imm );
	if( 0x00 != i_err )		{ return i_err;	}

	if( '+' == p_now->str_data[0] )
		{ (*pi_plus)++;	}
	else if( '*' == p_now->str_data[0] ) {

		(*pi_accum)++;
		
		assert( NULL != p_now->p_left );
		assert( NULL != p_now->p_right );

		if( isBitFlag( 
				((Drd64_Intel64_OperandNode *)(p_now->p_left))->w_typeid,
				OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR))	{
			return 0xfd;
		}

		if( isBitFlag( 
				((Drd64_Intel64_OperandNode *)(p_now->p_right))->w_typeid,
				OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR))	{
			return 0xfc;
		}
	}
	else if( isBitFlag( p_now->w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	{
		(*pi_imm)++;
	}
	
	return 0x00;
}


int
	Drd64_Intel64_ExchangeChildOperandNode(
		Drd64_Intel64_OperandNode *p_root )
{
	Drd64_Intel64_OperandNode	*p_temp[2];
	Drd64_Intel64_OperandNode	*p_bak;
	Word	w_type[2];

	if(( NULL == p_root->p_left ) && ( NULL == p_root->p_right ))	{
		return 0x00;
	}
	else if(( NULL == p_root->p_left ) || ( NULL == p_root->p_right ))	{
		return 0x01;
	}

	p_temp[0]	= p_root->p_left;
	w_type[0]	= p_temp[0]->w_typeid;

	p_temp[1]	= p_root->p_right;
	w_type[1]	= p_temp[1]->w_typeid;
	
	if((( !isBitFlag(w_type[0],OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR)) &&
		 ( isBitFlag(w_type[1],OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR))) ||
		(( '*' == p_temp[0]->str_data[0] ) &&
		 ( '+' == p_temp[1]->str_data[0] )) ||
		(( isBitFlag(w_type[0],OPTYPE_BASE_DATA_IMMEDIATE_IMM) ) &&
		 ( !isBitFlag(w_type[1],OPTYPE_BASE_DATA))))	{
		p_bak	= p_root->p_left;
		p_root->p_left	= p_root->p_right;
		p_root->p_right	= p_bak;
	}

	return 0x00;
}


int
	Drd64_Intel64_SortOperandNode(
		Drd64_Intel64_OperandNode *p_root )
{
	Drd64_Intel64_OperandNode	*p_temp;
	Drd64_Intel64_OperandNode	*p_bak;
	Word	w_type;
	int		i_err;
	
	i_err	= Drd64_Intel64_ExchangeChildOperandNode( p_root );
	if( 0x00 != i_err )		{ return 0x01;	}

	/* Level 1 - Right */
	p_temp	= p_root->p_right;
	if( NULL != p_temp )	{
		w_type	= p_temp->w_typeid;
		if( OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR == w_type )		{
			i_err	= Drd64_Intel64_ExchangeChildOperandNode( p_temp );
			if( 0x00 != i_err )		{ return 0x01;	}
		}
	}

	/* Level 1 - Left */
	p_temp	= p_root->p_left;
	if( NULL != p_temp )	{ 
		w_type	= p_temp->w_typeid;
		if( OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR == w_type )		{
			i_err	= Drd64_Intel64_ExchangeChildOperandNode( p_temp );
			if( 0x00 != i_err )		{ return 0x01;	}
		}

		/* Level 2 - Left */
		p_temp	= p_temp->p_left;
		if( NULL != p_temp )	{
			w_type	= p_temp->w_typeid;
			if( OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR == w_type)	{
				i_err	= Drd64_Intel64_ExchangeChildOperandNode( p_temp );
				if( 0x00 != i_err )		{ return 0x01;	}
			}
		}
	}

	return 0x00;
}


void
	Drd64_Intel64_CalcOperandSize_AddressMode(
		Drd64_Intel64_OperandNode *p_now )
{
	if( NULL == p_now)	 { return;	}

	Drd64_Intel64_CalcOperandSize_AddressMode( p_now->p_left );

	Drd64_Intel64_CalcOperandSize_AddressMode( p_now->p_right );

	if( isBitFlag( p_now->w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR ))	{
		assert( NULL != p_now->p_left );
		assert( NULL != p_now->p_right );

		if( ((Drd64_Intel64_OperandNode *)p_now->p_left)->i_operandsize <
				((Drd64_Intel64_OperandNode *)p_now->p_right)->i_operandsize ) {
			p_now->i_operandsize	= 
				((Drd64_Intel64_OperandNode *)p_now->p_right)->i_operandsize;
		}
		else	{
			p_now->i_operandsize	= 
				((Drd64_Intel64_OperandNode *)p_now->p_left)->i_operandsize;
		}
	}

	return;
}


void
	Drd64_Intel64_CalcAddressSize_AddressMode(
		Drd64_Intel64_OperandNode *p_now )
{
	if( NULL == p_now)	 { return;	}

	if( NULL != p_now->p_parent )	{
		p_now->i_addressize	=
			((Drd64_Intel64_OperandNode *)p_now->p_parent)->i_addressize;
	}

	Drd64_Intel64_CalcAddressSize_AddressMode( p_now->p_left );
	Drd64_Intel64_CalcAddressSize_AddressMode( p_now->p_right );
	
	return;
}


int
	Drd64_Intel64_CheckRegister_AddressMode(
		Drd64_Intel64_OperandNode *p_now )
{
	int		i_err;

	if( NULL == p_now)	 { return 0x00;	}

	i_err	= Drd64_Intel64_CheckRegister_AddressMode( p_now->p_left );
	if( 0x00 != i_err )		{ return i_err; }

	i_err	= Drd64_Intel64_CheckRegister_AddressMode( p_now->p_right );
	if( 0x00 != i_err )		{ return i_err; }

	if( !isBitFlag( p_now->w_typeid, OPTYPE_BASE_DATA ))	{
		if( (p_now->w_typeid & OPTYPE_BASE_REG_TYPEMASK)
				!= OPTYPE_BASE_REG_GENERIC )	{
			/* Rip */
			if( ((Word)p_now->w_typeid) != OPTYPE_REG_RIP )	{
				return 0x01;
			}
		}
		if(( !isBitFlag( p_now->w_typeid, OPTYPE_BASE_REG_64BIT )) &&
				( !isBitFlag( p_now->w_typeid, OPTYPE_BASE_REG_32BIT )))	{
			return 0x02;
		}
	}

	return 0x00;
}


int
	Drd64_Intel64_CheckOperandNode(
		Drd64_Intel64_OperandNode *p_now)
{
	int	i_plus_num;
	int	i_accum_num;
	int	i_imm_num;
	int	i_err;
	Drd64_Intel64_OperandNode	*p_leaf[3];
	Drd64_Intel64_OperandNode	*p_left;

	i_plus_num	= 0;
	i_accum_num	= 0;
	i_imm_num	= 0;

	i_err	= Drd64_Intel64_CheckOperandNode_Operator(
					p_now, &i_plus_num, &i_accum_num, &i_imm_num );
	if( 0x00 != i_err )		{ return i_err; }

	/* Value Mode --- */
	if( 0x00 == p_now->b_flag_addr )	{
		if( 0 < i_plus_num )	{ return 0x04; }
		if( 0 < i_accum_num )	{ return 0x05; }

		assert( NULL == p_now->p_left );
		assert( NULL == p_now->p_right );
		
	}
	/* Address Mode ---*/
	else	{
		if( 2 < i_plus_num )	{ return 0x02; }
		if( 1 < i_accum_num )	{ return 0x03; }

		i_err	= Drd64_Intel64_SortOperandNode( p_now );
		if( 0x00 != i_err )		{ return i_err; }

		if( 2 == i_plus_num )	{
			p_left		= p_now->p_left;
			p_leaf[0]	= p_left->p_left;
			p_leaf[1]	= p_left->p_right;
			p_leaf[2]	= p_now->p_right;
	
			assert( NULL != p_leaf[0] );
			assert( NULL != p_leaf[1] );
			assert( NULL != p_leaf[2] );
	
			/* XXX */
			if( (1 + i_accum_num) < i_imm_num )	{ return 0x04; }
			
			if( 0 == i_imm_num )	{ return 0x05; }
			
			if( isBitFlag( p_leaf[1]->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	{
				p_left->p_right	= p_leaf[2];
				p_now->p_right	= p_leaf[1];
		
				i_err	= Drd64_Intel64_SortOperandNode( p_now );
				if( 0x00 != i_err )		{ return i_err; }
			}
		}


		/* Check Register is Generic? */
		i_err	= Drd64_Intel64_CheckRegister_AddressMode( p_now );
		if( 0x00 != i_err )		{ return i_err; }

		/* Check Accumlate Operator */
		if( 0 < i_accum_num )	{
			if( 0 == i_plus_num )	{
				p_left	= p_now;
			}
			else if( 1 == i_plus_num )	{
				p_left	= p_now->p_left;
				assert( NULL != p_left );
			}
			else if( 2 == i_plus_num )	{
				p_left	= p_now->p_left;
				assert( NULL != p_left );
				p_left	= p_left->p_left;
				assert( NULL != p_left );
			}

			assert( '*' == p_left->str_data[0] );

			p_left	= p_left->p_right;
			assert( NULL != p_left );
			if( !isBitFlag( p_left->w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
				{ return 0x06; }
			if(( '2' != p_left->str_data[0] ) && 
					( '4' != p_left->str_data[0] ) && 
					( '8' != p_left->str_data[0] ))		{
				return 0x07;
			}
			/* XXX : '1' is Break Node */
		}
	}

	return i_err;
}


Drd64_Intel64_OperandNode *
	Drd64_Intel64_CheckOperand(
		char	*pstr_operand,
		Drd64_Intel64_AssemblePacket *p_assemble )
{
	int		i_err;
	int		i_operand_pattern;
	Drd64_Intel64_OperandNode	*p_chain;
	Drd64_Intel64_OperandNode	*p_root;
	Drd64_Intel64_OperandNode	*p_temp;
	Drd64_Intel64_OperandNode	*p_opesize_prefix;
	
	/* Phase 1 : Construct Reverse Poland Chain ---*/
	p_chain	= Drd64_Intel64_ConstructOperand_RPNChain( pstr_operand );
	if( NULL == p_chain )	{ return NULL; } 

	/* Phase 2 : Carve Operand Size Prefix --- */
	p_opesize_prefix	= NULL;
	p_temp	= Drd64_Intel64_CarveOperandSizePrefix(p_chain);
	if( p_temp != p_chain )		{
		p_opesize_prefix	= p_chain;
		p_chain				= p_temp;
	}

	/* Phase 3 : Check Memory Format ---*/
	i_operand_pattern	= Drd64_Intel64_CheckMemoryOperandFormat( p_chain );
	if( 0 > i_operand_pattern )		{
		return NULL;
	}

	/* Phase 4 : Construct Operand Tree from RPN Chain --- */
	p_root	= Drd64_Intel64_ConstructOperandTree( p_chain );
	if( NULL == p_root )	{ return NULL; } 

	i_err	= Drd64_Intel64_SetOperandNodeInfo( p_root );
	if( 0x00 != i_err )		{ return NULL; }

	i_err	= Drd64_Intel64_CarveSegmentPrefix( p_assemble, p_root );
	if( 0x00 != i_err )		{ return NULL; }

	i_err	= Drd64_Intel64_CheckOperandNode( p_root );
	if( 0x00 != i_err )		{ return NULL; }

	/* Calc Operand Size */
	Drd64_Intel64_CalcOperandSize_AddressMode( p_root );
	p_root->i_addressize	= p_root->i_operandsize;

	/* Calc Address Size */
	Drd64_Intel64_CalcAddressSize_AddressMode( p_root );

	/* */
	if( 0x00 != p_root->b_flag_addr )	{
		if( NULL == p_opesize_prefix )		{
			p_opesize_prefix	= Drd64_Intel64_AllocOperandNode();
			if( NULL == p_opesize_prefix )	{ return NULL; }
			p_opesize_prefix->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE;
			p_opesize_prefix->i_operandsize	= 8;
		}

		p_opesize_prefix->i_addressize	= p_root->i_addressize;
		p_opesize_prefix->p_left		= p_root;
		p_root							= p_opesize_prefix;
	}

	return p_root;
}


int
	Drd64_Intel64_SetAnalyzePacket_OperandMemory(
		Drd64_Intel64_AnalyzePacket		*p_analyze,
		Drd64_Intel64_OperandNode		*p_head,
		Word	w_typeid,
		Word	w_sizeid)
{
	Drd64_Intel64_OperandNode	*p_root;
	Drd64_Intel64_OperandNode	*p_base;
	Drd64_Intel64_OperandNode	*p_index;
	Drd64_Intel64_OperandNode	*p_scale;
	Drd64_Intel64_OperandNode	*p_disp;
	Drd64_Intel64_OperandNode	*p_temp[4];
	Word	w_temp;

	p_root	= p_head->p_left;
	assert( NULL != p_root );

	p_base	= NULL;
	p_index	= NULL;
	p_scale	= NULL;
	p_disp	= NULL;

	/* Pattern 3 : IndexReg + Scale */
	if( '*' == p_root->str_data[0] )	{
		p_index	= p_root->p_left;
		p_scale	= p_root->p_right;

		p_analyze->i_sib_bytes	= 1;
	}
	else if( '+' == p_root->str_data[0] )	{
		p_temp[0]	= p_root->p_left;
		p_temp[1]	= p_root->p_right;

		/* Level 1 right */
		if( isRegType( p_temp[1]->w_typeid, OPTYPE_BASE_REG_GENERIC ) )	{
			p_base	= p_temp[1];
		}
		else if( OPTYPE_BASE_DATA_IMMEDIATE_IMM
						== p_temp[1]->w_typeid )	{
			p_disp	= p_temp[1];
		}

		/* Level 1 left */
		/* Pattern 6 : Index * Scale + Disp */
		if( '*' == p_temp[0]->str_data[0] )	{
			p_index	= p_temp[0]->p_left;
			p_scale	= p_temp[0]->p_right;

			p_analyze->i_sib_bytes	= 1;
		}
		else if( '+' == p_temp[0]->str_data[0] )	{
			p_temp[2]	= p_temp[0]->p_left;
			p_temp[3]	= p_temp[0]->p_right;

			assert( NULL == p_base );
			p_base = p_temp[3];
			assert( NULL != p_disp );
			
			/* Pattern 5 : Index * Scale + Base + Disp */
			if( '*' == p_temp[2]->str_data[0] )	{
				p_index	= p_temp[2]->p_left;
				p_scale	= p_temp[2]->p_right;

				p_analyze->i_sib_bytes	= 1;
			}
			/* Pattern 4 : Index + Base + Disp */
			else if( isRegType( p_temp[2]->w_typeid,
						OPTYPE_BASE_REG_GENERIC ))	{
				p_index	= p_temp[2];
	
				/* p_scale	= *1 */
				p_scale = Drd64_Intel64_AllocOperandNode();
				if( NULL == p_scale )	{ return 0x01; }
				p_scale->str_data[0]	= '1';
				p_scale->v_val.val.val64	= 1;
				p_scale->v_val.i_bytes		= 1;
				p_scale->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_IMM;
				p_scale->b_flag_addr	= 0xff;
				p_scale->i_operandsize	= 1;
				p_scale->i_addressize	= 1;

				p_analyze->i_sib_bytes	= 1;
			}
		}
		else if( isRegType( p_temp[0]->w_typeid,
						OPTYPE_BASE_REG_GENERIC ))	{
			/* Pattern 2-1 : Base + Disp */
			if( NULL == p_base )	{
				p_base	= p_temp[0];
			}
			/* Pattern 2-2 : Index * 1 + Base */
			else	{
				p_index	= p_temp[0];

				/* p_scale	= *1 */
				p_scale = Drd64_Intel64_AllocOperandNode();
				if( NULL == p_scale )	{ return 0x01; }
				p_scale->str_data[0]	= '1';
				p_scale->v_val.val.val64	= 1;
				p_scale->v_val.i_bytes		= 1;
				p_scale->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_IMM;
				p_scale->b_flag_addr	= 0xff;
				p_scale->i_operandsize	= 1;
				p_scale->i_addressize	= 1;

				p_analyze->i_sib_bytes	= 1;
			}
		}
		else if( ((Word)p_temp[0]->w_typeid) == OPTYPE_REG_RIP )	{
			if( NULL != p_base )	{ return 0x02; }
			p_base	= p_temp[0];
		}
	}
	/* Pattern 1-2 : Disp. Only */
	/* XXX
		else if( (unsigned int)OPTYPE_BASE_DATA_IMMEDIATE_IMM
			== p_root->w_typeid )	{ */
	else if( isBitFlag(p_root->w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM))	{
		p_disp	= p_root;

		p_analyze->i_sib_bytes	= 1;
	}
	/* Pattern 1-1 : Reg. Only */
	else if( !isBitFlag( p_root->w_typeid, OPTYPE_BASE_DATA) )	{
		p_base	= p_root;

		/* Support [?BP] => p_disp	= 0 */
		/* XXX
			if( (((Word)p_base->w_typeid) & OPTYPE_BASE_REG_GENERIC_IDMASK )
				== OPTYPE_BASE_REG_GENERIC_BP )	{ */
		if( isRegType( p_base->w_typeid, OPTYPE_BASE_REG_GENERIC ))	{
			if((isRegGenericID(p_base->w_typeid,
						OPTYPE_BASE_REG_GENERIC_BP)) ||
					(isRegGenericID(p_base->w_typeid,
						OPTYPE_BASE_REG_GENERIC_R13)))	{

				p_disp = Drd64_Intel64_AllocOperandNode();
				if( NULL == p_disp )	{ return 0x01; }

				p_disp->str_data[0]	= '0';
				p_disp->v_val.val.val64	= 0;
				p_disp->v_val.i_bytes		= 1;
				p_disp->w_typeid	= OPTYPE_BASE_DATA_IMMEDIATE_IMM;
				p_disp->b_flag_addr	= 0xff;
				p_disp->i_operandsize	= 1;
				p_disp->i_addressize	= 1;
	
				p_analyze->i_sib_bytes	= 1;
			}
		}
	}
	/* Illegal Pattern */
	else	{
		return 0x02;
	}

	/* Set Displacement */
	if( NULL != p_disp )	{
		assert( 0 == p_analyze->v_disp.i_bytes );

		p_analyze->v_disp.i_bytes	= p_disp->v_val.i_bytes;
		p_analyze->v_disp.val.val64	= p_disp->v_val.val.val64;
	}

	/* [RIP + disp] Support Code */
	if( ((Word)p_temp[0]->w_typeid) == OPTYPE_REG_RIP )	{
		p_analyze->modrm.modrm.mod	= 0x00;
		p_analyze->modrm.modrm.rm	= 0x05;

		p_analyze->v_disp.i_bytes	= 4;
	}
	else	{
		/* Support [?SP + disp?] => SiB = 1Bytes */
		if( NULL != p_base )	{
			if( isRegType( p_base->w_typeid, OPTYPE_BASE_REG_GENERIC ))	{
				if((isRegGenericID( p_base->w_typeid,
							OPTYPE_BASE_REG_GENERIC_SP )) ||
						(isRegGenericID( p_base->w_typeid,
							OPTYPE_BASE_REG_GENERIC_R12 )))	
					{ p_analyze->i_sib_bytes	= 1; }
			}
		}

		/* Mod */
		if( NULL == p_disp )
			{ p_analyze->modrm.modrm.mod	= 0x00; }
		else if( 1 == p_disp->i_operandsize )
			{ p_analyze->modrm.modrm.mod	= 0x01; }
		else
			{ p_analyze->modrm.modrm.mod	= 0x02; }


		/* R/M */
		/* SiB */
		if( 0 < p_analyze->i_sib_bytes )	{
			/* index */
			if( NULL != p_index )	{
				w_temp = ( p_index->w_typeid & OPTYPE_BASE_REG_IDMASK ) >> 8;
				p_analyze->sib.sib.index	= w_temp & 0x0007;
				p_analyze->rex.rex.x		= (w_temp & 0x0008) >> 3;
			}
			else	{
				p_analyze->sib.sib.index	= 0x0004;
			}

			/* Scale */
			if( NULL != p_scale )	{
				if(( 0x00 != p_analyze->rex.rex.x )
						|| ( 0x0004 != p_analyze->sib.sib.index ))	{
					if( 1 == p_scale->v_val.val.val64 )
						{ p_analyze->sib.sib.scale	= 0x00; }
					else if( 2 == p_scale->v_val.val.val64 )
						{ p_analyze->sib.sib.scale	= 0x01; }
					else if( 4 == p_scale->v_val.val.val64 )
						{ p_analyze->sib.sib.scale	= 0x02; }
					else if( 8 == p_scale->v_val.val.val64 )
						{ p_analyze->sib.sib.scale	= 0x03; }
				}
			}

			/* Base */
			if( NULL != p_base )	{
				w_temp	= ( p_base->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
				p_analyze->sib.sib.base		= w_temp & 0x0007;
				p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
	
			}
			else	{
				p_analyze->sib.sib.base	= 0x05;
	
				if(( NULL == p_scale ) && ( NULL != p_disp ))
					{ p_analyze->modrm.modrm.mod	= 0x00; }
			}
	
			p_analyze->modrm.modrm.rm	= 0x04;
		}
		else	{
			if( NULL != p_base )	{
				w_temp	= ( p_base->w_typeid & OPTYPE_BASE_REG_IDMASK ) >> 8;
				p_analyze->modrm.modrm.rm	= w_temp & 0x0007;
				p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
			}
		}
	}

	/* Debug Print */
	Drd64_Intel64_Debug_Asm_PrintMemoryOperand(
						p_index, p_scale, p_base, p_disp);

	return 0x00;
}


int
	Drd64_Intel64_SetAnalyzePacket_Operand(
		Drd64_Intel64_AnalyzePacket		*p_analyze,
		Drd64_Intel64_OperandNode		*p_root,
		Word	w_typeid,
		Word	w_sizeid)
{
	Word	w_temp;
	Byte	b_temp;

	/* T : [ModR/M:reg] Test Reg. ( Reserved ) */
	/* C : [ModR/M:reg] Control Reg.  */
	if( OPTYPE_DATA_METHOD_C == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* D : [ModR/M:reg] Debug Reg. */
	else if( OPTYPE_DATA_METHOD_D == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* G : [ModR/M:reg] General Reg. */
	else if( OPTYPE_DATA_METHOD_G == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* R : [ModR/M:R/M] refer to General Reg by R/M Field */
	else if( OPTYPE_DATA_METHOD_R == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
		p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
		p_analyze->modrm.modrm.mod	= 0x03;
	}
	/* P : [ModR/M:reg] Packed-QuadWord MMX Reg. */
	else if( OPTYPE_DATA_METHOD_P == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* N : [ModR/M:R/M] Packed-QuadWord MMX Reg. */
	else if( OPTYPE_DATA_METHOD_N == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
		p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
		p_analyze->modrm.modrm.mod	= 0x03;
	}
	/* V : [ModR/M:reg] 128bit XMM Reg. */
	else if( OPTYPE_DATA_METHOD_V == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* U : [ModR/M:R/M] 128bit XMM Reg. */
	else if( OPTYPE_DATA_METHOD_U == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
		p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
		p_analyze->modrm.modrm.mod	= 0x03;
	}
	/* S : [ModR/M:reg] Segment Reg. */
	else if( OPTYPE_DATA_METHOD_S == w_typeid )	{
		w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
		p_analyze->modrm.modrm.reg	= (w_temp & 0x0007);
		p_analyze->rex.rex.r		= (w_temp & 0x0008) >> 3;
	}
	/* E : [ModR/M] Memory & Reg. */
	else if( OPTYPE_DATA_METHOD_E == w_typeid )	{
		/* General Reg. */
		if( isRegType( p_root->w_typeid, OPTYPE_BASE_REG_GENERIC ) )	{
			w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
			p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
			p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
			p_analyze->modrm.modrm.mod	= 0x03; 
		}
		/* Memory Address */
		else	{
			Drd64_Intel64_SetAnalyzePacket_OperandMemory(
					p_analyze, p_root, w_typeid, w_sizeid);
		}
	}
	/* W : [ModR/M] 128bit XMM Reg. or Memory Address 
        ( Memory Address calculated by Seg.Reg. BaseReg. IndexReg. 
            ScalingFactor, Displacement */
	else if( OPTYPE_DATA_METHOD_W == w_typeid )	{
		/* XMM Reg. */
		if( isRegType( p_root->w_typeid, OPTYPE_BASE_REG_SSE ) )	{
			w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
			p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
			p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
			p_analyze->modrm.modrm.mod	= 0x03; 
		}
		/* Memory Address */
		else	{
			Drd64_Intel64_SetAnalyzePacket_OperandMemory(
					p_analyze, p_root, w_typeid, w_sizeid);
		}
	}
	/* Q : [ModR/M] MMX reg. or Memory Address 
        ( Memory Address calced by Seg.Reg, BaseReg. IndexReg. 
            ScalingFactor, Displacement */
	else if( OPTYPE_DATA_METHOD_Q == w_typeid )	{
		/* MMX Reg. */
		if( isRegType( p_root->w_typeid, OPTYPE_BASE_REG_MMX ) )	{
			w_temp	= (p_root->w_typeid & OPTYPE_BASE_REG_IDMASK) >> 8;
			p_analyze->modrm.modrm.rm	= (w_temp & 0x0007);
			p_analyze->rex.rex.b		= (w_temp & 0x0008) >> 3;
			p_analyze->modrm.modrm.mod	= 0x03; 
		}
		/* Memory Address */
		else	{
			Drd64_Intel64_SetAnalyzePacket_OperandMemory(
					p_analyze, p_root, w_typeid, w_sizeid);
		}
	}
	/* M : Memory Access (by ModR/M) (NO!!: Reg. Indicate by ModR/M) */
	else if( OPTYPE_DATA_METHOD_M == w_typeid )	{
		Drd64_Intel64_SetAnalyzePacket_OperandMemory(
				p_analyze, p_root, w_typeid, w_sizeid);
	}
	/* A : Direct Address (NO!!: ModR/M, BaseReg, IndexReg, ScalingFactor) */
	/* else if( OPTYPE_DATA_METHOD_A == w_typeid )	{ } */
	/* I : Immediate Data (NO!!: ModR/M) */
	else if( OPTYPE_DATA_METHOD_I == w_typeid )	{
		p_analyze->v_imm.val.val64	= p_root->v_val.val.val64;
		p_analyze->v_imm.i_bytes	= p_root->i_operandsize;

		/* Size */
		if(( OPSIZE_W == w_sizeid ) && ( 1 == p_root->i_operandsize ))	{
			p_root->i_operandsize	= 2;
		}
		else if(( OPSIZE_D == w_sizeid ) && ( 2 >= p_root->i_operandsize ))	{
			p_root->i_operandsize	= 4;
		}
		else if(( OPSIZE_Q == w_sizeid ) && ( 4 >= p_root->i_operandsize ))	{
			p_root->i_operandsize	= 8;
		}
		else if( OPSIZE_V == w_sizeid )	{
			p_root->i_operandsize	= p_analyze->i_operandsize;
		}
		else if( OPSIZE_Z == w_sizeid )	{
			if(( 2 == p_analyze->i_operandsize)
					&& ( 1 == p_root->i_operandsize )) 	{
				p_root->i_operandsize	= 2;
			}
			else	{
				if( 2 >= p_root->i_operandsize )	{
					p_root->i_operandsize	= 4;
				}
			}
		}

		if( p_root->i_operandsize > p_analyze->v_imm.i_bytes )	{
			Drd64_Intel64_Common_ExtendValueBit(
       				&(p_analyze->v_imm), p_root->i_operandsize,
					p_root->b_flag_addr);
		}
	}
	/* J : IP relative Address (NO!!: ModR/M) */
	else if( OPTYPE_DATA_METHOD_J == w_typeid )	{
		p_analyze->v_imm.val.val64	= p_root->v_val.val.val64;
		p_analyze->v_imm.i_bytes	= p_root->i_operandsize;
	}
	/* O : Word of DWord Data
		(NO!!: ModR/M, BaseReg. IndexReg, ScalingFactor */
	else if( OPTYPE_DATA_METHOD_O == w_typeid )	{
		p_analyze->v_imm.val.val64	= p_root->v_val.val.val64;
		p_analyze->v_imm.i_bytes	= p_root->i_operandsize;
	}
	/* F : EFLAGS / RFLAGS Reg. (NO!!: ModR/M)  */
	/* else if( OPTYPE_DATA_METHOD_F == w_typeid )	{ } */
	/* X : DS:rSI (Memory Address) */
	/* else if( OPTYPE_DATA_METHOD_X == w_typeid )	{ } */
	/* Y : ES:rDI (Memory Address) */
	/* else if( OPTYPE_DATA_METHOD_Y == w_typeid )	{ } */
	/* 1 : 0x01 Data (Immediate Data) */
	/* else if( OPTYPE_DATA_METHOD_1 == w_typeid )	{ } */
	/* - : Illegal Instruction by DrDeamon64 Assembler System */
	else if( OPTYPE_DATA_METHOD_ILLEGAL == w_typeid )	{
		return 0x01;
	}

	return 0x00;
}

int
	Drd64_Intel64_SetAnalyzePacket(
		Drd64_Intel64_AnalyzePacket	*p_analyze,
		Drd64_Intel64_AssemblePacket	*p_assemble )
{
	/* Proc. ModR/M Extension */
	/* Operand */
	Drd64_Intel64_SetAnalyzePacket_Operand(
		p_analyze, p_assemble->p_desttree,
		p_analyze->w_desttype, p_analyze->w_destsize);

	Drd64_Intel64_SetAnalyzePacket_Operand(
		p_analyze, p_assemble->p_srctree,
		p_analyze->w_srctype, p_analyze->w_srcsize);

	Drd64_Intel64_SetAnalyzePacket_Operand(
		p_analyze, p_assemble->p_optiontree,
		p_analyze->w_optiontype, p_analyze->w_optionsize);

	return 0x00;
}


int
	Drd64_Intel64_CalcDefaultAddressSize(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64_AssemblePacket *p_assemble )
{
	Drd64_Intel64_OperandNode	*p_node;

	/* Address Size */
	p_node	= p_assemble->p_desttree;
	if( NULL != p_node )	{
		if( isBitFlag(p_node->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE)) 	{
			if( 0 == p_analyze->i_addresssize )	{
				p_analyze->i_addresssize	= p_node->i_addressize;
			}
		}
	}

	p_node	= p_assemble->p_srctree;
	if( NULL != p_node )	{
		if( isBitFlag(p_node->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE)) 	{
			if( 0 == p_analyze->i_addresssize )	{
				p_analyze->i_addresssize	= p_node->i_addressize;
			} 
			else if( p_node->i_addressize != p_analyze->i_addresssize )	{
				return 0x01;
			}
		}
	}

	p_node	= p_assemble->p_optiontree;
	if( NULL != p_node )	{
		if( isBitFlag(p_node->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE)) 	{
			if( 0 == p_analyze->i_addresssize )	{
				p_analyze->i_addresssize	= p_node->i_addressize;
			} 
			else if( p_node->i_addressize != p_analyze->i_addresssize )	{
				return 0x01;
			}
		}
	}

	return 0x00;
}


int
	Drd64_Intel64_ConstructModRM(
		Drd64_Intel64_AnalyzePacket *p_analyze )
{
	/* reg Field */
	if( 0x08 > p_analyze->b_regtype )	{
		p_analyze->modrm.modrm.reg	= (p_analyze->b_regtype & 0x07);
	}

	/* r/m Field */
	if( 0x08 > p_analyze->b_rmtype )	{
		p_analyze->modrm.modrm.rm	= (p_analyze->b_rmtype & 0x07);
	}

	/* Mod Field */
	if( 0x04 > p_analyze->b_modtype )	{
		p_analyze->modrm.modrm.mod	= (p_analyze->b_modtype & 0x03);
	}

	return 0x00;
}


int
	Drd64_Intel64_CalcDefaultOperandSize(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64_AssemblePacket *p_assemble )
{
	int		i_destsize;
	int		i_srcsize;
	int		i_optionsize;
	int		i_defaultsize;
	Drd64_Intel64_OperandNode	*p_node;

	i_defaultsize	= 0;
	i_destsize	= 0;
	p_node	= p_assemble->p_desttree;
	if( NULL != p_node )	{
		if( OPSIZE_V == p_analyze->w_destsize )	{
			/* XXX : MMX/SSE/Debug/Ctrl Reg. */
			i_destsize	= p_node->i_operandsize;
		}
		/* else if( OPSIZE_Z == p_analyze->w_destsize )	{ } */
		/* else if( OPSIZE_P == p_analyze->w_destsize )	{ } */
		else if( OPSIZE_ILLEGAL == p_analyze->w_destsize )	{
			if( isRegType( p_node->w_typeid,
								OPTYPE_BASE_REG_GENERIC ))	{
				i_destsize	= p_node->i_operandsize;
			}
		}
	}

	i_srcsize	= 0;
	p_node	= p_assemble->p_srctree;
	if( NULL != p_node )	{
		if( OPSIZE_V == p_analyze->w_srcsize )	{
			/* XXX : MMX/SSE/Debug/Ctrl Reg. */
			i_srcsize	= p_node->i_operandsize;
		}
		/* else if( OPSIZE_Z == p_analyze->w_srcsize )	{ } */
		/* else if( OPSIZE_P == p_analyze->w_srcsize )	{ } */
		else if( OPSIZE_ILLEGAL == p_analyze->w_srcsize )	{
			if( isRegType( p_node->w_typeid,
								OPTYPE_BASE_REG_GENERIC ))	{
				i_srcsize	= p_node->i_operandsize;
			}
		}
	}

	i_optionsize	= 0;
	p_node	= p_assemble->p_optiontree;
	if( NULL != p_node )	{
		if( OPSIZE_V == p_analyze->w_optionsize )	{
			/* XXX : MMX/SSE/Debug/Ctrl Reg. */
			i_optionsize	= p_node->i_operandsize;
		}
		/* else if( OPSIZE_Z == p_analyze->w_optionsize )	{ } */
		/* else if( OPSIZE_P == p_analyze->w_optionsize )	{ } */
		else if( OPSIZE_ILLEGAL == p_analyze->w_optionsize )	{
			if( isRegType( p_node->w_typeid,
								OPTYPE_BASE_REG_GENERIC ))	{
				i_optionsize	= p_node->i_operandsize;
			}
		}
	}

	if( 0 != i_destsize )	{
		i_defaultsize	= i_destsize;
	}

	if( 0 != i_srcsize )	{
		if( 0 != i_defaultsize )	{
			p_node	= p_assemble->p_srctree;
			if( isBitFlag( p_node->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	{
				if( i_defaultsize < i_srcsize )
					{ return 0x01; }
			}
			else	{
				if( i_defaultsize != i_srcsize )
					{ return 0x02; }
			}
		}
		else	{
			i_defaultsize	= i_srcsize;
		}
	}

	if( 0 != i_optionsize )	{
		if( 0 != i_defaultsize )	{
			p_node	= p_assemble->p_optiontree;
			if( isBitFlag( p_node->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	{
				if( i_defaultsize < i_optionsize )
					{ return 0x01; }
			}
			else	{
				if( i_defaultsize != i_optionsize )
					{ return 0x02; }
			}
		}
		else	{
			i_defaultsize	= i_optionsize;
		}
	}
	
	if( 0 == i_defaultsize )
		{ i_defaultsize	= 4; }

	p_analyze->i_operandsize	= i_defaultsize;

	return 0x00;
}


int
	Drd64_Intel64_SetPrefixByte(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64_AssemblePacket *p_assemble )
{
	/* Address Size Prefix */
	if( 4 == p_analyze->i_addresssize )	{
		p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x67;
	}

	/* Operand Size Prefix */
	if( 8 == p_analyze->i_operandsize )	{
		p_analyze->rex.rex.w	= 0x01;
	}
	else if( 2 == p_analyze->i_operandsize )	{
		p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x66;
	}
		
	/* Rex Byte */
	if( 0x00 != p_analyze->rex.b_rex )	{
		p_analyze->rex.rex.head	= 0x04;
	}

	/* Segment Prefix Byte */
	if( NULL != p_assemble->p_segment )	{
		if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_FS )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x64; }
		else if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_GS )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x65; }
		else if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_ES )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x26; }
		else if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_CS )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x2e; }
		else if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_SS )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x36; }
		else if( (unsigned int)p_assemble->p_segment->w_typeid
				== OPTYPE_REG_DS )
			{ p_analyze->b_prefix[p_analyze->i_prefixes++]	= 0x3e; }
	}

	return 0x00;
}


int
	Drd64_Intel64_ConstructBinary(
		Byte	*pb_dest,
		Drd64_Intel64_AnalyzePacket	*p_analyze,
		int		i_maxdest )
{
	Byte	*pb_now;
	Drd64_Intel64_OperandNode	*p_disp;
	int		i_bytes;
	int		i_cnt;

	i_bytes	= 0;
	pb_now	= pb_dest;

	/* Prefix */
	for( i_cnt = p_analyze->i_prefixes; i_cnt > 0; i_cnt-- )	{
		*pb_now++	= p_analyze->b_prefix[i_cnt - 1];
		i_bytes++;
	}

	/* Rex */
	if( 0x00 != p_analyze->rex.b_rex )	{
		*pb_now++	= p_analyze->rex.b_rex;
		i_bytes++;
	}

	/* OpeCode */
	for( i_cnt = 0; i_cnt < p_analyze->i_opcodes; i_cnt++ )	{
		*pb_now++	= p_analyze->b_opcode[i_cnt];
		i_bytes++;
	} 

	/* ModR/M */
	if( 0x00 != p_analyze->modrm.b_modrm )	{
		*pb_now++	= p_analyze->modrm.b_modrm;
		i_bytes++;
	}

	/* SiB */
	if( 0x00 != p_analyze->sib.b_sib )	{
		*pb_now++	= p_analyze->sib.b_sib;
		i_bytes++;
	}
	
	/* Displacement */
	if( 0 != p_analyze->v_disp.i_bytes )	{

		if( 1 == p_analyze->v_disp.i_bytes )	{
			*pb_now++	= p_analyze->v_disp.val.val8;
			i_bytes++;
		}
		else	{
			if( 2 == p_analyze->v_disp.i_bytes )	{
				Drd64_Intel64_Common_ExtendValueBit(
        				&(p_analyze->v_disp), 4 , 1);
			}
			*(pb_now + 0)
				= (((DWord)(p_analyze->v_disp.val.val32)) & 0x000000ff);
			*(pb_now + 1)
				= (((DWord)(p_analyze->v_disp.val.val32)) & 0x0000ff00) >>  8;
			*(pb_now + 2)
				= (((DWord)(p_analyze->v_disp.val.val32)) & 0x00ff0000) >> 16;
			*(pb_now + 3)
				= (((DWord)(p_analyze->v_disp.val.val32)) & 0xff000000) >> 24;
			pb_now	+= 4;
			i_bytes	+= 4;
		}
	}

	/* Immediate */
	if( 0 != p_analyze->v_imm.i_bytes )	{

		if( 1 == p_analyze->v_imm.i_bytes )	{
			*pb_now++	= p_analyze->v_imm.val.val8;
			i_bytes++;
		}
		else if( 2 == p_analyze->v_imm.i_bytes )	{
			*(pb_now + 0)
				= (((DWord)(p_analyze->v_imm.val.val16)) & 0x00ff);
			*(pb_now + 1)
				= (((DWord)(p_analyze->v_imm.val.val16)) & 0xff00) >>  8;
			pb_now	+= 2;
			i_bytes	+= 2;
		}
		else if( 4 == p_analyze->v_imm.i_bytes )	{
			*(pb_now + 0)
				= (((DWord)(p_analyze->v_imm.val.val32)) & 0x000000ff);
			*(pb_now + 1)
				= (((DWord)(p_analyze->v_imm.val.val32)) & 0x0000ff00) >>  8;
			*(pb_now + 2)
				= (((DWord)(p_analyze->v_imm.val.val32)) & 0x00ff0000) >> 16;
			*(pb_now + 3)
				= (((DWord)(p_analyze->v_imm.val.val32)) & 0xff000000) >> 24;
			pb_now	+= 4;
			i_bytes	+= 4;
		}
		else if( 8 == p_analyze->v_imm.i_bytes )	{
			*(pb_now + 0)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x00000000000000ff);
			*(pb_now + 1)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x000000000000ff00) >>  8;
			*(pb_now + 2)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x0000000000ff0000) >> 16;
			*(pb_now + 3)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x00000000ff000000) >> 24;
			*(pb_now + 4)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x000000ff00000000) >> 32;
			*(pb_now + 5)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x0000ff0000000000) >> 40;
			*(pb_now + 6)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0x00ff000000000000) >> 48;
			*(pb_now + 7)
				= (((QWord)(p_analyze->v_imm.val.val64))
						& 0xff00000000000000) >> 56;
			pb_now	+= 8;
			i_bytes	+= 8;
		}
	}

	return i_bytes;
}


LIBINTEL64ASM_FUNC	int
	Drd64_LibIntel64asm_AsmLine(
		Byte	*pb_dest,
		char	*p_src,
		int		i_maxdest)
{
	Drd64_Intel64_AssemblePacket	drd64_assemble;
	Drd64_Intel64_AnalyzePacket		drd64_analyze;
	int		i_bytes;	
	int		i_err;
	char	*p_now;
	char	*p_temp;

	p_now	= p_src;
	i_bytes	= 0;
	
	memset( &drd64_assemble, 0x00, sizeof(Drd64_Intel64_AssemblePacket) );
	memset( &drd64_analyze, 0x00, sizeof(Drd64_Intel64_AnalyzePacket) );

	/* Phase 1 : Carve String to String Block */
	i_err	= Drd64_Intel64_CarveStringBlock( &drd64_assemble, p_src );
	if( 0x00 != i_err )		{ return 0xff; }

	Drd64_Intel64_Debug_Asm_PrintCarveString( &drd64_assemble, p_src );

	/* Phase 2 : Check Operand & Construct Operand Tree */
	if( '\0' != drd64_assemble.str_destination[0] )	{
		drd64_assemble.p_desttree	= 
			Drd64_Intel64_CheckOperand(
				drd64_assemble.str_destination, &drd64_assemble );
		if( NULL == drd64_assemble.p_desttree )	{ return 0xff; }
	}
	Drd64_Intel64_Debug_PrintOperandTree(
				drd64_assemble.p_desttree, "Destination" );

	if( '\0' != drd64_assemble.str_source[0] )	{
		drd64_assemble.p_srctree	= 
			Drd64_Intel64_CheckOperand(
				drd64_assemble.str_source, &drd64_assemble );
		if( NULL == drd64_assemble.p_srctree )	{ return 0xff; }
	}
	Drd64_Intel64_Debug_PrintOperandTree(
			drd64_assemble.p_srctree, "Source" );

	if( '\0' != drd64_assemble.str_option[0] )	{
		drd64_assemble.p_optiontree	= 
			Drd64_Intel64_CheckOperand(
				drd64_assemble.str_option, &drd64_assemble );
		if( NULL == drd64_assemble.p_optiontree )	{ return 0xff; }
	}
	Drd64_Intel64_Debug_PrintOperandTree(
			drd64_assemble.p_optiontree, "Option" );

	/* Phase 3 : Search Intel64 Database */
	i_err	= Drd64_Intel64db_SearchInstruction(
					&drd64_analyze, &drd64_assemble );
	Drd64_Intel64_Debug_PrintAnalyzePacket( &drd64_analyze, "Search DB", 3 );
	if( 0x00 != i_err )		{ return 0x00; }

	/* Phase 4 : Calc Default Operand Size */
	i_err	= Drd64_Intel64_CalcDefaultAddressSize(
				&drd64_analyze, &drd64_assemble );
	if( 0x00 != i_err )		{ return 0x01; }

	i_err	= Drd64_Intel64_CalcDefaultOperandSize(
				&drd64_analyze, &drd64_assemble );
	if( 0x00 != i_err )		{ return 0x01; }

	/* Phase 4 : Construct */
	/* Phase 4-1 : construct ModR/M Encoding */
	Drd64_Intel64_ConstructModRM( &drd64_analyze );

	/* Phase 4-2 : Construct ModR/M + SiB */
	Drd64_Intel64_SetAnalyzePacket( &drd64_analyze, &drd64_assemble );
	Drd64_Intel64_Debug_PrintAnalyzePacket( &drd64_analyze, "Set Analyze", 3 );

	/* Phase 4-3 : Construct Prefix & Rex Byte */	
	Drd64_Intel64_SetPrefixByte(&drd64_analyze, &drd64_assemble );

	Drd64_Intel64_Debug_PrintAnalyzePacket( &drd64_analyze, "Final", 2);
	Drd64_Intel64_Debug_Asm_PrintCarveString( &drd64_assemble, p_src );

	/* Phase 5 : Construct Binary */
	i_bytes	= Drd64_Intel64_ConstructBinary(
						pb_dest, &drd64_analyze, i_maxdest );

	Drd64_Intel64_Debug_Asm_PrintAnswer( pb_dest, p_src, i_bytes );

	Drd64_Intel64_ResetOperandNode_Memory();
 
	return 0x00;
}



/* EOF of drd64_intel64_asm.c ----------------------------------- */
