/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
    
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_csvcompiler.c
Function: Intel64 DataBase CSV Compiler 
Comment:  none
----------------------------------------------------------------------*/

#include"drd64_intel64.h"
#include"drd64_intel64_db.h"
#include"drd64_intel64_dbfile.h"
#include"drd64_intel64_dbcommon.h"

/* USAGE: drdasm_compiler SrcFileName [DestFileName] */


Word
	drd64_asm64compiler_compile_sizetype(
		char *pstr_size)
{
	Word	w_ret	= 0x0000;

	if( !strncmp( pstr_size, OPSIZE_B_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_B;
	} else if( !strncmp( pstr_size, OPSIZE_W_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_W;
	} else if( !strncmp( pstr_size, OPSIZE_D_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_D;
	} else if( !strncmp( pstr_size, OPSIZE_Q_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_Q;
	} else if( !strncmp( pstr_size, OPSIZE_DQ_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_DQ;
	} else if( !strncmp( pstr_size, OPSIZE_H_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_H;
	} else if( !strncmp( pstr_size, OPSIZE_P_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_P;
	} else if( !strncmp( pstr_size, OPSIZE_R_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_R;
	} else if( !strncmp( pstr_size, OPSIZE_T_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_T;
	} else if( !strncmp( pstr_size, OPSIZE_PD_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_PD;
	} else if( !strncmp( pstr_size, OPSIZE_PS_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_PS;
	} else if( !strncmp( pstr_size, OPSIZE_SD_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_SD;
	} else if( !strncmp( pstr_size, OPSIZE_SS_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_SS;
	} else if( !strncmp( pstr_size, OPSIZE_S_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_S;
	} else if( !strncmp( pstr_size, OPSIZE_V_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_V;
	} else if( !strncmp( pstr_size, OPSIZE_Z_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_Z;
	} else if( !strncmp( pstr_size, OPSIZE_A_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_A;
	} else if( !strncmp( pstr_size, OPSIZE_ILLEGAL_STR,
					MAX_OPERAND_DATASIZE_LENGTH))	{
		w_ret	= OPSIZE_ILLEGAL;
	} else	{
		w_ret	= 0xffff;
	}

	return	w_ret;
}


Word
	Drd64_Intel64_CsvCompiler_CompileMethodType(
		char *pstr_method)
{
	Word		w_ret	= 0x0000;

	/* AX */
	if( !strncmp( pstr_method, OPTYPE_REG_RAX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RAX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_EAX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_EAX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_AX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_AX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_AH_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_AH;
	} else if( !strncmp( pstr_method, OPTYPE_REG_AL_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_AL;
	}
	/* CX */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RCX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RCX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_ECX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_ECX;
	} 
	/* Reserved!
	else if( !strncmp( pstr_method, OPTYPE_REG_CX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_CX;
	} 
	*/
	  else if( !strncmp( pstr_method, OPTYPE_REG_CH_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_CH;
	} else if( !strncmp( pstr_method, OPTYPE_REG_CL_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_CL;
	}
	/* DX */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RDX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RDX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_EDX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_EDX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_DX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_DX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_DH_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_DH;
	} else if( !strncmp( pstr_method, OPTYPE_REG_DL_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_DL;
	}
	/* BX */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RBX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RBX;
	} else if( !strncmp( pstr_method, OPTYPE_REG_EBX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_EBX;
	/*  -- Reserved! --
	} else if( !strncmp( pstr_method, OPTYPE_REG_BX_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_BX;
	*/	
	} else if( !strncmp( pstr_method, OPTYPE_REG_BH_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_BH;
	} else if( !strncmp( pstr_method, OPTYPE_REG_BL_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_BL;
	}
	/* SP */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RSP_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RSP;
	} else if( !strncmp( pstr_method, OPTYPE_REG_ESP_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_ESP;
	}
	/* BP */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RBP_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RBP;
	} else if( !strncmp( pstr_method, OPTYPE_REG_EBP_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_EBP;
	}
	/* SI */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RSI_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RSI;
	} else if( !strncmp( pstr_method, OPTYPE_REG_ESI_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_ESI;
	}
	/* DI */
	  else if( !strncmp( pstr_method, OPTYPE_REG_RDI_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_RDI;
	} else if( !strncmp( pstr_method, OPTYPE_REG_EDI_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_EDI;
	}

	/* R8 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R8_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R8;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R8D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R8D;
	}
	/* R9 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R9_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R9;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R9D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R9D;
	}
	/* R10 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R10_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R10;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R10D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R10D;
	}
	/* R11 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R11_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R11;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R11D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R11D;
	}
	/* R12 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R12_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R12;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R12D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R12D;
	}
	/* R13 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R13_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R13;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R13D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R13D;
	}
	/* R14 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R14_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R14;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R14D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R14D;
	}
	/* R15 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_R15_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R15;
	} else if( !strncmp( pstr_method, OPTYPE_REG_R15D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_R15D;
	}

	/* CS */
	  else if( !strncmp( pstr_method, OPTYPE_REG_CS_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_CS;
	}
	/* DS */
	  else if( !strncmp( pstr_method, OPTYPE_REG_DS_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_DS;
	}
	/* ES */
	  else if( !strncmp( pstr_method, OPTYPE_REG_ES_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_ES;
	}
	/* SS */
	  else if( !strncmp( pstr_method, OPTYPE_REG_SS_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_SS;
	}
	/* FS */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FS_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FS;
	}
	/* GS */
	  else if( !strncmp( pstr_method, OPTYPE_REG_GS_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_GS;
	}

	/* FPU-0 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST0_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST0;
	}
	/* FPU-1 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST1_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST1;
	}
	/* FPU-2 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST2_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST2;
	}
	/* FPU-3 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST3_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST3;
	}
	/* FPU-4 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST4_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST4;
	}
	/* FPU-5 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST5_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST5;
	}
	/* FPU-6 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST6_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST6;
	}
	/* FPU-7 */
	  else if( !strncmp( pstr_method, OPTYPE_REG_FPU_ST7_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_REG_FPU_ST7;
	}

	/* DataMethod: C */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_C_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_C;
	}
	/* DataMethod: D */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_D_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_D;
	}
	/* DataMethod: G */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_G_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_G;
	}
	/* DataMethod: P */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_P_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_P;
	}
	/* DataMethod: S */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_S_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_S;
	}
	/* DataMethod: T */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_T_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_T;
	}
	/* DataMethod: V */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_V_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_V;
	}
	/* DataMethod: N */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_N_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_N;
	}
	/* DataMethod: R */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_R_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_R;
	}
	/* DataMethod: U */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_U_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_U;
	}
	/* DataMethod: E */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_E_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_E;
	}
	/* DataMethod: W */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_W_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_W;
	}
	/* DataMethod: Q */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_Q_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_Q;
	}
	/* DataMethod: M */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_M_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_M;
	}

	/* DataMethod: A */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_A_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_A;
	}
	/* DataMethod: I */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_I_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_I;
	}
	/* DataMethod: J */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_J_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_J;
	}
	/* DataMethod: O */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_O_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_O;
	}
	/* DataMethod: F */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_F_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_F;
	}
	/* DataMethod: X */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_X_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_X;
	}
	/* DataMethod: Y */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_Y_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_Y;
	}
	/* DataMethod: 1 */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_1_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_1;
	}
	/* DataMethod: Illegal */
	  else if( !strncmp( pstr_method, OPTYPE_DATA_METHOD_ILLEGAL_STR,
					MAX_OPERAND_METHODTYPE_LENGTH))	{
		w_ret	= OPTYPE_DATA_METHOD_ILLEGAL;
	}
	/* Error */
	  else {
		w_ret	= OPTYPE_DATA_METHOD_ILLEGAL;
	}

	return w_ret;
}

Byte drd64_asm64compiler_conv_str2hex(char *str_src)
{
	Byte	b_hex	= 0x00;
	Byte	b_tmp	= 0x00;

	do{
		if( isdigit( *str_src ) )	{
			b_tmp	= *str_src - '0';
		} else if(('a' <= *str_src) && ('f' >= *str_src))	{
			b_tmp	= *str_src - 'a' + 0x0a;
		} else {
			b_hex	= 0xff;
			break;
		}

		b_hex	= (b_hex << 4) + b_tmp;	
	}while( '\0' != *++str_src );

	return  b_hex;
}	

int	drd64_asm64compiler_conv_str2int(char *str_src)
{
	int		i_num	= 0;
	char	*str_tmp;

	str_tmp	= str_src;

	if( '-' == *str_tmp  )	{ str_tmp++; }

	do	{
		if( 0x00 == isdigit( *str_tmp ) )	
			{ break; }	

		i_num	= (*str_tmp - '0') + (i_num * 10);					
	}while( '\0' != *++str_tmp);

	if( '-' == *str_src  )	{ i_num	= i_num * -1; }
	
	return i_num;
}


int
	Drd64_Intel64_GetCsvLines(
		FILE *fp_src )
{
	char	str_buf[512];
	int		i_csvlines;

	i_csvlines	= 0;
	while( NULL != fgets(str_buf, 512, fp_src))	{
		if( '#' == *(str_buf + 0) )	
			{ continue; }
		
		i_csvlines++;
	} while(0x00 == feof(fp_src));
	fseek(fp_src, 0L, SEEK_SET);

	printf(" CSV Data Lines = %d\n", i_csvlines);
	return i_csvlines;
}


int
	Drd64_Intel64_WriteDBFileHeader(
		FILE	*fp_dest,
		int		i_csvlines)
{
	Drd64_Intel64db_FileHeader	s_db64header;

	/* DB File Header Setting */
	strncpy(s_db64header.str_drd64file_header, 
				DRD64_INTEL64DB_FILEHEADER_STR, 16);
	s_db64header.b_drd64file_version	= DRD64_INTEL64DB_FILEVERSION;
	s_db64header.w_drd64file_id			= DRD64_INTEL64DB_FILEID;
	strncpy(s_db64header.str_intel64db_header, 
				DRD64_INTEL64DB_INTEL64DBHEADER_STR, 16);
	s_db64header.w_intel64db_version	= DRD64_INTEL64DB_INTEL64DB_VERSION;
	s_db64header.w_lines				= i_csvlines;

	fwrite(&s_db64header, sizeof(Drd64_Intel64db_FileHeader), 1, fp_dest);
	return 0x00;
}

int
	Drd64_Intel64_CsvCompiler_ReadCSVRecord(
		Drd64_Intel64db_FileRecord	*p_dbrec,
		FILE	*fp_src,
		int		i_csvlines)
{
	int		i_error	= 0x00;
	int		i_count;
	char	str_buf[512];
	char	str_datatype[MAX_OPERAND_METHODTYPE_LENGTH];
	char	str_datasize[MAX_OPERAND_DATASIZE_LENGTH];
	char	str_restrict[10];
	Word	w_methodtype;
	Word	w_datasize;
	char	*str_tp;
	char	*pstr_now;
	Drd64_Intel64db_FileRecord	*p_dbnow;
	
	i_count	= 0;
	p_dbnow	= p_dbrec;

	/* Compile CSV Lines */
	while( NULL != fgets(str_buf, 512, fp_src))	{
		if( '#' == *(str_buf + 0) )	{
			continue;
		}

		/* Compile & Write Routine !! */

		/* No. */
		str_tp	= strtok(str_buf, ",");
		/*p_dbnow->i_num	= drd64_asm64compiler_conv_str2int( str_tp );*/
		p_dbnow->i_num	= i_count++;
		
		/* b_prefix */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_prefix	= drd64_asm64compiler_conv_str2hex( str_tp );

		/* b_rex */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_rex	= drd64_asm64compiler_conv_str2hex( str_tp );

		/* Opcodes  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->i_opcodes	= drd64_asm64compiler_conv_str2int( str_tp );

		/* Opcode 1  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_opcode[0]	= drd64_asm64compiler_conv_str2hex( str_tp );
		/* Opcode 2  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_opcode[1]	= drd64_asm64compiler_conv_str2hex( str_tp );
		/* Opcode 3  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_opcode[2]	= drd64_asm64compiler_conv_str2hex( str_tp );

		/* ModR/M byte : Mod  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_mod	= (Byte)drd64_asm64compiler_conv_str2int( str_tp );
		/* ModR/M byte : reg  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_reg	= (Byte)drd64_asm64compiler_conv_str2int( str_tp );
		/* ModR/M byte : R/M  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_rm	= (Byte)drd64_asm64compiler_conv_str2int( str_tp );

		/* x87 FloatCode-Opcode  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_fpu	= drd64_asm64compiler_conv_str2hex( str_tp );

		/* Instruction Bits  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_bits	= (Byte)drd64_asm64compiler_conv_str2int( str_tp );

		/* Instruction String  */
		str_tp	= strtok(NULL, ",");
		strncpy( p_dbnow->str_instruction, str_tp, MAX_INSTRUCTION );
		pstr_now	= p_dbnow->str_instruction;
		do{
			*pstr_now	= tolower(*pstr_now);
		} while( '\0' != *(pstr_now++ + 1));

		/* Option Nums  */
		str_tp	= strtok(NULL, ",");
		p_dbnow->b_option	= (Byte)drd64_asm64compiler_conv_str2int( str_tp );

		/* Operands   */
		str_tp	= strtok(NULL, ",");
		p_dbnow->i_operands	= drd64_asm64compiler_conv_str2int( str_tp );

		/* Dest. DataType String  */
		str_tp	= strtok(NULL, ",");
		strncpy(str_datatype, str_tp, MAX_OPERAND_METHODTYPE_LENGTH - 1 );
		w_methodtype	= Drd64_Intel64_CsvCompiler_CompileMethodType(
								str_datatype);
		if( 0xffff == w_methodtype )	{
			printf("  Compile Error[%04d]: Method Type : %s\n",
					p_dbnow->i_num, str_datatype);
			return 0x01;
		}
		p_dbnow->w_desttype	= w_methodtype;

		/* Dest. DataSize String  */
		str_tp	= strtok(NULL, ",");
		strncpy( str_datasize, str_tp, MAX_OPERAND_DATASIZE_LENGTH - 1 );
		w_datasize	= drd64_asm64compiler_compile_sizetype(str_datasize);
		if( 0xffff == w_datasize )	{
			printf("  Compile Error[%04d]: Data Size : %s\n",
					p_dbnow->i_num, str_datasize);
			return 0x02;
		}
		p_dbnow->w_destsize	= w_datasize;

		/* Src. DataType String  */
		str_tp	= strtok(NULL, ",");
		strncpy(str_datatype, str_tp, MAX_OPERAND_METHODTYPE_LENGTH - 1 );
		w_methodtype	= Drd64_Intel64_CsvCompiler_CompileMethodType(
							str_datatype);
		if( 0xffff == w_methodtype )	{
			printf("  Compile Error[%04d]: Method Type : %s\n",
					p_dbnow->i_num, str_datatype);
			return 0x03;
		}
		p_dbnow->w_srctype	= w_methodtype;

		/* Src. DataSize String  */
		str_tp	= strtok(NULL, ",");
		strncpy( str_datasize, str_tp, MAX_OPERAND_DATASIZE_LENGTH - 1 );
		w_datasize	= drd64_asm64compiler_compile_sizetype(str_datasize);
		if( 0xffff == w_datasize )	{
			printf("  Compile Error[%04d]: Data Size : %s\n",
					p_dbnow->i_num, str_datasize);
			return 0x04;
		}
		p_dbnow->w_srcsize	= w_datasize;

		/* Option DataType String  */
		str_tp	= strtok(NULL, ",");
		strncpy( str_datatype, str_tp, MAX_OPERAND_METHODTYPE_LENGTH - 1 );
		w_methodtype	= Drd64_Intel64_CsvCompiler_CompileMethodType(
								str_datatype);
		if( 0xffff == w_methodtype )	{
			printf("  Compile Error[%04d]: Method Type : %s\n",
					p_dbnow->i_num, str_datatype);
			return 0x05;
		}
		p_dbnow->w_optiontype	= w_methodtype;

		/* Option DataSize String  */
		str_tp	= strtok(NULL, ",");
		strncpy(str_datasize, str_tp, MAX_OPERAND_DATASIZE_LENGTH - 1 );
		w_datasize	= drd64_asm64compiler_compile_sizetype(str_datasize);
		if( 0xffff == w_datasize )	{
			printf("  Compile Error[%04d]: Data Size : %s\n",
					p_dbnow->i_num, str_datasize);
			return 0x06;
		}
		p_dbnow->w_optionsize	= w_datasize;

		/* Duplication Flag  */
		str_tp	= strtok(NULL, ",");
		if( '-' == *str_tp )	{ p_dbnow->b_duplicationflag	= 0x01; }

		/* Search Priority */
		str_tp	= strtok(NULL, ",");
		p_dbnow->i_priority	= drd64_asm64compiler_conv_str2int( str_tp );

		/* Restrict String */
		str_tp	= strtok(NULL, ",");
		strncpy( str_restrict, str_tp, 10 );
		if( !strncmp( str_restrict, "d64", 10 ))
			{ p_dbnow->w_restrict	= 0x01; }
		else if( !strncmp( str_restrict, "f64", 10 ))
			{ p_dbnow->w_restrict	= 0x02; }

		/* Instruction Link (Initialize) */
		p_dbnow->i_link	= -2;
		p_dbnow->i_search	= -2;
		
		p_dbnow++;
	} while(0x00 == feof(fp_src));

	return 0x00;
}


int
	Drd64_Intel64_CsvCompiler_LinkFileRecord(
		Drd64_Intel64db_FileRecord	*p_dbrec,
		int		i_csvlines)
{
	int	i_now;
	int	i_pos;
	int	i_sort;
	Drd64_Intel64db_FileRecord	*p_dbnow;
	Drd64_Intel64db_FileRecord	*p_dbbefore;
	Drd64_Intel64db_FileRecord	*p_dbpos;
	Drd64_Intel64db_FileRecord	*p_dbsort;
	Drd64_Intel64db_FileRecord	*p_dbprev;
	Drd64_Intel64db_FileRecord	*p_dbtop;

	for( i_now = 0; i_now < i_csvlines; i_now++ )	{
		p_dbnow	= (p_dbrec + i_now);

		if( -2 < p_dbnow->i_link )	{ continue; }

		p_dbbefore	= p_dbnow;
		p_dbtop	= p_dbnow;
		p_dbtop->i_search	= -3;

		for( i_pos = i_now+1; i_pos < i_csvlines; i_pos++ )	{
			p_dbpos	= (p_dbrec + i_pos);

			if( !strncmp( p_dbpos->str_instruction,
						p_dbnow->str_instruction, MAX_INSTRUCTION ))	{

				/* Sort */
				i_sort	= p_dbtop->i_num;
				p_dbprev	= NULL;
				while( -1 < i_sort )	{
					p_dbsort	= (p_dbrec + i_sort);

					if( p_dbpos->i_priority > p_dbsort->i_priority )	{
						if( NULL != p_dbprev )		{
							p_dbprev->i_link	= p_dbpos->i_num;
							p_dbpos->i_search	= -1;
						}
						else	 {
							p_dbtop->i_search	= -1;
							p_dbtop	= p_dbpos;
							p_dbtop->i_search	= -3;
						}
						p_dbpos->i_link		= p_dbsort->i_num;
						break;
					}
					p_dbprev	= p_dbsort;
					i_sort		= p_dbsort->i_link;
				}
				if( 0 > i_sort )	{
					p_dbbefore->i_link	= p_dbpos->i_num;
					p_dbbefore	= p_dbpos;
					p_dbbefore->i_search	= -1;
				}
					
			}
		}
		p_dbbefore->i_link		= -1;
	}

	/*for( i_now = 0; i_now < i_csvlines; i_now++ )	{
		p_dbnow	= (p_dbrec + i_now);
		printf("%d : %s (%d)> %d : %d\n", p_dbnow->i_num,
				p_dbnow->str_instruction, p_dbnow->i_priority,
				p_dbnow->i_link, p_dbnow->i_search);
	}*/
	return 0x00;
}


int
	Drd64_Intel64_CsvCompiler_CalcRecordHash(
		Drd64_Intel64db_FileRecord	*p_dbrec,
		int		*pi_hash_start,
		int		i_csvlines)
{
	int	i_now;
	int	i_value;
	int	i_hash_now[DRD64_INTEL64DB_HASH_RADIX];
	Drd64_Intel64db_FileRecord	*p_dbnow;
	Drd64_Intel64db_FileRecord	*p_dbtemp;

	for( i_now = 0; i_now < DRD64_INTEL64DB_HASH_RADIX; i_now++ ) {
		*(pi_hash_start + i_now)	= -1;
		i_hash_now[i_now]			= -1;
	}

	for( i_now = 0; i_now < i_csvlines; i_now++ )	{
		p_dbnow	= (p_dbrec + i_now);

		i_value	= Drd64_Intel64_DBCommon_CalcHashValue(
								p_dbnow->str_instruction );
		p_dbnow->b_hash	= (Byte)i_value;

		if( -3 < p_dbnow->i_search )	{ continue; }
		
		if( -1 == *(pi_hash_start + i_value) )	{
			*(pi_hash_start + i_value)	= p_dbnow->i_num;
		}

		if( -1 < i_hash_now[i_value] )	{
			p_dbtemp	= (p_dbrec + i_hash_now[i_value]);
			p_dbtemp->i_search	= p_dbnow->i_num;
		}

		i_hash_now[i_value]	= p_dbnow->i_num;
	}

	return 0x00;
}


int
	Drd64_Intel64_CsvCompiler_Debug_PrintLink(
		Drd64_Intel64db_FileRecord	*p_dbrec,
		int		i_csvlines)
{
	int	i_now;
	Drd64_Intel64db_FileRecord	*p_dbnow;


	for( i_now = 0; i_now < i_csvlines; i_now++ )	{
		p_dbnow	= (p_dbrec + i_now);
		printf("%3d : %10s (%3d : %2d)> %4d : %4d\n", p_dbnow->i_num,
				p_dbnow->str_instruction, p_dbnow->i_priority,
				p_dbnow->b_hash, p_dbnow->i_link, p_dbnow->i_search);
	}
	return 0x00;
}


int
	Drd64_Intel64_CsvCompiler_Compile(
		const char *str_dest_filename,
		const char *str_src_filename)
{
	int		i_error	= 0x00;
	int		i_hash_start[DRD64_INTEL64DB_HASH_RADIX];
	FILE	*fp_src;
	FILE	*fp_dest;
	Drd64_Intel64db_FileRecord	*p_dbrec;
	
	int		i_csvlines	= 0;

	/* Phase 1 : Read CSV Section ----------------------*/
	puts("[Phase 1] Reading CSV File");
	/* Open SrcFile */
	fp_src = fopen(str_src_filename, "r");
	if( NULL == fp_src )	{
		return 0x01;
	}

	/* Count CSV Lines */
	i_csvlines	= Drd64_Intel64_GetCsvLines( fp_src );

	/* Alloc FileRecord Memory */
	p_dbrec	= (Drd64_Intel64db_FileRecord *)malloc(
				sizeof(Drd64_Intel64db_FileRecord) * i_csvlines );
	if( NULL == p_dbrec )	{
		fclose( fp_src );
		return 0x01;
	}
	memset( p_dbrec, 0x00, (sizeof(Drd64_Intel64db_FileRecord) * i_csvlines));

	/* Read CSV Lines */
	i_error = Drd64_Intel64_CsvCompiler_ReadCSVRecord(
				p_dbrec, fp_src, i_csvlines );

	/* Close SrcFile */
	fclose(fp_src);

	/* Phase 2 : Optimize FileRecord -------------------*/
	puts("[Phase 2] Optimize File Record");

	/* Linking FileRecord */
	Drd64_Intel64_CsvCompiler_LinkFileRecord( p_dbrec, i_csvlines );

	/* Sort FileRecord with Priority */
	Drd64_Intel64_CsvCompiler_CalcRecordHash(
					p_dbrec, i_hash_start, i_csvlines);

	Drd64_Intel64_CsvCompiler_Debug_PrintLink( p_dbrec, i_csvlines );

	/* Phase 3 : Write DB Binary File ------------------*/
	/* Open DestFile */
	fp_dest = fopen(str_dest_filename, "wb");
	if( NULL == fp_dest )	{
		return 0x02;
	}

	/* Write DB File Header */
	Drd64_Intel64_WriteDBFileHeader( fp_dest, i_csvlines );

	/* Write DB Records */
	if( 0x00 == fwrite( p_dbrec,
					(sizeof(Drd64_Intel64db_FileRecord) * i_csvlines),
					1, fp_dest))	{
		puts("  Compile Error : Record Write Error ");
	}

	/* Write Hash Records */
	if( 0x00 == fwrite( &i_hash_start,
					(sizeof(int) * DRD64_INTEL64DB_HASH_RADIX),
					1, fp_dest))	{
		puts("  Compile Error : Record Write Error ");
	}

	/* Close DestFile */
	fclose(fp_dest);

	free( p_dbrec );

	return 0x00;
}

	
int main(int argc, char *argv[])
{
	char	str_src_filename[256];
	char	str_dest_filename[256];

	/* Check Option Parameter */
	if(2 > argc)	{
		puts("USAGE: drdasm_compiler SrcFileName [OutputFileName]\n");
		return 0x01;
	}
	
	strncpy(str_src_filename, argv[1], 256);
	
	if( 3 > argc )	{
		strncpy(str_dest_filename, "drd64_intel64db.bin", 256);
	}

	Drd64_Intel64_CsvCompiler_Compile(str_dest_filename, str_src_filename);

	/* Post Proc. */
	puts("Complete CSV File Compile!");
	return 0x00;
}

/* EOF of drd64_intel64_csvcompiler.c --------------------------------- */ 
