/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_db.c
Function: INTEL64 Assembler DataBase 
Comment: none
----------------------------------------------------------------------*/

#include"drd64_intel64.h"
#include"drd64_intel64_dbtype.h"
#include"drd64_intel64_db.h"
#include"drd64_intel64_dbfile.h"
#include"drd64_intel64_asm.h"
#include"drd64_intel64_disasm.h"
#include"drd64_intel64_dbcommon.h"

/* Make Hash Table */
/* Access & Search Function */
#define	DRD64_INTEL64DB_FILENAME	"drd64_intel64db.bin"

static	Drd64_Intel64db_Record	*p_db64rec;
static	int						i_db64datanum;
static	void					*p_db64_bytetable[2][256];
static	Drd64_Intel64db_Record	*p_db64_hashtable[DRD64_INTEL64DB_HASH_RADIX];

/*-----------------------------------------------------------------------
Word
	Drd64_Intel64db_GetRegisterCode(
		: Get Register Code form Register String

		char	*pstr_operand) : [src] Register String
-----------------------------------------------------------------------*/
Word
	Drd64_Intel64db_GetRegisterCode(
		char	*pstr_operand) 
{
	Word	w_regcode;
	w_regcode	= OPTYPE_REG_INVAILD;

	if( !strncmp( pstr_operand, OPTYPE_REG_RAX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RAX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_EAX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_EAX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_AX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_AX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_AH_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_AH; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_AL_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_AL; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RCX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RCX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_ECX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_ECX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CH_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CH; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CL_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CL; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RDX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RDX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_EDX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_EDX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DH_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DH; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DL_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DL; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RBX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RBX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_EBX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_EBX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_BX_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_BX; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_BH_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_BH; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_BL_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_BL; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RSP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RSP; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_ESP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_ESP; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SP; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RBP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RBP; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_EBP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_EBP; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_BP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_BP; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RSI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RSI; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_ESI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_ESI; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SI; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RDI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RDI; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_EDI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_EDI; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DI_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DI; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R8B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R8B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R8W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R8W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R8D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R8D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R8_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R8; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R9B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R9B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R9W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R9W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R9D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R9D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R9_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R9; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R10B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R10B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R10W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R10W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R10D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R10D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R10_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R10; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R11B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R11B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R11W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R11W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R11D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R11D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R11_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R11; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R12B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R12B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R12W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R12W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R12D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R12D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R12_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R12; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R13B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R13B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R13W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R13W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R13D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R13D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R13_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R13; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R14B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R14B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R14W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R14W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R14D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R14D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R14_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R14; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_R15B_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R15B; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R15W_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R15W; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R15D_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R15D; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_R15_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_R15; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_ES_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_ES; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CS_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CS; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SS_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SS; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DS_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DS; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FS_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FS; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_GS_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_GS; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST0_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST0; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST1_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST1; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST2_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST2; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST3_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST3; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST4_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST4; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST5_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST5; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST6_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST6; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_FPU_ST7_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_FPU_ST7; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_CR0_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR0; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR1_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR1; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR2_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR2; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR3_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR3; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR4_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR4; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR5_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR5; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR6_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR6; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR7_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR7; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR8_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR8; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR9_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR9; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR10_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR10; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR11_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR11; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR12_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR12; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR13_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR13; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR14_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR14; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_CR15_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_CR15; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_DR0_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR0; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR1_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR1; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR2_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR2; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR3_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR3; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR4_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR4; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR5_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR5; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR6_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR6; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR7_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR7; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR8_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR8; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR9_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR9; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR10_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR10; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR11_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR11; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR12_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR12; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR13_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR13; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR14_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR14; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_DR15_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_DR15; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX0_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX0; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX1_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX1; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX2_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX2; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX3_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX3; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX4_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX4; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX5_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX5; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX6_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX6; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_MMX7_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_MMX7; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE0_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE0; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE1_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE1; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE2_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE2; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE3_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE3; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE4_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE4; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE5_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE5; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE6_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE6; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE7_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE7; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE8_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE8; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE9_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE9; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE10_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE10; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE11_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE11; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE12_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE12; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE13_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE13; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE14_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE14; }
	else if( !strncmp( pstr_operand, OPTYPE_REG_SSE15_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_SSE15; }

	else if( !strncmp( pstr_operand, OPTYPE_REG_RIP_STR ,MAX_OPERAND))
		{ w_regcode	= OPTYPE_REG_RIP; }

	return w_regcode;
}


/*-----------------------------------------------------------------------
int
	Drd64_Intel64db_GetRegisterString(
		: Convert Reg.ID to Reg. String

		Byte *p_regstr,		: Dest. Register String
		Word w_regid,		: Src. Register ID
		int i_maxstr )		: Dest. Buf. Max Size

-----------------------------------------------------------------------*/
int
	Drd64_Intel64db_GetRegisterString(
		Byte *p_regstr,
		Word w_regid,
		int i_maxstr )
{
	char	*p_srcstr	= NULL;

	switch( w_regid )	{
 		case OPTYPE_REG_RAX:	p_srcstr = OPTYPE_REG_RAX_STR;	break;
 		case OPTYPE_REG_EAX:	p_srcstr = OPTYPE_REG_EAX_STR;	break;
 		case OPTYPE_REG_AX:		p_srcstr = OPTYPE_REG_AX_STR;	break;
 		case OPTYPE_REG_AH:		p_srcstr = OPTYPE_REG_AH_STR;	break;
 		case OPTYPE_REG_AL:		p_srcstr = OPTYPE_REG_AL_STR;	break;
 		case OPTYPE_REG_RCX:	p_srcstr = OPTYPE_REG_RCX_STR;	break;
 		case OPTYPE_REG_ECX:	p_srcstr = OPTYPE_REG_ECX_STR;	break;
 		case OPTYPE_REG_CX:		p_srcstr = OPTYPE_REG_CX_STR;	break;
 		case OPTYPE_REG_CH:		p_srcstr = OPTYPE_REG_CH_STR;	break;
 		case OPTYPE_REG_CL:		p_srcstr = OPTYPE_REG_CL_STR;	break;
 		case OPTYPE_REG_RDX:	p_srcstr = OPTYPE_REG_RDX_STR;	break;
 		case OPTYPE_REG_EDX:	p_srcstr = OPTYPE_REG_EDX_STR;	break;
 		case OPTYPE_REG_DX:		p_srcstr = OPTYPE_REG_DX_STR;	break;
 		case OPTYPE_REG_DH:		p_srcstr = OPTYPE_REG_DH_STR;	break;
 		case OPTYPE_REG_DL:		p_srcstr = OPTYPE_REG_DL_STR;	break;
 		case OPTYPE_REG_RBX:	p_srcstr = OPTYPE_REG_RBX_STR;	break;
 		case OPTYPE_REG_EBX:	p_srcstr = OPTYPE_REG_EBX_STR;	break;
 		case OPTYPE_REG_BX:		p_srcstr = OPTYPE_REG_BX_STR;	break;
 		case OPTYPE_REG_BH:		p_srcstr = OPTYPE_REG_BH_STR;	break;
 		case OPTYPE_REG_BL:		p_srcstr = OPTYPE_REG_BL_STR;	break;
 		case OPTYPE_REG_RSP:	p_srcstr = OPTYPE_REG_RSP_STR;	break;
 		case OPTYPE_REG_ESP:	p_srcstr = OPTYPE_REG_ESP_STR;	break;
 		case OPTYPE_REG_SP:		p_srcstr = OPTYPE_REG_SP_STR;	break;
 		case OPTYPE_REG_RBP:	p_srcstr = OPTYPE_REG_RBP_STR;	break;
 		case OPTYPE_REG_EBP:	p_srcstr = OPTYPE_REG_EBP_STR;	break;
 		case OPTYPE_REG_BP:		p_srcstr = OPTYPE_REG_BP_STR;	break;
 		case OPTYPE_REG_RSI:	p_srcstr = OPTYPE_REG_RSI_STR;	break;
 		case OPTYPE_REG_ESI:	p_srcstr = OPTYPE_REG_ESI_STR;	break;
 		case OPTYPE_REG_SI:		p_srcstr = OPTYPE_REG_SI_STR;	break;
 		case OPTYPE_REG_RDI:	p_srcstr = OPTYPE_REG_RDI_STR;	break;
 		case OPTYPE_REG_EDI:	p_srcstr = OPTYPE_REG_EDI_STR;	break;
 		case OPTYPE_REG_DI:		p_srcstr = OPTYPE_REG_DI_STR;	break;
 		case OPTYPE_REG_R8B:	p_srcstr = OPTYPE_REG_R8B_STR;	break;
 		case OPTYPE_REG_R8W:	p_srcstr = OPTYPE_REG_R8W_STR;	break;
 		case OPTYPE_REG_R8D:	p_srcstr = OPTYPE_REG_R8D_STR;	break;
 		case OPTYPE_REG_R8:		p_srcstr = OPTYPE_REG_R8_STR;	break;
 		case OPTYPE_REG_R9B:	p_srcstr = OPTYPE_REG_R9B_STR;	break;
 		case OPTYPE_REG_R9W:	p_srcstr = OPTYPE_REG_R9W_STR;	break;
 		case OPTYPE_REG_R9D:	p_srcstr = OPTYPE_REG_R9D_STR;	break;
 		case OPTYPE_REG_R9:		p_srcstr = OPTYPE_REG_R9_STR;	break;
 		case OPTYPE_REG_R10B:	p_srcstr = OPTYPE_REG_R10B_STR;	break;
 		case OPTYPE_REG_R10W:	p_srcstr = OPTYPE_REG_R10W_STR;	break;
 		case OPTYPE_REG_R10D:	p_srcstr = OPTYPE_REG_R10D_STR;	break;
 		case OPTYPE_REG_R10:	p_srcstr = OPTYPE_REG_R10_STR;	break;
 		case OPTYPE_REG_R11B:	p_srcstr = OPTYPE_REG_R11B_STR;	break;
 		case OPTYPE_REG_R11W:	p_srcstr = OPTYPE_REG_R11W_STR;	break;
 		case OPTYPE_REG_R11D:	p_srcstr = OPTYPE_REG_R11D_STR;	break;
 		case OPTYPE_REG_R11:	p_srcstr = OPTYPE_REG_R11_STR;	break;
		case OPTYPE_REG_R12B:	p_srcstr = OPTYPE_REG_R12B_STR;	break;
 		case OPTYPE_REG_R12W:	p_srcstr = OPTYPE_REG_R12W_STR;	break;
 		case OPTYPE_REG_R12D:	p_srcstr = OPTYPE_REG_R12D_STR;	break;
 		case OPTYPE_REG_R12:	p_srcstr = OPTYPE_REG_R12_STR;	break;
 		case OPTYPE_REG_R13B:	p_srcstr = OPTYPE_REG_R13B_STR;	break;
 		case OPTYPE_REG_R13W:	p_srcstr = OPTYPE_REG_R13W_STR;	break;
 		case OPTYPE_REG_R13D:	p_srcstr = OPTYPE_REG_R13D_STR;	break;
 		case OPTYPE_REG_R13:	p_srcstr = OPTYPE_REG_R13_STR;	break;
 		case OPTYPE_REG_R14B:	p_srcstr = OPTYPE_REG_R14B_STR;	break;
 		case OPTYPE_REG_R14W:	p_srcstr = OPTYPE_REG_R14W_STR;	break;
 		case OPTYPE_REG_R14D:	p_srcstr = OPTYPE_REG_R14D_STR;	break;
 		case OPTYPE_REG_R14:	p_srcstr = OPTYPE_REG_R14_STR;	break;
 		case OPTYPE_REG_R15B:	p_srcstr = OPTYPE_REG_R15B_STR;	break;
 		case OPTYPE_REG_R15W:	p_srcstr = OPTYPE_REG_R15W_STR;	break;
 		case OPTYPE_REG_R15D:	p_srcstr = OPTYPE_REG_R15D_STR;	break;
 		case OPTYPE_REG_R15:	p_srcstr = OPTYPE_REG_R15_STR;	break;
		case OPTYPE_REG_ES:		p_srcstr = OPTYPE_REG_ES_STR;	break;
		case OPTYPE_REG_CS:		p_srcstr = OPTYPE_REG_CS_STR;	break;
		case OPTYPE_REG_SS:		p_srcstr = OPTYPE_REG_SS_STR;	break;
		case OPTYPE_REG_DS:		p_srcstr = OPTYPE_REG_DS_STR;	break;
		case OPTYPE_REG_FS:		p_srcstr = OPTYPE_REG_FS_STR;	break;
		case OPTYPE_REG_GS:		p_srcstr = OPTYPE_REG_GS_STR;	break;
		/* FPU Register */
		case OPTYPE_REG_FPU_ST0:	p_srcstr = OPTYPE_REG_FPU_ST0_STR;	break;
		case OPTYPE_REG_FPU_ST1:	p_srcstr = OPTYPE_REG_FPU_ST1_STR;	break;
		case OPTYPE_REG_FPU_ST2:	p_srcstr = OPTYPE_REG_FPU_ST2_STR;	break;
		case OPTYPE_REG_FPU_ST3:	p_srcstr = OPTYPE_REG_FPU_ST3_STR;	break;
		case OPTYPE_REG_FPU_ST4:	p_srcstr = OPTYPE_REG_FPU_ST4_STR;	break;
		case OPTYPE_REG_FPU_ST5:	p_srcstr = OPTYPE_REG_FPU_ST5_STR;	break;
		case OPTYPE_REG_FPU_ST6:	p_srcstr = OPTYPE_REG_FPU_ST6_STR;	break;
		case OPTYPE_REG_FPU_ST7:	p_srcstr = OPTYPE_REG_FPU_ST7_STR;	break;
		/* Control Register */
		case OPTYPE_REG_CR0:	p_srcstr = OPTYPE_REG_CR0_STR; break;
		case OPTYPE_REG_CR1:	p_srcstr = OPTYPE_REG_CR1_STR; break;
		case OPTYPE_REG_CR2:	p_srcstr = OPTYPE_REG_CR2_STR; break;
		case OPTYPE_REG_CR3:	p_srcstr = OPTYPE_REG_CR3_STR; break;
		case OPTYPE_REG_CR4:	p_srcstr = OPTYPE_REG_CR4_STR; break;
		case OPTYPE_REG_CR5:	p_srcstr = OPTYPE_REG_CR5_STR; break;
		case OPTYPE_REG_CR6:	p_srcstr = OPTYPE_REG_CR6_STR; break;
		case OPTYPE_REG_CR7:	p_srcstr = OPTYPE_REG_CR7_STR; break;
		case OPTYPE_REG_CR8:	p_srcstr = OPTYPE_REG_CR8_STR; break;
		case OPTYPE_REG_CR9:	p_srcstr = OPTYPE_REG_CR9_STR; break;
		case OPTYPE_REG_CR10:	p_srcstr = OPTYPE_REG_CR10_STR; break;
		case OPTYPE_REG_CR11:	p_srcstr = OPTYPE_REG_CR11_STR; break;
		case OPTYPE_REG_CR12:	p_srcstr = OPTYPE_REG_CR12_STR; break;
		case OPTYPE_REG_CR13:	p_srcstr = OPTYPE_REG_CR13_STR; break;
		case OPTYPE_REG_CR14:	p_srcstr = OPTYPE_REG_CR14_STR; break;
		case OPTYPE_REG_CR15:	p_srcstr = OPTYPE_REG_CR15_STR; break;
		/* Debug Register */
		case OPTYPE_REG_DR0:	p_srcstr = OPTYPE_REG_DR0_STR; break;
		case OPTYPE_REG_DR1:	p_srcstr = OPTYPE_REG_DR1_STR; break;
		case OPTYPE_REG_DR2:	p_srcstr = OPTYPE_REG_DR2_STR; break;
		case OPTYPE_REG_DR3:	p_srcstr = OPTYPE_REG_DR3_STR; break;
		case OPTYPE_REG_DR4:	p_srcstr = OPTYPE_REG_DR4_STR; break;
		case OPTYPE_REG_DR5:	p_srcstr = OPTYPE_REG_DR5_STR; break;
		case OPTYPE_REG_DR6:	p_srcstr = OPTYPE_REG_DR6_STR; break;
		case OPTYPE_REG_DR7:	p_srcstr = OPTYPE_REG_DR7_STR; break;
		case OPTYPE_REG_DR8:	p_srcstr = OPTYPE_REG_DR8_STR; break;
		case OPTYPE_REG_DR9:	p_srcstr = OPTYPE_REG_DR9_STR; break;
		case OPTYPE_REG_DR10:	p_srcstr = OPTYPE_REG_DR10_STR; break;
		case OPTYPE_REG_DR11:	p_srcstr = OPTYPE_REG_DR11_STR; break;
		case OPTYPE_REG_DR12:	p_srcstr = OPTYPE_REG_DR12_STR; break;
		case OPTYPE_REG_DR13:	p_srcstr = OPTYPE_REG_DR13_STR; break;
		case OPTYPE_REG_DR14:	p_srcstr = OPTYPE_REG_DR14_STR; break;
		case OPTYPE_REG_DR15:	p_srcstr = OPTYPE_REG_DR15_STR; break;
		/* MMX Register */
		case OPTYPE_REG_MMX0:	p_srcstr = OPTYPE_REG_MMX0_STR; break;
		case OPTYPE_REG_MMX1:	p_srcstr = OPTYPE_REG_MMX1_STR; break;
		case OPTYPE_REG_MMX2:	p_srcstr = OPTYPE_REG_MMX2_STR; break;
		case OPTYPE_REG_MMX3:	p_srcstr = OPTYPE_REG_MMX3_STR; break;
		case OPTYPE_REG_MMX4:	p_srcstr = OPTYPE_REG_MMX4_STR; break;
		case OPTYPE_REG_MMX5:	p_srcstr = OPTYPE_REG_MMX5_STR; break;
		case OPTYPE_REG_MMX6:	p_srcstr = OPTYPE_REG_MMX6_STR; break;
		case OPTYPE_REG_MMX7:	p_srcstr = OPTYPE_REG_MMX7_STR; break;
		/* SSE Register */
		case OPTYPE_REG_SSE0:	p_srcstr = OPTYPE_REG_SSE0_STR; break;
		case OPTYPE_REG_SSE1:	p_srcstr = OPTYPE_REG_SSE1_STR; break;
		case OPTYPE_REG_SSE2:	p_srcstr = OPTYPE_REG_SSE2_STR; break;
		case OPTYPE_REG_SSE3:	p_srcstr = OPTYPE_REG_SSE3_STR; break;
		case OPTYPE_REG_SSE4:	p_srcstr = OPTYPE_REG_SSE4_STR; break;
		case OPTYPE_REG_SSE5:	p_srcstr = OPTYPE_REG_SSE5_STR; break;
		case OPTYPE_REG_SSE6:	p_srcstr = OPTYPE_REG_SSE6_STR; break;
		case OPTYPE_REG_SSE7:	p_srcstr = OPTYPE_REG_SSE7_STR; break;
		case OPTYPE_REG_SSE8:	p_srcstr = OPTYPE_REG_SSE8_STR; break;
		case OPTYPE_REG_SSE9:	p_srcstr = OPTYPE_REG_SSE9_STR;	break;
		case OPTYPE_REG_SSE10:	p_srcstr = OPTYPE_REG_SSE10_STR; break;
		case OPTYPE_REG_SSE11:	p_srcstr = OPTYPE_REG_SSE11_STR; break;
		case OPTYPE_REG_SSE12:	p_srcstr = OPTYPE_REG_SSE12_STR; break;
		case OPTYPE_REG_SSE13:	p_srcstr = OPTYPE_REG_SSE13_STR; break;
		case OPTYPE_REG_SSE14:	p_srcstr = OPTYPE_REG_SSE14_STR; break;
		case OPTYPE_REG_SSE15:	p_srcstr = OPTYPE_REG_SSE15_STR; break;
		default: break;
	}

	if( NULL != p_srcstr )	{
		strncpy( p_regstr, p_srcstr, i_maxstr ); 
	}

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64db_JudgeDB_AssemblePacket_OperandType(
		Drd64_Intel64_OperandNode	*p_operand,
		Word w_dbid)
{
	int		i_ret;
	Word	w_typeid;

	w_typeid	= p_operand->w_typeid;	
	i_ret		= 0xff;

	/* C : [ModR/M:reg] Control Reg.  */
	if( OPTYPE_DATA_METHOD_C == w_dbid )	{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_CONTROL ) )
			{ i_ret	= 0x00; }
	}
	/* D : [ModR/M:reg] Debug Reg. */
	else if( OPTYPE_DATA_METHOD_D == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_DEBUG ) )
			{ i_ret	= 0x00; }
	}
	/* G : [ModR/M:reg] General Reg. */
	else if( OPTYPE_DATA_METHOD_G == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_GENERIC ) )
			{ i_ret	= 0x00; }
	}
	/* P : [ModR/M:reg] Packed-QuadWord MMX Reg. */
	/* N : [ModR/M:R/M] Packed-QuadWord MMX Reg. */
	else if(( OPTYPE_DATA_METHOD_P == w_dbid ) ||
			( OPTYPE_DATA_METHOD_N == w_dbid ))	{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_MMX ) )
			{ i_ret	= 0x00; }
	}
	/* V : [ModR/M:reg] 128bit XMM Reg. */
	/* U : [ModR/M:R/M] 128bit XMM Reg. */
	else if(( OPTYPE_DATA_METHOD_V == w_dbid ) ||
			( OPTYPE_DATA_METHOD_U == w_dbid ))		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_SSE ) )
			{ i_ret	= 0x00; }
	}
	/* R : [ModR/M:R/M] refer to General Reg by R/M Field */
	else if( OPTYPE_DATA_METHOD_R == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_GENERIC ) )
			{ i_ret	= 0x00; }
	}
	/* E : [ModR/M] Memory & Reg. */
	else if( OPTYPE_DATA_METHOD_E == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_GENERIC ) )
			{ i_ret	= 0x00; }
		else if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE ))	
			{ i_ret	= 0x00; }
	}
	/* S : [ModR/M:reg] Segment Reg. */
	else if( OPTYPE_DATA_METHOD_S == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_SEGMENT ) )
			{ i_ret	= 0x00; }
	}
	/* W : [ModR/M] 128bit XMM Reg. or Memory Address 
        ( Memory Address calculated by Seg.Reg. BaseReg. IndexReg. 
            ScalingFactor, Displacement */
	else if( OPTYPE_DATA_METHOD_W == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_SSE ) )
			{ i_ret	= 0x00; }
		else if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE ))	
			{ i_ret	= 0x00; }
	}
	/* Q : [ModR/M] MMX reg. or Memory Address 
        ( Memory Address calced by Seg.Reg, BaseReg. IndexReg. 
            ScalingFactor, Displacement */
	else if( OPTYPE_DATA_METHOD_Q == w_dbid )		{
		if( isRegType( w_typeid, OPTYPE_BASE_REG_MMX ) )
			{ i_ret	= 0x00; }
		else if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE ))	
			{ i_ret	= 0x00; }
	}
	/* M : Memory Access (by ModR/M) (NO!!: Reg. Indicate by ModR/M) */
	else if( OPTYPE_DATA_METHOD_M == w_dbid )		{
		if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE ))	
			{ i_ret	= 0x00; }
	}
	/* I : Immediate Data (NO!!: ModR/M) */
	/* J : IP relative Address (NO!!: ModR/M) */
	else if(( OPTYPE_DATA_METHOD_I == w_dbid ) ||
			( OPTYPE_DATA_METHOD_J == w_dbid ))		{
		if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	
			{ i_ret	= 0x00; }
	}
	/* O : XXX Word of DWord Data
		(NO!!: ModR/M, BaseReg. IndexReg, ScalingFactor */
	/*else if( OPTYPE_DATA_METHOD_O == w_dbid )		{
		if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	
			{ i_ret	= 0x00; }
	}*/
	/* F : EFLAGS / RFLAGS Reg. (NO!!: ModR/M)  */
	/* X : DS:rSI (Memory Address) */
	/* Y : ES:rDI (Memory Address) */
	else if(( OPTYPE_DATA_METHOD_F == w_dbid ) ||
			( OPTYPE_DATA_METHOD_X == w_dbid ) ||	
			( OPTYPE_DATA_METHOD_Y == w_dbid ))		{
		if( NULL == p_operand )	
			{ i_ret	= 0x00; }
	}
	/* 1 : 0x01 Data (Immediate Data) */
	else if( OPTYPE_DATA_METHOD_1 == w_dbid )		{
		if( isBitFlag( w_typeid, OPTYPE_BASE_DATA_IMMEDIATE_IMM ))	{
			if( 1 == p_operand->v_val.val.val64 )		
				{ i_ret	= 0x00; }
		}
	}
	else if( isRegType( w_dbid, OPTYPE_BASE_REG_GENERIC ) )	{
		if(((unsigned int)w_dbid & OPTYPE_BASE_REG_GENERIC_IDMASK)
				== ((unsigned int)w_typeid & OPTYPE_BASE_REG_GENERIC_IDMASK))
			{ i_ret	= 0x00; }
	}
	else if( isRegType( w_dbid, OPTYPE_BASE_REG_SEGMENT ) )	{
		if( w_dbid == w_typeid )	{
			i_ret	= 0x00;
		}
	}
	else if( isRegType( w_dbid, OPTYPE_BASE_REG_FPU ) )	{
		if( w_dbid == w_typeid )	{
			i_ret	= 0x00;
		}
	}
	/* - : Illegal Instruction by DrDeamon64 Assembler System */
	/*else	{	OPTYPE_DATA_METHOD_ILLEGAL
	} */
	/* Method Type T = No Impliment 
	else if( OPTYPE_DATA_METHOD_S == w_typeid )	{ } */
	/* A : Direct Address
		(NO!!: ModR/M, BaseReg, IndexReg, ScalingFactor)
	else if( OPTYPE_DATA_METHOD_A == w_dbid )	{ } */
	
	return i_ret;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64db_JudgeDB_AssemblePacket_OperandSize(
		int		*pi_operandsize,
		Drd64_Intel64_OperandNode	*p_operand,
		Word w_dbsizeid)
{
	int		i_ret;
	int		i_size;

	i_ret	= 0xff;

	if( 0 == p_operand->i_operandsize )
		{ return i_ret;	}

	if( OPSIZE_B == w_dbsizeid )	{
		if( 1 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
	}
	else if( OPSIZE_W == w_dbsizeid )	{
		if( 2 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
		else if(( isBitFlag( p_operand->w_typeid,
					OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
				&& ( 2 >= p_operand->i_operandsize))
			{ i_ret	= 0x00; }
	}
	else if( OPSIZE_D == w_dbsizeid )	{
		if( 4 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
		else if(( isBitFlag( p_operand->w_typeid,
					OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
				&& ( 4 >= p_operand->i_operandsize))
			{ i_ret	= 0x00; }
	}
	else if( OPSIZE_Q == w_dbsizeid )	{
		if( 8 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
		else if(( isBitFlag( p_operand->w_typeid,
					OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
				&& ( 8 >= p_operand->i_operandsize))
			{ i_ret	= 0x00; }
	}
	else if(( OPSIZE_DQ == w_dbsizeid ) ||
			( OPSIZE_PD == w_dbsizeid )	||
			( OPSIZE_PS == w_dbsizeid )	||
			( OPSIZE_SD == w_dbsizeid )	||
			( OPSIZE_SS == w_dbsizeid ))	{	
		if( 16 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
	}
	/* XXX */
	else if( OPSIZE_H == w_dbsizeid )	{
		if( 8 == p_operand->i_operandsize )	
			{ i_ret	= 0x00; }
	}
	/* XXX */
	else if( OPSIZE_S == w_dbsizeid )	{

	}
	else if(( OPSIZE_V == w_dbsizeid ) ||
			( OPSIZE_P == w_dbsizeid ))	{
		if(( 8 == p_operand->i_operandsize ) ||
				( 4 == p_operand->i_operandsize ) ||
				( 2 == p_operand->i_operandsize ))	 {
			i_ret	= 0x00;
			*pi_operandsize	= p_operand->i_operandsize;
		}
		else if(( isBitFlag( p_operand->w_typeid,
					OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
				&& ( 8 >= p_operand->i_operandsize)) {
			i_ret	= 0x00;
		}
	}
	else if( OPSIZE_Z == w_dbsizeid )	{
		if( 0 == *pi_operandsize )	{
			if(( 4 == p_operand->i_operandsize ) ||
					( 2 == p_operand->i_operandsize ))	 {
				i_ret	= 0x00;
				*pi_operandsize	= p_operand->i_operandsize;
			}
			else if(( isBitFlag( p_operand->w_typeid,
						OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
					&& ( 4 >= p_operand->i_operandsize)) {
				i_ret	= 0x00;
			}
		}
		else	{
			if( 2 == *pi_operandsize )	{
				if( 2 == p_operand->i_operandsize )
					{ i_ret	= 0x00;	}
				else if(( isBitFlag( p_operand->w_typeid,
							OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
						&& ( 2 >= p_operand->i_operandsize)) {
					i_ret	= 0x00;
				}
			}
			else	{
				if( 4 == p_operand->i_operandsize )	{
					i_ret	= 0x00;
				}
				else if(( isBitFlag( p_operand->w_typeid,
							OPTYPE_BASE_DATA_IMMEDIATE_IMM ))
						&& ( 4 >= p_operand->i_operandsize)) {
					i_ret	= 0x00;
				}
			}
		}
	}
	/*else if( OPSIZE_A == w_dbsizeid )	{ } */
	else if( ((Word)OPSIZE_ILLEGAL) == w_dbsizeid )		{
		if( !isBitFlag( p_operand->w_typeid, OPTYPE_BASE_DATA ) )	{
			if( (( 0 < *pi_operandsize ) &&
					( p_operand->i_operandsize == *pi_operandsize)) ||
					( 0 == *pi_operandsize ))
			{ i_ret	= 0x00; }
		}
		else if( ((Word)p_operand->w_typeid) == OPTYPE_DATA_METHOD_1 )
			{ i_ret	= 0x00; } 
	}

	return i_ret;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64db_JudgeDB_AssemblePacket_Operand(
		int		*pi_operandsize,
		Drd64_Intel64_OperandNode	*p_operand,
		Word	w_dbtypeid,
		Word	w_dbsizeid)
{
	int		i_err;

	i_err	= Drd64_Intel64db_JudgeDB_AssemblePacket_OperandType(
		p_operand, w_dbtypeid);
	if( 0x00 != i_err )
		{ return i_err; }

	i_err	= Drd64_Intel64db_JudgeDB_AssemblePacket_OperandSize(
		pi_operandsize, p_operand, w_dbsizeid);
	if( 0x00 != i_err )
		{ return i_err; }
	
	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64db_SetAnalyzePacket_fromDB(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64db_Record *p_db64rec_now)
{

	if( 0x00 != p_db64rec_now->b_prefix )	{
		p_analyze->b_prefix[0]	= p_db64rec_now->b_prefix;
		p_analyze->i_prefixes	= 1;
	}

	p_analyze->rex.b_rex	= p_db64rec_now->b_rex;
	p_analyze->b_codetype	= p_db64rec_now->b_option;
	p_analyze->i_opcodes	= p_db64rec_now->i_opcodes;

	if( 0x07 == p_db64rec_now->b_option ) 
		{ p_analyze->i_opcodes	= 1; }
	else if( 0x08 == p_db64rec_now->b_option ) 
		{ p_analyze->i_opcodes	= 2; }

	p_analyze->b_opcode[0]	= p_db64rec_now->b_opcode[0];
	if( 0x00 != p_db64rec_now->b_fpu )	{
		p_analyze->b_opcode[1]	= p_db64rec_now->b_fpu;
	} else	{
		p_analyze->b_opcode[1]	= p_db64rec_now->b_opcode[1];
		p_analyze->b_opcode[2]	= p_db64rec_now->b_opcode[2];
	}

	p_analyze->b_modtype	= p_db64rec_now->b_mod;
	p_analyze->b_regtype	= p_db64rec_now->b_reg;
	p_analyze->b_rmtype		= p_db64rec_now->b_rm;
	p_analyze->b_bits		= p_db64rec_now->b_bits;
	p_analyze->i_operands	= p_db64rec_now->i_operands;
	p_analyze->w_desttype	= p_db64rec_now->w_desttype;
	p_analyze->w_destsize	= p_db64rec_now->w_destsize;
	p_analyze->w_srctype	= p_db64rec_now->w_srctype;
	p_analyze->w_srcsize	= p_db64rec_now->w_srcsize;
	p_analyze->w_optiontype	= p_db64rec_now->w_optiontype;
	p_analyze->w_optionsize	= p_db64rec_now->w_optionsize;

	return 0x00;
}
		

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Intel64db_SearchInstruction(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64_AssemblePacket *p_assemble)
{
	Drd64_Intel64db_Record	*p_db64rec_now;
	int		i_operandsize;
	int		i_err;
	int		i_hash;
	
	i_err			= 0xff;
	p_db64rec_now	= p_db64rec;


	/* Calc. Instruction Hash */
	i_hash	= Drd64_Intel64_DBCommon_CalcHashValue(
							p_assemble->str_instruction );
	p_db64rec_now	= p_db64_hashtable[ i_hash ];


	/* Search Instruction */
	do	{
		
		if( !strncmp( p_assemble->str_instruction, 
						p_db64rec_now->str_instruction,
						MAX_INSTRUCTION ))
			{ break; }

		p_db64rec_now	= p_db64rec_now->p_dbrec_search;
	}while( p_db64rec_now != NULL );
	
	if( NULL == p_db64rec_now )	 { return 0x01; }

	/* Search Operand */
	do	{
		
		i_err	= 0x00;

		if( 32 == p_db64rec_now->b_bits )
			{ i_err	= 0x01; }

		i_operandsize	= 0;
		if( NULL != p_assemble->p_desttree )	{
			i_err += Drd64_Intel64db_JudgeDB_AssemblePacket_Operand(
						&i_operandsize, 
						p_assemble->p_desttree, 
						p_db64rec_now->w_desttype,
						p_db64rec_now->w_destsize);
		}
		else	{
			if( 0 < p_db64rec_now->i_operands )	{
				i_err	+= 0x01;
			}
		}

		if( NULL != p_assemble->p_srctree )	{
			i_err += Drd64_Intel64db_JudgeDB_AssemblePacket_Operand(
						&i_operandsize, 
						p_assemble->p_srctree, 
						p_db64rec_now->w_srctype,
						p_db64rec_now->w_srcsize);
		}
		else	{
			if( 1 < p_db64rec_now->i_operands )	{
				i_err	+= 0x01;
			}
		}

		if( NULL != p_assemble->p_optiontree )	{
			i_err += Drd64_Intel64db_JudgeDB_AssemblePacket_Operand(
						&i_operandsize, 
						p_assemble->p_optiontree, 
						p_db64rec_now->w_optiontype,
						p_db64rec_now->w_optionsize);
		}
		else	{
			if( 2 < p_db64rec_now->i_operands )	{
				i_err	+= 0x01;
			}
		}

		if( 0x00 == i_err )	{
			Drd64_Intel64db_SetAnalyzePacket_fromDB( p_analyze, p_db64rec_now );
			break;
		}

		p_db64rec_now	= p_db64rec_now->p_dbrec_link;	

	}while( NULL != p_db64rec_now );

	return i_err;
}


/*-----------------------------------------------------------------------

-----------------------------------------------------------------------*/
static int
	Drd64_Intel64db_JudgeDB_AnalyzePacket( 
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Drd64_Intel64db_Record *p_db64, Byte b_bits )
{

	/* Judge Instruction - Bits */
	if( INTEL64_BITFREE != p_db64->b_bits )	{
		if( b_bits != p_db64->b_bits )
			{ return 0xff; }
	}

	/* Judge Opecode */
	if( p_analyze->i_opcodes > 0 )	{
		if( p_db64->b_opcode[0] != p_analyze->b_opcode[0] )
			{ return 0x01; }
	}

	if( p_analyze->i_opcodes > 1 )	{
		if( p_db64->i_opcodes < 2 )
			{ return 0x21; }
		if( p_db64->b_opcode[1] != p_analyze->b_opcode[1] ) {
			if( 0x00 != p_db64->b_fpu )	{
				if( p_db64->b_fpu != p_analyze->b_opcode[1] )
					{ return 0x22; }
			} else	{
				return 0x23;
			}
		}
	}

	if( p_analyze->i_opcodes > 2 )	{
		if( p_db64->i_opcodes < 3 )
			{ return 0x03; }
		if( p_db64->b_opcode[2] != p_analyze->b_opcode[2] )
			{ return 0x03; }
	}
	
	/* Judge REX prefix */
	if( 0x00 != p_db64->b_rex )	{
		if( p_db64->b_rex != p_analyze->rex.b_rex )
			{ return 0x04; }
	}

	/* Judge Prefix */
	if( 0x00 != p_db64->b_prefix )	{
		if( 0 == p_analyze->i_prefixes )			{
			return 0x51;
		} else if( 1 == p_analyze->i_prefixes )		{
			if( p_analyze->b_prefix[0] != p_db64->b_prefix )
				{ return 0x52;	}
		} else if( 2 == p_analyze->i_prefixes )		{
			if(( p_analyze->b_prefix[0] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[1] != p_db64->b_prefix ))	
				{ return 0x53;	}
		} else if( 3 == p_analyze->i_prefixes )		{
			if(( p_analyze->b_prefix[0] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[1] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[2] != p_db64->b_prefix ))	
				{ return 0x54;	}
		} else if( 4 == p_analyze->i_prefixes )		{
			if(( p_analyze->b_prefix[0] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[1] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[2] != p_db64->b_prefix )
					&& ( p_analyze->b_prefix[3] != p_db64->b_prefix ))	
				{ return 0x55;	}
		}

		/* XXX :
		if( (( 0 < p_analyze->i_prefixes )
				 && ( p_analyze->b_prefix[0] != p_db64->b_prefix ))
			|| (( 1 < p_analyze->i_prefixes )
				 && ( p_analyze->b_prefix[1] != p_db64->b_prefix ))
			|| (( 2 < p_analyze->i_prefixes )
				 && ( p_analyze->b_prefix[2] != p_db64->b_prefix ))
			|| (( 3 < p_analyze->i_prefixes )
				 && ( p_analyze->b_prefix[3] != p_db64->b_prefix )) )
				{ return 0x52; }
		*/

	}
	/* Judge ModR/M */
	if( 0 < p_analyze->i_modrm_bytes )	{
		if( INTEL64_MODTYPE_REG == p_db64->b_mod )	{
			if( 0x03 != p_analyze->modrm.modrm.mod)
				{ return 0x61; }
			if( ( 0x08 > p_db64->b_reg)
					&& ( p_analyze->modrm.modrm.reg != p_db64->b_reg ))
				{ return 0x62; } 
			if( ( 0x08 > p_db64->b_rm)
					&& ( p_analyze->modrm.modrm.rm != p_db64->b_rm ))
				{ return 0x63; } 
		}
		else if( INTEL64_MODTYPE_MEMREG == p_db64->b_mod )	{
			if( ( 0x08 > p_db64->b_reg)
					&& ( p_analyze->modrm.modrm.reg != p_db64->b_reg ))
				{ return 0x71; } 
			if( ( 0x08 > p_db64->b_rm)
					&& ( p_analyze->modrm.modrm.rm != p_db64->b_rm ))
				{ return 0x72; } 

		} 
		else if( INTEL64_MODTYPE_MEM == p_db64->b_mod )	{
			if( 0x03 == p_analyze->modrm.modrm.mod)
				{ return 0x81; }
			if( ( 0x08 > p_db64->b_reg)
					&& ( p_analyze->modrm.modrm.reg != p_db64->b_reg ))
				{ return 0x82; } 
			if( ( 0x08 > p_db64->b_rm)
					&& ( p_analyze->modrm.modrm.rm != p_db64->b_rm ))
				{ return 0x83; } 

		} 

		else if( INTEL64_MODTYPE_FPU == p_db64->b_mod )	{
			if( 0xbf < p_analyze->modrm.b_modrm )
				{ return 0x91;	}
			if(( 0x08 > p_db64->b_reg )
					&& ( p_analyze->modrm.modrm.reg != p_db64->b_reg))
				{ return 0x92;	}

		}

		if( INTEL64_MODTYPE_FPU == p_analyze->b_modtype )	{
			if( INTEL64_MODTYPE_ESCAPE == p_db64->b_mod )
				{ return 0xa0;	}
		}
		
	}
	return 0x00;
}


/*-----------------------------------------------------------------------
Byte
	Drd64_Intel64db_GetByteCodeType(
		: Get ByteCode Tyep from Intel 64 DataBase 
	
		Drd64_Intel64_AnalyzePacket *p_analyze)	
			: [Dest][Src] Analyze Packet
-----------------------------------------------------------------------*/
Byte
	Drd64_Intel64db_GetByteCodeType(
		Drd64_Intel64_AnalyzePacket *p_analyze)
{
	Byte	b_ret	= INTEL64_CODETYPE_NOINSTRUCTION;
	Drd64_Intel64db_Record	*p_db64rec_now;
	void					**p_ext_bytetable;
	int		i_judge;

	if( 1 < p_analyze->i_opcodes )		{
		p_ext_bytetable	= p_db64_bytetable[1][ p_analyze->b_opcode[0] ];
		if( NULL == p_ext_bytetable )	{
			return INTEL64_CODETYPE_ERROR;
		}
		p_db64rec_now	= *(p_ext_bytetable + p_analyze->b_opcode[1] );
	} else	{
		p_db64rec_now	= p_db64_bytetable[0][ p_analyze->b_opcode[0] ];
	}

	if( NULL == p_db64rec_now )	{
		return INTEL64_CODETYPE_ERROR;
	}

	do	{
		i_judge = Drd64_Intel64db_JudgeDB_AnalyzePacket(
						p_analyze, p_db64rec_now, INTEL64_BIT64ONLY );
		if( 0x00 == i_judge )	{
			b_ret	= p_db64rec_now->b_option;
			p_analyze->b_codetype	= p_db64rec_now->b_option;
			p_analyze->b_modtype	= p_db64rec_now->b_mod;
			p_analyze->b_regtype	= p_db64rec_now->b_reg;
			p_analyze->b_rmtype		= p_db64rec_now->b_rm;
			strncpy( p_analyze->str_instruction,
				p_db64rec_now->str_instruction, MAX_INSTRUCTION );
			
			p_analyze->w_desttype	= p_db64rec_now->w_desttype;
			p_analyze->w_destsize	= p_db64rec_now->w_destsize;
			p_analyze->w_srctype	= p_db64rec_now->w_srctype;
			p_analyze->w_srcsize	= p_db64rec_now->w_srcsize;
			p_analyze->w_optiontype	= p_db64rec_now->w_optiontype;
			p_analyze->w_optionsize	= p_db64rec_now->w_optionsize;
			break;	
		}
		p_db64rec_now++;	
	} while( p_db64rec_now->i_num < i_db64datanum );

	return b_ret;
}


/*-----------------------------------------------------------------------
Byte
	Drd64_Intel64db_GetBytePrefixType(
		: Get ByteCode Type is Prefix Or None

		Byte b_code,	: [src] ByteCode 
		Byte b_bits)	: [opt] Judge Bit Mode (32/64)

-----------------------------------------------------------------------*/
Byte
	Drd64_Intel64db_GetBytePrefixType(
		Byte b_code,
		Byte b_bits)
{
	Byte	b_ret	= 0x00;
	Drd64_Intel64db_Record	*p_db64rec_now;

	p_db64rec_now	= p_db64_bytetable[0][b_code];
	do	{
		if(( INTEL64_BITFREE == p_db64rec_now->b_bits )
			|| ((INTEL64_BIT64ONLY == b_bits )
				&& ( INTEL64_BIT64ONLY == p_db64rec_now->b_bits ))) {
			b_ret	= p_db64rec_now->b_option;
			break;	
		}
		p_db64rec_now++;	
	} while( p_db64rec_now->i_num < i_db64datanum );
	
	return b_ret;
}


/*-----------------------------------------------------------------------
static int
	Drd64_Intel64db_FreeByteTable(void)
		: Free Intel 64 Database Byte Table for High-speed Access
-----------------------------------------------------------------------*/
static int
	Drd64_Intel64db_FreeByteTable(void)
{
	int		i_cnt;

	for( i_cnt=0; i_cnt<256; i_cnt++ )	{
		if( NULL != p_db64_bytetable[1][ i_cnt ] )	{
			free( p_db64_bytetable[1][ i_cnt ] );
			p_db64_bytetable[1][ i_cnt ]	= NULL; 
		}
		p_db64_bytetable[0][ i_cnt ]	= NULL; 
	}
	
	return 0x00;
}


/*-----------------------------------------------------------------------
static int
	Drd64_Intel64db_GenerateByteTable(void)
		: Generate Intel 64 Database Byte Table for High-speed Access
-----------------------------------------------------------------------*/
static int
	Drd64_Intel64db_GenerateByteTable(void)
{
	int						i_cnt;
	Drd64_Intel64db_Record	*p_db64rec_now;
	void					**p_ext_bytetable;
	Byte					b_opcode[2];

	/* Initialize Byte Table */
	memset( p_db64_bytetable, 0x00, sizeof(void *) * 256 * 2);

	for( i_cnt=i_db64datanum; i_cnt>=0; i_cnt-- )	{
		p_db64rec_now	= p_db64rec + i_cnt;
		b_opcode[0]		= p_db64rec_now->b_opcode[0];
	
		if( 1 < p_db64rec_now->i_opcodes )	{
			if( NULL == p_db64_bytetable[1][ b_opcode[0] ] )	{
				p_ext_bytetable = malloc( 256 * sizeof(void *));
				if( NULL == p_ext_bytetable ) 	{
					return 0x01;
				}
				p_db64_bytetable[1][ b_opcode[0] ] = p_ext_bytetable;
			}
			
			if( 4 == p_db64rec_now->i_opcodes ) 
				{ b_opcode[1]	= p_db64rec_now->b_fpu; }
			else
				{ b_opcode[1]	= p_db64rec_now->b_opcode[1]; }
					
			p_ext_bytetable	= p_db64_bytetable[1][ b_opcode[0] ];
			*(p_ext_bytetable + b_opcode[1]) = p_db64rec_now;
		} else	{
			p_db64_bytetable[0][ b_opcode[0] ] = p_db64rec_now;
		}
	}

	return 0x00;
}


/*-----------------------------------------------------------------------
static int
	Drd64_Intel64db_GenerateByteTable(void)
		: Generate Intel 64 Database Byte Table for High-speed Access
-----------------------------------------------------------------------*/
static int
	Drd64_Intel64db_GenerateHashTable(
		FILE	*fp_db )
{
	int		i_cnt;
	int		i_hashtable[DRD64_INTEL64DB_HASH_RADIX];

	if( 1 != fread( &i_hashtable, sizeof(int) * DRD64_INTEL64DB_HASH_RADIX,
						1, fp_db))	{
		puts("Error 005");
		return 0x05;
	}

	for( i_cnt = 0; i_cnt < DRD64_INTEL64DB_HASH_RADIX; i_cnt++ )	{
		if( 0 > i_hashtable[i_cnt] )	{	
			p_db64_hashtable[i_cnt]	= NULL;
		} else	{
			p_db64_hashtable[i_cnt]	= (p_db64rec + i_hashtable[i_cnt]);
		}
	}

	return 0x00;
}


/*-----------------------------------------------------------------------
static Drd64_Intel64db_Record *
	Drd64_Intel64db_AllocMemory(void)
		: Alloc Intel 64 Database Memory 
-----------------------------------------------------------------------*/
static Drd64_Intel64db_Record *
	Drd64_Intel64db_AllocMemory(void)
{
	Drd64_Intel64db_Record	*p_db64rec_ret;

	p_db64rec_ret	= NULL;
	p_db64rec_ret = (Drd64_Intel64db_Record *)malloc(sizeof(Drd64_Intel64db_Record) * i_db64datanum);
	if( NULL == p_db64rec_ret )	{
		return p_db64rec_ret;
	}

	memset( p_db64rec_ret, 0x00,
			sizeof(Drd64_Intel64db_Record) * i_db64datanum );

	return p_db64rec_ret;
}


/*-----------------------------------------------------------------------
static int
	Drd64_Intel64db_LoadRecord(FILE	*)
		: Load Intel 64 DataBase from binary-File
-----------------------------------------------------------------------*/
static int
	Drd64_Intel64db_LoadRecord(
		FILE	*fp_db )
{
	int		i_cnt;
	Drd64_Intel64db_FileRecord	db64_filerecord;
	Drd64_Intel64db_Record		*p_db64rec_now;

	p_db64rec_now	= p_db64rec;
	for( i_cnt=0; i_cnt<i_db64datanum; i_cnt++ )	{
		/* Read Record */
		memset( &db64_filerecord, 0x00, sizeof(Drd64_Intel64db_FileRecord));
		if( 1 != fread( &db64_filerecord, sizeof(Drd64_Intel64db_FileRecord), 1, fp_db))	{
			puts("Error 004");
			return 0x04;
		}

		/* Copy PackData to MemoryData */
		p_db64rec_now->i_num		= db64_filerecord.i_num;
		p_db64rec_now->b_prefix		= db64_filerecord.b_prefix;
		p_db64rec_now->b_rex		= db64_filerecord.b_rex;
		p_db64rec_now->i_opcodes	= db64_filerecord.i_opcodes;
		p_db64rec_now->b_opcode[0]	= db64_filerecord.b_opcode[0];
		p_db64rec_now->b_opcode[1]	= db64_filerecord.b_opcode[1];
		p_db64rec_now->b_opcode[2]	= db64_filerecord.b_opcode[2];
		p_db64rec_now->b_mod		= db64_filerecord.b_mod;
		p_db64rec_now->b_reg		= db64_filerecord.b_reg;
		p_db64rec_now->b_rm			= db64_filerecord.b_rm;
		p_db64rec_now->b_fpu		= db64_filerecord.b_fpu;
		p_db64rec_now->b_bits		= db64_filerecord.b_bits;
		strncpy( p_db64rec_now->str_instruction,
					db64_filerecord.str_instruction, MAX_INSTRUCTION );
		p_db64rec_now->b_option		= db64_filerecord.b_option;
		p_db64rec_now->i_operands	= db64_filerecord.i_operands;
		p_db64rec_now->w_desttype	= db64_filerecord.w_desttype;
		p_db64rec_now->w_destsize	= db64_filerecord.w_destsize;
		p_db64rec_now->w_srctype	= db64_filerecord.w_srctype;
		p_db64rec_now->w_srcsize	= db64_filerecord.w_srcsize;
		p_db64rec_now->w_optiontype	= db64_filerecord.w_optiontype;
		p_db64rec_now->w_optionsize	= db64_filerecord.w_optionsize;
		p_db64rec_now->b_duplicationflag	= db64_filerecord.b_duplicationflag;
		p_db64rec_now->i_priority	= db64_filerecord.i_priority;
		p_db64rec_now->w_restrict	= db64_filerecord.w_restrict;
		p_db64rec_now->b_hash		= db64_filerecord.b_hash;
		
		if( 0 > db64_filerecord.i_link )	{
			p_db64rec_now->p_dbrec_link	= NULL;
		} else	{
			p_db64rec_now->p_dbrec_link	
					= (p_db64rec + db64_filerecord.i_link);
		}

		if( 0 > db64_filerecord.i_search )	{
			p_db64rec_now->p_dbrec_search	= NULL;
		} else	{
			p_db64rec_now->p_dbrec_search	
					= (p_db64rec + db64_filerecord.i_search);
		}

		p_db64rec_now++;
	}

	return 0x00;
}


/*-----------------------------------------------------------------------
[extern] int
	Drd64_Intel64db_Initialize(void)
		: Initialize Intel 64 DataBase Before Use. 
-----------------------------------------------------------------------*/
int
	Drd64_Intel64_DB_Initialize(
		void)
{
	int		i_cnt;
	FILE	*fp_db;
	Drd64_Intel64db_FileHeader	db64_fileheader;

	fp_db	= NULL;
	i_db64datanum	= 0;
	
	/* Load DB file */
	fp_db	= fopen(DRD64_INTEL64DB_FILENAME, "rb");
	if( NULL == fp_db )		{ return 0x01; }

	/* DB header Load */
	if( 1 != fread(&db64_fileheader,
				sizeof(Drd64_Intel64db_FileHeader), 1, fp_db))
		{ return 0x02;	}
	
	/* Check DB Header */


	/* Set Header Data */
	i_db64datanum	= (int)db64_fileheader.w_lines;

	/* Alloc Memory */
	p_db64rec = Drd64_Intel64db_AllocMemory();
	if( NULL == p_db64rec )		{ return 0x03; }

	/* Load */
	if( 0x00 != Drd64_Intel64db_LoadRecord(fp_db) )
			{ return 0x04; }

	/* Make Byte Table */
	Drd64_Intel64db_GenerateByteTable();

	/* Make Hash Table */
	Drd64_Intel64db_GenerateHashTable( fp_db );
	
	fclose(fp_db);

	return 0x00;
}


/*-----------------------------------------------------------------------
[extern] int
	Drd64_Intel64db_Terminate(void)
		: Terminate Intel64 DataBase Use
-----------------------------------------------------------------------*/
int
	Drd64_Intel64_DB_Terminate(
		void)
{
	Drd64_Intel64db_FreeByteTable();

	if( NULL != p_db64rec )	{
		free( p_db64rec );
	}

	return 0x00;
}


/* EOF of drd64_intel64_db.c ----------------------------------- */
