/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
    
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_dbfile.h
Function: Intel64 DataBase Binary File Defines/Headers
Comment:  none
----------------------------------------------------------------------*/


#ifndef DRD64_HEADER_INTEL64DBFILE
#define DRD64_HEADER_INTEL64DBFILE

#include"drd64_intel64.h"
#include"drd64_intel64_db.h"

#define	DRD64_INTEL64DB_HASH_MUL	137
#define	DRD64_INTEL64DB_HASH_RADIX	69

typedef struct {
	int		i_num;
	Byte	b_prefix;
	Byte	b_rex;
	int		i_opcodes;
	Byte	b_opcode[3];
	Byte	b_mod;
	Byte	b_reg;
	Byte	b_rm;
	Byte	b_fpu;
	Byte	b_bits;
	char	str_instruction[MAX_INSTRUCTION];
	Byte	b_option;
	int		i_operands;
	Word	w_desttype;
	Word	w_destsize;	
	Word	w_srctype;
	Word	w_srcsize;
	Word	w_optiontype;
	Word	w_optionsize;
	Byte	b_duplicationflag;
	int		i_priority;
	Word	w_restrict;
	int		i_link;
	int		i_search;
	Byte	b_hash;
} __attribute((packed))	Drd64_Intel64db_FileRecord;


#define	DRD64_INTEL64DB_FILEHEADER_STR		"DrDeamon64 BSD "
#define	DRD64_INTEL64DB_FILEVERSION			0x10
#define	DRD64_INTEL64DB_FILEID				0x8664
#define	DRD64_INTEL64DB_INTEL64DBHEADER_STR	"INTEL64 NIMONIC "
#define	DRD64_INTEL64DB_INTEL64DB_VERSION	0x0010

typedef struct {
	char	str_drd64file_header[16];	/* "DrDeamon64 BSD \0" */
	Byte	b_drd64file_version;		/* 0x10 */
	Word	w_drd64file_id;				/* */

	char	str_intel64db_header[16];	/* "INTEL64 NIMONIC \0" */
	Word	w_intel64db_version;		/* 0x0010 */
	Word	w_lines;					
	
} __attribute((packed))	Drd64_Intel64db_FileHeader;


/* C : [ModR/M:reg] Control Reg.  */
#define OPTYPE_DATA_METHOD_C_STR	"C"
/* D : [ModR/M:reg] Debug Reg. */
#define OPTYPE_DATA_METHOD_D_STR	"D"
/* G : [ModR/M:reg] General Reg. */
#define OPTYPE_DATA_METHOD_G_STR	"G"
/* P : [ModR/M:reg] Packed-QuadWord MMX Reg. */ 
#define OPTYPE_DATA_METHOD_P_STR	"P"
/* S : [ModR/M:reg] Segment Reg. */
#define OPTYPE_DATA_METHOD_S_STR	"S"
/* T : [ModR/M:reg] Test Reg. ( Reserved ) */
#define OPTYPE_DATA_METHOD_T_STR	"T"
/* V : [ModR/M:reg] 128bit XMM Reg. */
#define OPTYPE_DATA_METHOD_V_STR	"V"
/* N : [ModR/M:R/M] Packed-QuadWord MMX Reg. */
#define OPTYPE_DATA_METHOD_N_STR	"N"
/* R : [ModR/M:R/M] refer to General Reg by R/M Field */
#define OPTYPE_DATA_METHOD_R_STR	"R"
/* U : [ModR/M:R/M] 128bit XMM Reg. */
#define OPTYPE_DATA_METHOD_U_STR	"U"
/* E : [ModR/M] Memory & Reg. */
#define OPTYPE_DATA_METHOD_E_STR	"E"
/* W : [ModR/M] 128bit XMM Reg. or Memory Address 
		( Memory Address calculated by Seg.Reg. BaseReg. IndexReg. 
			ScalingFactor, Displacement */
#define OPTYPE_DATA_METHOD_W_STR	"W"
/* Q : [ModR/M] MMX reg. or Memory Address 
		( Memory Address calced by Seg.Reg, BaseReg. IndexReg. 
			ScalingFactor, Displacement */
#define OPTYPE_DATA_METHOD_Q_STR	"Q"
/* M : Memory Access (by ModR/M) (NO!!: Reg. Indicate by ModR/M) */
#define OPTYPE_DATA_METHOD_M_STR	"M"

/* A : Direct Address (NO!!: ModR/M, BaseReg, IndexReg, ScalingFactor) */
#define OPTYPE_DATA_METHOD_A_STR	"A"
/* I : Immediate Data (NO!!: ModR/M) */
#define OPTYPE_DATA_METHOD_I_STR	"I"
/* J : IP relative Address (NO!!: ModR/M) */
#define OPTYPE_DATA_METHOD_J_STR	"J"
/* O : Word of DWord Data (NO!!: ModR/M, BaseReg. IndexReg, ScalingFactor */
#define OPTYPE_DATA_METHOD_O_STR	"O"
/* F : EFLAGS / RFLAGS Reg. (NO!!: ModR/M)  */
#define OPTYPE_DATA_METHOD_F_STR	"F"
/* X : DS:rSI (Memory Address) */
#define OPTYPE_DATA_METHOD_X_STR	"X"
/* Y : ES:rDI (Memory Address) */
#define OPTYPE_DATA_METHOD_Y_STR	"Y"

/* 1 : 0x01 Data (Immediate Data) */
#define OPTYPE_DATA_METHOD_1_STR	"1"
/* - : Illegal Instruction by DrDeamon64 Assembler System */
#define OPTYPE_DATA_METHOD_ILLEGAL_STR	"-"

/* b : Byte (Regardless Operand Size Attribute) */
#define OPSIZE_B_STR	"b"
/* w : Word (Regardless Operand Size Attribute) */
#define OPSIZE_W_STR	"w"
/* d : DWord (Regardless Operand Size Attribute) */
#define OPSIZE_D_STR	"d"
/* q : QuadWord(64bit) (Regardless Operand Size Attribute) */
#define OPSIZE_Q_STR	"q"
/* dq : Double QuadWord(128Bit) (Regardless Operand Size Attribute) */
#define OPSIZE_DQ_STR	"dq"
/* h : Memory Pointer for 94/108bit */
#define OPSIZE_H_STR	"h"
/* p : Memory Pointer for 32bit or 48bit (depend on Operand Size Attribute) */
#define OPSIZE_P_STR	"p"
/* r : Memory Pointer for 14bit / 28bit */
#define OPSIZE_R_STR	"r"
/* t : Memory Pointer for 80bit */
#define OPSIZE_T_STR	"t"
/* pd : 128bit Packed double-float Data */
#define OPSIZE_PD_STR	"pd"
/* ps : 128bit Packed float Data */
#define OPSIZE_PS_STR	"ps"
/* sd : Scalar Element of 128bit Packed Double-float Data */
#define OPSIZE_SD_STR	"sd"
/* ss : Scalar Element of 128bit Packed float Data */
#define OPSIZE_SS_STR	"ss"
/* s : 6Byte or 10 Byte Pseudo Descriptor */
#define OPSIZE_S_STR	"s"
/* v : Word, DWord, QuadWord(64bit-ModeOnly) (Depend On Operand Size Attribute)*/
#define OPSIZE_V_STR	"v"
/* z : Word(16bit Operand Size) or DWord(32/64 Operand Size) */
#define OPSIZE_Z_STR	"z"
/* a : 2 Word or 2 DWord in Memory ( for BOUND ) */
#define OPSIZE_A_STR	"a"

#define	OPSIZE_ILLEGAL_STR		"-"	


#endif	/* DRD64_HEADER_INTEL64DBFILE */

/* EOF of drd64_intel64_dbfile.h --------------------------------------*/

