/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
    
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_dbtype.h
Function: Intel64 Nimonic DataBase Defines Header
Comment: none
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_INTEL64_DBTYPE
#define DRD64_HEADER_INTEL64_DBTYPE

#include"drd64_intel64.h"

#define	MAX_INSTRUCTION		20
#define	MAX_OPERAND_METHODTYPE_LENGTH	7
#define	MAX_OPERAND_DATASIZE_LENGTH	5
#define	MAX_OPERAND	50

#define	INTEL64_CODETYPE_SEGMENT		0x03
#define	INTEL64_CODETYPE_REX			0x04
#define	INTEL64_CODETYPE_PREFIX			0x01
#define	INTEL64_CODETYPE_ESCAPE			0x02
#define	INTEL64_CODETYPE_FPUBYTE1		0x05
#define	INTEL64_CODETYPE_ESCAPE2		0x06
#define	INTEL64_CODETYPE_ILLEGAL		0x09
#define	INTEL64_CODETYPE_FPU_MEM		0x07
#define	INTEL64_CODETYPE_FPU_REG		0x08
#define	INTEL64_CODETYPE_ERROR			0xff
#define	INTEL64_CODETYPE_NOINSTRUCTION	0xf0

#define	INTEL64_BITFREE				86
#define	INTEL64_BIT32ONLY			32
#define	INTEL64_BIT64ONLY			64

#define	INTEL64_MODTYPE_REG			3
#define	INTEL64_MODTYPE_NONE		4
#define	INTEL64_MODTYPE_REQUIRE		5
#define	INTEL64_MODTYPE_MEMREG		6
#define	INTEL64_MODTYPE_MEM			7
#define	INTEL64_MODTYPE_FPU			8
#define	INTEL64_MODTYPE_NONE_FPU	9
#define	INTEL64_MODTYPE_ESCAPE		10
#define	INTEL64_MODTYPE_ERROR		15



/* Opeland Type Defines */
/*
	Bit 15: have ModR/M
	Bit 14: have SIB
	Bit 13: have Immidiate Data  
	Bit 12:
	Bit 11:
	Bit 10:
	Bit  9: 
	Bit  8:
	Bit  7:
	Bit  6:
	Bit  5:
	Bit  4:
	Bit  3:
	Bit  2:
	Bit  1:
	Bit  0:

*/
#define OPTYPE_BASE_REG		0x0000
#define OPTYPE_BASE_DATA	0x8000

#define OPTYPE_BASE_REG_TYPEMASK	0x7000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_GENERIC		0x1000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_SEGMENT		0x2000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_CONTROL		0x3000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_FPU			0x4000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_DEBUG		0x5000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_MMX			0x6000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_SSE			0x7000|OPTYPE_BASE_REG
#define OPTYPE_BASE_REG_OTHER		0x0000|OPTYPE_BASE_REG

#define OPTYPE_BASE_REG_SIZEMASK	0x00f0
#define OPTYPE_BASE_REG_64BIT		0x0080
#define OPTYPE_BASE_REG_32BIT		0x0040
#define OPTYPE_BASE_REG_16BIT		0x0020
#define OPTYPE_BASE_REG_8BIT		0x0010

#define OPTYPE_BASE_REG_8BIT_HIGH	0x0002|OPTYPE_BASE_REG_8BIT
#define OPTYPE_BASE_REG_8BIT_LOW	0x0001|OPTYPE_BASE_REG_8BIT

#define OPTYPE_BASE_REG_IDMASK			0x0f00	
#define OPTYPE_BASE_REG_GENERIC_IDMASK	0x0f00|OPTYPE_BASE_REG_GENERIC	
#define OPTYPE_BASE_REG_GENERIC_AX		0x0000|OPTYPE_BASE_REG_GENERIC	
#define OPTYPE_BASE_REG_GENERIC_CX		0x0100|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_DX		0x0200|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_BX		0x0300|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_SP		0x0400|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_BP		0x0500|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_SI		0x0600|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_DI		0x0700|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R8		0x0800|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R9		0x0900|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R10		0x0a00|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R11		0x0b00|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R12		0x0c00|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R13		0x0d00|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R14		0x0e00|OPTYPE_BASE_REG_GENERIC
#define OPTYPE_BASE_REG_GENERIC_R15		0x0f00|OPTYPE_BASE_REG_GENERIC


#define OPTYPE_REG_RAX		(OPTYPE_BASE_REG_GENERIC_AX|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_EAX		(OPTYPE_BASE_REG_GENERIC_AX|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_AX		(OPTYPE_BASE_REG_GENERIC_AX|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_AH		(OPTYPE_BASE_REG_GENERIC_AX|OPTYPE_BASE_REG_8BIT_HIGH)
#define OPTYPE_REG_AL		(OPTYPE_BASE_REG_GENERIC_AX|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_RCX		(OPTYPE_BASE_REG_GENERIC_CX|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_ECX		(OPTYPE_BASE_REG_GENERIC_CX|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_CX		(OPTYPE_BASE_REG_GENERIC_CX|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_CH		(OPTYPE_BASE_REG_GENERIC_CX|OPTYPE_BASE_REG_8BIT_HIGH)
#define OPTYPE_REG_CL		(OPTYPE_BASE_REG_GENERIC_CX|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_RDX		(OPTYPE_BASE_REG_GENERIC_DX|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_EDX		(OPTYPE_BASE_REG_GENERIC_DX|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_DX		(OPTYPE_BASE_REG_GENERIC_DX|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_DH		(OPTYPE_BASE_REG_GENERIC_DX|OPTYPE_BASE_REG_8BIT_HIGH)
#define OPTYPE_REG_DL		(OPTYPE_BASE_REG_GENERIC_DX|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_RBX		(OPTYPE_BASE_REG_GENERIC_BX|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_EBX		(OPTYPE_BASE_REG_GENERIC_BX|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_BX		(OPTYPE_BASE_REG_GENERIC_BX|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_BH		(OPTYPE_BASE_REG_GENERIC_BX|OPTYPE_BASE_REG_8BIT_HIGH)
#define OPTYPE_REG_BL		(OPTYPE_BASE_REG_GENERIC_BX|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_RSP		(OPTYPE_BASE_REG_GENERIC_SP|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_ESP		(OPTYPE_BASE_REG_GENERIC_SP|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_SP		(OPTYPE_BASE_REG_GENERIC_SP|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_RBP		(OPTYPE_BASE_REG_GENERIC_BP|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_EBP		(OPTYPE_BASE_REG_GENERIC_BP|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_BP		(OPTYPE_BASE_REG_GENERIC_BP|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_RSI		(OPTYPE_BASE_REG_GENERIC_SI|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_ESI		(OPTYPE_BASE_REG_GENERIC_SI|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_SI		(OPTYPE_BASE_REG_GENERIC_SI|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_RDI		(OPTYPE_BASE_REG_GENERIC_DI|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_EDI		(OPTYPE_BASE_REG_GENERIC_DI|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_DI		(OPTYPE_BASE_REG_GENERIC_DI|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R8B		(OPTYPE_BASE_REG_GENERIC_R8|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R8W		(OPTYPE_BASE_REG_GENERIC_R8|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R8D		(OPTYPE_BASE_REG_GENERIC_R8|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R8		(OPTYPE_BASE_REG_GENERIC_R8|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R9B		(OPTYPE_BASE_REG_GENERIC_R9|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R9W		(OPTYPE_BASE_REG_GENERIC_R9|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R9D		(OPTYPE_BASE_REG_GENERIC_R9|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R9		(OPTYPE_BASE_REG_GENERIC_R9|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R10B		(OPTYPE_BASE_REG_GENERIC_R10|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R10W		(OPTYPE_BASE_REG_GENERIC_R10|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R10D		(OPTYPE_BASE_REG_GENERIC_R10|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R10		(OPTYPE_BASE_REG_GENERIC_R10|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R11B		(OPTYPE_BASE_REG_GENERIC_R11|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R11W		(OPTYPE_BASE_REG_GENERIC_R11|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R11D		(OPTYPE_BASE_REG_GENERIC_R11|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R11		(OPTYPE_BASE_REG_GENERIC_R11|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R12B		(OPTYPE_BASE_REG_GENERIC_R12|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R12W		(OPTYPE_BASE_REG_GENERIC_R12|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R12D		(OPTYPE_BASE_REG_GENERIC_R12|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R12		(OPTYPE_BASE_REG_GENERIC_R12|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R13B		(OPTYPE_BASE_REG_GENERIC_R13|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R13W		(OPTYPE_BASE_REG_GENERIC_R13|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R13D		(OPTYPE_BASE_REG_GENERIC_R13|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R13		(OPTYPE_BASE_REG_GENERIC_R13|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R14B		(OPTYPE_BASE_REG_GENERIC_R14|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R14W		(OPTYPE_BASE_REG_GENERIC_R14|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R14D		(OPTYPE_BASE_REG_GENERIC_R14|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R14		(OPTYPE_BASE_REG_GENERIC_R14|OPTYPE_BASE_REG_64BIT)
#define OPTYPE_REG_R15B		(OPTYPE_BASE_REG_GENERIC_R15|OPTYPE_BASE_REG_8BIT_LOW)
#define OPTYPE_REG_R15W		(OPTYPE_BASE_REG_GENERIC_R15|OPTYPE_BASE_REG_16BIT)
#define OPTYPE_REG_R15D		(OPTYPE_BASE_REG_GENERIC_R15|OPTYPE_BASE_REG_32BIT)
#define OPTYPE_REG_R15		(OPTYPE_BASE_REG_GENERIC_R15|OPTYPE_BASE_REG_64BIT)

#define OPTYPE_REG_FPU_ST0			(0x0000|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST1			(0x0100|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST2			(0x0200|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST3			(0x0300|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST4			(0x0400|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST5			(0x0500|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST6			(0x0600|OPTYPE_BASE_REG_FPU)
#define OPTYPE_REG_FPU_ST7			(0x0700|OPTYPE_BASE_REG_FPU)

#define OPTYPE_REG_ES				(0x0000|OPTYPE_BASE_REG_SEGMENT)
#define OPTYPE_REG_CS				(0x0100|OPTYPE_BASE_REG_SEGMENT)
#define OPTYPE_REG_SS				(0x0200|OPTYPE_BASE_REG_SEGMENT)
#define OPTYPE_REG_DS				(0x0300|OPTYPE_BASE_REG_SEGMENT)
#define OPTYPE_REG_FS				(0x0400|OPTYPE_BASE_REG_SEGMENT)
#define OPTYPE_REG_GS				(0x0500|OPTYPE_BASE_REG_SEGMENT)

#define	OPTYPE_REG_CR0				(0x0000|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR1				(0x0100|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR2				(0x0200|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR3				(0x0300|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR4				(0x0400|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR5				(0x0500|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR6				(0x0600|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR7				(0x0700|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR8				(0x0800|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR9				(0x0900|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR10				(0x0a00|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR11				(0x0b00|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR12				(0x0c00|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR13				(0x0d00|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR14				(0x0e00|OPTYPE_BASE_REG_CONTROL)
#define	OPTYPE_REG_CR15				(0x0f00|OPTYPE_BASE_REG_CONTROL)

#define	OPTYPE_REG_DR0				(0x0000|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR1				(0x0100|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR2				(0x0200|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR3				(0x0300|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR4				(0x0400|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR5				(0x0500|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR6				(0x0600|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR7				(0x0700|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR8				(0x0800|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR9				(0x0900|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR10				(0x0a00|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR11				(0x0b00|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR12				(0x0c00|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR13				(0x0d00|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR14				(0x0e00|OPTYPE_BASE_REG_DEBUG)
#define	OPTYPE_REG_DR15				(0x0f00|OPTYPE_BASE_REG_DEBUG)

#define	OPTYPE_REG_MMX0				(0x0000|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX1				(0x0100|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX2				(0x0200|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX3				(0x0300|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX4				(0x0400|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX5				(0x0500|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX6				(0x0600|OPTYPE_BASE_REG_MMX)
#define	OPTYPE_REG_MMX7				(0x0700|OPTYPE_BASE_REG_MMX)

#define	OPTYPE_REG_SSE0				(0x0000|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE1				(0x0100|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE2				(0x0200|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE3				(0x0300|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE4				(0x0400|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE5				(0x0500|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE6				(0x0600|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE7				(0x0700|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE8				(0x0800|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE9				(0x0900|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE10			(0x0a00|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE11			(0x0b00|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE12			(0x0c00|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE13			(0x0d00|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE14			(0x0e00|OPTYPE_BASE_REG_SSE)
#define	OPTYPE_REG_SSE15			(0x0f00|OPTYPE_BASE_REG_SSE)

#define	OPTYPE_REG_RIP				(0x0100|OPTYPE_BASE_REG_OTHER|OPTYPE_BASE_REG_64BIT)
#define	OPTYPE_REG_INVAILD			(0x0fff|OPTYPE_BASE_REG_OTHER)
/*
	Bit 15: Type = Data
	Bit 14: ModR/M = 1, Immediate = 0
	Bit 13: [ModR/M] Field Mod
	Bit 12: [ModR/M] Field reg
	Bit 11: [ModR/M] Field R/M
	Bit 10: Memory Address
	Bit  9:
	Bit  8:
	Bit  7: General Register
	Bit  6: Segment Register
	Bit  5: Debug Register
	Bit  4: Control Register
	Bit  3: Packed-QuadWord MMX Register
	Bit  2: 128bit XMM Register
	Bit  1: Others Register
	Bit  0: <Reserved> 
*/
#define OPTYPE_BASE_DATA_MODRM			0x4000|OPTYPE_BASE_DATA
#define OPTYPE_BASE_DATA_IMMEDIATE		0x0000|OPTYPE_BASE_DATA

#define OPTYPE_BASE_DATA_MODRM_FLD_MOD		0x2000|OPTYPE_BASE_DATA_MODRM
#define OPTYPE_BASE_DATA_MODRM_FLD_REG		0x1000|OPTYPE_BASE_DATA_MODRM
#define	OPTYPE_BASE_DATA_MODRM_FLD_RM		0x0800|OPTYPE_BASE_DATA_MODRM
#define	OPTYPE_BASE_DATA_MODRM_FLD_FULL		0x3800|OPTYPE_BASE_DATA_MODRM
#define OPTYPE_BASE_DATA_MODRM_MEMORY		0x0400|OPTYPE_BASE_DATA_MODRM

#define	OPTYPE_BASE_DATA_MODRM_REG_GENERAL	0x0080
#define OPTYPE_BASE_DATA_MODRM_REG_SEGMENT	0x0040
#define OPTYPE_BASE_DATA_MODRM_REG_DEBUG	0x0020
#define OPTYPE_BASE_DATA_MODRM_REG_CONTROL	0x0010
#define OPTYPE_BASE_DATA_MODRM_REG_PQMMX	0x0008
#define OPTYPE_BASE_DATA_MODRM_REG_128XMM	0x0004
#define OPTYPE_BASE_DATA_MODRM_REG_OTHER	0x0002
#define OPTYPE_BASE_DATA_MODRM_REG_FULL		0x00fe

#define OPTYPE_REG_RAX_STR	"rax"		
#define OPTYPE_REG_EAX_STR	"eax"		
#define OPTYPE_REG_AX_STR	"ax"		
#define OPTYPE_REG_AH_STR	"ah"		
#define OPTYPE_REG_AL_STR	"al"		
#define OPTYPE_REG_RCX_STR	"rcx"		
#define OPTYPE_REG_ECX_STR	"ecx"		
#define OPTYPE_REG_CX_STR	"cx"		
#define OPTYPE_REG_CH_STR	"ch"		
#define OPTYPE_REG_CL_STR	"cl"		
#define OPTYPE_REG_RDX_STR	"rdx"		
#define OPTYPE_REG_EDX_STR	"edx"		
#define OPTYPE_REG_DX_STR	"dx"		
#define OPTYPE_REG_DH_STR	"dh"		
#define OPTYPE_REG_DL_STR	"dl"		
#define OPTYPE_REG_RBX_STR	"rbx"		
#define OPTYPE_REG_EBX_STR	"ebx"		
#define OPTYPE_REG_BX_STR	"bx"		
#define OPTYPE_REG_BH_STR	"bh"		
#define OPTYPE_REG_BL_STR	"bl"		
#define OPTYPE_REG_RSP_STR	"rsp"		
#define OPTYPE_REG_ESP_STR	"esp"		
#define OPTYPE_REG_SP_STR	"sp"		
#define OPTYPE_REG_RBP_STR	"rbp"		
#define OPTYPE_REG_EBP_STR	"ebp"		
#define OPTYPE_REG_BP_STR	"bp"		
#define OPTYPE_REG_RSI_STR	"rsi"		
#define OPTYPE_REG_ESI_STR	"esi"		
#define OPTYPE_REG_SI_STR	"si"		
#define OPTYPE_REG_RDI_STR	"rdi"		
#define OPTYPE_REG_EDI_STR	"edi"		
#define OPTYPE_REG_DI_STR	"di"		
#define OPTYPE_REG_R8B_STR	"r8l"		
#define OPTYPE_REG_R8W_STR	"r8w"		
#define OPTYPE_REG_R8D_STR	"r8d"		
#define OPTYPE_REG_R8_STR	"r8"		
#define OPTYPE_REG_R9B_STR	"r9l"		
#define OPTYPE_REG_R9W_STR	"r9w"		
#define OPTYPE_REG_R9D_STR	"r9d"		
#define OPTYPE_REG_R9_STR	"r9"		
#define OPTYPE_REG_R10B_STR	"r10l"		
#define OPTYPE_REG_R10W_STR	"r10w"		
#define OPTYPE_REG_R10D_STR	"r10d"		
#define OPTYPE_REG_R10_STR	"r10"		
#define OPTYPE_REG_R11B_STR	"r11l"		
#define OPTYPE_REG_R11W_STR	"r11w"		
#define OPTYPE_REG_R11D_STR	"r11d"		
#define OPTYPE_REG_R11_STR	"r11"		
#define OPTYPE_REG_R12B_STR	"r12l"		
#define OPTYPE_REG_R12W_STR	"r12w"		
#define OPTYPE_REG_R12D_STR	"r12d"		
#define OPTYPE_REG_R12_STR	"r12"		
#define OPTYPE_REG_R13B_STR	"r13l"		
#define OPTYPE_REG_R13W_STR	"r13w"		
#define OPTYPE_REG_R13D_STR	"r13d"		
#define OPTYPE_REG_R13_STR	"r13"		
#define OPTYPE_REG_R14B_STR	"r14l"		
#define OPTYPE_REG_R14W_STR	"r14w"		
#define OPTYPE_REG_R14D_STR	"r14d"		
#define OPTYPE_REG_R14_STR	"r14"		
#define OPTYPE_REG_R15B_STR	"r15l"		
#define OPTYPE_REG_R15W_STR	"r15w"		
#define OPTYPE_REG_R15D_STR	"r15d"		
#define OPTYPE_REG_R15_STR	"r15"		
#define OPTYPE_REG_CS_STR	"cs"		
#define OPTYPE_REG_DS_STR	"ds"		
#define OPTYPE_REG_ES_STR	"es"		
#define OPTYPE_REG_SS_STR	"ss"		
#define OPTYPE_REG_FS_STR	"fs"		
#define OPTYPE_REG_GS_STR	"gs"		
#define	OPTYPE_REG_RIP_STR	"rip"

#define OPTYPE_REG_FPU_ST0_STR	"st0"
#define OPTYPE_REG_FPU_ST1_STR	"st1"
#define OPTYPE_REG_FPU_ST2_STR	"st2"
#define OPTYPE_REG_FPU_ST3_STR	"st3"
#define OPTYPE_REG_FPU_ST4_STR	"st4"
#define OPTYPE_REG_FPU_ST5_STR	"st5"
#define OPTYPE_REG_FPU_ST6_STR	"st6"
#define OPTYPE_REG_FPU_ST7_STR	"st7"

#define	OPTYPE_REG_CR0_STR		"cr0"
#define	OPTYPE_REG_CR1_STR		"cr1"
#define	OPTYPE_REG_CR2_STR		"cr2"
#define	OPTYPE_REG_CR3_STR		"cr3"
#define	OPTYPE_REG_CR4_STR		"cr4"
#define	OPTYPE_REG_CR5_STR		"cr5"
#define	OPTYPE_REG_CR6_STR		"cr6"
#define	OPTYPE_REG_CR7_STR		"cr7"
#define	OPTYPE_REG_CR8_STR		"cr8"
#define	OPTYPE_REG_CR9_STR		"cr9"
#define	OPTYPE_REG_CR10_STR		"cr10"
#define	OPTYPE_REG_CR11_STR		"cr11"
#define	OPTYPE_REG_CR12_STR		"cr12"
#define	OPTYPE_REG_CR13_STR		"cr13"
#define	OPTYPE_REG_CR14_STR		"cr14"
#define	OPTYPE_REG_CR15_STR		"cr15"

#define	OPTYPE_REG_DR0_STR		"dr0"
#define	OPTYPE_REG_DR1_STR		"dr1"
#define	OPTYPE_REG_DR2_STR		"dr2"
#define	OPTYPE_REG_DR3_STR		"dr3"
#define	OPTYPE_REG_DR4_STR		"dr4"
#define	OPTYPE_REG_DR5_STR		"dr5"
#define	OPTYPE_REG_DR6_STR		"dr6"
#define	OPTYPE_REG_DR7_STR		"dr7"
#define	OPTYPE_REG_DR8_STR		"dr8"
#define	OPTYPE_REG_DR9_STR		"dr9"
#define	OPTYPE_REG_DR10_STR		"dr10"
#define	OPTYPE_REG_DR11_STR		"dr11"
#define	OPTYPE_REG_DR12_STR		"dr12"
#define	OPTYPE_REG_DR13_STR		"dr13"
#define	OPTYPE_REG_DR14_STR		"dr14"
#define	OPTYPE_REG_DR15_STR		"dr15"

#define	OPTYPE_REG_MMX0_STR		"mm0"
#define	OPTYPE_REG_MMX1_STR		"mm1"
#define	OPTYPE_REG_MMX2_STR		"mm2"
#define	OPTYPE_REG_MMX3_STR		"mm3"
#define	OPTYPE_REG_MMX4_STR		"mm4"
#define	OPTYPE_REG_MMX5_STR		"mm5"
#define	OPTYPE_REG_MMX6_STR		"mm6"
#define	OPTYPE_REG_MMX7_STR		"mm7"

#define	OPTYPE_REG_SSE0_STR		"xmm0"
#define	OPTYPE_REG_SSE1_STR		"xmm1"
#define	OPTYPE_REG_SSE2_STR		"xmm2"
#define	OPTYPE_REG_SSE3_STR		"xmm3"
#define	OPTYPE_REG_SSE4_STR		"xmm4"
#define	OPTYPE_REG_SSE5_STR		"xmm5"
#define	OPTYPE_REG_SSE6_STR		"xmm6"
#define	OPTYPE_REG_SSE7_STR		"xmm7"
#define	OPTYPE_REG_SSE8_STR		"xmm8"
#define	OPTYPE_REG_SSE9_STR		"xmm9"
#define	OPTYPE_REG_SSE10_STR	"xmm10"
#define	OPTYPE_REG_SSE11_STR	"xmm11"
#define	OPTYPE_REG_SSE12_STR	"xmm12"
#define	OPTYPE_REG_SSE13_STR	"xmm13"
#define	OPTYPE_REG_SSE14_STR	"xmm14"
#define	OPTYPE_REG_SSE15_STR	"xmm15"

/* C : [ModR/M:reg] Control Reg.  */
#define OPTYPE_DATA_METHOD_C	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_CONTROL)
/* D : [ModR/M:reg] Debug Reg. */
#define OPTYPE_DATA_METHOD_D	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_DEBUG)
/* G : [ModR/M:reg] General Reg. */
#define OPTYPE_DATA_METHOD_G	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_GENERAL)
/* P : [ModR/M:reg] Packed-QuadWord MMX Reg. */ 
#define OPTYPE_DATA_METHOD_P	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_PQMMX)
/* S : [ModR/M:reg] Segment Reg. */
#define OPTYPE_DATA_METHOD_S	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_SEGMENT)
/* T : [ModR/M:reg] Test Reg. ( Reserved ) */
#define OPTYPE_DATA_METHOD_T	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_OTHER)
/* V : [ModR/M:reg] 128bit XMM Reg. */
#define OPTYPE_DATA_METHOD_V	(OPTYPE_BASE_DATA_MODRM_FLD_REG|OPTYPE_BASE_DATA_MODRM_REG_128XMM)
/* N : [ModR/M:R/M] Packed-QuadWord MMX Reg. */
#define OPTYPE_DATA_METHOD_N	(OPTYPE_BASE_DATA_MODRM_FLD_RM|OPTYPE_BASE_DATA_MODRM_REG_PQMMX)
/* R : [ModR/M:R/M] refer to General Reg by R/M Field */
#define OPTYPE_DATA_METHOD_R	(OPTYPE_BASE_DATA_MODRM_FLD_RM|OPTYPE_BASE_DATA_MODRM_REG_GENERAL)
/* U : [ModR/M:R/M] 128bit XMM Reg. */
#define OPTYPE_DATA_METHOD_U	(OPTYPE_BASE_DATA_MODRM_FLD_RM|OPTYPE_BASE_DATA_MODRM_REG_128XMM)
/* E : [ModR/M] Memory & Reg. */
#define OPTYPE_DATA_METHOD_E	(OPTYPE_BASE_DATA_MODRM_FLD_FULL|OPTYPE_BASE_DATA_MODRM_REG_FULL|OPTYPE_BASE_DATA_MODRM_MEMORY)
/* W : [ModR/M] 128bit XMM Reg. or Memory Address 
		( Memory Address calculated by Seg.Reg. BaseReg. IndexReg. 
			ScalingFactor, Displacement */
#define OPTYPE_DATA_METHOD_W	(OPTYPE_BASE_DATA_MODRM_FLD_FULL|OPTYPE_BASE_DATA_MODRM_REG_128XMM|OPTYPE_BASE_DATA_MODRM_MEMORY)
/* Q : [ModR/M] MMX reg. or Memory Address 
		( Memory Address calced by Seg.Reg, BaseReg. IndexReg. 
			ScalingFactor, Displacement */
#define OPTYPE_DATA_METHOD_Q	(OPTYPE_BASE_DATA_MODRM_FLD_FULL|OPTYPE_BASE_DATA_MODRM_REG_PQMMX|OPTYPE_BASE_DATA_MODRM_MEMORY)
/* M : Memory Access (by ModR/M) (NO!!: Reg. Indicate by ModR/M) */
#define OPTYPE_DATA_METHOD_M	(OPTYPE_BASE_DATA_MODRM_FLD_FULL|OPTYPE_BASE_DATA_MODRM_MEMORY)

#define OPTYPE_BASE_DATA_IMMEDIATE_MEMSIZE	0x0800|OPTYPE_BASE_DATA_IMMEDIATE
#define OPTYPE_BASE_DATA_IMMEDIATE_OPERATOR	0x0400|OPTYPE_BASE_DATA_IMMEDIATE
#define OPTYPE_BASE_DATA_IMMEDIATE_DATA		0x0200|OPTYPE_BASE_DATA_IMMEDIATE
#define OPTYPE_BASE_DATA_IMMEDIATE_IMM		0x0100|OPTYPE_BASE_DATA_IMMEDIATE
#define OPTYPE_BASE_DATA_IMMEDIATE_NONE		0x0000|OPTYPE_BASE_DATA_IMMEDIATE

/* A : Direct Address (NO!!: ModR/M, BaseReg, IndexReg, ScalingFactor) */
#define OPTYPE_DATA_METHOD_A	(0x0010|OPTYPE_BASE_DATA_IMMEDIATE_DATA)
/* I : Immediate Data (NO!!: ModR/M) */
#define OPTYPE_DATA_METHOD_I	(0x0020|OPTYPE_BASE_DATA_IMMEDIATE_DATA)
/* J : IP relative Address (NO!!: ModR/M) */
#define OPTYPE_DATA_METHOD_J	(0x0030|OPTYPE_BASE_DATA_IMMEDIATE_DATA)
/* O : Word of DWord Data (NO!!: ModR/M, BaseReg. IndexReg, ScalingFactor */
#define OPTYPE_DATA_METHOD_O	(0x0040|OPTYPE_BASE_DATA_IMMEDIATE_DATA)
/* F : EFLAGS / RFLAGS Reg. (NO!!: ModR/M)  */
#define OPTYPE_DATA_METHOD_F	(0x0010|OPTYPE_BASE_DATA_IMMEDIATE_NONE)
/* X : DS:rSI (Memory Address) */
#define OPTYPE_DATA_METHOD_X	(0x0020|OPTYPE_BASE_DATA_IMMEDIATE_NONE)
/* Y : ES:rDI (Memory Address) */
#define OPTYPE_DATA_METHOD_Y	(0x0030|OPTYPE_BASE_DATA_IMMEDIATE_NONE)

/* 1 : 0x01 Data (Immediate Data) */
#define OPTYPE_DATA_METHOD_1	(0x0001|OPTYPE_BASE_DATA_IMMEDIATE_IMM)
/* - : Illegal Instruction by DrDeamon64 Assembler System */
#define OPTYPE_DATA_METHOD_ILLEGAL	(0x00ff|OPTYPE_BASE_DATA_IMMEDIATE_IMM)




#define OPSIZE_BASE_SIZE_BYTE		0x0001
#define OPSIZE_BASE_SIZE_WORD		0x0002
#define OPSIZE_BASE_SIZE_DWORD		0x0004
#define OPSIZE_BASE_SIZE_QWORD		0x0008
#define OPSIZE_BASE_SIZE_DQWORD		0x0010
#define	OPSIZE_BASE_FLOAT			0x0040
#define	OPSIZE_BASE_DOUBLE			0x0080
#define	OPSIZE_BASE_ILLEGAL			0x00ff

#define OPSIZE_BASE_ATTR_DEPENDON	0x2000
#define OPSIZE_BASE_ATTR_REGARDLESS	0x0000
#define OPSIZE_BASE_ADDRESS			0x4000
#define OPSIZE_BASE_SPECIAL			0x8000
#define	OPSIZE_BASE_PACKED			0x1000
#define OPSIZE_BASE_SCALAR			0x0800


/* b : Byte (Regardless Operand Size Attribute) */
#define OPSIZE_B	(OPSIZE_BASE_ATTR_REGARDLESS|OPSIZE_BASE_SIZE_BYTE)
/* w : Word (Regardless Operand Size Attribute) */
#define OPSIZE_W	(OPSIZE_BASE_ATTR_REGARDLESS|OPSIZE_BASE_SIZE_WORD)
/* d : DWord (Regardless Operand Size Attribute) */
#define OPSIZE_D	(OPSIZE_BASE_ATTR_REGARDLESS|OPSIZE_BASE_SIZE_DWORD)
/* q : QuadWord(64bit) (Regardless Operand Size Attribute) */
#define OPSIZE_Q	(OPSIZE_BASE_ATTR_REGARDLESS|OPSIZE_BASE_SIZE_QWORD)
/* dq : Double QuadWord(128Bit) (Regardless Operand Size Attribute) */
#define OPSIZE_DQ	(OPSIZE_BASE_ATTR_REGARDLESS|OPSIZE_BASE_SIZE_DQWORD)
/* h : Memory Pointer for 94/108bit */
#define OPSIZE_H	(OPSIZE_BASE_ADDRESS)
/* p : Memory Pointer for 32bit or 48bit (depend on Operand Size Attribute) */
#define OPSIZE_P	(OPSIZE_BASE_ADDRESS|OPSIZE_BASE_ATTR_DEPENDON)
/* r : Memory Pointer for 14bit / 28bit */
#define OPSIZE_R	(OPSIZE_BASE_ADDRESS)
/* t : Memory Pointer for 80bit */
#define OPSIZE_T	(OPSIZE_BASE_ADDRESS)
/* pd : 128bit Packed double-float Data */
#define OPSIZE_PD	(OPSIZE_BASE_PACKED|OPSIZE_BASE_DOUBLE|OPSIZE_BASE_SIZE_DQWORD)
/* ps : 128bit Packed float Data */
#define OPSIZE_PS	(OPSIZE_BASE_PACKED|OPSIZE_BASE_FLOAT|OPSIZE_BASE_SIZE_DQWORD)
/* sd : Scalar Element of 128bit Packed Double-float Data */
#define OPSIZE_SD	(OPSIZE_BASE_PACKED|OPSIZE_BASE_SCALAR|OPSIZE_BASE_DOUBLE|OPSIZE_BASE_SIZE_DQWORD)
/* ss : Scalar Element of 128bit Packed float Data */
#define OPSIZE_SS	(OPSIZE_BASE_PACKED|OPSIZE_BASE_SCALAR|OPSIZE_BASE_FLOAT|OPSIZE_BASE_SIZE_DQWORD)
/* s : 6Byte or 10 Byte Pseudo Descriptor */
#define OPSIZE_S	(OPSIZE_BASE_SPECIAL|0x0001)
/* v : Word, DWord, QuadWord(64bit-ModeOnly) (Depend On Operand Size Attribute)*/
#define OPSIZE_V	(OPSIZE_BASE_ATTR_DEPENDON|OPSIZE_BASE_SIZE_WORD|OPSIZE_BASE_SIZE_DWORD|OPSIZE_BASE_SIZE_QWORD)
/* z : Word(16bit Operand Size) or DWord(32/64 Operand Size) */
#define OPSIZE_Z	(OPSIZE_BASE_ATTR_DEPENDON|OPSIZE_BASE_SIZE_WORD|OPSIZE_BASE_SIZE_DWORD)
/* a : 2 Word or 2 DWord in Memory ( for BOUND ) */
#define OPSIZE_A	(OPSIZE_BASE_ADDRESS|OPSIZE_BASE_SIZE_WORD|OPSIZE_BASE_SIZE_DWORD)

#define	OPSIZE_ILLEGAL			(OPSIZE_BASE_ILLEGAL)



#define isRegType(m,n)  (((Word)(((Word)(m))&(OPTYPE_BASE_REG_TYPEMASK)))==(n))
#define isRegID(m,n)  (((Word)(((Word)(m))&(OPTYPE_BASE_REG_IDMASK)))==(n))
#define isRegGenericID(m,n)  (((Word)(((Word)(m))&(OPTYPE_BASE_REG_GENERIC_IDMASK)))==(n))
#define isRegSize(m,n)  (((Word)(((Word)(m))&(OPTYPE_BASE_REG_SIZEMASK)))==(n))


#endif	/* DRD64_HEADER_INTEL64_DBTYPE */

/* EOF of drd64_intel64_dbtype.h ----------------------------------- */ 

