/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_debug.c
Function: Intel64 DisAsm/Asm Debug Fucntions 
Comment:  none
----------------------------------------------------------------------*/

#include"drd64_intel64.h"
#include"drd64_intel64_dbtype.h"
#include"drd64_intel64_asm.h"
#include"drd64_intel64_disasm.h"
#define DRD64_SRC_LIBINTEL64ASM_FUNC
#include"../include/libintel64asm.h"


/* [ Debug Level ] -----------------------------------------------------
 Level Range : 0 - 4 ( Default : 0 )
 Level 0 : None Message
 Level 1 : Assemble & DisAssemble Start & Last Status Only
 Level 2 : 
 Level 3 : 
 Level 4 : Full Message
----------------------------------------------------------------------*/


static	int		i_debug_level;




/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_Asm_PrintCarveString(
		Drd64_Intel64_AssemblePacket *p_assemble,
		char	*pstr_input )
{
	/* Judge Debug Level */
	if( 3 > i_debug_level )		{ return; }

	puts(   "----------------------------------------------------------");
	printf( " Input String : %s\n", pstr_input );
	printf( "    [ Instruction : %s ]\n", p_assemble->str_instruction );
	printf( "    [ Destination : %s ]\n", p_assemble->str_destination );
	printf( "    [ Source      : %s ]\n", p_assemble->str_source );
	printf( "    [ Option      : %s ]\n", p_assemble->str_option );
	puts("");

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
static void
	Drd64_Intel64_Debug_PrintOperandTree_Sub(
		Drd64_Intel64_OperandNode *p_now)
{
	if( NULL == p_now )		{ return; }

	Drd64_Intel64_Debug_PrintOperandTree_Sub( p_now->p_left );
	Drd64_Intel64_Debug_PrintOperandTree_Sub( p_now->p_right );

	printf( "    [%s (Operand Size = %2d, Address Size = %2d, TypeID = %04x )]\n",
		p_now->str_data, p_now->i_operandsize, p_now->i_addressize,
		p_now->w_typeid );

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_PrintOperandTree(
		Drd64_Intel64_OperandNode *p_root,
		char *pstr_operandstr )
{
	/* Judge Debug Level */
	if( 3 > i_debug_level )		{ return; }


	printf( "- Operand Tree : %s -----------------------\n",
		pstr_operandstr );

	if( NULL == p_root )
		{ puts(" None "); }
	else
		{ Drd64_Intel64_Debug_PrintOperandTree_Sub( p_root ); }

	puts("");

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_Asm_PrintOperandChain(
		Drd64_Intel64_OperandNode *p_chain )
{
	Drd64_Intel64_OperandNode 	*p_temp;

	/* Judge Debug Level */
	if( 3 > i_debug_level )		{ return; }

	puts( "- Operand Chain --------------------------");

	p_temp	= p_chain;
	do	{
		printf( "{%s} => ", p_temp->str_data );
		p_temp	= p_temp->p_next;
	}while( NULL != p_temp );

	puts("\n");

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_Asm_PrintMemoryOperand(
		Drd64_Intel64_OperandNode	*p_index,
		Drd64_Intel64_OperandNode	*p_scale,
		Drd64_Intel64_OperandNode	*p_base,
		Drd64_Intel64_OperandNode	*p_disp)
{
	/* Judge Debug Level */
	if( 3 > i_debug_level )		{ return; }

    printf("- Analyze Memory Operand -----------------------------\n");
    if( NULL != p_index )   {
        printf(" Index = %p ( TypeID = %02x : String = %s : Value = %ld )\n",
                p_index, p_index->w_typeid, p_index->str_data,
                p_index->v_val.val.val64 );
    } else  {
        printf(" Index = None\n");
    }

    if( NULL != p_scale )   {
        printf(" Scale = %p ( TypeID = %02x : String = %s : Value = %ld )\n",
                p_scale, p_scale->w_typeid, p_scale->str_data,
                p_scale->v_val.val.val64 );
    } else  {
        printf(" Scale = None\n");
    }

    if( NULL != p_base )    {
        printf(" Base  = %p ( TypeID = %02x : String = %s : Value = %ld )\n",
                p_base, p_base->w_typeid, p_base->str_data,
                p_base->v_val.val.val64 );
    } else  {
        printf(" Base  = None\n");
    }

    if( NULL != p_disp )    {
        printf(" Disp. = %p ( TypeID = %02x : String = %s : Value = %ld )\n",
                p_disp, p_disp->w_typeid, p_disp->str_data,
                p_disp->v_val.val.val64 );
    } else  {
        printf(" Disp. = None\n");
    }

    puts("");

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_Asm_PrintAnswer(
		Byte	*pb_data,
		char	*pstr_src,
		int		i_bytes )
{
	int		i_cnt;

	/* Judge Debug Level */
	if( 1 > i_debug_level )		{ return; }

    puts("- Assemble Answer -----------------------------");

	printf(" Input    : %s\n", pstr_src );

    printf(" Output   : %2d Bytes [", i_bytes );
    for( i_cnt = 0; i_cnt < i_bytes - 1; i_cnt++ )
		{ printf(" %02x :", *(pb_data + i_cnt) ); }
    printf(" %02x ]\n\n", *(pb_data + i_cnt) );

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_DisAsm_PrintAnswer(
		char	*pstr_answer,
		Byte	*pb_src,
		int		i_bytes )
{
	int		i_cnt;

	/* Judge Debug Level */
	if( 1 > i_debug_level )		{ return; }

    puts("- DisAssemble Answer -----------------------------");

    printf(" Input    : %2dBytes [", i_bytes );
    for( i_cnt = 0; i_cnt < i_bytes - 1; i_cnt++ )
		{ printf(" %02x :", *(pb_src + i_cnt) ); }
    printf(" %02x ]\n", *(pb_src + i_cnt) );

	printf(" Output   : %s\n\n", pstr_answer );

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
void
	Drd64_Intel64_Debug_PrintAnalyzePacket(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		char *pstr_debugstr,
		int i_print_debuglevel)
{
	/* Judge Debug Level */
	if( i_print_debuglevel > i_debug_level )		{ return; }

	printf("- Analyze Packet (%s) --------------------------\n",
			pstr_debugstr );

	if( NULL == p_analyze )		{

	}
	else 	{
		printf(" Prefixes : %d [%02x : %02x : %02x : %02x]\n",
            p_analyze->i_prefixes,
			p_analyze->b_prefix[0],
            p_analyze->b_prefix[1],
			p_analyze->b_prefix[2],
            p_analyze->b_prefix[3] );

		printf( " Rex      : %02x [ b = %d : x = %d : r = %d : w = %d ]\n",
			p_analyze->rex.b_rex, p_analyze->rex.rex.b,
			p_analyze->rex.rex.x, p_analyze->rex.rex.r,
			p_analyze->rex.rex.w );
		printf( " Nimonic  : %s\n", p_analyze->str_instruction );
		printf( " Opcodes  : %d [ %02x : %02x : %02x ]\n",
			p_analyze->i_opcodes, p_analyze->b_opcode[0],
			p_analyze->b_opcode[1], p_analyze->b_opcode[2] );
		printf( " CodeType : %02x\n", p_analyze->b_codetype );
		printf( " ModR/M   : %02x [ Mod = %x : reg = %x : r/m = %x ]\n",
			p_analyze->modrm.b_modrm, p_analyze->modrm.modrm.mod,
			p_analyze->modrm.modrm.reg, p_analyze->modrm.modrm.rm );
		printf( " SiB      : %02x [ scale = %x : index = %x : base = %x ]\n",
			p_analyze->sib.b_sib, p_analyze->sib.sib.scale,
			p_analyze->sib.sib.index, p_analyze->sib.sib.base );
		printf( "   [ Type : Mod = %02x, reg = %02x, r/m = %02x ]\n",
			p_analyze->b_modtype, p_analyze->b_regtype,
			p_analyze->b_rmtype );
		printf( " Operands : %d [ Operand Size = %2d : Address Size = %2d ]\n",
			p_analyze->i_operands, p_analyze->i_operandsize, 
			p_analyze->i_addresssize );
		printf( "  Destination : [ TypeID = %02x : SizeID = %02x Size = %d] \n",
			p_analyze->w_desttype,
			p_analyze->w_destsize,
			p_analyze->i_destsize );
		printf( "                [ %s ]\n",
			p_analyze->str_destination );
		printf( "  Source      : [ TypeID = %02x : SizeID = %02x Size = %d] \n",
			p_analyze->w_srctype,
			p_analyze->w_srcsize,
			p_analyze->i_srcsize );
		printf( "                [ %s ]\n",
			p_analyze->str_source );
		printf( "  Option      : [ TypeID = %02x : SizeID = %02x Size = %d] \n",
			p_analyze->w_optiontype,
			p_analyze->w_optionsize,
			p_analyze->i_optionsize );
		printf( "                [ %s ]\n",
			p_analyze->str_option );

		printf(" Displacement : %d [%08x]\n",
			p_analyze->v_disp.i_bytes, ((p_analyze->v_disp.i_bytes == 1) ?
			p_analyze->v_disp.val.val8 : p_analyze->v_disp.val.val32));
	
		if( 0 == p_analyze->v_imm.i_bytes )
		    { printf(" Immediate    : 0 \n"); }
		else if( 1 == p_analyze->v_imm.i_bytes )
		   	{ printf(" Immediate    : 1 [%02x]\n",
		       	p_analyze->v_imm.val.val8 ); }
		else if( 2 == p_analyze->v_imm.i_bytes )
		   	{ printf(" Immediate    : 2 [%04x]\n",
			   	p_analyze->v_imm.val.val16 ); }
		else if( 4 == p_analyze->v_imm.i_bytes )
		   	{ printf(" Immediate    : 4 [%08x]\n",
		       	p_analyze->v_imm.val.val32 ); }
		else if( 8 == p_analyze->v_imm.i_bytes )
		   	{ printf(" Immediate    : 8 [%16x]\n",
	          	p_analyze->v_imm.val.val64 ); }

	}	

	puts("");

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBINTEL64ASM_FUNC	void
	Drd64_LibIntel64asm_SetDebugLevel(
		int	i_level )
{
	i_debug_level	= i_level;

	return;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
LIBINTEL64ASM_FUNC	int
	Drd64_LibIntel64asm_GetDebugLevel(
		void )
{
	return i_debug_level;
}

/* EOF of drd64_intel64_debug.c ----------------------------------- */
