/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_disasm.c
Function: Intel64 DisAssembler Main Module
Comment: none 
----------------------------------------------------------------------*/

#include"drd64_intel64.h"
#include"drd64_intel64_disasm.h"
#include"drd64_intel64_dbtype.h"
#include"drd64_intel64_db.h"
#include"drd64_intel64_common.h"
/*#include"drd64_intel64_debug.h"*/
#define	DRD64_SRC_LIBINTEL64ASM_FUNC
#include"../include/libintel64asm.h"


Word drd64_register_table[][16] = {
	{ OPTYPE_REG_AL  , OPTYPE_REG_CL  , OPTYPE_REG_DL  , OPTYPE_REG_BL  ,
	  OPTYPE_REG_AH  , OPTYPE_REG_CH  , OPTYPE_REG_DH  , OPTYPE_REG_BH  ,
	  OPTYPE_REG_R8B , OPTYPE_REG_R9B , OPTYPE_REG_R10B, OPTYPE_REG_R11B,
	  OPTYPE_REG_R12B, OPTYPE_REG_R13B, OPTYPE_REG_R14B, OPTYPE_REG_R15B }, 
	{ OPTYPE_REG_AX  , OPTYPE_REG_CX  , OPTYPE_REG_DX  , OPTYPE_REG_BX  ,
	  OPTYPE_REG_SP  , OPTYPE_REG_BP  , OPTYPE_REG_SI  , OPTYPE_REG_DI  ,
	  OPTYPE_REG_R8W , OPTYPE_REG_R9W , OPTYPE_REG_R10W, OPTYPE_REG_R11W,
	  OPTYPE_REG_R12W, OPTYPE_REG_R13W, OPTYPE_REG_R14W, OPTYPE_REG_R15W }, 
	{ OPTYPE_REG_EAX , OPTYPE_REG_ECX , OPTYPE_REG_EDX , OPTYPE_REG_EBX ,
	  OPTYPE_REG_ESP , OPTYPE_REG_EBP , OPTYPE_REG_ESI , OPTYPE_REG_EDI ,
	  OPTYPE_REG_R8D , OPTYPE_REG_R9D , OPTYPE_REG_R10D, OPTYPE_REG_R11D,
	  OPTYPE_REG_R12D, OPTYPE_REG_R13D, OPTYPE_REG_R14D, OPTYPE_REG_R15D }, 
	{ OPTYPE_REG_RAX , OPTYPE_REG_RCX , OPTYPE_REG_RDX , OPTYPE_REG_RBX ,
	  OPTYPE_REG_RSP , OPTYPE_REG_RBP , OPTYPE_REG_RSI , OPTYPE_REG_RDI ,
	  OPTYPE_REG_R8  , OPTYPE_REG_R9  , OPTYPE_REG_R10 , OPTYPE_REG_R11 ,
	  OPTYPE_REG_R12 , OPTYPE_REG_R13 , OPTYPE_REG_R14 , OPTYPE_REG_R15 }, 
	{ OPTYPE_REG_ES  , OPTYPE_REG_CS  , OPTYPE_REG_SS  , OPTYPE_REG_DS  ,
	  OPTYPE_REG_FS  , OPTYPE_REG_GS  , OPTYPE_REG_INVAILD,OPTYPE_REG_INVAILD,
	  OPTYPE_REG_ES	 , OPTYPE_REG_CS  , OPTYPE_REG_SS  , OPTYPE_REG_DS  ,
	  OPTYPE_REG_FS  , OPTYPE_REG_GS  , OPTYPE_REG_INVAILD,OPTYPE_REG_INVAILD},
	{ OPTYPE_REG_CR0 , OPTYPE_REG_CR1 , OPTYPE_REG_CR2 , OPTYPE_REG_CR3 ,
	  OPTYPE_REG_CR4 , OPTYPE_REG_CR5 , OPTYPE_REG_CR6 , OPTYPE_REG_CR7 ,
	  OPTYPE_REG_CR8 , OPTYPE_REG_CR9 , OPTYPE_REG_CR10, OPTYPE_REG_CR11,
	  OPTYPE_REG_CR12, OPTYPE_REG_CR13, OPTYPE_REG_CR14, OPTYPE_REG_CR15 }, 
	{ OPTYPE_REG_DR0 , OPTYPE_REG_DR1 , OPTYPE_REG_DR2 , OPTYPE_REG_DR3 ,
	  OPTYPE_REG_DR4 , OPTYPE_REG_DR5 , OPTYPE_REG_DR6 , OPTYPE_REG_DR7 ,
	  OPTYPE_REG_DR8 , OPTYPE_REG_DR9 , OPTYPE_REG_DR10, OPTYPE_REG_DR11,
	  OPTYPE_REG_DR12, OPTYPE_REG_DR13, OPTYPE_REG_DR14, OPTYPE_REG_DR15 }, 
	{ OPTYPE_REG_MMX0, OPTYPE_REG_MMX1, OPTYPE_REG_MMX2, OPTYPE_REG_MMX3,
	  OPTYPE_REG_MMX4, OPTYPE_REG_MMX5, OPTYPE_REG_MMX6, OPTYPE_REG_MMX7,
	  OPTYPE_REG_MMX0, OPTYPE_REG_MMX1, OPTYPE_REG_MMX2, OPTYPE_REG_MMX3,
	  OPTYPE_REG_MMX4, OPTYPE_REG_MMX5, OPTYPE_REG_MMX6, OPTYPE_REG_MMX7 }, 
	{ OPTYPE_REG_SSE0, OPTYPE_REG_SSE1, OPTYPE_REG_SSE2, OPTYPE_REG_SSE3,
	  OPTYPE_REG_SSE4, OPTYPE_REG_SSE5, OPTYPE_REG_SSE6, OPTYPE_REG_SSE7,
	  OPTYPE_REG_SSE8, OPTYPE_REG_SSE9,OPTYPE_REG_SSE10,OPTYPE_REG_SSE11,
	 OPTYPE_REG_SSE12,OPTYPE_REG_SSE13,OPTYPE_REG_SSE14,OPTYPE_REG_SSE15 }
};



/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_ConvValue2String(
		: Convert Value to String 

		char *p_str,	: [dest] String from Value
		Value *p_val,	: [src] Value
		int i_maxstr) 	: [opt] Max Strings
----------------------------------------------------------------------*/
static int
	Drd64_Intel64_DisAsm_ConvValue2String(
		char *p_str,
		Value *p_val,
		int i_maxstr) 
{
	if( 1 == p_val->i_bytes )	{
		snprintf( p_str, i_maxstr, "%03xh", p_val->val.val8 );
	} else if( 2 == p_val->i_bytes )	{
		snprintf( p_str, i_maxstr, "%05xh", p_val->val.val16 );
	} else if( 4 == p_val->i_bytes )	{
		snprintf( p_str, i_maxstr, "%09xh", p_val->val.val32 );
	} else if( 8 == p_val->i_bytes )	{
		snprintf( p_str, i_maxstr, "%09x%08xh",
			(p_val->val.val64 >> 32), p_val->val.val64 );
	}

	return 0x00;
}

/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_CalcDefaultAddressSize(
		: Calc. Default Address Size from Prefix67h

		Drd64_Intel64_AnalyzePacket *p_analyze )
				: [dest][src] Drd64 Analyze Packet
----------------------------------------------------------------------*/
/* XXX - 64bit Long Mode Only!! --------------------------------------*/
static int
	Drd64_Intel64_DisAsm_CalcDefaultAddressSize(
		Drd64_Intel64_AnalyzePacket *p_analyze )
{
	int		i_defaultaddresssize	= 8;

	/* Check Operand-Size Prefix(066h) */
	if(( 0x67 == p_analyze->b_prefix[0])
			|| ( 0x67 == p_analyze->b_prefix[1])
			|| ( 0x67 == p_analyze->b_prefix[2])
			|| ( 0x67 == p_analyze->b_prefix[3]) )	{
		i_defaultaddresssize	= 4;
	}

	p_analyze->i_addresssize	= i_defaultaddresssize;
	
	return i_defaultaddresssize;
}


/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_CalcOperandSize(
		: Calc. Operand Size from Prefix66h & Rex.W

		Drd64_Intel64_AnalyzePacket *p_analyze )
				: [dest][src] Drd64 Analyze Packet
----------------------------------------------------------------------*/
/* XXX - 64bit Long Mode Only!! --------------------------------------*/
static int
	Drd64_Intel64_DisAsm_CalcOperandSize(
		Drd64_Intel64_AnalyzePacket *p_analyze )
{
	Byte	b_prefix66h	= 0x00;
	int		i_defaultsize	= 4;

	/* Check Operand-Size Prefix(066h) */
	if(( 0x66 == p_analyze->b_prefix[0])
			|| ( 0x66 == p_analyze->b_prefix[1])
			|| ( 0x66 == p_analyze->b_prefix[2])
			|| ( 0x66 == p_analyze->b_prefix[3]) )	{
		b_prefix66h	= 0x66;
	}

	if( 0x00 != p_analyze->rex.rex.w )	{ i_defaultsize = 8; }
	else if( 0x66 == b_prefix66h )		{ i_defaultsize = 2; }

	p_analyze->i_operandsize	= i_defaultsize;
	
	return i_defaultsize;
}

/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_GetSize_SizeID(
		: Get Operand Size form Intel 64 DB SizeID

		int i_operandsize,	: [src] Default Operand Size
		Word w_methodtype,	: [src] Method Type ID
		Word w_sizeid )		: [src] Size ID
----------------------------------------------------------------------*/
/* XXX - 64bit Long Mode Only!! --------------------------------------*/
static int
	Drd64_Intel64_DisAsm_GetSize_SizeID(
		int i_operandsize,
		Word w_methodtype,
		Word w_sizeid )
{
	int		i_ret = -1;

	if( isBitFlag(w_methodtype,OPTYPE_BASE_DATA))	{
		/* Memory / Immediate Data ---*/
		switch( w_sizeid )
			{
			case OPSIZE_B: i_ret	= 1; break;
			case OPSIZE_W: i_ret	= 2; break;
			case OPSIZE_D: i_ret	= 4; break;
			case OPSIZE_Q: i_ret	= 8; break;
			case OPSIZE_DQ: i_ret	= 16; break;
			case OPSIZE_PD: i_ret	= 16; break;
			case OPSIZE_PS: i_ret	= 16; break;
			case OPSIZE_SD: i_ret	= 16; break;
			case OPSIZE_SS: i_ret	= 16; break;
			/* OPSIZE_H, OPSIZE_R, OPSIZE_T */
			case OPSIZE_H: i_ret	= 8; break;		/* XXX */
			case OPSIZE_Z:
				i_ret	= ((2 == i_operandsize) ? 2 : 4);	break;
			case OPSIZE_S: i_ret	= -1; break;	/* XXX */
			case OPSIZE_A: i_ret	= -1; break;	/* XXX */
			case OPSIZE_V: i_ret	= i_operandsize; break;
			case OPSIZE_P: i_ret	= i_operandsize; break;
			default:	i_ret	= -1;	break;
		}
	} else	{
		/* Register Data ---*/
		if( isBitFlag(w_methodtype,OPTYPE_BASE_REG_64BIT))
			{ i_ret	= 8; }
		else if( isBitFlag(w_methodtype,OPTYPE_BASE_REG_32BIT))
			{ i_ret	= 4; }
		else if( isBitFlag(w_methodtype,OPTYPE_BASE_REG_16BIT))
			{ i_ret	= 2; }
		else
			{ i_ret	= 1; }

		switch( w_sizeid )	{
			case OPSIZE_V:	i_ret	= i_operandsize;	break;
		}

	}

	return i_ret;
}

/*----------------------------------------------------------------------
static Byte *
	Drd64_Intel64_DisAsm_CarvePrefixByte(
		: Carve Prefix Byte from ByteString

		Drd64_Intel64_AnalyzePacket *drd64_analyze,
						: [dest] drd64 Analyze Packet
		Byte *pb_base)	: [src] Byte String
----------------------------------------------------------------------*/
static Byte *
	Drd64_Intel64_DisAsm_CarvePrefixByte(
		Drd64_Intel64_AnalyzePacket *drd64_analyze,
		Byte *pb_base)
{
	Byte	*pb_now;
	int		i_cnt;
	Byte	b_codetype;

	pb_now	= pb_base;

	for( i_cnt=0; i_cnt<5; i_cnt++ )	{
		/* Query GetByte is Prefix? to Intel64DB */	
		b_codetype = Drd64_Intel64db_GetBytePrefixType( *pb_now, INTEL64_BIT64ONLY );
		if(( INTEL64_CODETYPE_PREFIX == b_codetype )
			|| ( INTEL64_CODETYPE_SEGMENT == b_codetype ) )		{
			drd64_analyze->b_prefix[ drd64_analyze->i_prefixes ]
				= *pb_now++;
			drd64_analyze->i_prefixes++;
		} else if( INTEL64_CODETYPE_REX == b_codetype )	{
			drd64_analyze->rex.b_rex = *pb_now++;
			break;
		} else	{
			break;
		}
	}	

	return pb_now;
}

/*----------------------------------------------------------------------
static Byte *
	Drd64_Intel64_DisAsm_CarveOpecode(
		: Carve OpeCodes from Byte String

		Drd64_Intel64_AnalyzePacket *p_analyze,
						: [dest] Drd64 Analyze Packet
		Byte *pb_base )	: [src] Byte String
----------------------------------------------------------------------*/
static Byte *
	Drd64_Intel64_DisAsm_CarveOpecode(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Byte *pb_base )
{
	Byte	*pb_now;
	Byte	b_codetype;

	pb_now	= pb_base;

	/* Set Byte 0 ---*/
	p_analyze->b_opcode[0]	= *(pb_now + 0);
	p_analyze->i_opcodes		= 1;
	b_codetype = Drd64_Intel64db_GetByteCodeType( p_analyze );

	/* Judge & Set MultiByte ---*/
	if( INTEL64_CODETYPE_ESCAPE == b_codetype )	{
		/* Set Byte 1 ---*/
		p_analyze->b_opcode[1]	= *(pb_now + 1);
		p_analyze->i_opcodes		= 2;
		b_codetype = Drd64_Intel64db_GetByteCodeType( p_analyze );

		if( INTEL64_CODETYPE_ESCAPE2 == b_codetype )	{
			p_analyze->b_opcode[2]	= *(pb_now + 2);
			p_analyze->i_opcodes		= 3;
			b_codetype = Drd64_Intel64db_GetByteCodeType( p_analyze );
		}

		/* XXX ---*/
		/*
		if( INTEL64_CODETYPE_ILLEGAL == b_codetype )	{
			return NULL;
		}
		*/

	} else if( INTEL64_CODETYPE_FPUBYTE1 == b_codetype )	{
		/* Judge Byte2 is 0BFh up/down */
		if( 0xbf < *(pb_now + 1) )	{
			p_analyze->b_opcode[1]	= *(pb_now + 1);
			p_analyze->i_opcodes		= 2;
			b_codetype = Drd64_Intel64db_GetByteCodeType( p_analyze );
		} else	{
			p_analyze->b_modtype	= INTEL64_MODTYPE_FPU;
		}
	} else if( INTEL64_CODETYPE_ILLEGAL == b_codetype )	{
		return NULL;
	}
	pb_now	+= p_analyze->i_opcodes;

	return pb_now;
}


/*----------------------------------------------------------------------
static Byte *
	Drd64_Intel64_DisAsm_CarveDisplacement(
		: Carve Displacement from ByteString

		Drd64_Intel64_AnalyzePacket *p_analyze,	
						: [dest] Drd64 Analyze Packet
		Byte *pb_base)	: [src] Byte String
----------------------------------------------------------------------*/
/* XXX - 64bit Long Mode Only!! --------------------------------------*/
static Byte *
	Drd64_Intel64_DisAsm_CarveDisplacement(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Byte *pb_base)
{
	Byte	*pb_now;

	pb_now	= pb_base;

	/* Carve Displacement */
	if( 0 < p_analyze->i_modrm_bytes )	{
		if( 0x01 == p_analyze->modrm.modrm.mod )	{
			p_analyze->v_disp.i_bytes	= 1;
			p_analyze->v_disp.val.val8	= *pb_base++;
		} else if( 0x02 == p_analyze->modrm.modrm.mod )	{
			p_analyze->v_disp.i_bytes	= 4;
			p_analyze->v_disp.val.val32
				=     (*(pb_now + 3) << 24) 
					+ (*(pb_now + 2) << 16)
					+ (*(pb_now + 1) <<  8)
					+ (*(pb_now + 0)      );
			pb_base += 4;
		} else if(( 0x00 == p_analyze->modrm.modrm.mod )
					&& ( 0x05 == p_analyze->modrm.modrm.rm ))	{
			/* RIP disp Mode : 64bit Long Mode Only */
			p_analyze->v_disp.i_bytes	= 4;
			p_analyze->v_disp.val.val32
				=     (*(pb_now + 3) << 24) 
					+ (*(pb_now + 2) << 16)
					+ (*(pb_now + 1) <<  8)
					+ (*(pb_now + 0)      );
			pb_base += 4;

		} else if(( 0x00 == p_analyze->modrm.modrm.mod )
					&& ( 0x04 == p_analyze->modrm.modrm.rm )
					&& ( 0x05 == p_analyze->sib.sib.base ))	{
			p_analyze->v_disp.i_bytes	= 4;
			p_analyze->v_disp.val.val32
				=     (*(pb_now + 3) << 24) 
					+ (*(pb_now + 2) << 16)
					+ (*(pb_now + 1) <<  8)
					+ (*(pb_now + 0)      );
			pb_base += 4;
		} else {
			p_analyze->v_disp.i_bytes	= 0;
		}
	}

	return pb_base;
}

/*----------------------------------------------------------------------
static Byte *
	Drd64_Intel64_DisAsm_CarveImmediate(
		: Carve Immediate Value from Byte String

		Drd64_Intel64_AnalyzePacket *p_analyze,
						: [dest] Drd64 Analyze Packet
		Byte *pb_base)	: [src] Byte String
----------------------------------------------------------------------*/
/* XXX - 64bit Long Mode Only!! --------------------------------------*/
static Byte *
	Drd64_Intel64_DisAsm_CarveImmediate(
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Byte *pb_base)
{
	Byte	*pb_now;
	QWord	q_temp;

	pb_now	= pb_base;

	if(( OPTYPE_DATA_METHOD_A == p_analyze->w_desttype )
			|| ( OPTYPE_DATA_METHOD_I == p_analyze->w_desttype )
			|| ( OPTYPE_DATA_METHOD_J == p_analyze->w_desttype )
			|| ( OPTYPE_DATA_METHOD_O == p_analyze->w_desttype ) )	{
		assert( 0 ==  p_analyze->v_imm.i_bytes );
		p_analyze->v_imm.i_bytes	= p_analyze->i_destsize;
	}
	if(( OPTYPE_DATA_METHOD_A == p_analyze->w_srctype )
			|| ( OPTYPE_DATA_METHOD_I == p_analyze->w_srctype )
			|| ( OPTYPE_DATA_METHOD_J == p_analyze->w_srctype )
			|| ( OPTYPE_DATA_METHOD_O == p_analyze->w_srctype ) )	{
		assert( 0 ==  p_analyze->v_imm.i_bytes );
		p_analyze->v_imm.i_bytes	= p_analyze->i_srcsize;
	}
	
	if(( OPTYPE_DATA_METHOD_A == p_analyze->w_optiontype )
			|| ( OPTYPE_DATA_METHOD_I == p_analyze->w_optiontype )
			|| ( OPTYPE_DATA_METHOD_J == p_analyze->w_optiontype )
			|| ( OPTYPE_DATA_METHOD_O == p_analyze->w_optiontype ) )	{
		assert( 0 ==  p_analyze->v_imm.i_bytes );
		p_analyze->v_imm.i_bytes	= p_analyze->i_optionsize;
	}

	if( 1 == p_analyze->v_imm.i_bytes )	{
		p_analyze->v_imm.val.val8	= *pb_now++;
	} else if( 2 == p_analyze->v_imm.i_bytes )	{
		p_analyze->v_imm.val.val16
			=     (*(pb_now + 1) << 8) 
				+ (*(pb_now + 0)     );
		pb_now	+= 2;
	} else if( 4 == p_analyze->v_imm.i_bytes )	{
		p_analyze->v_imm.val.val32
			=     (*(pb_now + 3) << 24) 
				+ (*(pb_now + 2) << 16)
				+ (*(pb_now + 1) <<  8)
				+ (*(pb_now + 0)      );
		pb_now	+= 4;
	} else if( 8 == p_analyze->v_imm.i_bytes )	{
		q_temp	= *(pb_now + 7);
		q_temp	= (q_temp << 8) + *(pb_now + 6);
		q_temp	= (q_temp << 8) + *(pb_now + 5);
		q_temp	= (q_temp << 8) + *(pb_now + 4);
		q_temp	= (q_temp << 8) + *(pb_now + 3);
		q_temp	= (q_temp << 8) + *(pb_now + 2);
		q_temp	= (q_temp << 8) + *(pb_now + 1);
		q_temp	= (q_temp << 8) + *(pb_now + 0);
		
		p_analyze->v_imm.val.val64	= q_temp;
		pb_now	+= 8;
	}

	return pb_now;
}

/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_AnalyzeSIB(
		: Analyze SIB ( to Asm String )

		char *p_strsib,		: [dest] Asm String
		Drd64_Intel64_AnalyzePacket *p_analyze,	: [src] Analyze Packet
		int i_maxstr )		: [opt] Dest Max Strings 
----------------------------------------------------------------------*/
static int
	Drd64_Intel64_DisAsm_AnalyzeSIB(
		char *p_strsib,
		Drd64_Intel64_AnalyzePacket *p_analyze,
		int i_maxstr )
{
	int		i_scale;
	Word	w_regid;
	int		i_sizerow;
	Byte	b_regtype;
	char	str_sibtemp[MAX_OPERAND];
	char	str_sibbase[MAX_OPERAND];

	str_sibtemp[0]	= '\0';
	str_sibbase[0]	= '\0';

	i_sizerow		= 0x03;
	if( 8 == p_analyze->i_addresssize )			{ i_sizerow	= 0x03; }
	else if( 4 == p_analyze->i_addresssize )	{ i_sizerow	= 0x02; }

	if(( 0x04 != p_analyze->sib.sib.index )	||
			(( 0x04 == p_analyze->sib.sib.index )
				&& ( 0x01 == p_analyze->rex.rex.x )))	{

		b_regtype	= ((p_analyze->rex.rex.x) << 3) |
								(p_analyze->sib.sib.index);
		w_regid	= drd64_register_table[i_sizerow][b_regtype];
		Drd64_Intel64db_GetRegisterString( str_sibtemp, w_regid, i_maxstr );

		if( 0x01 == p_analyze->sib.sib.scale )
			{ strncat(str_sibtemp, " * 02h", MAX_OPERAND ); }
		else if( 0x02 == p_analyze->sib.sib.scale )
			{ strncat(str_sibtemp, " * 04h", MAX_OPERAND ); }
		else if( 0x03 == p_analyze->sib.sib.scale )
			{ strncat(str_sibtemp, " * 08h", MAX_OPERAND ); }
	}
		
	if(( 0x05 != p_analyze->sib.sib.base )
			|| ( 0x00 != p_analyze->modrm.modrm.mod ))	{
		b_regtype	= ((p_analyze->rex.rex.b) << 3) | (p_analyze->sib.sib.base);
		w_regid	= drd64_register_table[i_sizerow][b_regtype];
		Drd64_Intel64db_GetRegisterString( str_sibbase, w_regid, i_maxstr );

		if(( 0x04 != p_analyze->sib.sib.index )	||
				(( 0x04 == p_analyze->sib.sib.index )
					&& ( 0x01 == p_analyze->rex.rex.x )))	{
			strncat( str_sibtemp, " + ", MAX_OPERAND );
		}
		strncat( str_sibtemp, str_sibbase, MAX_OPERAND );
	}

	strncpy( p_strsib, str_sibtemp, i_maxstr );

	return 0x00;
}


/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_AnalyzeOperand_Memory(
		: Analyze Memory Operand ( Sub )

		char *p_operandstr,		: [dest] Operand String
		Drd64_Intel64_AnalyzePacket *p_analyze,
								: [src] Drd64 Analyze Packet
		Word w_methodtype,		: MethodType ID
		Word w_size,			: Size ID
		int i_size,				: Bytes
		int i_maxstr )			: Operand Max Strings
----------------------------------------------------------------------*/
static int
	Drd64_Intel64_DisAsm_AnalyzeOperand_Memory(
		char *p_operandstr,
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Word w_methodtype,
		Word w_size,
		int i_size,
		int i_maxstr )
{
	Word	w_regid;
	int		i_sizerow;
	int		i_regtbl_type;
	int		i_err;
	Byte	b_regtype;
	char	str_modrm[MAX_OPERAND];
	char	str_opesize[MAX_OPERAND];
	char	str_addr[MAX_OPERAND];
	char	str_segment[MAX_OPERAND];
	char	str_disp[20];

	memset(str_modrm, 0x00, MAX_OPERAND);	
	memset(str_opesize, 0x00, MAX_OPERAND);	
	memset(str_addr, 0x00, MAX_OPERAND);	
	memset(str_segment, 0x00, MAX_OPERAND);	

	/* Set Address Operand Size String */
	switch( i_size )	{
		case  1:		strncpy( str_opesize, "BYTE", MAX_OPERAND ); break;
		case  2:		strncpy( str_opesize, "WORD", MAX_OPERAND ); break;
		case  4:		strncpy( str_opesize, "DWORD", MAX_OPERAND ); break;
		case  8:		strncpy( str_opesize, "QWORD", MAX_OPERAND ); break;
		case 16:		strncpy( str_opesize, "DQWORD", MAX_OPERAND ); break;
	};

	i_regtbl_type	= 0x03;
	if( 4 == p_analyze->i_addresssize )	{
		i_regtbl_type	= 0x02;
	}	
	
	/* Set Base Address String */
	if( 0x04 == p_analyze->modrm.modrm.rm )	{
		i_err = Drd64_Intel64_DisAsm_AnalyzeSIB(
						str_addr, p_analyze, MAX_OPERAND );
		if( 0x00 != i_err )		{ return 0x01; }
	} else if(( 0x00 == p_analyze->modrm.modrm.mod )
			&& ( 0x05 == p_analyze->modrm.modrm.rm ))	{
		strncpy( str_addr, "rIP", MAX_OPERAND );
	} else	{
		b_regtype	= ((p_analyze->rex.rex.b) << 3)
						| (p_analyze->modrm.modrm.rm);
		w_regid	= drd64_register_table[i_regtbl_type][b_regtype];
		Drd64_Intel64db_GetRegisterString( str_addr, w_regid, MAX_OPERAND );
	}

	/* Set Segment Prefix String */
	/* 64h : FS */
	if(( 0x64 == p_analyze->b_prefix[0] )
			|| ( 0x64 == p_analyze->b_prefix[1] ) 
			|| ( 0x64 == p_analyze->b_prefix[2] ) 
			|| ( 0x64 == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "FS:", MAX_OPERAND ); }
	/* 65h : GS */
	else if(( 0x65 == p_analyze->b_prefix[0] )
			|| ( 0x65 == p_analyze->b_prefix[1] ) 
			|| ( 0x65 == p_analyze->b_prefix[2] ) 
			|| ( 0x65 == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "GS:", MAX_OPERAND ); }
	/* 26h : ES (32Bit Only) */
	else if(( 0x26 == p_analyze->b_prefix[0] )
			|| ( 0x26 == p_analyze->b_prefix[1] ) 
			|| ( 0x26 == p_analyze->b_prefix[2] ) 
			|| ( 0x26 == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "ES:", MAX_OPERAND ); }
	/* 2eh : CS (32Bit Only) */
	else if(( 0x2e == p_analyze->b_prefix[0] )
			|| ( 0x2e == p_analyze->b_prefix[1] ) 
			|| ( 0x2e == p_analyze->b_prefix[2] ) 
			|| ( 0x2e == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "CS:", MAX_OPERAND ); }
	/* 36h : SS (32Bit Only) */
	else if(( 0x36 == p_analyze->b_prefix[0] )
			|| ( 0x36 == p_analyze->b_prefix[1] ) 
			|| ( 0x36 == p_analyze->b_prefix[2] ) 
			|| ( 0x36 == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "SS:", MAX_OPERAND ); }
	/* 3eh : DS (32Bit Only) */
	else if(( 0x3e == p_analyze->b_prefix[0] )
			|| ( 0x3e == p_analyze->b_prefix[1] ) 
			|| ( 0x3e == p_analyze->b_prefix[2] ) 
			|| ( 0x3e == p_analyze->b_prefix[3] ))
		{ strncpy( str_segment, "DS:", MAX_OPERAND ); }


	/* Merge Base Address & Displacement String */
	strncat( p_operandstr, str_opesize, i_maxstr );
	strncat( p_operandstr, " [", i_maxstr );
	if( '\0' != str_segment[0] )	{
		strncat( p_operandstr, str_segment, i_maxstr );
	}
	if( '\0' != str_addr[0] )	{
		strncat( p_operandstr, str_addr, i_maxstr );
	}
	if( 0 < p_analyze->v_disp.i_bytes )	{
		/* Set Displacement String */
		Drd64_Intel64_Common_ExtendValueBit(
			 &(p_analyze->v_disp),p_analyze->i_addresssize, 1);
		Drd64_Intel64_DisAsm_ConvValue2String(
			str_disp, &(p_analyze->v_disp), 20); 

		if( '\0' != str_addr[0] )	{
			strncat( p_operandstr, " + ", i_maxstr );
		}
		strncat( p_operandstr, str_disp, i_maxstr );
	}
	strncat( p_operandstr, "]", i_maxstr );

	return 0x00;
}


/*----------------------------------------------------------------------
static int
	Drd64_Intel64_DisAsm_AnalyzeOperand(
		: Analyze Operand

		char *p_operandstr,		: [dest] Operand String
		Drd64_Intel64_AnalyzePacket *p_analyze,
								: [src] Drd64 Analyze Packet
		Word w_methodtype,		: MethodType ID
		Word w_size,			: Size ID
		int i_size,				: Bytes
		int i_maxstr )			: Operand Max Strings
----------------------------------------------------------------------*/
static int
	Drd64_Intel64_DisAsm_AnalyzeOperand(
		char *p_operandstr,
		Drd64_Intel64_AnalyzePacket *p_analyze,
		Word w_methodtype,
		Word w_size,
		int i_size,
		int i_maxstr )
{
	Word	w_regid;
	int		i_sizerow;
	Byte	b_regtype;
	int		i_err;

	i_err = 0x00;

	/* Data (Immediate, Memory) */
	if( (OPTYPE_BASE_DATA & w_methodtype) == OPTYPE_BASE_DATA )	{
		if( isBitFlag(w_methodtype,OPTYPE_BASE_DATA_MODRM) )	{
 			/* C : [ModR/M:reg] Control Reg.  */
			if( OPTYPE_DATA_METHOD_C == w_methodtype )	{
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[0x05][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* D : [ModR/M:reg] Debug Reg. */
			else if( OPTYPE_DATA_METHOD_D == w_methodtype ) 	{
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[0x06][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* G : [ModR/M:reg] General Reg. */
			else if( OPTYPE_DATA_METHOD_G == w_methodtype )		{
				switch( i_size )	{
					case 1:	i_sizerow	= 0x00;	break;
					case 2:	i_sizerow	= 0x01;	break;
					case 4:	i_sizerow	= 0x02;	break;
					case 8:	i_sizerow	= 0x03;	break;
				}	
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[i_sizerow][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* P : [ModR/M:reg] Packed-QuadWord MMX Reg. */
			else if( OPTYPE_DATA_METHOD_P == w_methodtype )		{
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[0x07][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* S : [ModR/M:reg] Segment Reg. */
			else if( OPTYPE_DATA_METHOD_S == w_methodtype )		{
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[0x04][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* T : [ModR/M:reg] Test Reg. ( Reserved ) */
			/* else if( OPTYPE_DATA_METHOD_T == w_methodtype )		{
			} */
 			/* V : [ModR/M:reg] 128bit XMM Reg. */
			else if( OPTYPE_DATA_METHOD_V == w_methodtype )		{
				b_regtype	= ((p_analyze->rex.rex.r) << 3)
						| (p_analyze->modrm.modrm.reg);
				w_regid	= drd64_register_table[0x08][b_regtype];
				Drd64_Intel64db_GetRegisterString(
					p_operandstr, w_regid, i_maxstr );
			}
 			/* N : [ModR/M:R/M] Packed-QuadWord MMX Reg. */
			else if( OPTYPE_DATA_METHOD_N == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[0x07][b_regtype];
					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				}
			}
 			/* R : [ModR/M:R/M] refer to General Reg by R/M Field */
			else if( OPTYPE_DATA_METHOD_R == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					switch( i_size )	{
						case 1:	i_sizerow	= 0x00;	break;
						case 2:	i_sizerow	= 0x01;	break;
						case 4:	i_sizerow	= 0x02;	break;
						case 8:	i_sizerow	= 0x03;	break;
					}	
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[i_sizerow][b_regtype];

					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				}
			}
 			/* U : [ModR/M:R/M] 128bit XMM Reg. */
			else if( OPTYPE_DATA_METHOD_U == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[0x08][b_regtype];
					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				}
			}
 			/* E : [ModR/M] Memory & Reg. */
			else if( OPTYPE_DATA_METHOD_E == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					switch( i_size )	{
						case 1:	i_sizerow	= 0x00;	break;
						case 2:	i_sizerow	= 0x01;	break;
						case 4:	i_sizerow	= 0x02;	break;
						case 8:	i_sizerow	= 0x03;	break;
					}	
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[i_sizerow][b_regtype];

					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				} else	{
					i_err	= Drd64_Intel64_DisAsm_AnalyzeOperand_Memory( 
						p_operandstr, p_analyze, w_methodtype, w_size,
						i_size, i_maxstr );
					if( 0x00 != i_err )	{ return 0x01; }
				}
			}
 			/* W : [ModR/M] 128bit XMM Reg. or Memory Address */
			else if( OPTYPE_DATA_METHOD_W == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[0x08][b_regtype];
					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				} else	{
					i_err	= Drd64_Intel64_DisAsm_AnalyzeOperand_Memory( 
						p_operandstr, p_analyze, w_methodtype, w_size,
						i_size, i_maxstr );
					if( 0x00 != i_err )	{ return 0x01; }
				}
			}
 			/* Q : [ModR/M] MMX reg. or Memory Address */
			else if( OPTYPE_DATA_METHOD_Q == w_methodtype )		{
				if( 0x03 == p_analyze->modrm.modrm.mod )	{
					b_regtype	= ((p_analyze->rex.rex.b) << 3)
							| (p_analyze->modrm.modrm.rm);
					w_regid	= drd64_register_table[0x07][b_regtype];
					Drd64_Intel64db_GetRegisterString(
						p_operandstr, w_regid, i_maxstr );
				} else	{
					i_err	= Drd64_Intel64_DisAsm_AnalyzeOperand_Memory( 
						p_operandstr, p_analyze, w_methodtype, w_size,
						i_size, i_maxstr );
					if( 0x00 != i_err )	{ return 0x01; }
				}
			}
 			/* M : Memory Access (by ModR/M) (NO!!: Reg. Indicate by ModR/M) */
			else if( OPTYPE_DATA_METHOD_M == w_methodtype )		{
				if( 0x03 != p_analyze->modrm.modrm.mod )	{
					i_err	= Drd64_Intel64_DisAsm_AnalyzeOperand_Memory( 
						p_operandstr, p_analyze, w_methodtype, w_size,
						i_size, i_maxstr );
					if( 0x00 != i_err )	{ return 0x01; }
				}
			}
			/* Illegal Method */
			else	{
				return 0x02;
			}
		} else	{
			/* A : Direct Address */
			if( OPTYPE_DATA_METHOD_A == w_methodtype )	{
				Drd64_Intel64_DisAsm_ConvValue2String( p_operandstr,
					&(p_analyze->v_imm), i_maxstr ); 
			}
			/* I : Immediate Data (NO!!: ModR/M) */
			else if( OPTYPE_DATA_METHOD_I == w_methodtype )	{
				Drd64_Intel64_DisAsm_ConvValue2String( p_operandstr,
					&(p_analyze->v_imm), i_maxstr ); 
			}
			/* J : IP relative Address (NO!!: ModR/M) */
			else if( OPTYPE_DATA_METHOD_J == w_methodtype )	{
				Drd64_Intel64_DisAsm_ConvValue2String( p_operandstr,
					&(p_analyze->v_imm), i_maxstr ); 
			}
			/* O : Word of DWord Data */
			else if( OPTYPE_DATA_METHOD_O == w_methodtype )	{
				Drd64_Intel64_DisAsm_ConvValue2String( p_operandstr,
					&(p_analyze->v_imm), i_maxstr ); 
			}
			/* F : EFLAGS / RFLAGS Reg. (NO!!: ModR/M)  */
			/*else if( OPTYPE_DATA_METHOD_F == w_methodtype )	{
			}*/
			/* X : DS:rSI (Memory Address) */
			else if( OPTYPE_DATA_METHOD_X == w_methodtype )	{
				strncpy( p_operandstr, "", i_maxstr );
			}
			/* Y : ES:rDI (Memory Address)*/
			else if( OPTYPE_DATA_METHOD_Y == w_methodtype )	{
				strncpy( p_operandstr, "", i_maxstr );
			}
			/* 1 : 0x01 Data (Immediate Data) */
			else if( OPTYPE_DATA_METHOD_1 == w_methodtype )	{
				strncpy( p_operandstr, "001h", i_maxstr );
			}
			/* - : Illegal Instruction */
			else	{
				return 0x01;
			}
		}
	}
	/* Register(Direct) */
	else	{
		/* ReDefine Register Code */
		if( isBitFlag(w_methodtype,OPTYPE_BASE_REG_64BIT) )	{
			if( 4 == i_size )	{
				w_methodtype ^= (OPTYPE_BASE_REG_32BIT|OPTYPE_BASE_REG_64BIT);
			} else if( 2 == i_size )	{
				w_methodtype ^= (OPTYPE_BASE_REG_16BIT|OPTYPE_BASE_REG_64BIT);
			}	
		} else if( isBitFlag(w_methodtype,OPTYPE_BASE_REG_32BIT) )	{
			if( 2 == i_size )	{
				w_methodtype ^= (OPTYPE_BASE_REG_16BIT|OPTYPE_BASE_REG_32BIT);
			}	
		}
		Drd64_Intel64db_GetRegisterString(
				p_operandstr, w_methodtype, i_maxstr );
	}
	
	return 0x00;
} 


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
/*Drd64_Intel64_DisAsm_DisAsmLine(*/
LIBINTEL64ASM_FUNC	int
	Drd64_LibIntel64asm_DisAsmLine(
		char *p_dest,
		Byte *pb_src,
		int i_maxdest)
{
	Drd64_Intel64_AnalyzePacket		drd64_analyze;
	Byte	*pb_now;
	Byte	b_modtype;
	Byte	b_ret;
	int		i_err	= 0x00;
	int		i_length	= 0;

	/* Initialize */
	pb_now	= pb_src;
	memset( &drd64_analyze, 0x00, sizeof(Drd64_Intel64_AnalyzePacket) );

	/* Proc. Prefix & REX */
	pb_now	= Drd64_Intel64_DisAsm_CarvePrefixByte( &drd64_analyze, pb_now );

	/* Proc. Opecodes */
	pb_now	= Drd64_Intel64_DisAsm_CarveOpecode( &drd64_analyze, pb_now );
	if( NULL == pb_now )	{
		/* Data code (Prefix 1Byte) */
		i_err	= 0xff;
		goto goto_Drd64_Intel64_DisAsm_DisAsmLine_Output;
	}

	/* Proc. ModR/M */
	b_modtype	= drd64_analyze.b_modtype;
	if(( INTEL64_MODTYPE_NONE !=b_modtype)
			&& ( INTEL64_MODTYPE_NONE_FPU  != b_modtype ) 
			&& ( INTEL64_MODTYPE_ESCAPE != b_modtype )
			&& ( INTEL64_MODTYPE_ERROR != b_modtype ) )	{
		drd64_analyze.modrm.b_modrm	= *pb_now++;
		drd64_analyze.i_modrm_bytes	= 1;
	}

	/* Carve SIB */
	if(( 0x03 != drd64_analyze.modrm.modrm.mod )
			&& ( 0x04 == drd64_analyze.modrm.modrm.rm ) )	{
		drd64_analyze.sib.b_sib	= *pb_now++;
		drd64_analyze.i_sib_bytes	= 1;	
	}
			
	/* Query Intel64-Instruction DataBase */
	b_ret = Drd64_Intel64db_GetByteCodeType( &drd64_analyze );
	if(( INTEL64_CODETYPE_ILLEGAL == b_ret ) ||
			( INTEL64_CODETYPE_NOINSTRUCTION == b_ret ) ||
			( INTEL64_CODETYPE_ERROR == b_ret ) )	{
		/* Data code (Prefix 1Byte) */
		i_err	= 0xff;
		goto goto_Drd64_Intel64_DisAsm_DisAsmLine_Output;
	}

	Drd64_Intel64_DisAsm_CalcOperandSize( &drd64_analyze );
	Drd64_Intel64_DisAsm_CalcDefaultAddressSize( &drd64_analyze );
	drd64_analyze.i_destsize
			= Drd64_Intel64_DisAsm_GetSize_SizeID(
				drd64_analyze.i_operandsize,
				drd64_analyze.w_desttype,
				drd64_analyze.w_destsize );
	drd64_analyze.i_srcsize
			= Drd64_Intel64_DisAsm_GetSize_SizeID(
				drd64_analyze.i_operandsize,
				drd64_analyze.w_srctype,
				drd64_analyze.w_srcsize );
	drd64_analyze.i_optionsize
			= Drd64_Intel64_DisAsm_GetSize_SizeID(
				drd64_analyze.i_operandsize,
				drd64_analyze.w_optiontype,
				drd64_analyze.w_optionsize );

	/* Carve Displacement */
	pb_now	= Drd64_Intel64_DisAsm_CarveDisplacement( &drd64_analyze, pb_now);

	/* Carve Immediate */
	pb_now	= Drd64_Intel64_DisAsm_CarveImmediate( &drd64_analyze, pb_now );

	/* Analyze Destination Operand */
	if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_desttype )	{
		i_err	+= Drd64_Intel64_DisAsm_AnalyzeOperand(
			drd64_analyze.str_destination, &drd64_analyze,
			drd64_analyze.w_desttype, drd64_analyze.w_destsize,
			drd64_analyze.i_destsize, MAX_OPERAND );
	}

	/* Analyze Source Operand */
	if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_srctype )	{
		i_err	+= Drd64_Intel64_DisAsm_AnalyzeOperand(
			drd64_analyze.str_source, &drd64_analyze,
			drd64_analyze.w_srctype, drd64_analyze.w_srcsize,
			drd64_analyze.i_srcsize, MAX_OPERAND );
	}

	/* Analyze Option Operand */
	if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_optiontype )	{
		i_err	+= Drd64_Intel64_DisAsm_AnalyzeOperand(
			drd64_analyze.str_option, &drd64_analyze,
			drd64_analyze.w_optiontype, drd64_analyze.w_optionsize,
			drd64_analyze.i_optionsize, MAX_OPERAND );
	}

goto_Drd64_Intel64_DisAsm_DisAsmLine_Output:
	/* Output Assembler Code */
	if( 0 < i_err )	{
		snprintf( p_dest, i_maxdest, "DB\t%x", *pb_now );
		i_length	= pb_now++ - pb_src;
	} else if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_optiontype )	{
		snprintf( p_dest, i_maxdest, "%s\t%s,%s,%s",
					drd64_analyze.str_instruction,
					drd64_analyze.str_destination,
					drd64_analyze.str_source,
					drd64_analyze.str_option );
		i_length	= pb_now - pb_src;
	} else if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_srctype )	{
		snprintf( p_dest, i_maxdest, "%s\t%s,%s",
					drd64_analyze.str_instruction,
					drd64_analyze.str_destination,
					drd64_analyze.str_source );
		i_length	= pb_now - pb_src;
	} else if( OPTYPE_DATA_METHOD_ILLEGAL != drd64_analyze.w_desttype )	{
		snprintf( p_dest, i_maxdest, "%s\t%s",
					drd64_analyze.str_instruction,
					drd64_analyze.str_destination );
		i_length	= pb_now - pb_src;
	} else if( OPTYPE_DATA_METHOD_ILLEGAL == drd64_analyze.w_desttype )	{
		snprintf( p_dest, i_maxdest, "%s",
					drd64_analyze.str_instruction );
		i_length	= pb_now - pb_src;
	}

	Drd64_Intel64_Debug_PrintAnalyzePacket( &drd64_analyze, "DisAssemble", 2 );

	Drd64_Intel64_Debug_DisAsm_PrintAnswer( p_dest, pb_src, i_length );

	return i_length;
}



/* EOF of drd64_intel64_disasm.c ----------------------------------- */
