/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_intel64_disasm.h
Function: Intel64 DisAssembler Main Module Header 
Comment:  none
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_INTEL64_DISASM
#define DRD64_HEADER_INTEL64_DISASM

#include"drd64_intel64_dbtype.h"
#include"drd64_intel64_db.h"
#include"drd64_intel64_asm.h"

typedef struct	{
	unsigned	rm		: 3;
	unsigned	reg		: 3;
	unsigned	mod		: 2;
} __attribute((packed)) ModRM;

typedef struct	{
	unsigned	base	: 3;
	unsigned	index	: 3;
	unsigned	scale	: 2;
} __attribute((packed)) SIB;

typedef struct	{
	unsigned	b		: 1;
	unsigned	x		: 1;
	unsigned	r		: 1;
	unsigned	w		: 1;
	unsigned	head	: 4;
} __attribute((packed)) REX;


typedef struct	{
	/* Prefix Data */
	int		i_prefixes;
	Byte	b_prefix[4];
	/* REX Data */
	union	{
		REX		rex;
		Byte	b_rex;
	} rex;
	/* Opecode Data */
	int		i_opcodes;
	Byte	b_opcode[3];
	Byte	b_codetype;
	/* ModR/M Data */	
	Byte	b_modtype;
	Byte	b_regtype;
	Byte	b_rmtype;
	int		i_modrm_bytes;
	union	{
		ModRM	modrm;
		Byte	b_modrm;
	} modrm;
	/* SIB Data */
	int		i_sib_bytes;
	union	{
		SIB		sib;
		Byte	b_sib;
	} sib;
	/* Displacement */
	Value	v_disp;
	/* Immediate */
	Value	v_imm;
		
	int		i_num;
	Byte	b_bits;
	int		i_operands;
	/* Instruction */
	char	str_instruction[MAX_INSTRUCTION];
	/* Operand Information */
	int		i_operandsize;
	int		i_addresssize;

	/* Destination Operand */
	Word	w_desttype;
	Word	w_destsize;	
	int		i_destsize;
	char	str_destination[MAX_OPERAND];
	/* Source Operand */
	Word	w_srctype;
	Word	w_srcsize;
	int		i_srcsize;
	char	str_source[MAX_OPERAND];
	/* Option Operand */
	Word	w_optiontype;
	Word	w_optionsize;
	int		i_optionsize;
	char	str_option[MAX_OPERAND];
	
	Byte	b_duplicationflag;
} Drd64_Intel64_AnalyzePacket;


#endif	/* DRD64_HEADER_INTEL64_DISASM */

/* EOF of drd64_intel64_disasm.h --------------------------------- */
