/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
        
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: intel64asm.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"../include/drd64_types.h"
#include"../include/libintel64asm.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	copyright(
		void )
{
	puts("INTEL64 Line Assembler/DisAssemble Version 1.00");
	puts("(Dr.Deamon64 SubProject -- LibIntel64asm Test Program)");
	puts("Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.");
	puts("");

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	usage(
		void )
{
	puts(" Usage: intel64asm [option] command data");
	puts("   command List :");
	puts("     -a : Assemble File    ex.>  intel64asm -a example.asm");
	puts("     -l : Assemble Line    ex.>  intel64asm -l mov rax, dword [ rsi + 0005h] ");
	puts("     -d : DisAssemble File ex.>  intel64asm -d example.bin");
	/*puts("     -r : DisAssemble Line ex.>  intel64asm -r 412a1200h");*/
	puts("     -v : [OPTION] Vervose Mode (Put All Debug Message)");
	puts("              ex. intel64asm -v -a example.asm");
	puts("   CAUTION!! : This Assembler isn't until support ELF Binary Format!");

	return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
    asm_file(
        char *filename )
{
    char    str_buf[200];
    Byte    b_dest[200];
    FILE    *fp;

    if( NULL == (fp = fopen( filename, "r" )))
		{ return 0x01;  }


    while( NULL != fgets( str_buf, 200, fp ))   {
        Drd64_LibIntel64asm_AsmLine( b_dest, str_buf, sizeof(b_dest));
    }

    fclose(fp);

    return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
    disasm_file(
		char *filename )
{
    char    ans[300];
    int     i_length;
    FILE    *fp;
    fpos_t  fsize;
    Byte    *pb_data;
    Byte    *pb_now;
    int     i_size;

    if(NULL == (fp = fopen( filename, "rb" )))
		{ return 0x01; }

    fseek(fp, 0, SEEK_END);
    fgetpos(fp, &fsize);
    fseek(fp, 0, SEEK_SET);

    pb_data = (Byte *)malloc(fsize);
	if( NULL == pb_data )	
		{ return 0x02; }

    fread(pb_data, fsize, 1, fp);

    fclose(fp);

    i_size  = fsize;
    pb_now  = pb_data;

    do  {
        i_length    = Drd64_LibIntel64asm_DisAsmLine(ans, pb_now, sizeof(ans));
        pb_now  += i_length;

    }while( pb_now < (pb_data+i_size) );

	free( pb_data );

    return 0x00;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	main(
		int argc,
		char *argv[] )
{
	int		i_debug_level;
	int		i_pos;
	int		i_cnt;
	char	str_option[256];
	unsigned char	b_dest[256];

	i_debug_level	= 1;
	str_option[0]	= '\0';

	copyright();

	if( 3 > argc )	{
		usage();
		return 0x00;
	}

	i_pos	= 1;
	/* Analyze Option Line */
	if( !strcmp( argv[i_pos], "-v" ))		{
		i_debug_level	= 4;
		i_pos++;
	}

	Drd64_LibIntel64asm_Initialize();
	Drd64_LibIntel64asm_SetDebugLevel( i_debug_level );

	/* Analyze Command Line */
	if( !strcmp( argv[i_pos], "-a" ))		{
		asm_file( argv[i_pos+1]);
	}
	else if( !strcmp( argv[i_pos], "-l" ))		{
		for( i_cnt = i_pos+1; i_cnt < argc; i_cnt++ )	{
			strncat( str_option, argv[i_cnt], sizeof( str_option ));
			strncat( str_option, " ", sizeof( str_option ));
		}
        Drd64_LibIntel64asm_AsmLine( b_dest, str_option, sizeof(b_dest));
	}
	else if( !strcmp( argv[i_pos], "-d" ))		{
    	disasm_file( argv[i_pos+1] );
	}
	else if( !strcmp( argv[i_pos], "-r" ))		{

	}

	Drd64_LibIntel64asm_Terminate();
	
	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
