/*
	bZ[WM

*/

#include "dscsd_g3.h"

void	*AudioMessage (void *arg)
{
	int	cmdout;
	int	length;

	struct	msg_info *voice_info;
 
	pthread_detach( pthread_self());

	voice_info = arg;

	if (AudioMsgCallCheck(voice_info))
	{
		UpdateMsgServerIP(voice_info->sender, TrustZrCallsign, TrustArCallsign);
		fprintf (LogFile, "%s INFO  audio  %8.8s %8.8s %8.8s %d.%d.%d.%d %20.20s\n", loctime(),
			voice_info->callsign, voice_info->zone, voice_info->area,
			voice_info->ip[0], voice_info->ip[1], voice_info->ip[2], voice_info->ip[3],
			voice_info->SlowMsg);
		fflush (LogFile);
//		if (memcmp (voice_info->area, voice_info->zone, 7)) sleep(2);
//		else sleep(1);
		SendAudioMsg(voice_info);
	}
	free (voice_info);		/* p[^EGẢ */
	return NULL;
}

void	SendAudioMsg (struct msg_info *voice)
{
	unsigned char	NullVoice0[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16};
	unsigned char	NullVoice1[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5};
	unsigned char	FileName[26] = {"/etc/dscsd_g3/audio/*.dsv\0"};

	struct	sockaddr_in VoiceSockAddr;
	int	VoiceSocket;
	int	length;
	uint32_t	ip_temp;
	unsigned char	header[56];
	uint16_t	crc;
	struct	timeval	t1, t2, t3, t4;
	uint16_t	rand_t;
	int	seq;
	int	i;
	int	k;
	int	timeout;
	int	ret;
	struct timeval tv;
	fd_set	readfd;
	FILE	*VoiceFile;
	FILE	*infile;

	timeout = 0;

	/* ̑M\Pbg */
	VoiceSocket = socket(AF_INET, SOCK_DGRAM, 0);
	memset(&VoiceSockAddr, 0x00, sizeof(VoiceSockAddr));
	VoiceSockAddr.sin_port = htons(VoicePort);
	VoiceSockAddr.sin_family = AF_INET;
	memcpy (&VoiceSockAddr.sin_addr.s_addr, &voice->ip, 4);

ReTry:
	memcpy (&header[0], "DSVT", 4);
	header[4] = 0x10;		/*  */
	header[5] = 0x00;		/*  */
	header[6] = 0x00;		/*  */
	header[7] = 0x00;		/*  */

	header[8] = 0x20;
	header[9] = 0x00;		/*  */
	header[10] = 0x01;		/*  */
	header[11] = 0x02;		/*  */
	
	rand_t = msgID();
	header[12] = rand_t >>8;	/* pPbgID̃Zbg */

	header[13] = rand_t & 0xff;
	header[14] = 0x80;

	header[15] = 0x00;		/* flag1 */
	header[16] = 0x00;		/* flag2 */
	header[17] = 0x00;		/* flaf3 */
	memcpy (&header[18], voice->area, 8);	/* rpt1 */
	memcpy (&header[26], voice->zone, 8);	/* rpt2 */
	header[33] = 'G';
	memcpy (&header[34], voice->callsign, 8);	/* YourCall */
	memcpy (&header[42], voice->sender, 8);	/* MyCall */
	memcpy (&header[50], voice->sender2, 4);	/* MyCall2 */

	crc = calc_crc (&header[15],  39);
	header[54] = crc >> 8;
	header[55] = crc & 0xff;

	/* wb_[M */
	for (k = 0 ; k < 5 ; k++)
	{
		sendto (VoiceSocket, header , 56, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
		usleep(500);
	}
	gettimeofday (&t1, NULL);
	t4.tv_sec = 0;
	t4.tv_usec = 1500000;		/* 150 m sec */	
	timeradd (&t1, &t4, &t3);
	t1.tv_sec = t3.tv_sec;
	t1.tv_usec = t3.tv_usec;

	header[14] = 0x00;
	seq = 0;
	header[4] = 0x20;
	if (memcmp (voice->callsign, "CQCQCQ  ", 8))
	{
		for (i = 0 ; i < 8 ; i++)
		{
			if (voice->callsign[i] != 0x20)
			{
				FileName[20] = voice->callsign[i];
				VoiceFile = fopen (FileName, "rb");
				while(1)
				{
					gettimeofday (&t2, NULL);
					if (timercmp (&t2, &t1, >))
					{
						if (fread (&header[15], 12, 1, VoiceFile) != 1) break;
						if (BusyCheck(voice->ip))
						{
							fclose (VoiceFile);
							if (timeout++ > MAXBUSYTIMEOUT) return;
//							sleep(1);
							goto ReTry;
						}
						if (header[14] == 0x00) memcpy (&header[24], &NullVoice0[9], 3);
						else	memcpy (&header[24], &NullVoice1[9], 3);
						sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
						header[14]++;
						if (header[14] > 20) header[14] = 0x00;
						t4.tv_sec = 0;
						t4.tv_usec = 20000;		/* 20 m sec */	
						timeradd (&t1, &t4, &t3);
						t1.tv_sec = t3.tv_sec;
						t1.tv_usec = t3.tv_usec;
					}
					else
					{
						usleep (2000);	/* wait 2 m sec */
					}
				}
				fclose (VoiceFile);
			}
			else
			{
				k = 0;
				while(1)
				{
					gettimeofday (&t2, NULL);
					if (timercmp (&t2, &t1, >))
					{
						if (BusyCheck(voice->ip))
						{
							if (timeout++ > MAXBUSYTIMEOUT) return;
//							sleep(1);
							goto ReTry;
						}
						if (header[14] == 0x00) memcpy (&header[15], NullVoice0, 12);
						else	memcpy (&header[15], NullVoice1, 12);
						sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
						header[14]++;
						if (header[14] > 20) header[14] = 0x00;
						t4.tv_sec = 0;
						t4.tv_usec = 20000;		/* 20 m sec */	
						timeradd (&t1, &t4, &t3);
						t1.tv_sec = t3.tv_sec;
						t1.tv_usec = t3.tv_usec;
						k++;
						if (k > 15) break;
					}
					else
					{
						usleep (2000);	/* wait 2 m sec */
					}
				}
			}
		}

		if (header[14] )
		{
			while(1)	
			{
				gettimeofday (&t2, NULL);
				if (timercmp (&t2, &t1, >))
				{
					if (BusyCheck(voice->ip))
					{
						if (timeout++ > MAXBUSYTIMEOUT) return;
//						sleep(1);
						goto ReTry;
					}
					if (header[14] == 0x00) memcpy (&header[15], NullVoice0, 12);
					else	memcpy (&header[15], NullVoice1, 12);
					sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
					header[14]++;
					if (header[14] > 20)
					{
						header[14] = 0x00;
						break;
					}
					t4.tv_sec = 0;
					t4.tv_usec = 20000;		/* 20 m sec */	
					timeradd (&t1, &t4, &t3);
					t1.tv_sec = t3.tv_sec;
					t1.tv_usec = t3.tv_usec;
				}
				else
				{
					usleep (2000);	/* wait 2 m sec */
				}
			}
		}
	}

	infile = fopen (voice->FileName, "rb");
	
	while (1)
	{
//		if (!memcmp (voiceIP, &voice->ip, 4))
		if (BusyCheck(voice->ip))
		{
			fclose(infile);
			if (timeout++ > MAXBUSYTIMEOUT) return;
//			sleep(1);
			goto ReTry;
		}

		gettimeofday (&t2, NULL);
		if (timercmp (&t2, &t1, >))
		{
			if (fread (&header[15], 12, 1, infile) != 1) break;
			/* EEEM */
			if (header[14] == 0)		/* resync set */
			{
//				header[24] = 0x55;
//				header[25] = 0x2d;
//				header[26] = 0x16;
				memcpy (&header[24], &NullVoice0[9], 3);
			}
			else
			{
				header[24] = 0x66 ^ 0x70;
				header[25] = 0x66 ^ 0x4f;
				header[26] = 0x66 ^ 0x93;
			}
			k = seq % 1050;
			switch (k)
			{
				case 1:
					header[24] = 0x40^ 0x70;
					header[25] = voice->SlowMsg[0] ^ 0x4f;
					header[26] = voice->SlowMsg[1] ^ 0x93;
					break;
				case 2:
					header[24] = voice->SlowMsg[2] ^ 0x70;
					header[25] = voice->SlowMsg[3] ^ 0x4f;
					header[26] = voice->SlowMsg[4] ^ 0x93;
					break;
				case 3:
					header[24] = 0x41 ^ 0x70;
					header[25] = voice->SlowMsg[5] ^ 0x4f;
					header[26] = voice->SlowMsg[6] ^ 0x93;
					break;
				case 4:
					header[24] = voice->SlowMsg[7] ^ 0x70;
					header[25] = voice->SlowMsg[8] ^ 0x4f;
					header[26] = voice->SlowMsg[9] ^ 0x93;
					break;
				case 5:
					header[24] = 0x42 ^ 0x70;
					header[25] = voice->SlowMsg[10] ^ 0x4f;
					header[26] = voice->SlowMsg[11] ^ 0x93;
					break;
				case 6:
					header[24] = voice->SlowMsg[12] ^ 0x70;
					header[25] = voice->SlowMsg[13] ^ 0x4f;
					header[26] = voice->SlowMsg[14] ^ 0x93;
					break;
				case 7:
					header[24] = 0x43 ^ 0x70;
					header[25] = voice->SlowMsg[15] ^ 0x4f;
					header[26] = voice->SlowMsg[16] ^ 0x93;
					break;
				case 8:
					header[24] = voice->SlowMsg[17] ^ 0x70;
					header[25] = voice->SlowMsg[18] ^ 0x4f;
					header[26] = voice->SlowMsg[19] ^ 0x93;
					break;
			}
			sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
			header[14]++;
			if (header[14] > 20) header[14] = 0x00;
			t4.tv_sec = 0;
			t4.tv_usec = 20000;		/* 20 m sec */	
			timeradd (&t1, &t4, &t3);
			t1.tv_sec = t3.tv_sec;
			t1.tv_usec = t3.tv_usec;
			seq++;
		}
		else
		{
			usleep (2000);	/* wait 2 m sec */
		}
	}
	fclose (infile);

	/* Xgt[̑M */
	header[24] = 0x55;
	header[25] = 0x55;
	header[26] = 0x55;
	sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
	header[14]++;
	if (header[14] > 20) header[14] = 0x00;
	header[14] |= 0x40;
	header[15] = 0x55;
	header[16] = 0xc8;
	header[17] = 0x7a;
	memset (&header[18], 0x00, 9);
	sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
}

void	UpdateMsgServerIP(unsigned char sender[], unsigned char ZrCall[], unsigned char ArCall[])
{
	int sock;
	char	regist[32];
 	/* 0x00, 0x03, 0x00, 0x00, 0x01, 0x00,  0x00, 0x00, 
	'7', 'M', '3', 'T', 'J', 'Z', ' ', 'F', 'J', 'K', '1', 'Z', 'R', 'W', ' ', ' ', 'J', 'K', '1', 'Z', 'R', 'W', ' ', 'A' */
	uint16_t	msg_id;
	struct sockaddr_in addr;

	sock = socket(AF_INET, SOCK_DGRAM, 0);

	addr.sin_family = AF_INET;
	addr.sin_port = htons(GWPort);
	addr.sin_addr.s_addr = inet_addr(TrustIpAddress);
	memset (regist, 0x00, 32);
	regist[1] = 0X03;
	regist[4] = 0x01;
	msg_id = msgID();
	regist[6] = msg_id >> 8;
	regist[7] = msg_id & 0xff;
	memcpy (&regist[8], sender, 8);
	memcpy (&regist[16], ZrCall, 8);
	memcpy (&regist[24], ArCall, 8);

	sendto(sock, regist, 32, 0, (struct sockaddr *)&addr, sizeof(addr));

	close(sock);  
}

