/*
	ݒt@Cǂݍ
*/

#include "dscsd_g3.h"			/* eϐ` */

void	read_config(int argc, char **argv)
{
	char	buff[128];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	FILE	*config_file;

	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			printf ("config file not found (%s)\n", argv[1]);
			exit (1);
		}
	} 
	else
	{
		config_file = fopen ("/etc/dscsd_g3/dscsd_g3.conf","r");
		if (!config_file)
		{
			printf ("config file not found (/etc/dscsd_g3.conf)\n");
			exit (1);
		}
	}

	while (fgets (buff, 127, config_file))
	{
		if (buff[0] != '#')
		{
			pnt = strtok(buff, delmi);
			pnt = strtok(NULL,delmi);

			if (!memcmp (buff, "CMDMODE_STD", 11))
			{
				cmdmode = atoi(pnt);
			}
			else if (!memcmp (buff, "TRUST_GW_PORT", 15))
			{
				GWPort = atoi(pnt);
			}
			else if (!memcmp (buff, "LOCAL_TRNASFER_PORT", 19))
			{
				LocalSyncPort = atoi(pnt);
			}
			else if (!memcmp (buff, "GLOBAL_TRNASFER_PORT", 20))
			{
				GlobalSyncPort = atoi(pnt);
			}
			else if (!memcmp (buff, "VOICE_PORT", 10))
			{
				VoicePort = atoi(pnt);
			}
			else if (!memcmp (buff, "AUDIO_MESSAGE", 13))
			{
				AudioMsg = atoi(pnt);
			}
			else if (!memcmp (buff, "ECHO_SERVER", 11))
			{
				EchoSrv = atoi(pnt);
			}
			else if (!memcmp (buff, "AUTOENTRY_SERVER", 16))
			{
				AutoEntry = atoi(pnt);
			}
			else if (!memcmp (buff, "AUDIO_SENDER_CALLSIGN", 21))
			{
				memset (AudioSenderCallsign, 0x20, 8);
				memcpy (AudioSenderCallsign, pnt, strlen(pnt));
			}
			else if (!memcmp (buff, "ECHO_SENDER_CALLSIGN", 20))
			{
				memset (EchoSenderCallsign, 0x20, 8);
				memcpy (EchoSenderCallsign, pnt, strlen(pnt));
			}
			else if (!memcmp (buff, "AUTOENTRY_SENDER_CALLSIGN", 25))
			{
				memset (AutoEntrySenderCallsign, 0x20, 8);
				memcpy (AutoEntrySenderCallsign, pnt, strlen(pnt));
			}
			else if (!memcmp (buff, "TRUST_ZR_CALLSIGN", 17))
			{
				memset (TrustZrCallsign, 0x20, 8);
				memcpy (TrustZrCallsign, pnt, strlen(pnt));
				TrustZrCallsign[7] = 0x20;
			}
			else if (!memcmp (buff, "TRUST_AR_CALLSIGN", 17))
			{
				memset (TrustArCallsign, 0x20, 8);
				memcpy (TrustArCallsign, pnt, strlen(pnt));
			}
			else if (!memcmp (buff, "TRUST_IP_ADDRESS", 16))
			{
				memset (TrustIpAddress, 0x00, 16);
				memcpy (TrustIpAddress, pnt, strlen(pnt));
			}
		}
	}

	fclose (config_file);
	
}
