#pragma once

#include "CD3DApplication.h"
#include "FDKError.h"

namespace FDK {
	namespace Graphics {
		
enum LOADPLACE {
	LOADTO_VIDEO,				// VIDEO MEMORY ɍ쐬AsG[B
	LOADTO_SYSTEM,				// SYSTEM MEMORY ɍ쐬AsG[B
	LOADTO_VIDEO_OR_SYSTEM,		// VIDEO MEMORY ɍ쐬As SYSTEM MEMORY ɍ쐬AɎsG[B
	LOADTO_NULL

	// ӁF
	// (1) T[tFCXȂׂ VIDEO ɍׂiLOADTO_SYSTEM gƕ\N\dȂO{iATI ALL-IN-WONDER128ȂǁjjA
	//     T[tFCXɂ̓eNX`̂悤ȎǗ@\͂Ȃ߁A܂ VIDEO LƃeNX`̊pł VIDEO ̂
	// @@oXl邱ƁB
	// @@rfIȂꍇAeNX`͂̎c菭Ȃ̈ł܂킳Ȃ΂ȂȂȂB
	// (2) CSurface  Blt 邽߂̃T[tFCX͕K LOADTO_VIDEO ō쐬邱ƁB(SYSTEMs)
};

class CSurface
{
public:
	// T[tFCX쐬̂߂̏ݒ(1)B
	// ł̓T[tFCX OATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	void InitDeviceObjects( LPCTSTR name, DWORD width, DWORD height, LOADPLACE place=LOADTO_VIDEO_OR_SYSTEM, LPDDPIXELFORMAT pFormat=NULL );

	// T[tFCX쐬̂߂̏ݒ(2)B
	// ł̓T[tFCX OAt@CATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	void InitDeviceObjectsFromFile( LPCTSTR name, LPCTSTR filename, DWORD width=0, DWORD height=0, LOADPLACE place=LOADTO_VIDEO_OR_SYSTEM, LPDDPIXELFORMAT pFormat=NULL );

	// t@CT[tFCX쐬邽߂̏ݒB
	// ł̓T[tFCX OAf[^Af[^TCYATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	void InitDeviceObjectsFromMemory( LPCTSTR name, BYTE* pData, DWORD dwDataSize, DWORD width=0, DWORD height=0, LOADPLACE place=LOADTO_VIDEO_OR_SYSTEM, LPDDPIXELFORMAT pFormat=NULL );

	// \[XT[tFCX쐬邽߂̏ݒB
	// ł̓T[tFCX OAf[^Af[^TCYATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	void InitDeviceObjectsFromResource( LPCTSTR name, LPCTSTR lpResourceName, LPCTSTR lpResourceType, DWORD width=0, DWORD height=0, LOADPLACE place=LOADTO_VIDEO_OR_SYSTEM, LPDDPIXELFORMAT pFormat=NULL );

	// T[tFCX̓ǂݍ݂ƍ\zB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjects();

	HRESULT	InvalidateDeviceObjects();		// T[tFCX̖iԂ͈ێj
	HRESULT	DeleteDeviceObjects();			// T[tFCX̔j

	void	SetAlphaConst( int a );			// Œ胿l̓o^ia = 0`255j
	HRESULT	SetColorKey();					// ̐FJ[L[ɐݒ肷
	HRESULT	SetColorKey( DWORD dwColor );	// wFJ[L[ɐݒ肷
	void	ColorKeyEnable( bool f=true )	{ this->bColorKeyEnable = f; }		// J[L[ ON/OFFBtrue  ONB
	HRESULT GetDC( HDC *phdc );				// foCXReLXg̎擾
	HRESULT ReleaseDC( HDC &hdc );			// foCXReLXg̉
	HRESULT Clear( LPRECT prc=NULL );		// T[tFCX̃NA
	
	// wT[tFCXւ̕`(1)
	// Appx: CTexture::m_pTexture ֕`悷ꍇ́ACSurface  LOADTO_VIDEO ł邱ƁB
	// @@@(Blt ͓tH[}bgłȂƓ]łȂۂBDD_OK ͕ԂBj
	HRESULT Draw( LPDIRECTDRAWSURFACE7 pDest, int x, int y, LPCRECT pSrc=NULL );
	
	// wT[tFCXւ̕`(2)
	// Appx: CTexture::m_pTexture ֕`悷ꍇ́ACSurface  LOADTO_VIDEO ł邱ƁB
	// @@@(Blt ͓tH[}bgłȂƓ]łȂۂBDD_OK ͕ԂBj
	HRESULT Draw( int x, int y, LPCRECT pSrc=NULL )	{
		return Draw( CD3DApplication::pddsBackBuffer, x, y, pSrc );
	}
	
	// wT[tFCXւ̕`(3)
	// Appx: CTexture::m_pTexture ֕`悷ꍇ́ACSurface  LOADTO_VIDEO ł邱ƁB
	// @@@(Blt ͓tH[}bgłȂƓ]łȂۂBDD_OK ͕ԂBj
	HRESULT Draw( CSurface *pDest, int x, int y, LPRECT pSrc=NULL ) {
		return Draw( pDest->pSurface, x, y, pSrc );
	}
	
	// m_nAlphaConst(<255) 𔽉f`i\tgjB
	// ]悪At@ꍇieNX`ȂǁjA]̃At@
	// ɍőlƂȂAFl̕ m_nAlphaConst fB
	// ]悪 24bit ̏ꍇ́AAt@ĂĂT|[g͂ȂB
	HRESULT BlendDraw( LPDIRECTDRAWSURFACE7 pDest, int x, int y, LPCRECT pSrc=NULL );

	// T[tFCXւ̕`(1)
	HRESULT	Text( int x, int y, HFONT hFont, LPCTSTR str, COLORREF color=RGB(255,255,255) );

	// T[tFCXւ̕`(2)
	HRESULT	Text( int x, int y, HFONT hFont, tstring &str, COLORREF color=RGB(255,255,255) ) {
		return Text(x,y,hFont,str.c_str(),color);
	}
	// T[tFCXւ̕`ɕKvȕihbgjԂ
	int	GetTextWidthDot( HFONT hFont, LPCTSTR str );

	// T[tFCXւ̕`(3)A`GCAXt
	// tHg͖ʐςS{̑傫̂̂w肷邱ƁI
	HRESULT	TextSharp( int x, int y, HFONT hFont, LPCTSTR str, COLORREF color=RGB(255,255,255) );

	// T[tFCXTCY̎擾
	DWORD GetSurfaceSize();

	CSurface();
	virtual ~CSurface();

public:
	LPDIRECTDRAWSURFACE7	pSurface;

	int				nAlphaConst;			// At@li萔 0`255j
	DWORD			dwWidth;				// T[tFCX̕
	DWORD			dwHeight;				// T[tFCX̍
	LOADPLACE		place;					// T[tFCX̔zuꏊ
	bool			bColorKeyEnable;		// J[L[LȂ true
	DWORD			dwColorKey;				// J[L[(32bit)
	tstring			strSurfaceName;			// T[tFCXiCӁj
	tstring			strFileName;			// t@Cit@CȂȂ "" j
	LPCTSTR			lpResourceName;			// \[Xi\[XȂȂ NULLj
	LPCTSTR			lpResourceType;			// \[X^Cvi\[XȂȂ NULLj
	BYTE*			pData;					// f[^ւ̃|C^i̐ȂȂNULLj
	DWORD			dwDataSize;				// f[^TCYi̐ȂȂ0j
	DDPIXELFORMAT	ddpfReference;			// Creatẽt@XtH[}bg

protected:
	// T[tFCX̖OAt@CATCYAzuꏊɋLB
	// ̑̃p[^̓ftHglɏB
	void	InitParameters( LPCTSTR name, LPCTSTR fname, LPCTSTR lpResourceName, LPCTSTR lpResourceType, BYTE* pData, DWORD dwDataSize, DWORD width, DWORD height, LOADPLACE place, LPDDPIXELFORMAT pFormat );

	// t@C̃T[tFCX̓ǂݍ݂ƍ\zB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromFile();

	// C[W̃T[tFCX̓ǂݍ݂ƍ\zB
	//  PNG ̂ݑΉ
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromFileInMemory();

	// \[X̃T[tFCX̓ǂݍ݂ƍ\zB
	//  PNG ̂ݑΉB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromResource();

	// rbg}bv hBitmap T[tFCX\zB
	HRESULT	RestoreFromBitmap( HBITMAP hBitmap );

	// JPEG/PNG f[^T[tFCX\zB
	HRESULT	RestoreFromBitmap( BITMAPINFO* pbinfo, BYTE* pbdata );

	// ̃T[tFCX̍쐬G
	// TCYim_dwWidth ~ m_dwHeightj̋̃T[tFCX쐬B
	HRESULT Create();

	void	BlendDraw16to16( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw16to24( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw16to32( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw24to16( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw24to24( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw24to32( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw32to16( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw32to24( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	BlendDraw32to32( LPDDSURFACEDESC2 pddsdSrc, LPCRECT prcSrc, LPDDSURFACEDESC2 pddsdDst, int x, int y );
	void	CopyFromBMP32x4( int x, int y, BITMAP* bmp, bool bSkipBlack );

	DWORD	BitCount( DWORD dwNum );		// dwNum ̃rbg'1'̐𐔂B
	DWORD	ShiftCount( DWORD dwNum );		// dwNum LSB0̑ԂBiF0x0020  5j

	void	LostCheck();		// T[tFCXXgĂ RestoreDeviceObject()ĂяoB
};

	}//Graphics
}//FDK

using namespace FDK::Graphics;
