#pragma once

#include "CTexture.h"

namespace FDK {
	namespace Graphics {

class CTextureManager
{
public:
	// LbV̎gptÕZbg
	void ResetCache();
	
	// LbVꂽeNX`ԂB
	// ԂꂽeNX`́ARestoreDeviceObjects() ܂ŊĂԁB
	CTexture* GetCachedTexture( LPCTSTR name, LPCTSTR filename, DWORD width=0, DWORD height=0 );

	// LbV̖gpeNX`̍폜
	void RemoveUnusedTextures();

	HRESULT	OneTimeSceneInit();						// Xg̏
	HRESULT	InitDeviceObjects();					// Xg̊eeNX`̏
	HRESULT	RestoreDeviceObjects();					// Xg̊eeNX`̍\z
	HRESULT	InvalidateDeviceObjects();				// Xg̊eeNX`̖
	HRESULT	DeleteDeviceObjects();					// Xg̊eeNX`̔j
	HRESULT	FinalCleanup();							// Xg̔j

public:
	CTextureManager();
	virtual ~CTextureManager() {};

protected:
	struct TextureList {
		bool		bUse;							// gpȂ true
		TCHAR		strTextureName[ _MAX_PATH ];	// eNX`
		TCHAR		strFileName[ _MAX_PATH ];		// t@C
		DWORD		width, height;					// TCY
		FILETIME	ftLastWriteTime;				// ŏIXV
		CTexture	texture;						// eNX`
		TextureList	*prev, *next;					// O^̃Z
	} *pTextureList, *pTextureListLast;
};

	}//Graphics
}//FDK

using namespace FDK::Graphics;
