#include "stdafx.h"
#include "ActPlayBGA.h"
#include "DTX.h"
#include "DTXViewer.h"
#include "CTimer.h"

namespace DTXViewer {
	namespace Stage {
		namespace Play {

static const int s_nChannel[8] = {
	0x04, 0x07, 0x55, 0x56, 0x57, 0x58, 0x59, 0x60,
};

ActPlayBGA::ActPlayBGA()
{
	this->bFirstWork = true;
	this->bActivate = false;
}

bool ActPlayBGA::MyOneTimeSceneInit()
{
	// ɃR[hLqBAddChild() ȂǁB

	return Activity::MyOneTimeSceneInit();
}
bool ActPlayBGA::MyFinalCleanup()
{
	// ɃR[hLqB

	return Activity::MyFinalCleanup();
}
bool ActPlayBGA::MyInitDeviceObjects()
{
	// ɃR[hLqBCTexture/CSurface::InitDeviceObjects() ȂǁB

	return Activity::MyInitDeviceObjects();
}
bool ActPlayBGA::MyDeleteDeviceObjects()
{
	// ɃR[hLqB

	//  Activity::MyDeleteDeviceObjects() ł́AqeNX`EqT[tFCX Delete (CTexture/CSurface::Delete) sB
	return Activity::MyDeleteDeviceObjects();
}
bool ActPlayBGA::MyActivate()
{
	this->bFirstWork = true;
	// ɃR[hLqB
	for( int i = 0; i < 8; i++ ) {
		this->structLayer[i].pBMP = NULL;
		this->structLayer[i].pBMPTEX = NULL;
		this->structLayer[i].dbړJnms = INIT_TIME;
	}

	//  Activity::MyActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Restore (MyRestoreDeviceTexture/Surface) sB
	// ȂAq Activity ͍̊sȂBĩ\bh𔲂ĂsBj
	return Activity::MyActivate();
}
bool ActPlayBGA::MyUnActivate()
{
	// ɃR[hLqB

	//  Activity::MyUnActivate() ł́Athis->bActivity ̃ZbgȂтɎqT[tFCXEqeNX` Invalidate (MyInvalidateDeviceObjects) sB
	// ȂAqActivity ̔񊈐͍sȂBĩ\bh𔲂ĂsBj
	return Activity::MyUnActivate();
}
bool ActPlayBGA::MyRestoreDeviceTextures()
{
	// ɃR[hLqB

	//  Activity::MyRestoreDeviceTextures() ł́AqeNX` Restore (CTexture::Restore) sB
	return Activity::MyRestoreDeviceTextures();
}
bool ActPlayBGA::MyRestoreDeviceSurfaces()
{
	// ɃR[hLqB

	//  Activity::MyRestoreDeviceSurfaces() ł́AqT[tFCX Restore (CSurface::Restore) sB
	return Activity::MyRestoreDeviceSurfaces();
}
bool ActPlayBGA::MyInvalidateDeviceObjects()
{
	// ɃR[hLqB

	//  Activity::MyInvalidateDeviceObjects() ł́AqeNX`EqT[tFCX Invalidate (CTexture/CSurface::Invalidate) sB
	return Activity::MyRestoreDeviceSurfaces();
}
//
void ActPlayBGA::Start( int n`l, DTX::BMP *bmp, DTX::BMPTEX* bmptex, int nJnTCYW, int nJnTCYH, int nITCYW, int nITCYH, int n摜JnʒuX, int n摜JnʒuY, int n摜IʒuX, int n摜IʒuY, int n\JnʒuX, int n\JnʒuY, int n\IʒuX, int n\IʒuY, double dbړms, double dbړJnms )
{
	// `l`FbN
	for( int i = 0; i < 8; i++ )
	{
		if( n`l == s_nChannel[i] )
		{
			// Zɒlݒ												BMP/BMPTEX	BGA		BGAPAN
			this->structLayer[i].pBMP				= bmp;				//						
			this->structLayer[i].pBMPTEX			= bmptex;			//						
			this->structLayer[i].szJnTCY.cx	= nJnTCYW;		//						
			this->structLayer[i].szJnTCY.cy	= nJnTCYH;		//						
			this->structLayer[i].szITCY.cx	= nITCYW;		//		--		--		
			this->structLayer[i].szITCY.cy	= nITCYH;		//		--		--		
			this->structLayer[i].pt摜Jnʒu.x	= n摜JnʒuX;	//		--				
			this->structLayer[i].pt摜Jnʒu.y	= n摜JnʒuY;	//		--				
			this->structLayer[i].pt摜Iʒu.x	= n摜IʒuX;	//		--		--		
			this->structLayer[i].pt摜Iʒu.y	= n摜IʒuY;	//		--		--		
			this->structLayer[i].pt\Jnʒu.x	= n\JnʒuX;	//		--				
			this->structLayer[i].pt\Jnʒu.y	= n\JnʒuY;	//		--				
			this->structLayer[i].pt\Iʒu.x	= n\IʒuX;	//		--		--		
			this->structLayer[i].pt\Iʒu.y	= n\IʒuY;	//		--		--		
			this->structLayer[i].dbړms		= dbړms;	//		--		--		
			this->structLayer[i].dbړJnms	= (dbړJnms != INIT_TIME) ? dbړJnms : g_Timer.Get();
		}
	}
}
void ActPlayBGA::SkipStart( double dbړJnms )
{
	for( DTX::Chip* cell = g_DTX.pChip; cell != NULL; cell = cell->next )
	{
		// JnȂÃ`bvŒł؂B
		if( cell->dbTime > dbړJnms ) 
			break;

		// BMP, BMPTEX, BGA, BGAPAN ȂĐw
		switch( cell->BGAtype )
		{

		case BGATYPE_BMP:
			if( cell->pBMP )
				Start( cell->nChannel, cell->pBMP, NULL,
					   cell->pBMP->pSurface->dwWidth, cell->pBMP->pSurface->dwHeight, 0, 0,
					   0, 0, 0, 0,
					   0, 0, 0, 0, 0, cell->dbTime );
			break;

		case BGATYPE_BMPTEX:
			if( cell->pBMPTEX )
				Start( cell->nChannel, NULL, cell->pBMPTEX,
					   cell->pBMPTEX->pTexture->dwWidth, cell->pBMPTEX->pTexture->dwHeight, 0, 0,
					   0, 0, 0, 0,
					   0, 0, 0, 0, 0, cell->dbTime );
			break;

		case BGATYPE_BGA:
			if( cell->pBGA )
				Start( cell->nChannel, cell->pBMP, cell->pBMPTEX,
					   cell->pBGA->x2 - cell->pBGA->x1, cell->pBGA->y2 - cell->pBGA->y1, 0, 0, 
					   cell->pBGA->x1, cell->pBGA->y1, 0, 0,
					   cell->pBGA->ox, cell->pBGA->oy, 0, 0, 0, cell->dbTime );
			break;

		case BGATYPE_BGAPAN:
			if( cell->pBGAPan )
				Start( cell->nChannel, cell->pBMP, cell->pBMPTEX,
						cell->pBGAPan->sw, cell->pBGAPan->sh, cell->pBGAPan->ew, cell->pBGAPan->eh,
						cell->pBGAPan->ssx, cell->pBGAPan->ssy, cell->pBGAPan->sex, cell->pBGAPan->sey,
						cell->pBGAPan->dsx, cell->pBGAPan->dsy, cell->pBGAPan->dex, cell->pBGAPan->dey,
						cell->dbLong, cell->dbTime );
			break;
		}
	}
}
void ActPlayBGA::Stop()
{
	for( int i = 0; i < 8; i++ )
		this->structLayer[i].dbړJnms = INIT_TIME;
}
void ActPlayBGA::Cont( double dbĊJms )
{
	for( int i = 0; i < 8; i++ )
	{
		if(  ( this->structLayer[i].pBMP    == NULL && this->structLayer[i].pBMPTEX == NULL ) 
		  || ( this->structLayer[i].pBMP    != NULL && ( ! this->structLayer[i].pBMP->bUse    || this->structLayer[i].pBMP->pSurface    == NULL ) )
		  || ( this->structLayer[i].pBMPTEX != NULL && ( ! this->structLayer[i].pBMPTEX->bUse || this->structLayer[i].pBMPTEX->pTexture == NULL ) ) )
			continue;

		this->structLayer[i].dbړJnms = dbĊJms;
	}
}
void ActPlayBGA::ChangeScope( int n`l, DTX::BMP* bmp, DTX::BMPTEX* bmptex )
{
	// `l`FbN
	for( int i = 0; i < 8; i++ )
	{
		if( n`l == s_nChannel[i] )
		{
			// Zɒlݒ(bmp, bmptex ̂)
			this->structLayer[i].pBMP		= bmp;
			this->structLayer[i].pBMPTEX	= bmptex;
		}
	}
}
int  ActPlayBGA::MainWork( int x, int y )
{
	for( int i = 0; i < 8; i++ )
	{
		// gpȂXLbv
		if( this->structLayer[i].dbړJnms == INIT_TIME
			|| ( this->structLayer[i].pBMP    == NULL && this->structLayer[i].pBMPTEX == NULL ) 
			|| ( this->structLayer[i].pBMP    != NULL && ( ! this->structLayer[i].pBMP->bUse    || this->structLayer[i].pBMP->pSurface    == NULL ) )
			|| ( this->structLayer[i].pBMPTEX != NULL && ( ! this->structLayer[i].pBMPTEX->bUse || this->structLayer[i].pBMPTEX->pTexture == NULL ) ) )
			continue;

		// p[^oEZo
		SIZE	szJnTCY		= this->structLayer[i].szJnTCY;
		SIZE	szITCY		= this->structLayer[i].szITCY;
		POINT	pt摜Jnʒu	= this->structLayer[i].pt摜Jnʒu;
		POINT	pt摜Iʒu	= this->structLayer[i].pt摜Iʒu;
		POINT	pt\Jnʒu	= this->structLayer[i].pt\Jnʒu;
		POINT	pt\Iʒu	= this->structLayer[i].pt\Iʒu;
		double	dbړms		= this->structLayer[i].dbړms;
		double	dbړJnms	= this->structLayer[i].dbړJnms; if( g_Timer.Get() < dbړJnms ) dbړJnms = g_Timer.Get();
		SIZE	szBGATCY			= { BGA_W, BGA_H };
		SIZE	szBMPTCY			= { (this->structLayer[i].pBMP) ? this->structLayer[i].pBMP->pSurface->dwWidth  : this->structLayer[i].pBMPTEX->pTexture->dwImageWidth,
										(this->structLayer[i].pBMP) ? this->structLayer[i].pBMP->pSurface->dwHeight : this->structLayer[i].pBMPTEX->pTexture->dwImageHeight };

		double	dbݎms		= ( g_Timer.Get() - dbړJnms ) * g_DTX.fSpeed;	// Jňoߎ[ms]

		// I (dbړms==0 ̂Ƃ͏IȂj
		if( dbړms != 0.0 && dbړms < dbݎms )
		{
			this->structLayer[i].pt摜Jnʒu = pt摜Jnʒu = pt摜Iʒu;
			this->structLayer[i].pt\Jnʒu = pt\Jnʒu = pt\Iʒu;
			this->structLayer[i].szJnTCY     = szJnTCY     = szITCY;
			this->structLayer[i].dbړms	  = dbړms   = 0.0;
			//dbړJnnms	= this->structLayer[i].dbړJnms = INIT_TIME;		^C}烌C̃XLbv邩_
		}

		/////////////
		// ݎ摜̈ƕ\̈vZ

		RECT rc摜̈;		// 摜̍オ 0, 0
		RECT rc\̈;		// BGÄ̍オ 0, 0

		if( dbړms == 0.0 )
		{
			// JnʒuEJnTCYƕێ
			rc摜̈.left   = pt摜Jnʒu.x;
			rc摜̈.top    = pt摜Jnʒu.y;
			rc摜̈.right  = rc摜̈.left + szJnTCY.cx;
			rc摜̈.bottom = rc摜̈.top  + szJnTCY.cy;
			
			rc\̈.left   = pt\Jnʒu.x;
			rc\̈.top    = pt\Jnʒu.y;
			rc\̈.right  = rc\̈.left + szJnTCY.cx;
			rc\̈.bottom = rc\̈.top  + szJnTCY.cy;
		}
		else
		{
			// db; JnI ̂Ƃ 0.0  1.0
			double db = dbݎms / dbړms;
		
			// ݂̃TCYi摜E\ʁj
			SIZE sz݂̃TCY = {
				szJnTCY.cx + (LONG)( ( szITCY.cx - szJnTCY.cx ) * db ),
				szJnTCY.cy + (LONG)( ( szITCY.cy - szJnTCY.cy ) * db )
			};

			// ]̈
			rc摜̈.left   = pt摜Jnʒu.x + (LONG)( ( pt摜Iʒu.x - pt摜Jnʒu.x ) * db );
			rc摜̈.top    = pt摜Jnʒu.y + (LONG)( ( pt摜Iʒu.y - pt摜Jnʒu.y ) * db );
			rc摜̈.right  = rc摜̈.left + sz݂̃TCY.cx;
			rc摜̈.bottom = rc摜̈.top  + sz݂̃TCY.cy;

			// ]̈
			rc\̈.left   = pt\Jnʒu.x + (LONG)( ( pt\Iʒu.x - pt\Jnʒu.x ) * db );
			rc\̈.top    = pt\Jnʒu.y + (LONG)( ( pt\Iʒu.y - pt\Jnʒu.y ) * db );
			rc\̈.right  = rc\̈.left + sz݂̃TCY.cx;
			rc\̈.bottom = rc\̈.top  + sz݂̃TCY.cy;
		}

		// ]ȂȂXLbv@ NbsOO
		if( rc摜̈.right <= 0 || rc摜̈.bottom <= 0 || rc摜̈.left >= szBMPTCY.cx || rc摜̈.top >= szBMPTCY.cy ) continue;
		if( rc\̈.right <= 0 || rc\̈.bottom <= 0 || rc\̈.left >= szBGATCY.cx || rc\̈.top >= szBGATCY.cy ) continue;

		// NbsO@ ]
		if( rc摜̈.left < 0 )	{ rc\̈.left += -rc摜̈.left; rc摜̈.left = 0; }
		if( rc摜̈.top  < 0 )	{ rc\̈.top  += -rc摜̈.top;  rc摜̈.top  = 0; }
		if( rc摜̈.right  > szBMPTCY.cx ) { rc\̈.right  -= rc摜̈.right  - szBMPTCY.cx; rc摜̈.right  = szBMPTCY.cx; }
		if( rc摜̈.bottom > szBMPTCY.cy ) { rc\̈.bottom -= rc摜̈.bottom - szBMPTCY.cy; rc摜̈.bottom = szBMPTCY.cy; }

		// NbsOA ]
		if( rc\̈.left < 0 ) { rc摜̈.left += -rc\̈.left; rc\̈.left = 0; }
		if( rc\̈.top  < 0 ) { rc摜̈.top  += -rc\̈.top;  rc\̈.top  = 0; }
		if( rc\̈.right  > szBGATCY.cx ) { rc摜̈.right  -= rc\̈.right  - szBGATCY.cx; rc\̈.right  = szBGATCY.cx; }
		if( rc\̈.bottom > szBGATCY.cy ) { rc摜̈.bottom -= rc\̈.bottom - szBGATCY.cy; rc\̈.bottom = szBGATCY.cy; }

		// ]ȂȂXLbvA NbsO
		if( rc摜̈.left >= rc摜̈.right || rc摜̈.top >= rc摜̈.bottom ) continue;
		if( rc\̈.left >= rc\̈.right || rc\̈.top >= rc\̈.bottom ) continue;
		if( rc摜̈.right < 0 || rc摜̈.bottom < 0 || rc摜̈.left > szBMPTCY.cx || rc摜̈.top > szBMPTCY.cy ) continue;
		if( rc\̈.right < 0 || rc\̈.bottom < 0 || rc\̈.left > szBGATCY.cx || rc\̈.top > szBGATCY.cy ) continue;

		// Z^ÓABGAPAN ł͈ӖȂiĵŔp~(2003/03/02)

		// `
		if( this->structLayer[i].pBMP )
		{
			this->structLayer[i].pBMP->pSurface->ColorKeyEnable( (i == 0) ? false : (g_DTX.bBlackColorKey ? true : false) );	// ŉwC͓߂Ȃ
			this->structLayer[i].pBMP->pSurface->Draw( x + rc\̈.left, y + rc\̈.top, &rc摜̈ );
		}
		else if( this->structLayer[i].pBMPTEX )
		{
			this->structLayer[i].pBMPTEX->pTexture->Draw( x + rc\̈.left, y + rc\̈.top, &rc摜̈ );
		}
	}
	return 0;
}

		}//Play
	}//Stage
}//DTXViewer
