#include "stdafx.h"
// FDK includes
#include "Activity.h"
#include "Debug.h"
#include "FDKError.h"
#include "CTimer.h"
#include "CSoundManager.h"
#include "CDirectInput.h"
#include "CTexture.h"
// DTXViewer includes
#include "../resource.h"
#include "DTXViewer.h"
#include "Version.h"
#include "DirectXVersion.h"
#include "CD3DMyApplication.h"
#include "CStagePlay.h"

namespace DTXViewer {
	namespace General {

static CD3DMyApplication* s_pApp = NULL;
LRESULT CALLBACK MyWndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	if( s_pApp ) return s_pApp->WndProc( hWnd, uMsg, wParam, lParam );
	return 0;
}
//
CD3DMyApplication::CD3DMyApplication() : CD3DApplication()
{
	s_pApp = this;
}
HRESULT	CD3DMyApplication::Create( HINSTANCE hInst, LPCTSTR strCmdLine )
{
	this->hInstance		= hInst;

	// ̓o^
	{
		this->bSʃ[h			= false;
		this->nWidth				= 640;
		this->nHeight				= 480;
		this->nBpp					= ( g_bFullcolor ) ? 32 : 16;
		this->bA			= false;
		this->dw`Ԋu			= 2;
		this->strWindowTitle		= _T("DTXViewer" VERSION );
		this->strWindowClass		= _T("DTXVIEWERCLASS" );
		this->dwEBhEX^C	= WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_VISIBLE | WS_MINIMIZEBOX;
	}
	//
	// EBhE̐VK
	{
		WNDCLASS wndClass = {
			0, MyWndProc, 0, 0, hInst,
			LoadIcon( this->hInstance, MAKEINTRESOURCE( IDI_DTXVIEWER ) ),
			LoadCursor( NULL, IDC_ARROW ),
			(HBRUSH)GetStockObject( WHITE_BRUSH ),
			NULL, this->strWindowClass
		};
		RegisterClass( &wndClass );

		RECT rc = { 0, 0, this->nWidth, this->nHeight };
		::AdjustWindowRect( &rc, this->dwEBhEX^C, FALSE );

		this->hWnd = CreateWindow(
			this->strWindowClass, this->strWindowTitle,
			(this->bSʃ[h) ? this->dwSʃX^C : this->dwEBhEX^C, 
			CW_USEDEFAULT, CW_USEDEFAULT,
			(rc.right-rc.left), (rc.bottom-rc.top), 0L,
			NULL, hInst, 0L );	

		if( this->hWnd == NULL ) {
			Debug::Msg( _T("Error: CEBhE̍쐬Ɏs܂B(%08x)\n"), GetLastError() );
			return E_FAIL;
		}
	}
	//
	// DirectX ^C̃o[W`FbN
	{
		DirectXVersion	dxver;

		dxver.tDirectX̃o[W擾();
		if( dxver.dwMajor < 7 ) {
			Debug::MsgDialog( this->hWnd, _T("DTXViewer runtime error"), _T("Error: DTXViewer ̎sɂ́ADirectX 7.0a ȏ̃^CCuKvłB\n") );
			return E_FAIL;
		}
	}
	//
	// eNX̌Ăяo
	{
		HRESULT hr;
		if( FAILED( hr = CD3DApplication::Create( hInst, strCmdLine ) ) )
			return hr;
	}
	//
	// ŏ̃Xe[W̐ݒ;
	// LCreate()ŃgbvxActivity  RestoreDeviceObjects܂Ŋ̂ŁA
	// ł悤₭gbvxActivityiŏ̃Xe[Wj Activate łB
	{
		g_StagePlay.Activate();
		g_Timer.Flush();
	}
	return S_OK;
}
HRESULT CD3DMyApplication::OneTimeSceneInit()
{
	HRESULT hr;

	this->btJnɃEBhEOʂɎĂ = true;

	// ̏
	{
		srand( (unsigned) time( NULL ) );
	}
	//
	// ^C}̏;
	// CD3DApplication ̐ CD3CMyApplication::timer  Init() Ă܂Ă̂ŁA
	// ^C}ʂw肷邽߂ɁAx Term()  Init() ȂB
	{
		g_Timer.Term();
		g_Timer.Init( TIMERTYPE_TIMEGTTIME );
	}
	//
	// DirectInput ̏
	{
		if( FAILED( hr = g_DirectInput.Init( this->hWnd ) ) )
		{
			Debug::Msg( _T("Error: DirectInput ̏Ɏs܂B(%s)\n"), HRMSG(hr) );
			return hr;
		}
	}
	//
	// gbvxActivity ̓o^Ə
	{
		this->actTopLevel.AddChild( &g_StagePlay );
		this->actTopLevel.OneTimeSceneInit();
	}
	//
	return S_OK;
}
HRESULT CD3DMyApplication::FinalCleanup()
{
	// gbvxActivity ̏I
	{
		this->actTopLevel.FinalCleanup();
	}
	//
	// DirectInput ̏I
	{
		g_DirectInput.Term();
	}
	//
	// ^C}̏I
	{
		g_Timer.Term();
	}
	//
	return S_OK;
}
HRESULT CD3DMyApplication::InitDeviceObjects()
{
	// eNX`tH[}bg̎OO擾
	CTexture::EnumTextureFormats();

	// gbvx Activity ̃foCXˑIuWFNg̏
	this->actTopLevel.InitDeviceObjects();

	return S_OK;
}
HRESULT CD3DMyApplication::DeleteDeviceObjects()
{
	// gbvx Activity ̃foCXˑIuWFNg̔j
	this->actTopLevel.DeleteDeviceObjects();

	return S_OK;
}
HRESULT CD3DMyApplication::RestoreDeviceObjects()
{
	// gbvx Activity ̃foCXˑIuWFNg̍\z
	this->actTopLevel.RestoreDeviceTextures();
	this->actTopLevel.RestoreDeviceSurfaces();
	
	return S_OK;
}
HRESULT CD3DMyApplication::InvalidateDeviceObjects()
{
	// gbvx Activity ̃foCXˑIuWFNg̉
	this->actTopLevel.InvalidateDeviceObjects();

	return S_OK;
}

//
LRESULT CD3DMyApplication::WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	// Kv΂ɃbZ[WnhOR[hǉB
	switch( uMsg )
	{
	case WM_COPYDATA:
		{
			if( g_bAction )		// ɃANV҂Ȃɂ
				Action();

			COPYDATASTRUCT* pcds = (COPYDATASTRUCT*) lParam;		// M g_strCmdLine ɃRs[
			lstrcpyn( g_strCmdLine, (LPCTSTR)pcds->lpData, COMLINESIZE );
			//SetWindowPos( m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE );	// EBhEőOʂ
			//SetWindowPos( m_hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE );
			g_bAction = true;		// ANVs
			break;
		}

	case WM_SYSKEYDOWN:
		if( wParam == VK_F4 )	// Al4 + F4
			SendMessage( this->hWnd, WM_CLOSE, 0, 0 );
		return 0;

	case WM_CLOSE:
		break;	// break  ĐeNX̏
	}

	return CD3DApplication::WndProc( hWnd, uMsg, wParam, lParam );
}
//	
void	CD3DMyApplication::tobNT[tFCXNA()
{
	if( this->pddsBackBuffer == NULL )
		return;

	DDBLTFX ddbltfx;
	::ZeroMemory( &ddbltfx, sizeof( ddbltfx ) );
	ddbltfx.dwSize = sizeof( ddbltfx );
	ddbltfx.dwFillColor = 0;
	this->pddsBackBuffer->Blt( NULL, NULL, NULL, DDBLT_COLORFILL, &ddbltfx );
}
bool	CD3DMyApplication::Render()
{
	// ߂l: true:AvI, false:p

	// ԍXV
	g_Timer.Flush();
	g_DirectInput.Poll();

	// V[`
	CTexture::BeginScene();
	this->tobNT[tFCXNA();
	if( g_StagePlay.MainWork() == -1 )
	{
		g_StagePlay.UnActivate();
		CTexture::EndScene();
		return true;		// AvI
	}
	CTexture::EndScene();

	// ANV
	if( g_bAction )
		this->Action();

	return false;
}
//
void CD3DMyApplication::Action()
{
	Debug::Out( _T("M = [%s]\n"), g_strCmdLine );

	// Ԃ̏
	g_DTX.SetWAVCache( true );
	g_DTX.SetBMPCache( true );

	// R}hCXg
	struct CmdList {
		TCHAR	str[ _MAX_PATH ];
		CmdList	*prev, *next;
	} *cmdList, *cmdListLast, *cell;
	cmdList = cmdListLast = cell = NULL;

	Debug::Out( _T("M = [%s]\n"), g_strCmdLine );

	// g_strCmdList R}hCXgicmdListjɕĊi[B
	TCHAR* p = g_strCmdLine;
	while( *p != _T('\0') )
	{
		while( *p==_T(' ') || *p==_T('\t') )
			p++;

		// (1) IvV̏ꍇ
		if( *p == _T('-') )
		{
			cell = new CmdList();
			int i = 0;
			while( *p != _T(' ') && *p != _T('\t') && *p != _T('\0') )
				cell->str[i++] = *p++;
			cell->str[i] = _T('\0');
		}

		// (2) t@C̏ꍇ
		else
		{
			cell = new CmdList();
			int i = 0;
			while( *p != _T('\0') )
			{
				if( *p == _T('-') && i > 0 && (*(p-1) == _T(' ') || *(p-1) == _T('\t') ) ) 	// IvVI[
					break;
				cell->str[i++] = *p++;
			}
			while( i > 0 && ( cell->str[i-1] == _T(' ') || cell->str[i-1] == _T('\t') ) )
				i--;	// ̋󔒂͑S폜
			cell->str[i] = _T('\0');

			// _uNHe[V("...")ň͂܂Ăꍇ͂͂
			if( cell->str[0] == _T('\"') )
			{
				int i = 1;
				while( cell->str[i] != _T('\"') && cell->str[i] != _T('\0') ) {
					cell->str[i-1] = cell->str[i];
					i++;
				}
				cell->str[i-1] = _T('\0');
			}
		}

		// (1)(2)ǂXg֐ڑ
		cell->prev = cell->next = NULL;
		APPENDLIST( cmdList, cmdListLast, cell );

		Debug::Out( _T("MZ:u%sv\n"), cell->str );
	}

	//
	// Xg̒Ƀt@C΂ g_strFileName ɃRs[B
	// t@Cꍇ́Aŏ̎ŵݗLƂB
	for( cell = cmdList; cell != NULL; cell=cell->next )
	{
		if( cell->str[0] != _T('-') )
		{
			lstrcpyn( g_strFileName, cell->str, _MAX_PATH );
			break;	// ŏ̂̂LB
		}
	}

	//
	// Xg̃IvVԂɃ}[NB
	bool btJn = false;
	int  ntJnʒu = -1;
	for( cell = cmdList; cell != NULL; cell=cell->next )
	{
		switch( cell->str[1] )
		{

		//////////////////
		// -N[num] c num߂̍ĐJn

		case _T('N'):
		case _T('n'): {
			
			// num ̎擾
			TCHAR* p = cell->str+2;
			int n = 1;
			while( *p == _T('-') ) { n *= -1; p++; }	// }CiXl
			ntJnʒu = atoi( p ) * n;
			btJn = true;	// ۂ̉t͂ switch 𔲂ƂŁcitOɑS̃IvV邽߁j
			break;
		}

		//////////////////
		// -S c Đ~
		case _T('S'):
		case _T('s'):
			g_StagePlay.Stop();
			break;

/*		//////////////////
		// -R c ĐĊJ		
		case _T('R'):
		case _T('r'):
			g_StagePlay.Replay();
			break;
*/
		//////////////////
		// -W[0|1] c WAVLbV
		//   -W0  WAVLbVOFF, ̑ ONBȗ -W1B
		case _T('W'):
		case _T('w'):
			g_DTX.SetWAVCache( ( cell->str[2] == _T('0') ) ? false : true );
			break;

		//////////////////
		// -B[0|1] c BMPLbV
		//   -B0  BMPLbVOFF, ̑ ONBȗ -B1B
		case _T('B'):
		case _T('b'):
			g_DTX.SetBMPCache( ( cell->str[2] == _T('0') ) ? false : true );
			break;

		//////////////////
		// -P[0|1]
		//   -P0 őOʂɂĂȂA-P1 łĂBȗ -P1B
		case _T('P'):
		case _T('p'):
			this->btJnɃEBhEOʂɎĂ = ( cell->str[2] == _T('0') ) ? false : true;
			break;

		default:
			break;
		}
	}
	//
	// tJnH
	if( btJn )
	{
		if( this->btJnɃEBhEOʂɎĂ )
			this->tEBhEOʂɂĂ();

		if( g_StagePlay.Load( g_strFileName ) )
			g_StagePlay.Play( ntJnʒu );
	}
	//
	// R}hCXg̉
	cell = cmdList;
	while( cell != NULL )
	{
		CmdList *next = cell->next;
		delete cell;
		cell = next;
	}

	// 
	g_bAction = false;
}
void	CD3DMyApplication::tEBhEOʂɂĂ()
{
	SetWindowPos( this->hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE );
	SetWindowPos( this->hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE );
}
	}//General
}//DTXViewer
