#include "stdafx.h"
#include "Activity.h"

namespace FDK {
	namespace AppBase {

Activity::Activity()
{
	this->bActivate = false;
	this->bFirstWork = true;
}

bool Activity::OneTimeSceneInit()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyOneTimeSceneInit();
	
	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( ! pa->OneTimeSceneInit() )
			bRet = false;
	}
	return bRet;
}

bool Activity::Activate()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyActivate();
	
	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( ! pa->Activate() )
			bRet = false;
	}
	return bRet;
}

bool Activity::UnActivate()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyUnActivate();
	
	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( !pa->UnActivate() )
			bRet = false;
	}
	return bRet;
}

bool Activity::FinalCleanup()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyFinalCleanup();
	
	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( !pa->FinalCleanup() )
			bRet = false;
	}
	return bRet;
}

bool Activity::InitDeviceObjects()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyInitDeviceObjects();

	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( !pa->InitDeviceObjects() )
			bRet = false;
	}
	return bRet;
}

bool Activity::RestoreDeviceTextures()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyRestoreDeviceTextures();

	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( !pa->RestoreDeviceTextures() )
			bRet = false;
	}
	return bRet;
}

bool Activity::RestoreDeviceSurfaces()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyRestoreDeviceSurfaces();

	// (2)qActivityW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( !pa->RestoreDeviceSurfaces() )
			bRet = false;
	}
	return bRet;
}

bool Activity::InvalidateDeviceObjects()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyInvalidateDeviceObjects();

	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( ! pa->InvalidateDeviceObjects() )
			bRet = false;
	}
	return bRet;
}

bool Activity::DeleteDeviceObjects()
{
	// {qWSɂāAG[oLĂB
	// G[łĂĂAĂяo͑SɂĂЂƒʂsB
	bool bRet = true;

	// (1)
	bRet = MyDeleteDeviceObjects();

	// (2)qW
	Activity* pa;
	this->Activities.resetList();
	while( ( pa = this->Activities.getNext() ) != NULL )
	{
		if( ! pa->DeleteDeviceObjects() )
			bRet = false;
	}
	return bRet;
}

bool Activity::MyActivate()
{
	if( this->bActivate )
		return true;		// łɊĂȂ牽Ȃ

	this->bActivate = true;		// MyResoreDeviceObjects() ̌ĂяȏOɐݒ

	bool bTex = MyRestoreDeviceTextures();
	bool bSur = MyRestoreDeviceSurfaces();
	if( ! bTex || ! bSur )		// G[oĂЂƒʂ肺ԉ
		this->bActivate = false;

	return this->bActivate;
}

bool Activity::MyUnActivate()
{
	if( ! this->bActivate )
		return true;		// ĂȂȂ牽Ȃ

	MyInvalidateDeviceObjects();

	this->bActivate = false;	// MyInvalidateDeviceObjects() ̌Ăяǒɐݒ
	return true;
}

bool Activity::MyRestoreDeviceTextures()
{
	if( ! this->bActivate )
		return true;		// ĂȂȂ牽Ȃ

	// qeNX`̍\z
	bool bRet = true;
	CTexture* pt;
	this->Textures.resetList();
	while( ( pt = this->Textures.getNext() ) != NULL )
	{
		if( FAILED( pt->RestoreDeviceObjects() ) )
			bRet = false;
	}
	return bRet;
}

bool Activity::MyRestoreDeviceSurfaces()
{
	if( ! this->bActivate )
		return true;		// ĂȂȂ牽Ȃ

	// qT[tFCX̍\z
	bool bRet = true;
	CSurface* ps;
	this->Surfaces.resetList();
	while( ( ps = this->Surfaces.getNext() ) != NULL )
	{
		if( FAILED( ps->RestoreDeviceObjects() ) )
			bRet = false;
	}
	return bRet;
}

bool Activity::MyInvalidateDeviceObjects()
{
	if( ! this->bActivate )
		return true;		// ĂȂȂ牽Ȃ

	bool bRet = true;

	// qeNX`̖
	CTexture* pt;
	this->Textures.resetList();
	while( ( pt = this->Textures.getNext() ) != NULL )
	{
		if( FAILED( pt->InvalidateDeviceObjects() ) )
			bRet = false;
	}

	// qT[tFCX̖
	CSurface* ps;
	this->Surfaces.resetList();
	while( ( ps = this->Surfaces.getNext() ) != NULL )
	{
		if( FAILED( ps->InvalidateDeviceObjects() ) )
			bRet = false;
	}

	return bRet;
}

bool Activity::MyDeleteDeviceObjects()
{
	bool bRet = true;

	// qeNX`̍폜
	CTexture* pt;
	this->Textures.resetList();
	while( ( pt = this->Textures.getNext() ) != NULL )
	{
		if( FAILED( pt->DeleteDeviceObjects() ) )
			bRet = false;
	}

	// qT[tFCX̍폜
	CSurface* ps;
	this->Surfaces.resetList();
	while( ( ps = this->Surfaces.getNext() ) != NULL )
	{
		if( FAILED( ps->DeleteDeviceObjects() ) )
			bRet = false;
	}

	return bRet;
}

	}//AppBase
}//FDK