#include "stdafx.h"
#include "CD3DDisplay.h"
#include "FDKError.h"

namespace FDK {
	namespace AppBase {

// Direct3D foCX񋓗p̃R[obN֐B
static HRESULT WINAPI DeviceEnumCallback( TCHAR* strDesc, TCHAR* strName, D3DDEVICEDESC7* pDesc, VOID* pContext )
{
	CD3DDisplay* app		= (CD3DDisplay*) pContext;
	D3DAdapterInfo* adapter	= app->pAdapter;
	D3DDeviceInfo* device	= adapter->pDevice;

	// foCXRs[B
	ZeroMemory( device, sizeof(D3DDeviceInfo) );
	device->guidDevice			= pDesc->deviceGUID;
	device->pDeviceGUID			= &device->guidDevice;
	device->bHardware			= (pDesc->dwDevCaps & D3DDEVCAPS_HWRASTERIZATION) ? true : false;
	memcpy( &device->ddDeviceDesc, pDesc, sizeof(D3DDEVICEDESC7) );
	if( adapter->pAdapterGUID )
		lstrcpyn( device->strDesc, adapter->strDesc, 39 );							// strDesc[]
	else
		lstrcpyn( device->strDesc, strName, 39 );
	if( device->bHardware )															// type
		device->type = ( device->guidDevice == IID_IDirect3DTnLHalDevice ) ? D3DAPPDEV_HALTnL : D3DAPPDEV_HAL;
	else
		device->type = ( device->guidDevice == IID_IDirect3DRefDevice ) ? D3DAPPDEV_REF : D3DAPPDEV_HEL;
	device->bStereoCompatible = false;					// bStereoCompatibleiōă`FbNj
	device->dwNumModes = 0;								// dwNumModes
	device->bWindowed = adapter->bDesktopCompatible;	// bWindowediŃEBhEɂȂȂtruej
	device->pMode = &(device->modes[0]);				// pModei640x480̃[hݒ肷j

	// dGZJ_A_v^ȍ~ɂẮAHAL/HALTnL ̂݃XgAbvB
    if( adapter->pAdapterGUID != NULL && ! device->bHardware )
		return D3DENUMRET_OK;
	
    // Avɂ̃foCX̋^s𔻒fB
    if( FAILED( app->ConfirmDevice( &adapter->ddHALCaps, &device->ddDeviceDesc ) ) )
		return D3DENUMRET_OK;
	
	// DirectDraw ̑S[hXgiAdaptermodes[]ĵADirect3D foCXƌ݊̂郂[h𔲐Xg쐬B
    for( DWORD i=0; i<adapter->dwNumModes; i++ )
    {
        DDSURFACEDESC2 ddsdDDMode	= adapter->modes[i];
        DWORD dwDDDepth				= ddsdDDMode.ddpfPixelFormat.dwRGBBitCount;			// A_v^̐[x
        DWORD dwD3DDepths			= device->ddDeviceDesc.dwDeviceRenderBitDepth;		// D3DfoCX̐[x

		// Direct3D foCX̃[hƌ݊̂郂[hF߂B
        if( ( ( dwDDDepth == 32 ) && ( dwD3DDepths & DDBD_32 ) ) ||
            ( ( dwDDDepth == 24 ) && ( dwD3DDepths & DDBD_24 ) ) ||
            ( ( dwDDDepth == 16 ) && ( dwD3DDepths & DDBD_16 ) ) )
        {
			// [hfoCX[h̃XgɃRs[B
            device->modes[device->dwNumModes++] = ddsdDDMode;

			// XeItbsO`F[ł邩L^Bi[hPłȂ trur ɂȂj
            if( ddsdDDMode.ddsCaps.dwCaps2 & DDSCAPS2_STEREOSURFACELEFT )
                device->bStereoCompatible = true;
        }
    }

	// foCX[hPT|[gȂȂ炱ŎߕB
    if( device->dwNumModes == 0 )
        return D3DENUMRET_OK;

	// ftHg̑Sʃ[hƂ 640x480x16 [hB
	for( DWORD i=0; i < device->dwNumModes; i++ )
	{
		if( ( device->modes[i].dwWidth == 640 ) &&
			( device->modes[i].dwHeight == 480 ) &&
			( device->modes[i].ddpfPixelFormat.dwRGBBitCount == 16 ) )
		{
			device->pMode = &( device->modes[i] );
			break;
		}
	}

	// foCXF߁A߂B
    if( adapter->dwNumDevices < 4 )
	{
		adapter->dwNumDevices++;
		adapter->pDevice++;
	}

    return D3DENUMRET_OK;
}

// DirectDraw ̃tXN[[h񋓗p̃R[obN֐B
static HRESULT WINAPI ModeEnumCallback( DDSURFACEDESC2* pddsd, VOID* pContext )
{
	D3DAdapterInfo* adapter = (D3DAdapterInfo*) pContext;
	adapter->modes[ adapter->dwNumModes ] = (*pddsd);
	if( adapter->dwNumModes < 149 ) adapter->dwNumModes++;
    return DDENUMRET_OK;
}

// fBXvC[hɃ\[g邽߂̃R[obN֐B
static int SortModesCallback( const VOID* arg1, const VOID* arg2 )
{
    DDSURFACEDESC2* p1 = (DDSURFACEDESC2*)arg1;
    DDSURFACEDESC2* p2 = (DDSURFACEDESC2*)arg2;

    if( p1->dwWidth < p2->dwWidth )
        return -1;
    if( p1->dwWidth > p2->dwWidth )
        return +1;

    if( p1->dwHeight < p2->dwHeight )
        return -1;
    if( p1->dwHeight > p2->dwHeight )
        return +1;

    if( p1->ddpfPixelFormat.dwRGBBitCount < p2->ddpfPixelFormat.dwRGBBitCount )
        return -1;
    if( p1->ddpfPixelFormat.dwRGBBitCount > p2->ddpfPixelFormat.dwRGBBitCount )
        return +1;

    return 0;
}

// A_v^񋓗p̃R[obN֐B
static BOOL WINAPI AdapterEnumCallback( GUID* pGUID, TCHAR* strDesc, TCHAR* strName, VOID* pContext )
{
    LPDIRECTDRAW7	pDD;
    LPDIRECT3D7		pD3D;
    HRESULT			hr;
	TCHAR			strErrorMsg[2048];
	
	CD3DDisplay* app		= (CD3DDisplay*) pContext;
	D3DAdapterInfo* adapter = app->pAdapter;
	
    // GUID w肵 DirectDraw 쐬B
    hr = DirectDrawCreateEx( pGUID, (VOID**)&pDD, IID_IDirectDraw7, NULL );
	if( FAILED(hr) )
	{
		D3DXGetErrorString( hr, 2048, strErrorMsg );
        return D3DENUMRET_OK;	// s
    }
	
    // D3DfoCX񋓂邽߂ɁADirect3D 擾B
    hr = pDD->QueryInterface( IID_IDirect3D7, (VOID**)&pD3D );
    if( FAILED(hr) )
	{
        pDD->Release();
		D3DXGetErrorString( hr, 2048, strErrorMsg );
        return D3DENUMRET_OK;	// s
	}

	// A_v^\̂փf[^Rs[B
	ZeroMemory( adapter, sizeof(D3DAdapterInfo) );
    if( pGUID )
	{
        adapter->guidAdapter = (*pGUID);				// 񋓂I GUID ɂȂ̂ŁAGUID ̖{̂ƍTĂB
        adapter->pAdapterGUID = &adapter->guidAdapter;	// ƂĂ GUID  NULL ̏ꍇ̂ŁAʂ̂߂ GUID ւ̃|C^pӂB
    }
	DDDEVICEIDENTIFIER2 dddi;
	pDD->GetDeviceIdentifier( &dddi, 0 );
	lstrcpyn( adapter->strDriver, dddi.szDescription, 512 );	// strDriver[]
	lstrcpyn( adapter->strDesc, strDesc, 39 );					// strDesc[]
	DWORD dwTotal, dwFree;
	DDSCAPS2 ddsc;
	ZeroMemory( &ddsc, sizeof(ddsc) );
	ddsc.dwCaps = DDSCAPS_VIDEOMEMORY;
	pDD->GetAvailableVidMem( &ddsc, &dwTotal, &dwFree );
	adapter->dwTotalMemory = dwTotal;							// dwTotalMemory
	adapter->ddHALCaps.dwSize = sizeof(DDCAPS);
    adapter->ddHELCaps.dwSize = sizeof(DDCAPS);
    pDD->GetCaps( &adapter->ddHALCaps, &adapter->ddHELCaps );	// ddHALCaps, ddHELCaps
    if( adapter->ddHALCaps.dwCaps2 & DDCAPS2_CANRENDERWINDOWED )	// EBhE[h̕`悪łA
        if( adapter->pAdapterGUID == NULL )							// hCo GUID  NULL łȂ
            adapter->bDesktopCompatible = true;						// fXNgbv݊A_v^łB

	adapter->dwNumModes = 0;						// dwNumModes
	adapter->dwNumDevices = 0;						// dwNumDevices
	adapter->pDevice = &(adapter->devices[0]);		// pDevice
	
	// DirectDraw ŗp\ȑS[h񋓂A\[gēɋLĂB
	//  ̃[hXgWƂāAeRcfoCXŗp\ȃ[hsbNAbvB
    pDD->EnumDisplayModes( 0, NULL, adapter, ModeEnumCallback );
    qsort( adapter->modes, adapter->dwNumModes, sizeof(DDSURFACEDESC2), SortModesCallback );

	// RcfoCXׂė񋓂B
    pD3D->EnumDevices( DeviceEnumCallback, app );

	// ftHgfoCXIB
	int nRank = -1;
	for( DWORD d=0; d<adapter->dwNumDevices; d++ )
	{
		if( adapter->devices[d].type == D3DAPPDEV_HALTnL )						// ŗD HALTnL
		{
			nRank = 4;
			adapter->pDevice = &( adapter->devices[d] );
		}
		else if( adapter->devices[d].type == D3DAPPDEV_HAL && nRank < 4 )		//  HAL
		{
			nRank = 3;
			adapter->pDevice = &( adapter->devices[d] );
		}
		else if( adapter->devices[d].type == D3DAPPDEV_HEL && nRank < 3 )		//  HEL
		{
			nRank = 2;
			adapter->pDevice = &( adapter->devices[d] );
		}
		else
		{
			nRank = 1;
			adapter->pDevice = &( adapter->devices[d] );						// Ōɂ̑
		}
	}
	if( nRank < 0 )
		adapter->pDevice = &( adapter->devices[0] );
	
	// |Ď̃A_v^ցB
    pD3D->Release();
    pDD->Release();
	if( app->dwNumAdapters < 19 )
	{
		app->dwNumAdapters ++;
		app->pAdapter ++;
	}

	return DDENUMRET_OK;
}

CD3DDisplay::CD3DDisplay()
{
	this->pAdapter = &(this->adapters[0]);
	this->dwNumAdapters = 0;
}

HRESULT CD3DDisplay::EnumerateDevices()
{
	// 񋓂
    DirectDrawEnumerate( AdapterEnumCallback, this );

	if( this->dwNumAdapters == 0 )
		return FDKERR_A_v^Ȃ;

	// m_pAdapter ɃftHg̃A_v^ւ̃|C^ZbgB
	for( DWORD a = 0; a < this->dwNumAdapters; a++ )
	{
		if( this->adapters[a].bDesktopCompatible )
		{
			this->pAdapter = &(this->adapters[a]);
			break;
		}
	}
	return S_OK;
}

bool	CD3DDisplay::FindMode( DWORD w, DWORD h, DWORD bpp )
{
	D3DAdapterInfo* a = this->pAdapter;
	D3DDeviceInfo*  d = a->pDevice;
	
	for( DWORD i = 0; i < d->dwNumModes; i++ )
	{
		if( ( d->modes[i].dwWidth == w ) &&
			( d->modes[i].dwHeight == h ) &&
			( d->modes[i].ddpfPixelFormat.dwRGBBitCount == bpp ) )
		{
			d->pMode = &( d->modes[i] );
			return true;		// 
		}
	}
	return false;	// Ȃ
}


	}//AppBase
}//FDK
