#pragma once

namespace FDK {
	namespace Graphics {

#define MAX_NUM_FORMATS		64		// 񋓂ő̃sNZtH[}bg

class CTexture
{
public:
	// eNX`쐬̂߂̏ݒ(1)B
	// ł̓eNX` OATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	HRESULT InitDeviceObjects( TCHAR* name, DWORD width, DWORD height, bool bSkipBlack=true );
	
	// eNX`쐬̂߂̏ݒ(2)B
	// ł̓eNX` OAt@CATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	HRESULT InitDeviceObjectsFromFile( LPCTSTR name, LPCTSTR filename, DWORD width=0, DWORD height=0, bool bSkipBlack=true );

	// t@CeNX`쐬邽߂̏ݒB
	// ł̓eNX` OAf[^Af[^TCYATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	HRESULT InitDeviceObjectsFromFileInMemory( TCHAR* name, BYTE* pData, DWORD dwDataSize, DWORD width=0, DWORD height=0, bool bSkipBlack=true );

	// \[XeNX`쐬邽߂̏ݒB
	// ł̓eNX` OAf[^Af[^TCYATCYAzuꏊ ɋL邾ŁAfoCX֌W͈̏؍sȂB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	//  width == 0 & height == 0 ̏ꍇ́At@C摜̃TCYɂȂB
	HRESULT	InitDeviceObjectsFromResource( TCHAR* name, LPCTSTR lpResourceName, LPCTSTR lpResourceType, DWORD width=0, DWORD height=0, bool bSkipBlack=true );

	// eNX`̓ǂݍ݂ƍ\zB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjects();

	HRESULT	InvalidateDeviceObjects();		// eNX`̖B
	HRESULT	DeleteDeviceObjects();			// eNX`̔j

	HRESULT	SetAlphaConst( int a );													// Œ胿l̓o^(a = 0`255)
	HRESULT	AddBlendEnable( bool f=true )	{ this->bUseAddBlend = f; return S_OK; }
	HRESULT	SetColorKey();															// ̐FJ[L[ɂB
	HRESULT	SetColorKey( DWORD dwColor );											// wFJ[L[ɐݒ肷B
	void	ColorKeyEnable( bool f=true )	{ this->bColorKeyEnable = f; }			// J[L[ ON/OFFBtrue  ONB
	HRESULT GetDC( HDC *phdc );														// foCXReLXg̎擾
	HRESULT ReleaseDC( HDC &hdc );													// foCXReLXg̉
	HRESULT	SetScale( float w, float h );											// XP[̕ύX
	void	GetScale( float* w, float* h ) { *w=this->fScaleW; *h=this->fScaleH; }	// XP[̎擾

	HRESULT Clear( LPRECT prc=NULL );												// T[tFCX̃NA
	HRESULT Draw( int x, int y, LPRECT pSrc=NULL );									// Qc`FobNobt@ւ݂̏T|[gȂ
	HRESULT Draw3D( int x, int y, LPRECT prcSrc, D3DXMATRIX *pMat );				// RcԂւ̕`FobNobt@ւ݂̏T|[gȂ

	// eNX`ւ̕̕`(1)
	HRESULT	Text( int x, int y, HFONT hFont, LPCTSTR str, COLORREF color=RGB(255,255,255) );
	int		GetTextWidthDot( HFONT hFont, LPCTSTR str );

	// eNX`ւ̕̕`(2)A`GCAXt
	// tHg͖ʐςS{̑傫̂̂w肷邱ƁI
	// At@͏255Ȃ̂Œӂ邱ƁIiXLbv鍕͏j
	HRESULT	TextSharp( int x, int y, HFONT hFont, LPCTSTR str, COLORREF color=RGB(255,255,255) );

	// eNX`T[tFCXTCY̎擾
	DWORD	GetSurfaceSize();

	static void EnumTextureFormats();	// eNX`tH[}bgXg̍쐬
	static void BeginScene();			// `Jn
	static void EndScene();				// `I

	CTexture();
	virtual ~CTexture();

public:
	LPDIRECTDRAWSURFACE7	pTexture;

	int				nAlphaConst;
	bool			bUseAddBlend;
	bool			bColorKeyEnable;
	DWORD			dwColorKey;
	DWORD			dwWidth;		// eNX`̎TCY
	DWORD			dwHeight;	
	DWORD			dwImageWidth;	// ǂݍ݌摜̃TCY
	DWORD			dwImageHeight;
	float			fScaleW;		// {
	float			fScaleH;		// c{
	tstring			strTextureName;					// eNX`iCӁj
	tstring			strFileName;					// t@Cit@CȂȂ "" j
	bool			bSkipBlack;		// 摜\z(RestoreDevice`) ɁA摜̍(0)XLbv邩(BMP,JPEĜݗL)
	LPCTSTR			lpResourceName;					// \[Xi\[XȂȂ NULLj
	LPCTSTR			lpResourceType;					// \[X^Cvi\[XȂȂ NULLj
	BYTE*			pData;							// f[^ւ̃|C^i̐ȂȂNULLj
	DWORD			dwDataSize;						// f[^TCYi̐ȂȂ0j

	static DDPIXELFORMAT	ddpfARGB8888;				// A8R8G8B8 (32-bit) tH[}bgBdwSize = 0 ȂgȂB
	static DDPIXELFORMAT	ddpfARGB4444;				// A4R4G4B4 (16-bit) tH[}bgBdwSize = 0 ȂgȂB

protected:
	// ̃eNX`̍쐬
	HRESULT Create();
	
	// _OXe[^X̐ݒ
	void	SetRenderStates();

	// RGB-32bit  BITMAP eNX`փRs[B
	// eNX`̃At@ 0xFF ƂȂB
	// @bSkipBlack ... true Ȃ獕F͕`悹XLbvB
	void	CopyFromBMP32( int x, int y, BITMAP* bmp, bool bSkipBlack=true );

	// RGB-32bit ̂S{ʐ BITMAP eNX`֏kRs[B
	// ḱA2x2̂ShbgPhbgϊōsB
	// 񂽂߁AeNX`̃At@ 0%, 25%, 50%, 75%, 100% ̂TނƂȂB
	// @bSkipBlack ... true Ȃ獕F͕`悹XLbvB
	void	CopyFromBMP32x4( int x, int y, BITMAP* bmp, bool bSkipBlack=true );

	// eNX`̖OAt@CATCYAzuꏊɋLB
	// ̑̃p[^̓ftHglɏB
	void	InitParameters( LPCTSTR name, LPCTSTR fname, LPCTSTR lpResourceName, LPCTSTR lpResourceType, BYTE* pData, DWORD dwDataSize, DWORD width, DWORD height, bool bSkipBlack );

	// t@C̃eNX`̍\zB
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromFile();

	// C[W̃eNX`̓ǂݍ݂ƍ\z
	//  PNG ̂ݑΉ
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromFileInMemory();

	// \[X̃eNX`̓ǂݍ݂ƍ\z
	//  PNG ̂ݑΉ
	//  width, height Ŏw肵TCYɉ摜g^kēǂݍ܂B
	HRESULT	RestoreDeviceObjectsFromResource();

	// DDS eNX`\zB
	HRESULT RestoreFromDDS( DDSURFACEDESC2* pddsd, BYTE** ppimage );

	DWORD	BitCount( DWORD dwNum );		// dwNum ̃rbg'1'̐𐔂B
	DWORD	ShiftCount( DWORD dwNum );		// dwNum LSB0̑ԂBiF0x0020  5j

	void LostCheck();		// T[tFCXXgĂꍇ RestoreDeviceObjest() ĂяoB
};

	}//Graphics
}//FDK

using namespace FDK::Graphics;
