#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<string.h>
#include	<sys/time.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<usb.h>
#include	<sys/utsname.h>
#include	<signal.h>
#include	<sys/select.h>
#include	<netinet/tcp.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<errno.h>
#include	<netdb.h>
#include	<time.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<linux/tty.h>
#include	<sys/ioctl.h>
#include	<net/if.h>
#include	<sys/select.h>
#include	"config.h"
#include	"node.h"
#include	"dstar.h"

#define		CONFIG_FILE	"/opt/dv_ap/etc/dv_ap.conf"
#define		LOG_FILE	"/var/log/dv_ap.log"
#define		PID_FILE	"/var/run/dv_ap.pid"

#define CSS_FILE        "/opt/dv_ap/web/dv_ap.css"
#define LOGO_FILE       "/opt/dv_ap/web/logo.png"
#define JS_FILE         "/opt/dv_ap/web/dv_ap.js"

#define		TRUE	1
#define		FALSE	0
#define		RECHECK	15

#define		DVAP_DEVICE	"/dev/dvap"
#define		DVAP_SPEED	B230400

#define		LOGD_PORT	30000
#define		TRUST_PORT	30001
#define		GATEWAY_PORT	40000
#define		GATEWAY_SRC_PORT 40002
#define		TRUST_TIMEOUT	100

#define		NicDeviceInitValue	"eth0"


void	print_PICinfo(void);
void    header_read_from_rig(void);
int	voice_read_from_rig(void);
void	last_frame_send(void);
void    header_send(struct dv_header header);
void    voice_send(char voice[]);
void	last_send(char	voice[]);
int	cos_check(void);
int     htoi (const char *s);
void	send_response(void);
void	header_send_set_from_rig(void);
void	printOnOff( char sw);
void    putFifo (int len, struct dv_packet pkt);
int     getFifo (int *len, struct dv_packet *pkt);
void	node_usb_init(void);
void	dvap_open(void);
void	dvap_close(void);
void	node_close (void);
void	node_term(void);
void    dv_pkt_set(struct dv_packet *hdr);
void	node_header_send (char header[]);
void	node_voice_send (char voice[]);
void	node_last_send (char voice[]);
void	dvap_header_send (char header[]);
void	dvap_voice_send (char voice[]);
void	dvap_last_send (char voice[]);

time_t	start_time;
time_t	keep_alive;
int	keep_alive_interval;

usb_dev_handle *udev;
union
{
	struct	dv_header	hdr;
	char	buffer[32];
} usb;

struct	dv_header	save_hdr;

char	status;
int	CrcSW, Notice;
int	HeaderLength;
int	voice_pnt;
char	seq;

struct	dv_packet	dv_pkt;
struct	dv_packet	node_pkt;
struct	dv_packet	dvap_pkt;
struct	dv_packet	reply_dv_pkt;

int	in_sd;
int	out_sd;
int	upnp_udp_sd;
int	upnp_http_sd;

int	trust_sd;
int	logd_sd;

int	httpd_sd;

struct	sockaddr_storage	http_recv;
socklen_t	http_recv_len;	

char	voice_save[24];

char	node_area_rep_callsign[8];
char	dvap_area_rep_callsign[8];
char	gateway_callsign[8];
char	rep_ip_addr[20];
FILE	*log_file;
FILE	*pid_file;

int	debug;

struct utsname      uname_buf;
time_t	cur_time;
int	sig_term;
char	trust_name[128];
int	gateway_port;
int	gateway_src_port;
int	trust_port;
int	logd_port;
int	http_port;
int	node_last_frame_sw;
int	dvap_last_frame_sw;
int	send_null_sw;
struct	dv_header	node_gw_resp;
struct	dv_header	dvap_gw_resp;
int	node_gw_resp_sw;
int	dvap_gw_resp_sw;
struct	timeval	dvap_in_time;



struct	addrinfo	hints;
struct	addrinfo	*gateway_in;
struct	addrinfo	*gateway_out;
struct	addrinfo	*trust_sock;
struct	addrinfo	*upnp_sock;
struct	addrinfo	*logd_sock;
struct	addrinfo	*aprs_sock;
struct	addrinfo	*http_serv;
char	PORT[8];

struct	sockaddr_storage	in_addr;
socklen_t	in_addr_len;

struct	sockaddr_storage	in_upnp_addr;
socklen_t	in_upnp_addr_len;

char		node_save_frame_id[2];
char		dvap_save_frame_id[2];
char		dvap_squelch_status;

struct	sockaddr_storage	mon_addr;
socklen_t			mon_addr_len;

struct	sockaddr_storage	upnp_addr;
socklen_t			upnp_addr_len;

struct  usb_bus *bus;
struct  usb_device      *dev;
int     dev_found;

union
{
	char	buf[2048];
	struct	dv_packet	buf_pkt;
} buf_pkt;

/* for pselect */
struct	timespec	tv;
fd_set  rfds;
fd_set	save_rfds;
sigset_t	sigset;
sigset_t	save_sigset;

struct	timeval	CosOffTime;
struct	timeval	InetInTime;
int	node_NoRespReply_sw;
int	dvap_NoRespReply_sw;
struct	dv_header	node_NoResp;
struct	dv_header	dvap_NoResp;
int	usb_read_cnt;
int	loop_cnt;

long	int	node_rig_pkt_cnt;
long	int	dvap_rig_pkt_cnt;
long	int	node_inet_pkt_cnt;
long	int	dvap_inet_pkt_cnt;

/* node adapter */
int	VenderID;
int	ProductID;

/* misc switch */


struct	FifoPkt
{
	struct	FifoPkt	*next;
	int	length;
	struct	dv_packet	pkt;
};

struct	FifoPkt *Rp;
struct	FifoPkt *Wp;

int	init_sw;
int	dvap_voice_send_sw;
int	node_voice_send_sw;
int	rep_position_send_sw;

int	dvap_fd;

time_t	dvap_keep_alive;

int	dvap_buff_pnt;
struct	timeval	dvap_InTime;

int	node_sw;
int	dvap_sw;
long	int	dvap_freq;
long	int	dvap_rx_freq;
long	int	dvap_tx_freq;
signed	char 	dvap_squelch;
short	int	dvap_calibration;
int	dvap_auto_calibration;
int	dvap_auto_calibration_set;
time_t	re_check;

int	get_position_sw;

char	gateway_position[40];
struct	timeval	req_time;

/* DPRS */
int	aprs_sd;
char	aprs_server[128];
char	aprs_srv[16];
long int	aprs_cnt;
int	verify_sw;
int	aprs_port;
int	AutoReLink;
int	BeaconInterval;
time_t	BeaconTime;
int	aprs_send_interval;
char	DprsTemp[256];
long int	BeaconLat;
long int	BeaconLong;
char	radio_id;
char	client_callsign[8];
char	beacon_comment[64];

struct	aprs_msg
{
	int	msg_pnt;
	char	aprs_msg[256];
	char	aprs_msg_save[256];
	char	short_msg[20];
	char	RadioGpsStatus;
        unsigned char   RadioLat[8];
        unsigned char   RadioLong[9];
        unsigned char   RadioCall[8];
        unsigned char   RadioMsg[20];
        unsigned char   RadioAtitude[6];
        unsigned char   RadioSpeed[3];
        unsigned char   RadioDirection[3];
        unsigned char   RadioTime[7];
	struct	
	{
		unsigned char mini_header;
		char	temp[5];
	} tmp;
};

struct	aprs_msg	node_msg;
struct	aprs_msg	dvap_msg;

unsigned char   GpsMsg[20];

struct SendCheck
{
	struct	SendCheck	*next;
        unsigned        char    CallSign[10];
        time_t                  SendTime;
};

struct SendCheck	*send_check_pnt;


char	NicDevice[IFNAMSIZ];
struct	in_addr OwnDvApIP;

int	upnp_sw;
char	upnp_buf[4096];
int	upnp_buf_pnt;
time_t	upnp_send_time;
int	upnp_add_sw;

int	trust_timeout;	

struct	tm	*gt;
char	aprs_ip[NI_MAXHOST];

time_t	node_recv_time;
time_t	dvap_recv_time;

char	Gw_IP[4];

