#include	"dv_ap.h"

int     init(int argc, char **argv);
void	reply_busy(struct dv_header dv_hdr);
void	send_resp(struct dv_header gw_resp);
void	NoRespReply(struct dv_header NoResp);
void	send_reply(char buf[]);

extern	char	lastframe[];

int	from_inet (void)
{
	int	len;

	struct	dv_header	dv_hdr;

	in_addr_len = sizeof(struct sockaddr_storage);

	if((len = recvfrom(in_sd, &buf_pkt, sizeof(buf_pkt), 0, 
		(struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf_pkt.buf, "DSVT", 4)) return TRUE;

	if (len == 56) 
	{
		memcpy (&dv_hdr, &buf_pkt.buf[15], 41); /* rf header save */
		if (debug)
		{
			time (&cur_time);
			fprintf (log_file, "%24.24s from INET Flags: %2.2x %2.2x %2.2x\n", 
				ctime(&cur_time), dv_hdr.flags[0], dv_hdr.flags[1], dv_hdr.flags[2]);
			fprintf (log_file, "%24.24s from INET RPT2:%8.8s RPT1:%8.8s\n", 
				ctime(&cur_time), dv_hdr.RPT2Call, dv_hdr.RPT1Call);
			fprintf (log_file, "%24.24s from INET YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n", 
					ctime(&cur_time), dv_hdr.YourCall, dv_hdr.MyCall, dv_hdr.MyCall2);
				fflush (log_file);
				if (!memcmp (&buf_pkt.buf[26], node_area_rep_callsign, 8)) node_inet_pkt_cnt = 0;
				else if (!memcmp (&buf_pkt.buf[26], dvap_area_rep_callsign, 8)) dvap_inet_pkt_cnt = 0;
		}
		if ((buf_pkt.buf[11] == 0xff) 
			&& (buf_pkt.buf[10] == 0xff) 
			&& (buf_pkt.buf[11] == 0xff)) /* response ? */
		{
			if (!memcmp (&buf_pkt.buf[18], node_area_rep_callsign, 8))
			{
				memcpy (&node_gw_resp, &buf_pkt.buf[15], 41);
				node_gw_resp_sw = TRUE;
				node_NoRespReply_sw = FALSE;
			}
			else if (!memcmp (&buf_pkt.buf[18], dvap_area_rep_callsign, 8))
			{
				memcpy (&dvap_gw_resp, &buf_pkt.buf[15], 41);
				dvap_gw_resp_sw = TRUE;
				dvap_NoRespReply_sw = FALSE;
			}
		}
		else
		{
			if (!memcmp (&buf_pkt.buf[18], node_area_rep_callsign, 8))
			{

				if ((node_save_frame_id[0] == 0x00) && (node_save_frame_id[1] == 0x00))
				/* frame ID check */
				{
					node_gw_resp_sw = FALSE;
					gettimeofday(&InetInTime, NULL);
					memcpy (node_save_frame_id, &buf_pkt.buf[12], 2);
					if (buf_pkt.buf[33] == 'G')
					{
						memcpy (dv_hdr.RPT2Call, &buf_pkt.buf[26], 8);
						memcpy (dv_hdr.RPT1Call, &buf_pkt.buf[18], 8);
					}
					header_send(dv_hdr);
					node_NoRespReply_sw = FALSE;
				}
				else if (memcmp (node_save_frame_id, &buf_pkt.buf[12], 2))
				{
					reply_busy (dv_hdr);
				}
			}
			else if (!memcmp (&buf_pkt.buf[18], dvap_area_rep_callsign, 8))
			{
				if ((dvap_save_frame_id[0] == 0x00) && (dvap_save_frame_id[1] == 0x00))
				/* frame ID check */
				{
					dvap_gw_resp_sw = FALSE;
					gettimeofday(&InetInTime, NULL);
					memcpy (dvap_save_frame_id, &buf_pkt.buf[12], 2);
					if (buf_pkt.buf[33] == 'G')
					{
						memcpy (dv_hdr.RPT2Call, &buf_pkt.buf[26], 8);
						memcpy (dv_hdr.RPT1Call, &buf_pkt.buf[18], 8);
					}
					header_send(dv_hdr);
					dvap_NoRespReply_sw = FALSE;
				}
				else if (memcmp (dvap_save_frame_id, &buf_pkt.buf[12], 2))
				{
					reply_busy (dv_hdr);
				}
			}
		}
	}
	else if (len == 27)
	{
		if (debug)
		{
			time (&cur_time);
			if (!memcmp (node_save_frame_id, &buf_pkt.buf[12], 2)) 
			{
				node_inet_pkt_cnt++;
				if (buf_pkt.buf[14] & 0x40)
				{
					fprintf (log_file, "%24.24s from INET packets:%ld\n",
						ctime(&cur_time), node_inet_pkt_cnt);
					fflush (log_file);
					node_inet_pkt_cnt = 0;
				}
			}
			else if (!memcmp (dvap_save_frame_id, &buf_pkt.buf[12], 2))
			{
				dvap_inet_pkt_cnt++;
				if (buf_pkt.buf[14] & 0x40)
				{
					fprintf (log_file, "%24.24s from INET packets:%ld\n",
						ctime(&cur_time), dvap_inet_pkt_cnt);
					fflush (log_file);
					dvap_inet_pkt_cnt = 0;
				}
				
			}
		}
				
		if (!memcmp (node_save_frame_id, &buf_pkt.buf[12], 2))
		{
			gettimeofday(&InetInTime, NULL);
			if (debug) node_inet_pkt_cnt++;
			if (buf_pkt.buf[14] & 0x40)
			{
				memcpy (&buf_pkt.buf[24], lastframe, 6);
				node_last_send (&buf_pkt.buf[15]);
				memset (node_save_frame_id, 0x00, 2);
			}
			else  node_voice_send (&buf_pkt.buf[15]);
		}
                else if (!memcmp (dvap_save_frame_id, &buf_pkt.buf[12], 2))
                {
       			gettimeofday(&InetInTime, NULL);
                        if (debug) dvap_inet_pkt_cnt++;
                        if (buf_pkt.buf[14] & 0x40)
                        {
                        	memcpy (&buf_pkt.buf[24], lastframe, 6);
                                dvap_last_send (&buf_pkt.buf[15]);
                                memset (dvap_save_frame_id, 0x00, 2);
                        }
                        else  dvap_voice_send (&buf_pkt.buf[15]);
       		}
	}
	return TRUE;
}

