#include	"dv_ap.h"

void	putFifo (int len, struct dv_packet pkt);
int	getFifo (int *len, struct dv_packet *pkt);
void    send_rep_position(void);

int     init(int argc, char **argv);
extern	char	lastframe[];
int	buff_length;
struct	dv_packet buff_pkt;

enum
{
	SEND_REQ_GATEWAY = 0,
	SEND_REQ_GATEWAY_WAIT,
	SEND_VOICE,
	SEND_INIT
} dv_packet = SEND_REQ_GATEWAY; 
	
void	send_inet(void)
{
	int	ret;
	char	temp[16];
	int	err;
	struct	timeval temp_time, c_time;
	struct	timeval timeout;

	switch (dv_packet)
	{
		case SEND_REQ_GATEWAY:
			if (getFifo (&buff_length, &buff_pkt))
			{
				if (buff_length == 56)
				{
					memset (temp, 0x20, 8);
					if (buff_pkt.dstar.b_bone.dstar_udp.rf_header.YourCall[0] == '/')
					{
						memcpy (temp, &buff_pkt.dstar.b_bone.dstar_udp.rf_header.YourCall[1], 6);
						temp[7] = buff_pkt.dstar.b_bone.dstar_udp.rf_header.YourCall[7];
						ReqPositionInfo (temp);
						memcpy (buff_pkt.dstar.b_bone.dstar_udp.rf_header.YourCall, "CQCQCQ  ", 8);
					}
					else
					{
						ReqPositionInfo (buff_pkt.dstar.b_bone.dstar_udp.rf_header.YourCall);
					}
					dv_packet = SEND_REQ_GATEWAY_WAIT;
					get_position_sw = FALSE;
					gettimeofday (&req_time, NULL);
				}
			}
			break;

		case SEND_REQ_GATEWAY_WAIT:
			if (get_position_sw)
			{
				dv_log_send (&buff_pkt);
				ReqPositionUpdate (&buff_pkt);
				
				memcpy (buff_pkt.dstar.b_bone.dstar_udp.rf_header.RPT2Call,
					&gateway_position[24], 8);
				memcpy (buff_pkt.dstar.b_bone.dstar_udp.rf_header.RPT1Call,
					&gateway_position[16], 8);
				buff_pkt.dstar.b_bone.dstar_udp.rf_header.RPT1Call[7] = 'G';
				sprintf (rep_ip_addr, "%d.%d.%d.%d",
						gateway_position[32],
						gateway_position[33],
						gateway_position[34],
						gateway_position[35]);

				memset (&hints, 0x00, sizeof(hints));
				hints.ai_socktype = SOCK_DGRAM;
				hints.ai_family = PF_UNSPEC;
				sprintf (PORT, "%d", gateway_port);

        			if ((err = getaddrinfo (rep_ip_addr, PORT, &hints, &gateway_out)) != 0)
        			{
                			fprintf (log_file, "%24.24s getaddrinfo error(gateway out) %s\n",
                       				ctime(&cur_time), gai_strerror(err));
               	 			fprintf (log_file, "%24.24s trust : %s\n", ctime(&cur_time), rep_ip_addr);
                			fflush (log_file);
					return;
        			}
        			if((out_sd = socket(gateway_out->ai_family, 
					gateway_out->ai_socktype, gateway_out->ai_protocol)) < 0)
        			{
                			fprintf (log_file, "%24.24s socket error in gateway out port %s\n",
                        			ctime(&cur_time), strerror(errno));
                			fflush (log_file);
					return;
        			}

				sendto (out_sd, &buff_pkt, buff_length, 0,
					gateway_out->ai_addr, gateway_out->ai_addrlen);
				dv_packet = SEND_VOICE;
			}
			else
			{
				gettimeofday (&c_time, NULL);
				timersub (&c_time, &req_time, &temp_time);
				timeout.tv_sec = 0;
				timeout.tv_usec = trust_timeout * 1000;;
				if (timercmp (&temp_time, &timeout, >))
				{
					dv_packet = SEND_REQ_GATEWAY;
					if (buff_pkt.dstar.b_bone.b_b.send_terminal_id == 0x03) node_gw_resp_sw = TRUE;
					else if (buff_pkt.dstar.b_bone.b_b.send_terminal_id == 0x04) dvap_gw_resp_sw = TRUE;
				}
			}
			break;

		case SEND_VOICE:
			if (getFifo (&buff_length, &buff_pkt))
			{
				if (buff_length != 27)
				{
					dv_packet = SEND_REQ_GATEWAY;
					memcpy (&buff_pkt.dstar.b_bone.dstar_udp.voice_d,
						&buff_pkt.dstar.b_bone.dstar_udp.voice_d.lastframe, 3);
				}

				sendto (out_sd, &buff_pkt, 27, 0,
					gateway_out->ai_addr, gateway_out->ai_addrlen);

				if (buff_length != 27)
				{
					close (out_sd);
					freeaddrinfo (gateway_out);
				}
				
			}
			break;

		case SEND_INIT:
			memset (temp, 0x00, 16);
			temp[4] = 0x40;
			memcpy (&temp[8], gateway_callsign, 8); 
                        ret = sendto(trust_sd, temp, 16, 0,
                                trust_sock->ai_addr, trust_sock->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			dv_packet = SEND_REQ_GATEWAY;
                        break;
	}
}

