#include	"dv_ap.h"
#include	"config.h"

extern long int timezone;

void	status_logoff_send(void)
{
	struct	STATUS_frame	StatusFrm;

	memset (&StatusFrm, 0x00, 100);
	memcpy (StatusFrm.StatusID, "DSTRST", 6);
	memcpy (StatusFrm.Type, "01", 2);
	memset (&StatusFrm.ip_addr, 0x00, 16);
	#if __WORDSIZE == 64
	time (&StatusFrm.EntryUpdateTime);
	#else
	time (&StatusFrm.EntryUpdateTime);
	memset (&StatusFrm.dummy_t, 0x00, 4);
	#endif
	// Convert local time to UTC
	StatusFrm.EntryUpdateTime += timezone;
	memcpy (StatusFrm.body.logoff.dxchange_callsign, client_callsign, 8);
	sendto (dv_status.status_sd, &StatusFrm, 100, 0,
		dv_status.status_info->ai_addr,
		dv_status.status_info->ai_addrlen);
	/* re_send */
        memcpy (StatusFrm.body.logoff.dxchange_callsign, client_callsign, 8);
        sendto (dv_status.status_sd, &StatusFrm, 100, 0,
        	dv_status.status_info->ai_addr,
        	dv_status.status_info->ai_addrlen);
}

void	status_keep_alive_send(void)
{
	struct	STATUS_frame	StatusFrm;

        if (dv_status.port)
        {
		memset (&StatusFrm, 0x00, 100);
                memcpy (StatusFrm.StatusID, "DSTRST", 6);
                memcpy (StatusFrm.Type, "99", 2);
                memset (&StatusFrm.ip_addr, 0x00, 16);
                #if __WORDSIZE == 64
                time (&StatusFrm.EntryUpdateTime);
                #else
                time (&StatusFrm.EntryUpdateTime);
                memset (&StatusFrm.dummy_t, 0x00, 4);
                #endif
                // Convert local time to UTC
                StatusFrm.EntryUpdateTime += timezone;
		if (node_area_rep_callsign[0] != 0x20)
		{
			memcpy (StatusFrm.body.keep_alive.ModuleName, node_area_rep_callsign, 8);
		}
		if (dvap_area_rep_callsign[0] != 0x20)
		{
			memcpy (StatusFrm.body.keep_alive.ModuleName, dvap_area_rep_callsign, 8);
		}
		memcpy (StatusFrm.body.keep_alive.dxchange_callsign, gateway_callsign, 8);
		memcpy (StatusFrm.body.keep_alive.Version, PACKAGE_VERSION, 5);
               	sendto (dv_status.status_sd, &StatusFrm, 100, 0,
                	dv_status.status_info->ai_addr,
                        dv_status.status_info->ai_addrlen);
                       	dv_status.packets++;
		time (&status_keep_alive);
        }
}

void	status_send_ptton(struct StatusTable *pnt)
{
	struct  status  *sta_pnt;

	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
        memcpy (&pnt->STATUS_Frm.Type, "05", 2);
        memcpy (&pnt->STATUS_Frm.body.status.RPT2Call, 
			&pnt->rpt_save.dstar.b_bone.dstar_udp.rf_header.RPT2Call, 36);
        memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
	memcpy (&pnt->STATUS_Frm.ip_addr, &pnt->src_ipaddress, 4);	/* IP V4 */
        #if __WORDSIZE == 64
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        #else
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
        #endif
	// Convert local time to UTC
	pnt->STATUS_Frm.EntryUpdateTime += timezone;
        memset (&pnt->STATUS_Frm.body.status.ShortMessage, 0x20, 20);
        //memset (&pnt->STATUS_Frm.body.status.Latitude, 0x00, 16);
        pnt->STATUS_Frm.body.status.Latitude = 3600000;
        pnt->STATUS_Frm.body.status.Longitude = 3600000;
        memset (&pnt->STATUS_Save, 0x00, 100);
        pnt->STATUS_Frm.port = 0;
        sendto (dv_status.status_sd, &pnt->STATUS_Frm, 100, 0,
               	dv_status.status_info->ai_addr, dv_status.status_info->ai_addrlen);
        dv_status.packets++;
        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
}

void	status_send_pttoff (struct StatusTable *pnt)
{
	struct	status	*sta_pnt;

        memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
        memcpy (&pnt->STATUS_Frm.Type, "06", 2);
        memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
        #if __WORDSIZE == 64
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        #else
        time (&pnt->STATUS_Frm.EntryUpdateTime);
        memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
        #endif
        // Convert local time to UTC
        pnt->STATUS_Frm.EntryUpdateTime += timezone;
       	sendto (dv_status.status_sd, &pnt->STATUS_Frm, 100, 0,
       		dv_status.status_info->ai_addr,
                dv_status.status_info->ai_addrlen);
                dv_status.packets++;
        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
}

void	status_send_update (struct StatusTable *pnt)
{
	struct	status	*sta_pnt;

	if (pnt->rpt_save.dstar.b_bone.b_b.seq == 0)
        {
        	memcpy (&pnt->STATUS_Frm.StatusID, "DSTRST", 6);
                memcpy (&pnt->STATUS_Frm.Type, "07", 2);
                memset (&pnt->STATUS_Frm.ip_addr, 0x00, 16);
                #if __WORDSIZE == 64
                time (&pnt->STATUS_Frm.EntryUpdateTime);
                #else
                time (&pnt->STATUS_Frm.EntryUpdateTime);
                memset (&pnt->STATUS_Frm.dummy_t, 0x00, 4);
                #endif
		// Convert local time to UTC
                pnt->STATUS_Frm.EntryUpdateTime += timezone;
                if (memcmp (&pnt->STATUS_Frm.ip_addr, &pnt->STATUS_Save.ip_addr, 84))
                {
                       	sendto (dv_status.status_sd, &pnt->STATUS_Frm, 100, 0,
                             dv_status.status_info->ai_addr,
                             dv_status.status_info->ai_addrlen);
                        dv_status.packets++;
                        memcpy (&pnt->STATUS_Save, &pnt->STATUS_Frm, 100);
                }
	}
}
