#include	"monitor.h"

char	temp[64];
char	*ltime(void);
void    add_user(struct ctable callstring);

void    tableclear()
{
        int     i;

        for (i = 0 ; i < MaxCallTable ; i++)
        {
                memset (&AccCall[i], 0x20, 40);
        }
        nextpnt = 0;
        curpnt = MaxCallTable - 1;      /* MaxCallTable - 1 */
}

void    tableinsert()
{
        int     i ,n;
	time_t	atime;

        n = curpnt;
        time (&atime);
        for (i = 0 ; i < MaxCallTable ; i++)
        {
                if (AccCall[n].datetime[0] != 0x20)
                {
                        if (difftime(atime, AccCall[n].EntryTime) > 10)
                        {
                                LogFile = fopen (LogFileName, "a");
                                fprintf (LogFile, "%.24s   %8.8s  %8.8s  %8.8s  %s\n",
                                AccCall[n].datetime, AccCall[n].mycall, AccCall[n].rpt1call, AccCall[n].rpt2call,AccCall[n].ipaddress);
                                fclose (LogFile);
                                add_user (AccCall[n]);
                                AccCall[n].datetime[0] = 0x20;
                        }
                }
                n--;
                if (n < 0) n = MaxCallTable -1;
        }
}

void    tablestore()
{
//      printf ("debug  %8.8s\n",&pkt_data[50]);
        memcpy (AccCall[nextpnt].datetime, ltime(), 24);
        memcpy (AccCall[nextpnt].mycall, &pkt_data[50], 8);
        memcpy (AccCall[nextpnt].rpt2call, &pkt_data[58], 8);
        memcpy (AccCall[nextpnt].rpt1call, &pkt_data[66], 8);
        time(&AccCall[nextpnt].EntryTime);
        sprintf (AccCall[nextpnt].ipaddress, "%d.%d.%d.%d" , pkt_data[26], pkt_data[27], pkt_data[28], pkt_data[29]);
//      sprintf (AccCall[nextpnt].ipaddress, "%d.%d.%d.%d" , pkt_data[78], pkt_data[79], pkt_data[80], pkt_data[81]);
        nextpnt++;
        if (nextpnt >= MaxCallTable) nextpnt = 0;
        curpnt++;
        if (curpnt >= MaxCallTable) curpnt = 0;
}

char *ltime(void)
{
        struct tm *pt;
        time_t  t;

        time (&t);
        pt = localtime (&t);

        /* <8c>≫<8d>Y<8e><9e><8d><8f><82>dUTC<8e><9e><8a>O<82>E<95>I<8a>・ */
        sprintf(temp, "%d-%02d-%02d %02d:%02d:%02d",pt->tm_year+1900, pt->tm_mon+1, pt->tm_mday, pt->tm_hour, pt->tm_min, pt->tm_sec);
        return temp;
}

void    add_user(struct ctable callstring)
{
        char    sql[256];
        PGconn  *con;
        PGresult        *res;
	time_t	atime;

        con = PQconnectdb("dbname=d-star user=dstar");
        if ( PQstatus(con) == CONNECTION_BAD ) {
                LogFile = fopen (LogFileName, "a");
                fprintf(LogFile,"%24.24s  Connection to database '%s' failed.\n",ctime(&atime) ,"trust");
                fprintf(LogFile,"%24.24s  %s",ctime(&atime), PQerrorMessage(con));
                fclose (LogFile);
                exit(1);
        }

        sprintf (sql, "insert into trust values ('%8.8s', '%8.8s','%8.8s','%s','%s',NULL,NULL,'NOT_DELETE(AUTO_ENTRY)')",
                callstring.mycall,callstring.rpt1call,callstring.rpt2call,callstring.ipaddress, callstring.datetime);
        res = PQexec (con, sql);
        if (PQresultStatus(res) != PGRES_COMMAND_OK ) {
                PQclear(res);
                sprintf (sql, "update trust set  area_repeater = '%8.8s', zone_repeater = '%8.8s', gw_address = '%s', update_daytime = '%s'  where call_sign = '%8.8s')",
                callstring.rpt1call,callstring.rpt2call,callstring.ipaddress, callstring.datetime,callstring.mycall);
                res = PQexec (con, sql);
                PQclear(res);
        }
        PQfinish (con);
}

