#include	"monitor.h"

void	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	time_t	atime;

	FILE	*config_file;

	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (LogFile, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (LogFile);
			return;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (LogFile, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (LogFile);
			return;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "CAP_PORT", 8))
				{
					cap_port = atoi (pnt);
				}
				else if (!memcmp (p, "NIC", 3))
				{
					memset (NicDevice, 0x00, 8);
					memcpy (NicDevice, pnt, strlen(pnt));
				}
                                else if (!memcmp (p, "OWN_IP", 6))
                                {
					OwnMonIP.s_addr = inet_addr (pnt);
                                }
				else if (!memcmp (p, "SERVER_FQDN", 11))
				{
					memset (dscsd_server_fqdn, 0x00, 64);
					memcpy (dscsd_server_fqdn, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
				else
				{
					time (&atime);
					fprintf (LogFile, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (LogFile);
				}
			}
		}
	}

	fclose (config_file);
	
}

