#include	"dv_repeater.h"

enum
{
        ECHO_SKIP = 0,
	ECHO_POSIT,
        ECHO_HEADER,
        ECHO_VOICE,
        ECHO_LAST
} echo_state = ECHO_SKIP;

extern enum
{
        SKIP,
        SEND_NULL,
        SEND_NULL_WAIT,
        SEND_SYS_POSIT,
        SEND_SYS_POSIT_WAIT,
        SEND_POSIT,
        SEND_POSIT_WAIT,
        SEND_HEADER,
        SEND_HEADER_WAIT,
        SEND_VOICE,
        SEND_VOICE_WAIT,
        SEND_LAST,
        SEND_LAST_WAIT,
        SEND_REPLY,
        SEND_REPLY_WAIT,
        SEND_ECHO_POSIT,
        SEND_ECHO_POSIT_WAIT,
        SEND_ECHO_HEADER,
        SEND_ECHO_HEADER_WAIT,
        SEND_ECHO_VOICE,
        SEND_ECHO_VOICE_WAIT,
        SEND_ECHO_LAST,
        SEND_ECHO_LAST_WAIT
} dv_state;

struct	timeval	echo_send_time;
struct	timeval echo_interval;
struct	timeval	echo_temp;
char	echo_buff[58];
extern	char	lastframe[];

void	echo_server_header (char header[])
{
	time_t	atime;

	time(&atime);
	echo_file = tmpfile();
	if (echo_file == NULL)
	{
		fprintf (log_file, "%24.24s tmpfile open error %s\n", 
			ctime(&atime), strerror(errno));
		fflush (log_file);
		memset (echo_server, 0x00, 8);
		return;
	}
	fwrite (header, 58, 1, echo_file);
}

void	echo_server_voice (char voice[])
{
	fwrite (voice, 29, 1, echo_file);
}

void	echo_server_last (void)
{
	gettimeofday (&echo_temp, NULL);
	echo_interval.tv_sec = 2;
	echo_interval.tv_usec = 0;
	timeradd (&echo_temp, &echo_interval, &echo_send_time);
	fflush (echo_file);
	rewind (echo_file);
	echo_state = ECHO_HEADER;
	EchoInTime.tv_sec = 0;
	EchoInTime.tv_usec = 0;
}

void	echo_server_send (void)
{
	if (dv_state != SKIP) return;
	gettimeofday (&echo_temp, NULL);
	switch (echo_state)
	{
		case ECHO_SKIP:
			break;

		case ECHO_POSIT:
			dv_state = SEND_ECHO_POSIT;
			echo_state = ECHO_SKIP;
			break;

		case ECHO_HEADER:
			if (timercmp (&echo_send_time, &echo_temp, >)) break;
			echo_state = ECHO_VOICE;
			fread (echo_buff, 58, 1, echo_file);
			echo_interval.tv_sec = 0;
			echo_interval.tv_usec = 100000;  /* 100 m sec. */
			timeradd (&echo_temp, &echo_interval, &echo_send_time);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header, &echo_buff[17], 41);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header.RPT2Call, gateway_callsign, 8);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header.RPT1Call, area_rep_callsign, 8);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header.YourCall, 
					&echo_dv_pkt.dstar_udp.rf_header.MyCall, 8);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header.MyCall, echo_server, 8);
			memcpy (&echo_dv_pkt.dstar_udp.rf_header.MyCall2, "ECHO", 4);
			echo_header_send_set();
			echo_seq = 0;
                	dv_state = SEND_ECHO_HEADER;
			break;
	
		case ECHO_VOICE:
			if (timercmp (&echo_send_time, &echo_temp, >)) break;
			memcpy (&echo_temp, &echo_send_time, sizeof (echo_temp));
			echo_interval.tv_sec = 0;
			echo_interval.tv_usec = 20000;  /* 20 m sec. */
			timeradd (&echo_temp, &echo_interval, &echo_send_time);
			if (fread (echo_buff, 29, 1, echo_file) == 1)
			{
				memcpy (&echo_dv_pkt.dstar_udp.voice_d, &echo_buff[17], 12);
                                dv_pkt_set(&echo_dv_pkt);
                                echo_dv_pkt.b_bone.seq = echo_seq;
                                echo_seq++;
                                if (echo_seq >= 21) echo_seq = 0;
                                echo_dv_pkt.length[0] = 0x00;
                                echo_dv_pkt.length[1] = 19;  /* 29 - 10 */
				dv_state = SEND_ECHO_VOICE;
				break;
			}
			echo_state = ECHO_LAST;
			fclose (echo_file);
			break;

		case ECHO_LAST:
			memcpy (&echo_dv_pkt.dstar_udp.voice_d.data_segment, 
					lastframe, 6);
                        dv_pkt_set(&echo_dv_pkt);
                        echo_dv_pkt.b_bone.seq = seq | 0x40;
                        echo_dv_pkt.length[0] = 0x00;
                        echo_dv_pkt.length[1] = 22;  /* 32 - 10 */
			dv_state = SEND_ECHO_LAST;
			echo_state = ECHO_SKIP;
			break;
	}	
}

