#include	"dv_repeater.h"

extern enum
{
        SKIP,
        SEND_NULL,
        SEND_NULL_WAIT,
        SEND_SYS_POSIT,
        SEND_SYS_POSIT_WAIT,
        SEND_POSIT,
        SEND_POSIT_WAIT,
        SEND_HEADER,
        SEND_HEADER_WAIT,
        SEND_VOICE,
        SEND_VOICE_WAIT,
        SEND_LAST,
        SEND_LAST_WAIT,
        SEND_REPLY,
        SEND_REPLY_WAIT,
        SEND_ECHO_POSIT,
        SEND_ECHO_POSIT_WAIT,
        SEND_ECHO_HEADER,
        SEND_ECHO_HEADER_WAIT,
        SEND_ECHO_VOICE,
        SEND_ECHO_VOICE_WAIT,
        SEND_ECHO_LAST,
        SEND_ECHO_LAST_WAIT
} dv_state;

void	dv_pkt_set(struct dv_packet *hdr);

char    lastframe[6] ={0x55, 0x55, 0x55, 0x55, 0xc8, 0x7a};

void    header_read_from_rig(void)         /* read from rig (DV packet) */
{
	int	ret;

        /***  from RIG  ***/

	if (dv_state != SKIP) return;

        ret = usb_control_msg(udev, 0xC0, GET_HEADER, 0, 0, usb.buffer, 32, 200);
        if (ret > 0)
        {
		if (usb_control_msg(udev, 0xC0, GET_HEADER, 
					0, 0, &usb.buffer[32], 9, 200) < 0)
		{
			return;
		}
                if (debug)
                {
                	time (&cur_time);
                        fprintf (log_file, "%24.24s from RIG Flags: %2.2x %2.2x %2.2x\n",
                        	ctime(&cur_time), usb.hdr.flags[0], usb.hdr.flags[1], usb.hdr.flags[2]);
                        fprintf (log_file, "%24.24s from RIG RPT2:%8.8s RPT1:%8.8s\n",
                                ctime(&cur_time), usb.hdr.RPT2Call, usb.hdr.RPT1Call);
                        fprintf (log_file, "%24.24s from RIG YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n",
                                ctime(&cur_time), usb.hdr.YourCall, usb.hdr.MyCall, usb.hdr.MyCall2);
                        fflush (log_file);
			rig_pkt_cnt = 0;
                }
		if (status & CRC_ERROR)
		{
			time(&cur_time);
			fprintf (log_file, "%24.24s CRC ERROR of RF header\n", ctime(&cur_time));
			fflush (log_file);
			return;
		}

		if (memcmp (usb.hdr.RPT1Call, area_rep_callsign, 8)) return;
		if (!(usb.hdr.flags[0] & 0x40))
		{
			//gw_resp_sw = TRUE;
			memcpy (gw_resp.MyCall, area_rep_callsign, 8);
			memcpy (gw_resp.YourCall, usb.hdr.MyCall, 8);
			memcpy (gw_resp.RPT1Call, area_rep_callsign, 8);
			memcpy (gw_resp.RPT2Call, area_rep_callsign, 8);
			gw_resp.flags[0] = 0x01;
			gw_resp.flags[1] = 0x00;
			gw_resp.flags[2] = 0x00;
			return;
		}
		else
		{
			if (!memcmp (usb.hdr.MyCall, "        ", 8)
			|| !memcmp (usb.hdr.YourCall, "        ", 8))
			{
				//gw_resp_sw = TRUE;
				memset (gw_resp.RPT2Call, 0x20, 36);
				memcpy (gw_resp.MyCall, area_rep_callsign, 8);
				gw_resp.flags[0] = 0x02;
				gw_resp.flags[1] = 0x00;
				gw_resp.flags[2] = 0x00;
				return;
			}
		}

		HeaderLength = 41;

		memcpy (&dv_pkt.dstar_udp.rf_header, usb.buffer, 41);
		dv_pkt.dstar_udp.rf_header.flags[0] &= 0xbf;	/* clear repeater flag */

       		memcpy (posit.id, "DSTR", 4);
       		posit.m[0] = m >> 8;
       		posit.m[1] = m & 0xff;
       		posit.sr = 's';
		posit.c = 0x21;	/* position */
		posit.length[0] = 0x00;
		posit.length[1] = 0x10;
		memcpy (posit.call1, dv_pkt.dstar_udp.rf_header.MyCall, 8);
		memcpy (posit.call2, dv_pkt.dstar_udp.rf_header.RPT1Call, 8);
		dv_state = SEND_POSIT;
	}
	else if (ret < 0)
	{
		sig_term = TRUE;
		time (&cur_time);
		fprintf (log_file, "%24.24s Node Adapter Down\n", ctime(&cur_time));
		fflush (log_file);
	}
}

void	header_send_set_from_rig(void)
{
	unsigned short int	tmp;

	dv_pkt_set(&dv_pkt);
	dv_pkt.length[0] = 0x00;
	dv_pkt.length[1] = 0x30;
	dv_pkt.b_bone.id = 0x20;	/* voice */
	tmp = rand() & 0xffff;
	memcpy (dv_pkt.b_bone.frame_id, &tmp, 2);
	dv_pkt.b_bone.seq = 0x80;

	NoRespReply_sw = TRUE;
	memcpy (&NoResp, usb.buffer, 41);
	seq = 0;
	last_frame_sw = TRUE;

	if (monitor_port)
	{
		if (sendto (monitor_sd, &dv_pkt, 58, 0,
			monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
		{
			time (&cur_time);
			fprintf (log_file, "%24.24s send error (monitor header) %s\n", ctime(&cur_time), strerror(errno));
			fflush (log_file);
		}
	}
	if (repeater) header_send (usb.hdr);
}

int	voice_read_from_rig()
{
	int	i;
	int	ret;

	int	read_len;

	if (dv_state != SKIP) return 0;

	read_len = 24 - voice_pnt;

	ret = usb_control_msg(udev, 0xC0, GET_DATA, 0, 0, usb.buffer, read_len, 200);
	if (ret > 0)
	{
		usb_read_cnt = 0;
		for (i = 0 ; i < ret; i++)
		{
			voice_save[voice_pnt] = usb.buffer[i];
			voice_pnt++;
			if (voice_pnt == 24)
			{
				voice_pnt = 12;
				memcpy (&dv_pkt.dstar_udp.voice_d, voice_save, 12);
				if (repeater) voice_send (voice_save);
				memcpy (voice_save, &voice_save[12], 12);
				dv_pkt_set(&dv_pkt);
				dv_pkt.b_bone.seq = seq;
				seq++;
				if (seq >= 21) seq = 0;
				dv_pkt.length[0] = 0x00;
				dv_pkt.length[1] = 19;  /* 29 - 10 */
				dv_state = SEND_VOICE;
				if (debug) rig_pkt_cnt++;
				if (monitor_sd)
				{
					if (sendto (monitor_sd, &dv_pkt, 29, 0,
						monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
					{
						time (&cur_time);
						fprintf (log_file, "%24.24s send error (monitor voice) %s\n", ctime(&cur_time), strerror(errno));
						fflush (log_file);
					}
				}
			}
			else if (voice_pnt == 15)
			{
				if (!memcmp (&voice_save[9], lastframe, 6))
				{
					memcpy (&dv_pkt.dstar_udp.voice_d, voice_save, 15);
					if (repeater) last_send (voice_save);
					dv_pkt_set(&dv_pkt);
					dv_pkt.b_bone.seq = seq | 0x40;
					dv_pkt.length[0] = 0x00;
					dv_pkt.length[1] = 22;	/* 32 - 10 */
					dv_state = SEND_LAST;
					last_frame_sw = FALSE;
					if (monitor_sd)
					{
						sendto (monitor_sd, &dv_pkt, 32, 0,
							monitor_out->ai_addr,	monitor_out->ai_addrlen);
					}
					if (debug)
					{
						time(&cur_time);
						fprintf (log_file, "%24.24s from RIG packet:%ld\n", ctime(&cur_time), rig_pkt_cnt);
						fflush (log_file);
					}
				}	
			}	
		}
		return ret;
	}
//	else
//	{
//		if (debug)
//		{
//			time(&cur_time);
//			fprintf (log_file, "%24.24s usb ret %d\n", ctime(&cur_time), ret);
//			fflush (log_file);
//		}
//	}
	return 0;
}

void	last_frame_send (void)
{
	if (dv_state != SKIP) return;

	memcpy (&dv_pkt.dstar_udp.voice_d.data_segment, lastframe, 6);
	dv_pkt_set(&dv_pkt);
	dv_pkt.b_bone.seq = seq;
	dv_pkt.b_bone.seq |= 0x40;
        dv_pkt.length[0] = 0x00;
        dv_pkt.length[1] = 22;	/* 32 - 10 */
	dv_state = SEND_LAST;
	last_frame_sw = FALSE;

	if (monitor_port)
	{
		if (sendto (monitor_sd, &dv_pkt, 32, 0,
			monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
		{
			time (&cur_time);
			fprintf (log_file, "%24.24s send error (monitor last) %s\n", ctime(&cur_time), strerror(errno));
			fflush (log_file);
		}
	}
}

