#include	"dv_repeater.h"

int	handler_init(void);
int     read_config(int argc, char **argv);
int	node_usb_init(void);

int	init(int argc, char **argv)
{
	int	err;

	uname (&uname_buf);
	tzset();
	daemon (0, 0);

	gateway_port = 0;
	sys_timeout.tv_sec = 60;
	sys_timeout.tv_usec = 0;
	NoRespReply_sw = FALSE;
	recv_sw = FALSE;
	HeaderLength = 0;
	repeater = FALSE;
	VenderID = 0x4d8;
	ProductID = 0x300;

	reply_busy_sw = FALSE;

	monitor_port = 0;
	memset (monitor_name, 0x00, 128);

/* LOG FILE open */
	log_file = fopen (LOG_FILE, "a");
	time (&cur_time);
	fprintf (log_file, "\n%24.24s dv_repeater start V%s (%s %s)\n", ctime(&cur_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fflush(log_file);

/* make PID file */
	pid_file = fopen (PID_FILE, "w");
	if (pid_file == NULL)
	{
		fprintf (log_file, "%24.24s Already running dv_repeater.\n", 
			ctime(&cur_time));
		fflush (log_file);
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file);

	if (!handler_init()) return FALSE;

	if (!read_config(argc, (char **)argv)) return FALSE;

	if (debug)
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s area repeater : %8.8s\n", 
			ctime(&cur_time), area_rep_callsign);
		fprintf (log_file, "%24.24s gateway call  : %8.8s\n", 
			ctime (&cur_time), gateway_callsign);
		fprintf (log_file, "%24.24s system call   : %8.8s\n",
			ctime(&cur_time), sys_call);
		if (echo_server[0] != 0x00)
		{
			fprintf (log_file, "%24.24s echo_server   : %s\n",
			ctime (&cur_time), echo_server);
		}
		fprintf (log_file, "%24.24s gateway : %s:%d\n",
			ctime (&cur_time), gateway_name, gateway_port);
		if (monitor_port)
		{
			fprintf (log_file, "%24.24s monitor : %s:%d\n",
				ctime (&cur_time), monitor_name, monitor_port);
		}
		fflush (log_file);
	}


	voice_pnt = 0;
	seq = 0;
	m = 0;
	last_frame_sw = FALSE;
	sig_term = FALSE;

	if (!node_usb_init()) return FALSE;

        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = PF_UNSPEC;
        hints.ai_flags = AI_PASSIVE;
        sprintf (PORT, "%d", gateway_port);
        if ((err = getaddrinfo (NULL, PORT, &hints, &gateway_in)) != 0)
        {
                time (&cur_time);
                fprintf (log_file, "%24.24s getaddrinfo error(gateway in) %s\n",
                        ctime(&cur_time), gai_strerror(err));
                fprintf (log_file, "%24.24s gatewaay : %s\n", ctime(&cur_time), gateway_name);
                fflush (log_file);
        }
        if((in_sd = socket(gateway_in->ai_family, gateway_in->ai_socktype, gateway_in->ai_protocol)) < 0)
	{
		fprintf (log_file, "%24.24s socket error in gateway in %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
                return FALSE;
        }

	if (monitor_port)
	{ 
		memset (&hints, 0x00, sizeof(hints));
		hints.ai_socktype = SOCK_DGRAM;
		hints.ai_family = PF_UNSPEC;
		sprintf (PORT, "%d", monitor_port);
		time (&cur_time);
		if ((err = getaddrinfo (monitor_name, PORT, &hints, &monitor_out)) != 0)
		{
			fprintf (log_file, "%24.24s getaddrinfo error(monitor out) %s\n",
				ctime(&cur_time), gai_strerror(err));
			fprintf (log_file, "%24.24s monitor : %s\n", ctime(&cur_time), monitor_name);
			fflush (log_file);
		}
		if((monitor_sd = socket(monitor_out->ai_family, monitor_out->ai_socktype, monitor_out->ai_protocol)) < 0) {
			fprintf (log_file, "%24.24s socket error in monitor port %s\n",
				ctime (&cur_time), strerror (errno));
			fflush (log_file);
			return FALSE;
		}
	}

        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = PF_UNSPEC;
        sprintf (PORT, "%d", gateway_port);
	time (&cur_time);
        if ((err = getaddrinfo (gateway_name, PORT, &hints, &gateway_out)) != 0)
        {
                fprintf (log_file, "%24.24s getaddrinfo error(gateway out) %s\n",
                        ctime(&cur_time), gai_strerror(err));
                fprintf (log_file, "%24.24s gatewaay : %s\n", ctime(&cur_time), gateway_name);
                fflush (log_file);
        }
	if((out_sd = socket(gateway_out->ai_family, gateway_out->ai_socktype, gateway_out->ai_protocol)) < 0)
	{
		fprintf (log_file, "%24.24s socket error in gateway port %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
		return FALSE;
	}

	time(&cur_time); 
	if(bind(in_sd, gateway_in->ai_addr, gateway_in->ai_addrlen) < 0) 
	{
		fprintf (log_file, "%24.24s bind error in gateway port %s\n",
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
		return FALSE;
	}

	memset(buf, 0, sizeof(buf));
 
	gettimeofday (&tm0, NULL);
	srand(tm0.tv_sec);
	tm0.tv_sec -= sys_timeout.tv_sec;
	tm0.tv_usec = sys_timeout.tv_usec;

	HeaderLength = 0;
	voice_skip_sw = FALSE;
	memset (save_frame_id, 0x00, 2);
	InetInTime.tv_sec = 0;
	InetInTime.tv_usec = 0;
	EchoInTime.tv_sec = 0;
	EchoInTime.tv_usec = 0;

	return TRUE;
}

