#include	"dv_repeater.h"

int     init(int argc, char **argv);
extern	char	lastframe[];
extern	char	echo_buff[];
enum
{
	SKIP = 0,
	SEND_NULL,
	SEND_NULL_WAIT,
	SEND_SYS_POSIT,
	SEND_SYS_POSIT_WAIT,
	SEND_POSIT,
	SEND_POSIT_WAIT,
	SEND_HEADER,
	SEND_HEADER_WAIT,
	SEND_VOICE,
	SEND_VOICE_WAIT,
	SEND_LAST,
	SEND_LAST_WAIT,
	SEND_REPLY,
	SEND_REPLY_WAIT,
	SEND_ECHO_POSIT,
	SEND_ECHO_POSIT_WAIT,
	SEND_ECHO_HEADER,
	SEND_ECHO_HEADER_WAIT,
	SEND_ECHO_VOICE,
	SEND_ECHO_VOICE_WAIT,
	SEND_ECHO_LAST,
	SEND_ECHO_LAST_WAIT
} dv_state = SKIP;

void	send_inet(void)
{
	int	ret;
	struct	timeval	tmp_tm;

	/* sending to INET (dsgwd) */
	switch (dv_state)
	{
		case SKIP:
			if (reply_busy_sw)
			{
				dv_state = SEND_REPLY;
				break;
			}
			timersub (&tm1, &tm0, &tmp_tm);
			if (timercmp (&tmp_tm, &sys_timeout, >))
			{
				timeradd (&tm0, &sys_timeout, &tmp_tm);
				tm0.tv_sec = tmp_tm.tv_sec;
				tm0.tv_usec = tmp_tm.tv_usec;
				dv_state = SEND_NULL;
				if (debug)
				{
					time (&cur_time);
					fprintf (log_file, "%24.24s send POSITION Info (seq:%d(0x%4.4x))\n", 
						ctime(&cur_time), m, m & 0xffff);
					fflush (log_file);
				}
			}
			break;
		case SEND_NULL:
                       	memcpy (posit.id, "DSTR", 4);
                       	posit.sr = 's';
                       	posit.c= 0x00;          /* null */
                       	posit.length[0] = 0x00;
                       	posit.length[1] = 0x00;		/* length 0 */
                       	posit.m[0] = m >> 8;
                       	posit.m[1] = m & 0xff;

                       	ret = sendto(in_sd, &posit, 10, 0,
                               	gateway_out->ai_addr, gateway_out->ai_addrlen);
                       	if (ret < 0) {
				fprintf (log_file, "%24.24s null(sync) packet send error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
                       	}
			dv_state = SEND_NULL_WAIT;
			loop_cnt = 0;
			break;
		case SEND_NULL_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SEND_SYS_POSIT;
			else
			{
				if (debug)
				{
					time (&cur_time);
					fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
					ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
					fflush (log_file);
				}
				m = recv_m;
				dv_state = SEND_NULL;
			}
			break;

		case SEND_SYS_POSIT:
			memcpy (posit.id, "DSTR", 4);
			memcpy (posit.call1, sys_call, 8);
			memcpy (posit.call2, sys_call, 8);
			posit.sr = 's';
			posit.c= 0x21;		/* position */
			posit.length[0] = 0x00;
			posit.length[1] = 0x10;		/* length 16 */
			posit.m[0] = m >> 8;
			posit.m[1] = m & 0xff;
	
    			ret = sendto(in_sd, &posit, 26, 0,
             				gateway_out->ai_addr, gateway_out->ai_addrlen);
    			if (ret < 0) {
				fprintf (log_file, "%24.24s position packet send error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
    			}
			dv_state = SEND_SYS_POSIT_WAIT;
			loop_cnt = 0;
			break;
		case SEND_SYS_POSIT_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SEND_ECHO_POSIT;
			else
			{
				if (loop_cnt++ > 10) dv_state = SEND_SYS_POSIT;
			}
			break;

		case SEND_POSIT:
               		ret = sendto (in_sd, &posit, 26, 0,
                       		gateway_out->ai_addr, gateway_out->ai_addrlen);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s position packet send error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			dv_state = SEND_POSIT_WAIT;
			loop_cnt = 0;
			break;
		case SEND_POSIT_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SEND_HEADER;
			else
			{
				if (loop_cnt++ > 10) dv_state = SEND_POSIT;
			}
			break;

		case SEND_HEADER:
			header_send_set_from_rig();
               		ret = sendto (in_sd, &dv_pkt, 58, 0,
                       		gateway_out->ai_addr, gateway_out->ai_addrlen);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s header packet send error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			dv_state = SEND_HEADER_WAIT;
			loop_cnt = 0;
			break;
		case SEND_HEADER_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SKIP;
			else
			{
				if (loop_cnt++ > 10) dv_state = SEND_HEADER;
			}
			break;

		case SEND_VOICE:
			ret = sendto (in_sd, &dv_pkt, 29, 0,
				gateway_out->ai_addr, gateway_out->ai_addrlen);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s voice packet send error %s\n", 
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			dv_state = SEND_VOICE_WAIT;
			loop_cnt = 0;
			break;
		case SEND_VOICE_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SKIP;
			else
			{
				if (loop_cnt++ > 10) dv_state = SEND_VOICE;
			}
			break;

		case SEND_LAST:
                        ret = sendto (in_sd, &dv_pkt, 32, 0,
       				gateway_out->ai_addr, gateway_out->ai_addrlen);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s last packet send error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			dv_state = SEND_LAST_WAIT;
			loop_cnt = 0;
			break;
		case SEND_LAST_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SKIP;
			else 
			{
				if (loop_cnt++ > 10) dv_state = SEND_LAST;
			}	
			break;

		case SEND_REPLY:
			reply_busy_sw = FALSE;
			ret = sendto (in_sd, &reply_dv_pkt, 58, 0,
		              gateway_out->ai_addr, gateway_out->ai_addrlen);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s last packet send error %s\n",
					 ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			dv_state = SEND_REPLY_WAIT;
			loop_cnt = 0;
			break;
		case SEND_REPLY_WAIT:
			if (!recv_check()) break;
			if (seq_check ()) dv_state = SKIP;
			else
			{
				if (loop_cnt++ > 10) dv_state = SEND_REPLY;
			}
			break;

                case SEND_ECHO_POSIT:
			if (echo_server[0] == 0x00)
			{
				dv_state = SKIP;
				break;
			}
                        memcpy (echo_posit.id, "DSTR", 4);
                        memcpy (echo_posit.call1, echo_server, 8);
                        memcpy (echo_posit.call2, area_rep_callsign, 8);
                        echo_posit.sr = 's';
                        echo_posit.c= 0x21;          /* position */
                        echo_posit.length[0] = 0x00;
                        echo_posit.length[1] = 0x10;         /* length 16 */
                        echo_posit.m[0] = m >> 8;
                        echo_posit.m[1] = m & 0xff;

                        ret = sendto (in_sd, &echo_posit, 26, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0)
                        {
                                fprintf (log_file, "%24.24s position packet send error (echo server) %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
                        dv_state = SEND_ECHO_POSIT_WAIT;
                        loop_cnt = 0;
                        break;
                case SEND_ECHO_POSIT_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ()) dv_state = SKIP;
                        else
                        {
                                if (loop_cnt++ > 10) dv_state = SEND_ECHO_POSIT;
                        }
                        break;

                case SEND_ECHO_HEADER:
                        ret = sendto (in_sd, &echo_dv_pkt, 58, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0)
                        {
                                fprintf (log_file, "%24.24s header packet send error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
                        dv_state = SEND_ECHO_HEADER_WAIT;
                        loop_cnt = 0;
                        break;
                case SEND_ECHO_HEADER_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ()) dv_state = SKIP;
                        else
                        {
                                if (loop_cnt++ > 10) dv_state = SEND_ECHO_HEADER;
                        }
                        break;

                case SEND_ECHO_VOICE:
                        ret = sendto (in_sd, &echo_dv_pkt, 29, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0)
                        {
                                fprintf (log_file, "%24.24s voice packet send error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
                        dv_state = SEND_ECHO_VOICE_WAIT;
                        loop_cnt = 0;
                        break;
                case SEND_ECHO_VOICE_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ()) dv_state = SKIP;
                        else
                        {
                                if (loop_cnt++ > 10) dv_state = SEND_ECHO_VOICE;
                        }
                        break;

                case SEND_ECHO_LAST:
                        ret = sendto (in_sd, &echo_dv_pkt, 32, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0)
                        {
                                fprintf (log_file, "%24.24s last packet send error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
                        dv_state = SEND_ECHO_LAST_WAIT;
                        loop_cnt = 0;
                        break;
                case SEND_ECHO_LAST_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ())
			{
				dv_state = SKIP;
				memset (echo_frame_id, 0x00, 2);
			}
                        else
                        {
                                if (loop_cnt++ > 10) dv_state = SEND_ECHO_LAST;
                        }
                        break;

	}
}

