#include	"dv_repeater.h"

void	header_send (struct dv_header header)
{
	unsigned char	len;

	if (debug)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s from dsgwd RPT2:%8.8s RPT1%8.8s Ur:%8.8s My:%8.8s/%4.4s\n", ctime(&cur_time), header.RPT2Call, header.RPT1Call, header.YourCall, header.MyCall, header.MyCall2);
		fflush (log_file);
	}

	if (cos_check()) return;
	
	/* Callsign set */
	usb_control_msg(udev, 0x40, SET_MyCALL, 0, 0, header.MyCall, 8, 100);
	usb_control_msg(udev, 0x40, SET_MyCALL2, 0, 0, header.MyCall2 , 4, 100);
	usb_control_msg(udev, 0x40, SET_YourCALL, 0, 0, header.YourCall, 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT1CALL, 0, 0, header.RPT1Call, 8, 100);
	usb_control_msg(udev, 0x40, SET_RPT2CALL, 0, 0, header.RPT2Call, 8, 100);
	header.flags[0] &= 0x07;
	usb_control_msg(udev, 0x40, SET_FLAGS, 0, 0, header.flags, 3, 100);

	usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
	while (len < 95)
	{
		usleep (100000);
		usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
	}
	usb_control_msg(udev, 0x40, SET_PTT, ON, 0, NULL, 0, 100);
}

void	voice_send (char voice[])
{
	int	ret;
	unsigned char	len;
 	
	usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
	while (len < 12)
	{
		usleep (20000);
		usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
	}
	ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
	while (ret < 0)
	{
		usleep (2000);
		ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 12, 100);
	}
}

void	last_send (char voice[])
{
	int	ret;
	unsigned char	len;

	usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
	while (len < 15)
        {
                usleep (20000);
                usb_control_msg(udev, 0xc0, GET_REMAINSPACE, 0, 0, (char *)&len ,1, 100);
        }
        ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 15, 100);
        while (ret < 0)
        {
                usleep (2000);
                ret = usb_control_msg(udev, 0x40, PUT_DATA, 0, 0, voice, 15, 100);
        }
	/* PTT OFF */
	ret = usb_control_msg(udev, 0x40, SET_PTT, OFF, 0, NULL, 0, 100);
}

