#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<string.h>
#include	<sys/time.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<usb.h>
#include	<sys/utsname.h>
#include	<signal.h>
#include	<sys/select.h>
#include	<errno.h>
#include	<netdb.h>
#include	<time.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<linux/tty.h>
#include	<sys/ioctl.h>
#include	"config.h"
#include	"node.h"
#include	"dstar.h"

#define		CONFIG_FILE	"/opt/dv_repeater/etc/dv_repeater.conf"
#define		LOG_FILE	"/var/log/dv_repeater.log"
#define		PID_FILE	"/var/run/dv_repeater.pid"
#define		TRUE	1
#define		FALSE	0
#define		RECHECK	60

#define		DVAP_DEVICE	"/dev/dvap"
#define		DVAP_SPEED	230400


void	print_PICinfo(void);
void    header_read_from_rig(void);
int	voice_read_from_rig(void);
void	last_frame_send(void);
void    header_send(struct dv_header header);
void    voice_send(char voice[]);
void	last_send(char	voice[]);
int	cos_check(void);
int     htoi (const char *s);
int	seq_check(void);
int	recv_check(void);
void	send_response(void);
void	header_send_set_from_rig(void);
void	printOnOff( char sw);
void    putFifo (int len, struct dv_packet pkt);
int     getFifo (int *len, struct dv_packet *pkt);
void	node_usb_init(void);
void	dvap_open(void);
void	dvap_close(void);
void	node_close (void);


usb_dev_handle *udev;
union
{
	char	buffer[32];
	struct	dv_header	hdr;
} usb;
char	status;
int	CrcSW, Notice;
int	HeaderLength;
int	voice_pnt;
char	seq;
int	m;
int	recv_m;
int	recv_sw;

struct	dv_packet	dv_pkt;
struct	dv_packet	node_pkt;
struct	dv_packet	dvap_pkt;
struct	dv_packet	echo_dv_pkt;
struct	dv_packet	reply_dv_pkt;
struct	dv_packet	posit;
struct	dv_packet	echo_posit;

int	in_sd;
int	out_sd;
int	monitor_sd;

char	voice_temp[12];
char	voice_save[24];

char	node_area_rep_callsign[8];
char	dvap_area_rep_callsign[8];
char	gateway_callsign[8];
char	sys_call[8];
char	echo_area_rep_callsign[8];
char	echo_server[8];

FILE	*log_file;
FILE	*pid_file;

int	debug;

struct utsname      uname_buf;
time_t	cur_time;
int	sig_term;
char	gateway_name[128];
int	gateway_port;
int	repeater;
int	node_last_frame_sw;
int	dvap_last_frame_sw;
int	send_null_sw;
struct	dv_header	gw_resp;
int	gw_resp_sw;

struct	addrinfo	hints;
struct	addrinfo	*gateway_in;
struct	addrinfo	*gateway_out;
struct	addrinfo	*monitor_out;
char	PORT[8];

struct	sockaddr_storage	in_addr;
socklen_t	in_addr_len;

struct	timeval		sys_timeout;
char		node_save_frame_id[2];
char		dvap_save_frame_id[2];
int		monitor_port;
char		monitor_name[128];

struct	sockaddr_storage	mon_addr;
socklen_t			mon_addr_len;

struct  usb_bus *bus;
struct  usb_device      *dev;
int     dev_found;

struct	timeval	tm0, tm1;

char	buf[2048];

/* for pselect */
struct	timeval	tv;
fd_set  rfds;

struct	timeval	CosOffTime;
struct	timeval	InetInTime;
int	NoRespReply_sw;
struct	dv_header	NoResp;
int	usb_read_cnt;
int	loop_cnt;

long	int	node_rig_pkt_cnt;
long	int	dvap_rig_pkt_cnt;
long	int	node_inet_pkt_cnt;
long	int	dvap_inet_pkt_cnt;
long	int	echo_pkt_cnt;

/* node adapter */
int	VenderID;
int	ProductID;

/* misc switch */

/* Jitter buffer */
struct	echo
{
	struct	echo	*next;
	long	int	in_cnt;
	long	int	out_cnt;
	struct	timeval	send_time;
	struct	timeval	EchoInTime;
	FILE	*tmp_file;
	int	echo_state;
	int	jitter_out_pnt;
	int	jitter_cnt;
	int	seq;
	char	jitter[21][12];
	char	callsign[8];
	char	frame_id;
	char	recv_seq;
	char	msg[20];
	char	mini_header;
	char	msg_tmp[5];
};

struct	echo	*echo_pnt;

int	send_echo_skip;

struct	FifoPkt
{
	struct	FifoPkt	*next;
	int	length;
	struct	dv_packet	pkt;
};

struct	FifoPkt *Rp;
struct	FifoPkt *Wp;

int	init_sw;
int	dvap_voice_send_sw;
int	node_voice_send_sw;

/* dvap dongle */
char	dvap_device[16];
int	dvap_speed;

int	dvap_fd;

time_t	dvap_keep_alive;

int	dvap_buff_pnt;
struct	timeval	dvap_InTime;

int	node_sw;
int	dvap_sw;
long	int	dvap_freq;
long	int	dvap_rx_freq;
long	int	dvap_tx_freq;
int	dvap_init;

time_t	re_check;
