#include	"dv_repeater.h"

void	node_close (void)
{
        usb_reset (udev);
        usb_close (udev);
	node_sw = FALSE;
	time(&cur_time);
	fprintf (log_file, "%24.24s Node Adapter down.\n", ctime(&cur_time));
	fflush (log_file);
}

void	dv_pkt_set(struct dv_packet *hdr)
{
	memcpy (hdr->id, "DSTR", 4);
	hdr->sr = 's';
	hdr->c = 0x12;	/* voice */
	hdr->dstar.b_bone.b_b.dest_repeater_id = 0x00;
	hdr->dstar.b_bone.b_b.send_repeater_id = 0x01;
	hdr->dstar.b_bone.b_b.send_terminal_id = 0x03;
}

void	send_reply (char buf[])
{
	char	reply_buf[10];

	memset (reply_buf, 0x00, 10);
	memcpy (reply_buf, buf, 6);
	reply_buf[6] = 'r';
	if (sendto (in_sd, reply_buf, 10, 0,
		(struct sockaddr *)&in_addr, sizeof (struct sockaddr)) < 0)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s send reply error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
	}
}

int	cos_check(void)
{
	if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100) < 0)
	{
		node_close();      /* node adapter down ? */
		return FALSE;
	}
	if (status & COS_OnOff) return TRUE;
	return FALSE;
}

int	htoi (const char *s)
{
	int n;

	if ( *s != '0' || !(*(s+1) != 'x' || *(s+1) != 'X') ) return 0;
    
	for (n=0,s+=2 ; *s ; s++)
	{
		if ( *s >= '0' && *s <= '9' ) 
		{
			n = 16 * n + (*s - '0');
		}
		else if ( *s >= 'a' && *s <= 'f' ) {
			n = 16 * n + ((*s - 'a') + 10);
		}
		else if ( *s >= 'A' && *s <= 'F' ) {
			n = 16 * n + ((*s - 'A') + 10);
		}
	}
    
	return n;
}

int	seq_check (void)
{
	if (recv_m == m)
	{
		m++;
		m &= 0xffff;
		return TRUE;
	}	
	return FALSE;
}

int	recv_check(void)
{
	if (!recv_sw) return FALSE;
	recv_sw = FALSE;
	return TRUE;
}

void	printOnOff (char sw)
{
	if (sw) fprintf (log_file, "ON\n");
	else	fprintf (log_file, "OFF\n");
}

void    echo_header_send_set(void)
{
        unsigned short int      tmp;

        dv_pkt_set(&echo_dv_pkt);
        echo_dv_pkt.length[0] = 0x00;
        echo_dv_pkt.length[1] = 0x30;
        echo_dv_pkt.dstar.b_bone.b_b.id = 0x20;        /* voice */
        tmp = rand() & 0xffff;
        memcpy (echo_dv_pkt.dstar.b_bone.b_b.frame_id, &tmp, 2);
        echo_dv_pkt.dstar.b_bone.b_b.seq = 0x80;
}

void	putFifo (int len, struct dv_packet pkt)
{
	struct FifoPkt	*ret;
	ret = malloc (sizeof (struct FifoPkt));
	if (ret == NULL)
	{
		fprintf (log_file, "memory error\n");
		fflush (log_file);
		return;
	}
	ret->next = NULL;
	ret->length = len;
	memcpy (&ret->pkt, &pkt, len);
	Wp->next = ret;
	Wp = ret;
}

int	getFifo (int *len, struct dv_packet *pkt)
{
	struct	FifoPkt	*tmp;

	if (Rp->next == NULL) return FALSE;
	tmp = Rp;
	Rp = Rp->next;
	*len = Rp->length;
	memcpy (pkt, &Rp->pkt, Rp->length);
	free (tmp);
	return TRUE;
}

void	short_msg(struct echo *echo, char voice[])
{
	if ((voice[16] & 0x1f) % 2)
	{
		echo->mini_header = voice[26] ^ 0x70;
		echo->msg_tmp[0] = voice [27] ^ 0x4f;
		echo->msg_tmp[1] = voice [28] ^ 0x93;
	}
	else
	{
		echo->msg_tmp[2] = voice[26] ^ 0x70;
		echo->msg_tmp[3] = voice[27] ^ 0x4f;
		echo->msg_tmp[4] = voice[28] ^ 0x93;
		switch (echo->mini_header)
		{
			case 0x40:      // short message
				memcpy (&echo->msg[0], &echo->msg_tmp[0], 5);
				break;
			case 0x41:
				memcpy (&echo->msg[5], &echo->msg_tmp[0], 5);
				break;
			case 0x42:
				memcpy (&echo->msg[10], &echo->msg_tmp[0], 5);
				break;
			case 0x43:
				memcpy (&echo->msg[15], &echo->msg_tmp[0], 5);
				break;
		}
	}
}
