#include	"dv_repeater.h"

struct	termios	save_attr;
char	dvap_buff[320];
char	dvap_header[47];
char	dvap_voice[18];
extern	char	lastframe[];

enum
{
	DVAP_IDLE = 0,
	DVAP_MODULATION,
	DVAP_FREQUENCY,
	DVAP_TX_FREQUENCY,
	DVAP_RX_FREQUENCY,
	DVAP_RUN
} dvap_state = DVAP_MODULATION;


void    dvap_last_frame_send (void)
{
        int     length;

        if (!dvap_voice_send_sw) return;
        dvap_rig_pkt_cnt++;
        memcpy (&dvap_pkt.dstar.b_bone.dstar_udp.voice_d, &dvap_voice[6], 12);
        dv_pkt_set(&dvap_pkt);
        dvap_pkt.dstar.b_bone.b_b.seq = dvap_voice[4];
        dvap_pkt.length[0] = 0x00;
	dvap_pkt.length[1] = 22;  /* 32 - 10 */
        memcpy (&dvap_pkt.dstar.b_bone.dstar_udp.voice_d.data_segment, lastframe, 6);
	putFifo (32, dvap_pkt);
        dvap_last_frame_sw = FALSE;

        if (monitor_port)
        {
                if (sendto (monitor_sd, &dvap_pkt, 32, 0,
                        monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
                {
                        time (&cur_time);
                        fprintf (log_file, "%24.24s send error (monitor last) %s\n", ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                }
        }
}
void	dvap(void)
{
	int	ret;

	char	modulation[5] = {0x05, 0x00, 0x28, 0x00, 0x01};
	char    RunState[5] = {0x05, 0x00, 0x18, 0x00, 0x01};
        char    TargetName[4] = {0x04, 0x20, 0x01, 0x00};
	char	frequency[8] = {0x08, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00};

	struct	timeval	timer_tmp1;
	struct	timeval timer_tmp2;

	switch (dvap_state)
	{
		case DVAP_IDLE:
			if (dvap_last_frame_sw)
			{
				gettimeofday (&timer_tmp2, NULL);
				timersub (&timer_tmp2, &dvap_InTime, &timer_tmp1);
				timer_tmp2.tv_sec = 0;
				timer_tmp2.tv_usec = 500000;
				if (timercmp (&timer_tmp1, &timer_tmp2, >)) 
				{
					dvap_last_frame_send();
				}	
			}
			break;

		case DVAP_MODULATION:
			ret = write (dvap_fd, modulation, 5);
			if (ret < 0)
			{
				time(&cur_time);
				fprintf (log_file, "%24.24s DVAP write (modulation) error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				dvap_close ();
				return;
			}
			dvap_state = DVAP_FREQUENCY;
			break;
		case DVAP_FREQUENCY:
			if (dvap_freq != 0)
			{
				frequency[4] = dvap_freq & 0xff;
				frequency[5] = (dvap_freq >> 8) & 0xff;
				frequency[6] = (dvap_freq >> 16) & 0xff;
				frequency[7] = (dvap_freq >> 24) & 0xff;
				ret = write (dvap_fd, frequency, 8);
				if (ret < 0)
				{
					time(&cur_time);
					fprintf (log_file, "%24.24s DVAP write (freuqncy) error %s\n",
						ctime(&cur_time), strerror(errno));
					fflush (log_file);
					dvap_close();
					return;
				}
			}
			dvap_state = DVAP_TX_FREQUENCY;
			break;
		case DVAP_TX_FREQUENCY:
			if (dvap_tx_freq != 0)
			{
				frequency[4] = dvap_tx_freq & 0xff;
				frequency[5] = (dvap_tx_freq >> 8) & 0xff;
				frequency[6] = (dvap_tx_freq >> 16) & 0xff;
				frequency[7] = (dvap_tx_freq >> 24) & 0xff;
				ret = write (dvap_fd, frequency, 8);
				if (ret < 0)
				{
					time(&cur_time);
					fprintf (log_file, "%24.24s DVAP write (freuqncy) error %s\n",
						ctime(&cur_time), strerror(errno));
					fflush (log_file);
					dvap_close ();
					return;
				}
			}
			dvap_state = DVAP_RX_FREQUENCY;
			break;
		case DVAP_RX_FREQUENCY:
			if (dvap_rx_freq)
			{
				frequency[4] = dvap_rx_freq & 0xff;
				frequency[5] = (dvap_rx_freq >> 8) & 0xff;
				frequency[6] = (dvap_rx_freq >> 16) & 0xff;
				frequency[7] = (dvap_rx_freq >> 24) & 0xff;
				ret = write (dvap_fd, frequency, 8);
				if (ret < 0)
				{
					time(&cur_time);
					fprintf (log_file, "%24.24s DVAP write (freuqncy) error %s\n",
						 ctime(&cur_time), strerror(errno));
					fflush (log_file);
					dvap_close ();
					return;
				}
			}	
			dvap_state = DVAP_RUN;
			break;
		case DVAP_RUN:
			/* clear read buffer */
			while (read (dvap_fd, dvap_buff, sizeof(dvap_buff)) != 0) ;
			ret = write (dvap_fd, RunState, 5);
			if (ret < 0)
			{
				time(&cur_time);
				fprintf (log_file, "%24.24s DVAP write error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				dvap_close ();
				return;
			}
			dvap_state = DVAP_IDLE;
			time (&dvap_keep_alive);
			dvap_init = TRUE;
			break;
	}
}
			
void	dvap_open(void)
{

        struct termios attr;
	int	speed;

        dvap_fd = open(dvap_device, O_RDWR | O_NOCTTY | O_NONBLOCK);
        if (dvap_fd < 0) 
	{
		time(&cur_time);
                fprintf (log_file, "%24.24s open error %s\n", 
			ctime(&cur_time), dvap_device);
		dvap_close ();
                return;
        }

        tcgetattr(dvap_fd, &attr);
        save_attr = attr;
        speed = B230400;

        cfsetispeed(&attr, speed);
        cfsetospeed(&attr, speed);
        cfmakeraw(&attr);
        attr.c_cflag |= CS8 | CLOCAL | CSTOPB;
        attr.c_iflag = IGNPAR;
        attr.c_oflag = 0;
        attr.c_lflag = 0;
        attr.c_cc[VMIN] = 0;
        attr.c_cc[VTIME] = 0;

        tcsetattr(dvap_fd, TCSANOW, &attr);

	dvap_state = DVAP_MODULATION;

	dvap_buff_pnt = 0;
	dvap_InTime.tv_sec = 0;
	dvap_InTime.tv_usec = 0;

	while (read (dvap_fd, dvap_buff, sizeof(dvap_buff)) != 0) ;	/* buffer clear */

	dvap_sw = TRUE;
	return;
}


void	dvap_close (void)
{
	tcsetattr (dvap_fd, TCSANOW, &save_attr);
	close (dvap_fd);
	dvap_sw = FALSE;
	time(&cur_time);
	fprintf (log_file, "%24.24s DVAP down.\n", ctime(&cur_time));
	fflush (log_file);
}

void	dvap_send_header (void)
{
	if (memcmp (&dvap_header[17], dvap_area_rep_callsign, 8)) return;
	if (!memcmp (dvap_pkt.dstar.b_bone.b_b.frame_id, &dvap_header[2], 2)) return;
        if (debug)
        {
        	time (&cur_time);
                fprintf (log_file, "%24.24s from DVAP Flags: %2.2x %2.2x %2.2x\n",
                	ctime(&cur_time), dvap_header[6], dvap_header[7], dvap_header[8]);
                fprintf (log_file, "%24.24s from DVAP RPT2:%8.8s RPT1:%8.8s\n",
                	ctime(&cur_time), &dvap_header[9], &dvap_header[17]);
                fprintf (log_file, "%24.24s from DVAP YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n",
                	ctime(&cur_time), &dvap_header[25], &dvap_header[33], &dvap_header[41]);
                fflush (log_file);
                dvap_rig_pkt_cnt = 0;
        }
        memcpy (&dvap_pkt.dstar.b_bone.dstar_udp.rf_header, &dvap_header[6], 41);
        dvap_pkt.dstar.b_bone.dstar_udp.rf_header.flags[0] &= 0xbf;       /* clear repeater flag */
	
	memcpy (posit.id, "DSTR", 4);
	posit.sr = 's';
	posit.c = 0x21; /* position */
	posit.length[0] = 0x00;
	posit.length[1] = 0x10;
	memcpy (posit.dstar.posit.call1, &dvap_header[33], 8);
	memcpy (posit.dstar.posit.call2, dvap_area_rep_callsign, 8);
	putFifo (26, posit);

        dv_pkt_set(&dvap_pkt);
        dvap_pkt.length[0] = 0x00;
        dvap_pkt.length[1] = 0x30;
        dvap_pkt.dstar.b_bone.b_b.id = 0x20;      /* voice */
        memcpy (dvap_pkt.dstar.b_bone.b_b.frame_id, &dvap_header[2], 2);
        dvap_pkt.dstar.b_bone.b_b.seq = dvap_header[4];

        if (memcmp (&dvap_header[9], &dvap_header[17], 8))
        {
                putFifo (58, dvap_pkt);
                dvap_voice_send_sw = TRUE;
        }
        else
        {
               dvap_voice_send_sw = FALSE;
        }

        //NoRespReply_sw = TRUE;
        //memcpy (&NoResp, usb.buffer, 41);
        dvap_last_frame_sw = TRUE;
        if (monitor_port)
        {
                if (sendto (monitor_sd, &dvap_pkt, 58, 0,
                        monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
                {
                        time (&cur_time);
                        fprintf (log_file, "%24.24s send error (monitor header) %s\n", ctime(&cur_time), strerror(errno));
                        fflush (log_file);
                }
        }
}

void	dvap_send_voice (void)
{
	int	length;

	if (!dvap_voice_send_sw) return;
	dvap_rig_pkt_cnt++;
	memcpy (&dvap_pkt.dstar.b_bone.dstar_udp.voice_d, &dvap_voice[6], 12);
	dv_pkt_set(&dvap_pkt);
	dvap_pkt.dstar.b_bone.b_b.seq = dvap_voice[4];
	dvap_pkt.length[0] = 0x00;
	if (dvap_voice[4] & 0x40)
	{
		memcpy (&dvap_pkt.dstar.b_bone.dstar_udp.voice_d.data_segment, lastframe, 6);
		dvap_pkt.length[1] = 22;  /* 32 - 10 */
		putFifo (32, dvap_pkt);
		length = 32;
		dvap_last_frame_sw = FALSE;
                if (debug)
                {
                	time(&cur_time);
                        fprintf (log_file, "%24.24s from DVAP packets:%ld\n", ctime(&cur_time), dvap_rig_pkt_cnt);
                        fflush (log_file);
                }
	}
	else
	{
		dvap_pkt.length[1] = 19;  /* 29 - 10 */
		putFifo (29, dvap_pkt);
		length = 29;
	}

	if (monitor_sd)
	{
		if (sendto (monitor_sd, &dvap_pkt, length, 0,
                	monitor_out->ai_addr, monitor_out->ai_addrlen) < 0)
                {
                	time (&cur_time);
                        fprintf (log_file, "%24.24s send error (monitor voice) %s\n", ctime(&cur_time), strerror(errno));
                        fflush (log_file);
		}
	}

}

void	dvap_read(void)
{
	int	len;
	int	k;
	int	n;

	len = read (dvap_fd, &dvap_buff[dvap_buff_pnt], sizeof(dvap_buff));
	if (len < 0)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s DVAP read error %s\n", ctime(&cur_time), strerror(errno));
		fflush (log_file);
		dvap_close();
		return;
	}
	dvap_buff_pnt += len;
	n = dvap_buff[0];
	if (n > dvap_buff_pnt) return;
	
	/* header */
	if ((dvap_buff[0] == 0x2f) && (dvap_buff[1] == 0xa0))
	{
		gettimeofday (&dvap_InTime, NULL);
		memcpy (dvap_header, dvap_buff, dvap_buff_pnt);
		dvap_send_header();
	}
	/* voice */
	if ((dvap_buff[0] == 0x12) && (dvap_buff[1] == 0xc0))
	{
		gettimeofday (&dvap_InTime, NULL);
		memcpy (dvap_voice, dvap_buff, dvap_buff_pnt);
		dvap_send_voice();
	}
	k = dvap_buff_pnt - n;
	if (k > 0) memmove (&dvap_buff[0], &dvap_buff[n], k);
	dvap_buff_pnt = k;
	if (dvap_buff_pnt > 160)
	{
		dvap_buff_pnt = 0;
	}
}
	

void	send_keep_alive(void)
{
	int	ret; 

	char keep_alive[3] = {0x03, 0x60, 0x00};

	ret = write (dvap_fd, keep_alive, 3);
	if (ret < 0)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s DVAP write error %s\n", ctime(&cur_time), strerror(errno));
		fflush (log_file);
		dvap_close();
		return;
	}
	time (&dvap_keep_alive);
}
