#include	"dv_repeater.h"

int     init(int argc, char **argv);
void	reply_busy(struct dv_header dv_hdr);
void	send_resp(struct dv_header gw_resp);
void	NoRespReply(struct dv_header NoResp);
void	send_reply(char buf[]);
void	echo_server_header(char buf[]);
void	echo_server_voice(char buf[]);
void	echo_server_last(char buf[]);

extern	char	lastframe[];

int	from_inet (void)
{
	int	len;

	struct	dv_header	dv_hdr;

	in_addr_len = sizeof(struct sockaddr_storage);

	if((len = recvfrom(in_sd, buf, sizeof(buf), 0, 
		(struct sockaddr *)&in_addr, &in_addr_len)) < 0) 
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s recvfrom error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
       		return FALSE;
	}

	if (memcmp (buf, "DSTR", 4)) return TRUE;


	if ((len >= 10) && (buf[6] == 's'))
	{
		if (memcmp (buf, "DSTR", 4)) return FALSE;
		send_reply (buf);
		if (buf[7] == 0x11) return TRUE;
		

		if (len == 58) 
		{
			memcpy (&dv_hdr, &buf[17], 41); /* rf header save */
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s from INET Flags: %2.2x %2.2x %2.2x\n", 
					ctime(&cur_time), dv_hdr.flags[0], dv_hdr.flags[1], dv_hdr.flags[2]);
				fprintf (log_file, "%24.24s from INET RPT2:%8.8s RPT1:%8.8s\n", 
					ctime(&cur_time), dv_hdr.RPT2Call, dv_hdr.RPT1Call);
				fprintf (log_file, "%24.24s from INET YourCall:%8.8s MyCall:%8.8s MyCall2:%4.4s\n", 
					ctime(&cur_time), dv_hdr.YourCall, dv_hdr.MyCall, dv_hdr.MyCall2);
				fflush (log_file);
				if (!memcmp (&buf[36], echo_server, 8)) echo_pkt_cnt = 0;
				else if (!memcmp (&buf[28], node_area_rep_callsign, 8)) node_inet_pkt_cnt = 0;
				else if (!memcmp (&buf[28], dvap_area_rep_callsign, 8)) dvap_inet_pkt_cnt = 0;
			}
			if ((buf[11] == 0xff) 
				&& (buf[12] == 0xff) 
				&& (buf[13] == 0xff)) /* response ? */
			{
				memcpy (&gw_resp, &buf[17], 41);
				gw_resp_sw = TRUE;
				NoRespReply_sw = FALSE;
			}
			else
			{
				if (!memcmp (&buf[20], node_area_rep_callsign, 8)
					&& !memcmp(&buf[36], echo_server, 8))
				{
					if (buf[17] == 0x00)
						echo_server_header (buf);
				}
				else
				{
					if (!memcmp (&buf[20], node_area_rep_callsign, 8))
					{
						if ((node_save_frame_id[0] == 0x00) && (node_save_frame_id[1] == 0x00))
						/* frame ID check */
						{
							gw_resp_sw = FALSE;
							gettimeofday(&InetInTime, NULL);
							memcpy (node_save_frame_id, &buf[14], 2);
							if (buf[35] == 'G')
							{
								memcpy (dv_hdr.RPT2Call, &buf[28], 8);
								memcpy (dv_hdr.RPT1Call, &buf[20], 8);
							}
							header_send(dv_hdr);
							NoRespReply_sw = FALSE;
						}
						else if (memcmp (node_save_frame_id, &buf[14], 2))
						{
							reply_busy (dv_hdr);
						}
					}
					else if (!memcmp (&buf[20], dvap_area_rep_callsign, 8))
					{
						if ((dvap_save_frame_id[0] == 0x00) && (dvap_save_frame_id[1] == 0x00))
						/* frame ID check */
						{
							gw_resp_sw = FALSE;
							gettimeofday(&InetInTime, NULL);
							memcpy (dvap_save_frame_id, &buf[14], 2);
							if (buf[35] == 'G')
							{
								memcpy (dv_hdr.RPT2Call, &buf[28], 8);
								memcpy (dv_hdr.RPT1Call, &buf[20], 8);
							}
							header_send(dv_hdr);
							NoRespReply_sw = FALSE;
						}
						else if (memcmp (dvap_save_frame_id, &buf[14], 2))
						{
							reply_busy (dv_hdr);
						}
					}
				}
			}
		}
		else if ((len == 29) || (len == 32))
		{
			if (debug)
			{
				time (&cur_time);
				if (!memcmp (node_save_frame_id, &buf[14], 2)) 
				{
					node_inet_pkt_cnt++;
					if ((len == 32) || (buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from INET packets:%ld\n",
							ctime(&cur_time), node_inet_pkt_cnt);
						fflush (log_file);
					}
				}
				else if (!memcmp (dvap_save_frame_id, &buf[14], 2))
				{
					dvap_inet_pkt_cnt++;
					if ((len == 32) || (buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from INET packets:%ld\n",
							ctime(&cur_time), dvap_inet_pkt_cnt);
						fflush (log_file);
					}
				}
				else 
				{
					echo_pkt_cnt++;
					//gettimeofday(&InetInTime, NULL);
					if ((len == 32) || (buf[16] & 0x40))
					{
						fprintf (log_file, "%24.24s from ECHO packets:%ld\n", 
							ctime(&cur_time), echo_pkt_cnt);
						fflush (log_file);
					}
				}
			}
					
			if (!memcmp (node_save_frame_id, &buf[14], 2))
			{
				gettimeofday(&InetInTime, NULL);
				if (debug) node_inet_pkt_cnt++;
				if (len == 29)
				{
					if (buf[16] & 0x40)
					{
						memcpy (&buf[26], lastframe, 6);
						node_last_send (&buf[17]);
						memset (node_save_frame_id, 0x00, 2);
					}
					else  node_voice_send (&buf[17]);
				}
				else if (len == 32)
				{
					memcpy (&buf[26], lastframe, 6);
					node_last_send(&buf[17]);
					memset (node_save_frame_id, 0x00, 2);
				}
			}
                        else if (!memcmp (dvap_save_frame_id, &buf[14], 2))
                        {
                                gettimeofday(&InetInTime, NULL);
                                if (debug) dvap_inet_pkt_cnt++;
                                if (len == 29)
                                {
                                        if (buf[16] & 0x40)
                                        {
                                                memcpy (&buf[26], lastframe, 6);
                                                dvap_last_send (&buf[17]);
                                                memset (dvap_save_frame_id, 0x00, 2);
                                        }
                                        else  dvap_voice_send (&buf[17]);
                                }
                                else if (len == 32)
                                {
                                        memcpy (&buf[26], lastframe, 6);
                                        dvap_last_send(&buf[17]);
                                        memset (dvap_save_frame_id, 0x00, 2);
                                }
                        }
			else
			{
				if (len == 29)
				{
					if (buf[16] & 0x40)
					{
						echo_server_last (buf);
					}
					else
					{
						echo_server_voice (buf);
					}
				}
				else if (len == 32)
				{
					echo_server_last (buf);
				}
					
			}
		}
	}
	if ((len == 10) && (buf[6] == 'r'))		/* reply(ack) packet */
	{
		recv_m = (buf[4] << 8)  | (buf[5] & 0xff);
		recv_m &= 0xffff;
		recv_sw = TRUE;
	}
	return TRUE;
}

